/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.service.CommerceCountryLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceCountry service. Represents a row in the &quot;CommerceCountry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceCountryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceCountryImpl
 * @see CommerceCountry
 * @generated
 */
public abstract class CommerceCountryBaseImpl
	extends CommerceCountryModelImpl implements CommerceCountry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce country model instance should use the <code>CommerceCountry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceCountryLocalServiceUtil.addCommerceCountry(this);
		}
		else {
			CommerceCountryLocalServiceUtil.updateCommerceCountry(this);
		}
	}

}