/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.service.CPDefinitionInventoryLocalServiceUtil;

/**
 * The extended model base implementation for the CPDefinitionInventory service. Represents a row in the &quot;CPDefinitionInventory&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CPDefinitionInventoryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CPDefinitionInventoryImpl
 * @see CPDefinitionInventory
 * @generated
 */
public abstract class CPDefinitionInventoryBaseImpl
	extends CPDefinitionInventoryModelImpl implements CPDefinitionInventory {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a cp definition inventory model instance should use the <code>CPDefinitionInventory</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CPDefinitionInventoryLocalServiceUtil.addCPDefinitionInventory(
				this);
		}
		else {
			CPDefinitionInventoryLocalServiceUtil.updateCPDefinitionInventory(
				this);
		}
	}

}