/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderItemModel;
import com.liferay.commerce.model.CommerceOrderItemSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceOrderItem service. Represents a row in the &quot;CommerceOrderItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceOrderItemModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceOrderItemImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceOrderItemImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceOrderItemModelImpl
	extends BaseModelImpl<CommerceOrderItem> implements CommerceOrderItemModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce order item model instance should use the <code>CommerceOrderItem</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceOrderItem";

	public static final Object[][] TABLE_COLUMNS = {
		{"externalReferenceCode", Types.VARCHAR},
		{"commerceOrderItemId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"commerceOrderId", Types.BIGINT},
		{"commercePriceListId", Types.BIGINT}, {"CProductId", Types.BIGINT},
		{"CPInstanceId", Types.BIGINT},
		{"parentCommerceOrderItemId", Types.BIGINT},
		{"quantity", Types.INTEGER}, {"shippedQuantity", Types.INTEGER},
		{"json", Types.CLOB}, {"name", Types.VARCHAR}, {"sku", Types.VARCHAR},
		{"unitPrice", Types.DECIMAL}, {"promoPrice", Types.DECIMAL},
		{"discountAmount", Types.DECIMAL}, {"finalPrice", Types.DECIMAL},
		{"discountPercentageLevel1", Types.DECIMAL},
		{"discountPercentageLevel2", Types.DECIMAL},
		{"discountPercentageLevel3", Types.DECIMAL},
		{"discountPercentageLevel4", Types.DECIMAL},
		{"unitPriceWithTaxAmount", Types.DECIMAL},
		{"promoPriceWithTaxAmount", Types.DECIMAL},
		{"discountWithTaxAmount", Types.DECIMAL},
		{"finalPriceWithTaxAmount", Types.DECIMAL},
		{"discountPctLevel1WithTaxAmount", Types.DECIMAL},
		{"discountPctLevel2WithTaxAmount", Types.DECIMAL},
		{"discountPctLevel3WithTaxAmount", Types.DECIMAL},
		{"discountPctLevel4WithTaxAmount", Types.DECIMAL},
		{"subscription", Types.BOOLEAN}, {"deliveryGroup", Types.VARCHAR},
		{"shippingAddressId", Types.BIGINT}, {"printedNote", Types.VARCHAR},
		{"requestedDeliveryDate", Types.TIMESTAMP},
		{"bookedQuantityId", Types.BIGINT}, {"manuallyAdjusted", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceOrderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceOrderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commercePriceListId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CProductId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("CPInstanceId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentCommerceOrderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("quantity", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("shippedQuantity", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("json", Types.CLOB);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("sku", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("unitPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("promoPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("finalPrice", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPercentageLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("unitPriceWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("promoPriceWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("finalPriceWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel1WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel2WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel3WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("discountPctLevel4WithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subscription", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("deliveryGroup", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("shippingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("printedNote", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("requestedDeliveryDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("bookedQuantityId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("manuallyAdjusted", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceOrderItem (externalReferenceCode VARCHAR(75) null,commerceOrderItemId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceOrderId LONG,commercePriceListId LONG,CProductId LONG,CPInstanceId LONG,parentCommerceOrderItemId LONG,quantity INTEGER,shippedQuantity INTEGER,json TEXT null,name STRING null,sku VARCHAR(75) null,unitPrice DECIMAL(30, 16) null,promoPrice DECIMAL(30, 16) null,discountAmount DECIMAL(30, 16) null,finalPrice DECIMAL(30, 16) null,discountPercentageLevel1 DECIMAL(30, 16) null,discountPercentageLevel2 DECIMAL(30, 16) null,discountPercentageLevel3 DECIMAL(30, 16) null,discountPercentageLevel4 DECIMAL(30, 16) null,unitPriceWithTaxAmount DECIMAL(30, 16) null,promoPriceWithTaxAmount DECIMAL(30, 16) null,discountWithTaxAmount DECIMAL(30, 16) null,finalPriceWithTaxAmount DECIMAL(30, 16) null,discountPctLevel1WithTaxAmount DECIMAL(30, 16) null,discountPctLevel2WithTaxAmount DECIMAL(30, 16) null,discountPctLevel3WithTaxAmount DECIMAL(30, 16) null,discountPctLevel4WithTaxAmount DECIMAL(30, 16) null,subscription BOOLEAN,deliveryGroup VARCHAR(75) null,shippingAddressId LONG,printedNote STRING null,requestedDeliveryDate DATE null,bookedQuantityId LONG,manuallyAdjusted BOOLEAN)";

	public static final String TABLE_SQL_DROP = "drop table CommerceOrderItem";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceOrderItem.createDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceOrderItem.createDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPINSTANCEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPRODUCTID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long BOOKEDQUANTITYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEORDERID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTCOMMERCEORDERITEMID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SUBSCRIPTION_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 256L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static CommerceOrderItem toModel(CommerceOrderItemSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceOrderItem model = new CommerceOrderItemImpl();

		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setCommerceOrderItemId(soapModel.getCommerceOrderItemId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceOrderId(soapModel.getCommerceOrderId());
		model.setCommercePriceListId(soapModel.getCommercePriceListId());
		model.setCProductId(soapModel.getCProductId());
		model.setCPInstanceId(soapModel.getCPInstanceId());
		model.setParentCommerceOrderItemId(
			soapModel.getParentCommerceOrderItemId());
		model.setQuantity(soapModel.getQuantity());
		model.setShippedQuantity(soapModel.getShippedQuantity());
		model.setJson(soapModel.getJson());
		model.setName(soapModel.getName());
		model.setSku(soapModel.getSku());
		model.setUnitPrice(soapModel.getUnitPrice());
		model.setPromoPrice(soapModel.getPromoPrice());
		model.setDiscountAmount(soapModel.getDiscountAmount());
		model.setFinalPrice(soapModel.getFinalPrice());
		model.setDiscountPercentageLevel1(
			soapModel.getDiscountPercentageLevel1());
		model.setDiscountPercentageLevel2(
			soapModel.getDiscountPercentageLevel2());
		model.setDiscountPercentageLevel3(
			soapModel.getDiscountPercentageLevel3());
		model.setDiscountPercentageLevel4(
			soapModel.getDiscountPercentageLevel4());
		model.setUnitPriceWithTaxAmount(soapModel.getUnitPriceWithTaxAmount());
		model.setPromoPriceWithTaxAmount(
			soapModel.getPromoPriceWithTaxAmount());
		model.setDiscountWithTaxAmount(soapModel.getDiscountWithTaxAmount());
		model.setFinalPriceWithTaxAmount(
			soapModel.getFinalPriceWithTaxAmount());
		model.setDiscountPercentageLevel1WithTaxAmount(
			soapModel.getDiscountPercentageLevel1WithTaxAmount());
		model.setDiscountPercentageLevel2WithTaxAmount(
			soapModel.getDiscountPercentageLevel2WithTaxAmount());
		model.setDiscountPercentageLevel3WithTaxAmount(
			soapModel.getDiscountPercentageLevel3WithTaxAmount());
		model.setDiscountPercentageLevel4WithTaxAmount(
			soapModel.getDiscountPercentageLevel4WithTaxAmount());
		model.setSubscription(soapModel.isSubscription());
		model.setDeliveryGroup(soapModel.getDeliveryGroup());
		model.setShippingAddressId(soapModel.getShippingAddressId());
		model.setPrintedNote(soapModel.getPrintedNote());
		model.setRequestedDeliveryDate(soapModel.getRequestedDeliveryDate());
		model.setBookedQuantityId(soapModel.getBookedQuantityId());
		model.setManuallyAdjusted(soapModel.isManuallyAdjusted());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<CommerceOrderItem> toModels(
		CommerceOrderItemSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceOrderItem> models = new ArrayList<CommerceOrderItem>(
			soapModels.length);

		for (CommerceOrderItemSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.model.CommerceOrderItem"));

	public CommerceOrderItemModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceOrderItemId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceOrderItemId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceOrderItemId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceOrderItem.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceOrderItem.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceOrderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrderItem, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceOrderItem)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceOrderItem, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceOrderItem, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceOrderItem)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceOrderItem, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceOrderItem, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<CommerceOrderItem, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceOrderItem, Object>>();

		attributeGetterFunctions.put(
			"externalReferenceCode",
			CommerceOrderItem::getExternalReferenceCode);
		attributeGetterFunctions.put(
			"commerceOrderItemId", CommerceOrderItem::getCommerceOrderItemId);
		attributeGetterFunctions.put("groupId", CommerceOrderItem::getGroupId);
		attributeGetterFunctions.put(
			"companyId", CommerceOrderItem::getCompanyId);
		attributeGetterFunctions.put("userId", CommerceOrderItem::getUserId);
		attributeGetterFunctions.put(
			"userName", CommerceOrderItem::getUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceOrderItem::getCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceOrderItem::getModifiedDate);
		attributeGetterFunctions.put(
			"commerceOrderId", CommerceOrderItem::getCommerceOrderId);
		attributeGetterFunctions.put(
			"commercePriceListId", CommerceOrderItem::getCommercePriceListId);
		attributeGetterFunctions.put(
			"CProductId", CommerceOrderItem::getCProductId);
		attributeGetterFunctions.put(
			"CPInstanceId", CommerceOrderItem::getCPInstanceId);
		attributeGetterFunctions.put(
			"parentCommerceOrderItemId",
			CommerceOrderItem::getParentCommerceOrderItemId);
		attributeGetterFunctions.put(
			"quantity", CommerceOrderItem::getQuantity);
		attributeGetterFunctions.put(
			"shippedQuantity", CommerceOrderItem::getShippedQuantity);
		attributeGetterFunctions.put("json", CommerceOrderItem::getJson);
		attributeGetterFunctions.put("name", CommerceOrderItem::getName);
		attributeGetterFunctions.put("sku", CommerceOrderItem::getSku);
		attributeGetterFunctions.put(
			"unitPrice", CommerceOrderItem::getUnitPrice);
		attributeGetterFunctions.put(
			"promoPrice", CommerceOrderItem::getPromoPrice);
		attributeGetterFunctions.put(
			"discountAmount", CommerceOrderItem::getDiscountAmount);
		attributeGetterFunctions.put(
			"finalPrice", CommerceOrderItem::getFinalPrice);
		attributeGetterFunctions.put(
			"discountPercentageLevel1",
			CommerceOrderItem::getDiscountPercentageLevel1);
		attributeGetterFunctions.put(
			"discountPercentageLevel2",
			CommerceOrderItem::getDiscountPercentageLevel2);
		attributeGetterFunctions.put(
			"discountPercentageLevel3",
			CommerceOrderItem::getDiscountPercentageLevel3);
		attributeGetterFunctions.put(
			"discountPercentageLevel4",
			CommerceOrderItem::getDiscountPercentageLevel4);
		attributeGetterFunctions.put(
			"unitPriceWithTaxAmount",
			CommerceOrderItem::getUnitPriceWithTaxAmount);
		attributeGetterFunctions.put(
			"promoPriceWithTaxAmount",
			CommerceOrderItem::getPromoPriceWithTaxAmount);
		attributeGetterFunctions.put(
			"discountWithTaxAmount",
			CommerceOrderItem::getDiscountWithTaxAmount);
		attributeGetterFunctions.put(
			"finalPriceWithTaxAmount",
			CommerceOrderItem::getFinalPriceWithTaxAmount);
		attributeGetterFunctions.put(
			"discountPercentageLevel1WithTaxAmount",
			CommerceOrderItem::getDiscountPercentageLevel1WithTaxAmount);
		attributeGetterFunctions.put(
			"discountPercentageLevel2WithTaxAmount",
			CommerceOrderItem::getDiscountPercentageLevel2WithTaxAmount);
		attributeGetterFunctions.put(
			"discountPercentageLevel3WithTaxAmount",
			CommerceOrderItem::getDiscountPercentageLevel3WithTaxAmount);
		attributeGetterFunctions.put(
			"discountPercentageLevel4WithTaxAmount",
			CommerceOrderItem::getDiscountPercentageLevel4WithTaxAmount);
		attributeGetterFunctions.put(
			"subscription", CommerceOrderItem::getSubscription);
		attributeGetterFunctions.put(
			"deliveryGroup", CommerceOrderItem::getDeliveryGroup);
		attributeGetterFunctions.put(
			"shippingAddressId", CommerceOrderItem::getShippingAddressId);
		attributeGetterFunctions.put(
			"printedNote", CommerceOrderItem::getPrintedNote);
		attributeGetterFunctions.put(
			"requestedDeliveryDate",
			CommerceOrderItem::getRequestedDeliveryDate);
		attributeGetterFunctions.put(
			"bookedQuantityId", CommerceOrderItem::getBookedQuantityId);
		attributeGetterFunctions.put(
			"manuallyAdjusted", CommerceOrderItem::getManuallyAdjusted);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<CommerceOrderItem, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<CommerceOrderItem, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<CommerceOrderItem, ?>>();

		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommerceOrderItem, String>)
				CommerceOrderItem::setExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"commerceOrderItemId",
			(BiConsumer<CommerceOrderItem, Long>)
				CommerceOrderItem::setCommerceOrderItemId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<CommerceOrderItem, Long>)CommerceOrderItem::setGroupId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceOrderItem, Long>)
				CommerceOrderItem::setCompanyId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceOrderItem, Long>)CommerceOrderItem::setUserId);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceOrderItem, String>)
				CommerceOrderItem::setUserName);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceOrderItem, Date>)
				CommerceOrderItem::setCreateDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceOrderItem, Date>)
				CommerceOrderItem::setModifiedDate);
		attributeSetterBiConsumers.put(
			"commerceOrderId",
			(BiConsumer<CommerceOrderItem, Long>)
				CommerceOrderItem::setCommerceOrderId);
		attributeSetterBiConsumers.put(
			"commercePriceListId",
			(BiConsumer<CommerceOrderItem, Long>)
				CommerceOrderItem::setCommercePriceListId);
		attributeSetterBiConsumers.put(
			"CProductId",
			(BiConsumer<CommerceOrderItem, Long>)
				CommerceOrderItem::setCProductId);
		attributeSetterBiConsumers.put(
			"CPInstanceId",
			(BiConsumer<CommerceOrderItem, Long>)
				CommerceOrderItem::setCPInstanceId);
		attributeSetterBiConsumers.put(
			"parentCommerceOrderItemId",
			(BiConsumer<CommerceOrderItem, Long>)
				CommerceOrderItem::setParentCommerceOrderItemId);
		attributeSetterBiConsumers.put(
			"quantity",
			(BiConsumer<CommerceOrderItem, Integer>)
				CommerceOrderItem::setQuantity);
		attributeSetterBiConsumers.put(
			"shippedQuantity",
			(BiConsumer<CommerceOrderItem, Integer>)
				CommerceOrderItem::setShippedQuantity);
		attributeSetterBiConsumers.put(
			"json",
			(BiConsumer<CommerceOrderItem, String>)CommerceOrderItem::setJson);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<CommerceOrderItem, String>)CommerceOrderItem::setName);
		attributeSetterBiConsumers.put(
			"sku",
			(BiConsumer<CommerceOrderItem, String>)CommerceOrderItem::setSku);
		attributeSetterBiConsumers.put(
			"unitPrice",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setUnitPrice);
		attributeSetterBiConsumers.put(
			"promoPrice",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setPromoPrice);
		attributeSetterBiConsumers.put(
			"discountAmount",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountAmount);
		attributeSetterBiConsumers.put(
			"finalPrice",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setFinalPrice);
		attributeSetterBiConsumers.put(
			"discountPercentageLevel1",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountPercentageLevel1);
		attributeSetterBiConsumers.put(
			"discountPercentageLevel2",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountPercentageLevel2);
		attributeSetterBiConsumers.put(
			"discountPercentageLevel3",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountPercentageLevel3);
		attributeSetterBiConsumers.put(
			"discountPercentageLevel4",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountPercentageLevel4);
		attributeSetterBiConsumers.put(
			"unitPriceWithTaxAmount",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setUnitPriceWithTaxAmount);
		attributeSetterBiConsumers.put(
			"promoPriceWithTaxAmount",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setPromoPriceWithTaxAmount);
		attributeSetterBiConsumers.put(
			"discountWithTaxAmount",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountWithTaxAmount);
		attributeSetterBiConsumers.put(
			"finalPriceWithTaxAmount",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setFinalPriceWithTaxAmount);
		attributeSetterBiConsumers.put(
			"discountPercentageLevel1WithTaxAmount",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountPercentageLevel1WithTaxAmount);
		attributeSetterBiConsumers.put(
			"discountPercentageLevel2WithTaxAmount",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountPercentageLevel2WithTaxAmount);
		attributeSetterBiConsumers.put(
			"discountPercentageLevel3WithTaxAmount",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountPercentageLevel3WithTaxAmount);
		attributeSetterBiConsumers.put(
			"discountPercentageLevel4WithTaxAmount",
			(BiConsumer<CommerceOrderItem, BigDecimal>)
				CommerceOrderItem::setDiscountPercentageLevel4WithTaxAmount);
		attributeSetterBiConsumers.put(
			"subscription",
			(BiConsumer<CommerceOrderItem, Boolean>)
				CommerceOrderItem::setSubscription);
		attributeSetterBiConsumers.put(
			"deliveryGroup",
			(BiConsumer<CommerceOrderItem, String>)
				CommerceOrderItem::setDeliveryGroup);
		attributeSetterBiConsumers.put(
			"shippingAddressId",
			(BiConsumer<CommerceOrderItem, Long>)
				CommerceOrderItem::setShippingAddressId);
		attributeSetterBiConsumers.put(
			"printedNote",
			(BiConsumer<CommerceOrderItem, String>)
				CommerceOrderItem::setPrintedNote);
		attributeSetterBiConsumers.put(
			"requestedDeliveryDate",
			(BiConsumer<CommerceOrderItem, Date>)
				CommerceOrderItem::setRequestedDeliveryDate);
		attributeSetterBiConsumers.put(
			"bookedQuantityId",
			(BiConsumer<CommerceOrderItem, Long>)
				CommerceOrderItem::setBookedQuantityId);
		attributeSetterBiConsumers.put(
			"manuallyAdjusted",
			(BiConsumer<CommerceOrderItem, Boolean>)
				CommerceOrderItem::setManuallyAdjusted);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceOrderItemId() {
		return _commerceOrderItemId;
	}

	@Override
	public void setCommerceOrderItemId(long commerceOrderItemId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceOrderItemId = commerceOrderItemId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceOrderId() {
		return _commerceOrderId;
	}

	@Override
	public void setCommerceOrderId(long commerceOrderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceOrderId = commerceOrderId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceOrderId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceOrderId"));
	}

	@JSON
	@Override
	public long getCommercePriceListId() {
		return _commercePriceListId;
	}

	@Override
	public void setCommercePriceListId(long commercePriceListId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePriceListId = commercePriceListId;
	}

	@JSON
	@Override
	public long getCProductId() {
		return _CProductId;
	}

	@Override
	public void setCProductId(long CProductId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CProductId = CProductId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCProductId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("CProductId"));
	}

	@JSON
	@Override
	public long getCPInstanceId() {
		return _CPInstanceId;
	}

	@Override
	public void setCPInstanceId(long CPInstanceId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CPInstanceId = CPInstanceId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCPInstanceId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("CPInstanceId"));
	}

	@JSON
	@Override
	public long getParentCommerceOrderItemId() {
		return _parentCommerceOrderItemId;
	}

	@Override
	public void setParentCommerceOrderItemId(long parentCommerceOrderItemId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentCommerceOrderItemId = parentCommerceOrderItemId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentCommerceOrderItemId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentCommerceOrderItemId"));
	}

	@JSON
	@Override
	public int getQuantity() {
		return _quantity;
	}

	@Override
	public void setQuantity(int quantity) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_quantity = quantity;
	}

	@JSON
	@Override
	public int getShippedQuantity() {
		return _shippedQuantity;
	}

	@Override
	public void setShippedQuantity(int shippedQuantity) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippedQuantity = shippedQuantity;
	}

	@JSON
	@Override
	public String getJson() {
		if (_json == null) {
			return "";
		}
		else {
			return _json;
		}
	}

	@Override
	public void setJson(String json) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_json = json;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getSku() {
		if (_sku == null) {
			return "";
		}
		else {
			return _sku;
		}
	}

	@Override
	public void setSku(String sku) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sku = sku;
	}

	@JSON
	@Override
	public BigDecimal getUnitPrice() {
		return _unitPrice;
	}

	@Override
	public void setUnitPrice(BigDecimal unitPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_unitPrice = unitPrice;
	}

	@JSON
	@Override
	public BigDecimal getPromoPrice() {
		return _promoPrice;
	}

	@Override
	public void setPromoPrice(BigDecimal promoPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_promoPrice = promoPrice;
	}

	@JSON
	@Override
	public BigDecimal getDiscountAmount() {
		return _discountAmount;
	}

	@Override
	public void setDiscountAmount(BigDecimal discountAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountAmount = discountAmount;
	}

	@JSON
	@Override
	public BigDecimal getFinalPrice() {
		return _finalPrice;
	}

	@Override
	public void setFinalPrice(BigDecimal finalPrice) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_finalPrice = finalPrice;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel1() {
		return _discountPercentageLevel1;
	}

	@Override
	public void setDiscountPercentageLevel1(
		BigDecimal discountPercentageLevel1) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel1 = discountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel2() {
		return _discountPercentageLevel2;
	}

	@Override
	public void setDiscountPercentageLevel2(
		BigDecimal discountPercentageLevel2) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel2 = discountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel3() {
		return _discountPercentageLevel3;
	}

	@Override
	public void setDiscountPercentageLevel3(
		BigDecimal discountPercentageLevel3) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel3 = discountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel4() {
		return _discountPercentageLevel4;
	}

	@Override
	public void setDiscountPercentageLevel4(
		BigDecimal discountPercentageLevel4) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel4 = discountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getUnitPriceWithTaxAmount() {
		return _unitPriceWithTaxAmount;
	}

	@Override
	public void setUnitPriceWithTaxAmount(BigDecimal unitPriceWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_unitPriceWithTaxAmount = unitPriceWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getPromoPriceWithTaxAmount() {
		return _promoPriceWithTaxAmount;
	}

	@Override
	public void setPromoPriceWithTaxAmount(BigDecimal promoPriceWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_promoPriceWithTaxAmount = promoPriceWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountWithTaxAmount() {
		return _discountWithTaxAmount;
	}

	@Override
	public void setDiscountWithTaxAmount(BigDecimal discountWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountWithTaxAmount = discountWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getFinalPriceWithTaxAmount() {
		return _finalPriceWithTaxAmount;
	}

	@Override
	public void setFinalPriceWithTaxAmount(BigDecimal finalPriceWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_finalPriceWithTaxAmount = finalPriceWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel1WithTaxAmount() {
		return _discountPercentageLevel1WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel1WithTaxAmount(
		BigDecimal discountPercentageLevel1WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel1WithTaxAmount =
			discountPercentageLevel1WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel2WithTaxAmount() {
		return _discountPercentageLevel2WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel2WithTaxAmount(
		BigDecimal discountPercentageLevel2WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel2WithTaxAmount =
			discountPercentageLevel2WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel3WithTaxAmount() {
		return _discountPercentageLevel3WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel3WithTaxAmount(
		BigDecimal discountPercentageLevel3WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel3WithTaxAmount =
			discountPercentageLevel3WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getDiscountPercentageLevel4WithTaxAmount() {
		return _discountPercentageLevel4WithTaxAmount;
	}

	@Override
	public void setDiscountPercentageLevel4WithTaxAmount(
		BigDecimal discountPercentageLevel4WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_discountPercentageLevel4WithTaxAmount =
			discountPercentageLevel4WithTaxAmount;
	}

	@JSON
	@Override
	public boolean getSubscription() {
		return _subscription;
	}

	@JSON
	@Override
	public boolean isSubscription() {
		return _subscription;
	}

	@Override
	public void setSubscription(boolean subscription) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subscription = subscription;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalSubscription() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("subscription"));
	}

	@JSON
	@Override
	public String getDeliveryGroup() {
		if (_deliveryGroup == null) {
			return "";
		}
		else {
			return _deliveryGroup;
		}
	}

	@Override
	public void setDeliveryGroup(String deliveryGroup) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryGroup = deliveryGroup;
	}

	@JSON
	@Override
	public long getShippingAddressId() {
		return _shippingAddressId;
	}

	@Override
	public void setShippingAddressId(long shippingAddressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingAddressId = shippingAddressId;
	}

	@JSON
	@Override
	public String getPrintedNote() {
		if (_printedNote == null) {
			return "";
		}
		else {
			return _printedNote;
		}
	}

	@Override
	public void setPrintedNote(String printedNote) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_printedNote = printedNote;
	}

	@JSON
	@Override
	public Date getRequestedDeliveryDate() {
		return _requestedDeliveryDate;
	}

	@Override
	public void setRequestedDeliveryDate(Date requestedDeliveryDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_requestedDeliveryDate = requestedDeliveryDate;
	}

	@JSON
	@Override
	public long getBookedQuantityId() {
		return _bookedQuantityId;
	}

	@Override
	public void setBookedQuantityId(long bookedQuantityId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_bookedQuantityId = bookedQuantityId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalBookedQuantityId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("bookedQuantityId"));
	}

	@JSON
	@Override
	public boolean getManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@JSON
	@Override
	public boolean isManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@Override
	public void setManuallyAdjusted(boolean manuallyAdjusted) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_manuallyAdjusted = manuallyAdjusted;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceOrderItem.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			CommerceOrderItem.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public CommerceOrderItem toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceOrderItem>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceOrderItemImpl commerceOrderItemImpl =
			new CommerceOrderItemImpl();

		commerceOrderItemImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceOrderItemImpl.setCommerceOrderItemId(getCommerceOrderItemId());
		commerceOrderItemImpl.setGroupId(getGroupId());
		commerceOrderItemImpl.setCompanyId(getCompanyId());
		commerceOrderItemImpl.setUserId(getUserId());
		commerceOrderItemImpl.setUserName(getUserName());
		commerceOrderItemImpl.setCreateDate(getCreateDate());
		commerceOrderItemImpl.setModifiedDate(getModifiedDate());
		commerceOrderItemImpl.setCommerceOrderId(getCommerceOrderId());
		commerceOrderItemImpl.setCommercePriceListId(getCommercePriceListId());
		commerceOrderItemImpl.setCProductId(getCProductId());
		commerceOrderItemImpl.setCPInstanceId(getCPInstanceId());
		commerceOrderItemImpl.setParentCommerceOrderItemId(
			getParentCommerceOrderItemId());
		commerceOrderItemImpl.setQuantity(getQuantity());
		commerceOrderItemImpl.setShippedQuantity(getShippedQuantity());
		commerceOrderItemImpl.setJson(getJson());
		commerceOrderItemImpl.setName(getName());
		commerceOrderItemImpl.setSku(getSku());
		commerceOrderItemImpl.setUnitPrice(getUnitPrice());
		commerceOrderItemImpl.setPromoPrice(getPromoPrice());
		commerceOrderItemImpl.setDiscountAmount(getDiscountAmount());
		commerceOrderItemImpl.setFinalPrice(getFinalPrice());
		commerceOrderItemImpl.setDiscountPercentageLevel1(
			getDiscountPercentageLevel1());
		commerceOrderItemImpl.setDiscountPercentageLevel2(
			getDiscountPercentageLevel2());
		commerceOrderItemImpl.setDiscountPercentageLevel3(
			getDiscountPercentageLevel3());
		commerceOrderItemImpl.setDiscountPercentageLevel4(
			getDiscountPercentageLevel4());
		commerceOrderItemImpl.setUnitPriceWithTaxAmount(
			getUnitPriceWithTaxAmount());
		commerceOrderItemImpl.setPromoPriceWithTaxAmount(
			getPromoPriceWithTaxAmount());
		commerceOrderItemImpl.setDiscountWithTaxAmount(
			getDiscountWithTaxAmount());
		commerceOrderItemImpl.setFinalPriceWithTaxAmount(
			getFinalPriceWithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel1WithTaxAmount(
			getDiscountPercentageLevel1WithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel2WithTaxAmount(
			getDiscountPercentageLevel2WithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel3WithTaxAmount(
			getDiscountPercentageLevel3WithTaxAmount());
		commerceOrderItemImpl.setDiscountPercentageLevel4WithTaxAmount(
			getDiscountPercentageLevel4WithTaxAmount());
		commerceOrderItemImpl.setSubscription(isSubscription());
		commerceOrderItemImpl.setDeliveryGroup(getDeliveryGroup());
		commerceOrderItemImpl.setShippingAddressId(getShippingAddressId());
		commerceOrderItemImpl.setPrintedNote(getPrintedNote());
		commerceOrderItemImpl.setRequestedDeliveryDate(
			getRequestedDeliveryDate());
		commerceOrderItemImpl.setBookedQuantityId(getBookedQuantityId());
		commerceOrderItemImpl.setManuallyAdjusted(isManuallyAdjusted());

		commerceOrderItemImpl.resetOriginalValues();

		return commerceOrderItemImpl;
	}

	@Override
	public int compareTo(CommerceOrderItem commerceOrderItem) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceOrderItem.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceOrderItem)) {
			return false;
		}

		CommerceOrderItem commerceOrderItem = (CommerceOrderItem)object;

		long primaryKey = commerceOrderItem.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceOrderItem> toCacheModel() {
		CommerceOrderItemCacheModel commerceOrderItemCacheModel =
			new CommerceOrderItemCacheModel();

		commerceOrderItemCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceOrderItemCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceOrderItemCacheModel.externalReferenceCode = null;
		}

		commerceOrderItemCacheModel.commerceOrderItemId =
			getCommerceOrderItemId();

		commerceOrderItemCacheModel.groupId = getGroupId();

		commerceOrderItemCacheModel.companyId = getCompanyId();

		commerceOrderItemCacheModel.userId = getUserId();

		commerceOrderItemCacheModel.userName = getUserName();

		String userName = commerceOrderItemCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceOrderItemCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceOrderItemCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceOrderItemCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceOrderItemCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceOrderItemCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceOrderItemCacheModel.commerceOrderId = getCommerceOrderId();

		commerceOrderItemCacheModel.commercePriceListId =
			getCommercePriceListId();

		commerceOrderItemCacheModel.CProductId = getCProductId();

		commerceOrderItemCacheModel.CPInstanceId = getCPInstanceId();

		commerceOrderItemCacheModel.parentCommerceOrderItemId =
			getParentCommerceOrderItemId();

		commerceOrderItemCacheModel.quantity = getQuantity();

		commerceOrderItemCacheModel.shippedQuantity = getShippedQuantity();

		commerceOrderItemCacheModel.json = getJson();

		String json = commerceOrderItemCacheModel.json;

		if ((json != null) && (json.length() == 0)) {
			commerceOrderItemCacheModel.json = null;
		}

		commerceOrderItemCacheModel.name = getName();

		String name = commerceOrderItemCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceOrderItemCacheModel.name = null;
		}

		commerceOrderItemCacheModel.sku = getSku();

		String sku = commerceOrderItemCacheModel.sku;

		if ((sku != null) && (sku.length() == 0)) {
			commerceOrderItemCacheModel.sku = null;
		}

		commerceOrderItemCacheModel.unitPrice = getUnitPrice();

		commerceOrderItemCacheModel.promoPrice = getPromoPrice();

		commerceOrderItemCacheModel.discountAmount = getDiscountAmount();

		commerceOrderItemCacheModel.finalPrice = getFinalPrice();

		commerceOrderItemCacheModel.discountPercentageLevel1 =
			getDiscountPercentageLevel1();

		commerceOrderItemCacheModel.discountPercentageLevel2 =
			getDiscountPercentageLevel2();

		commerceOrderItemCacheModel.discountPercentageLevel3 =
			getDiscountPercentageLevel3();

		commerceOrderItemCacheModel.discountPercentageLevel4 =
			getDiscountPercentageLevel4();

		commerceOrderItemCacheModel.unitPriceWithTaxAmount =
			getUnitPriceWithTaxAmount();

		commerceOrderItemCacheModel.promoPriceWithTaxAmount =
			getPromoPriceWithTaxAmount();

		commerceOrderItemCacheModel.discountWithTaxAmount =
			getDiscountWithTaxAmount();

		commerceOrderItemCacheModel.finalPriceWithTaxAmount =
			getFinalPriceWithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel1WithTaxAmount =
			getDiscountPercentageLevel1WithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel2WithTaxAmount =
			getDiscountPercentageLevel2WithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel3WithTaxAmount =
			getDiscountPercentageLevel3WithTaxAmount();

		commerceOrderItemCacheModel.discountPercentageLevel4WithTaxAmount =
			getDiscountPercentageLevel4WithTaxAmount();

		commerceOrderItemCacheModel.subscription = isSubscription();

		commerceOrderItemCacheModel.deliveryGroup = getDeliveryGroup();

		String deliveryGroup = commerceOrderItemCacheModel.deliveryGroup;

		if ((deliveryGroup != null) && (deliveryGroup.length() == 0)) {
			commerceOrderItemCacheModel.deliveryGroup = null;
		}

		commerceOrderItemCacheModel.shippingAddressId = getShippingAddressId();

		commerceOrderItemCacheModel.printedNote = getPrintedNote();

		String printedNote = commerceOrderItemCacheModel.printedNote;

		if ((printedNote != null) && (printedNote.length() == 0)) {
			commerceOrderItemCacheModel.printedNote = null;
		}

		Date requestedDeliveryDate = getRequestedDeliveryDate();

		if (requestedDeliveryDate != null) {
			commerceOrderItemCacheModel.requestedDeliveryDate =
				requestedDeliveryDate.getTime();
		}
		else {
			commerceOrderItemCacheModel.requestedDeliveryDate = Long.MIN_VALUE;
		}

		commerceOrderItemCacheModel.bookedQuantityId = getBookedQuantityId();

		commerceOrderItemCacheModel.manuallyAdjusted = isManuallyAdjusted();

		return commerceOrderItemCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceOrderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrderItem, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceOrderItem)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceOrderItem, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceOrderItem, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrderItem, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceOrderItem)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceOrderItem>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommerceOrderItem.class, ModelWrapper.class);

	}

	private String _externalReferenceCode;
	private long _commerceOrderItemId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceOrderId;
	private long _commercePriceListId;
	private long _CProductId;
	private long _CPInstanceId;
	private long _parentCommerceOrderItemId;
	private int _quantity;
	private int _shippedQuantity;
	private String _json;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _sku;
	private BigDecimal _unitPrice;
	private BigDecimal _promoPrice;
	private BigDecimal _discountAmount;
	private BigDecimal _finalPrice;
	private BigDecimal _discountPercentageLevel1;
	private BigDecimal _discountPercentageLevel2;
	private BigDecimal _discountPercentageLevel3;
	private BigDecimal _discountPercentageLevel4;
	private BigDecimal _unitPriceWithTaxAmount;
	private BigDecimal _promoPriceWithTaxAmount;
	private BigDecimal _discountWithTaxAmount;
	private BigDecimal _finalPriceWithTaxAmount;
	private BigDecimal _discountPercentageLevel1WithTaxAmount;
	private BigDecimal _discountPercentageLevel2WithTaxAmount;
	private BigDecimal _discountPercentageLevel3WithTaxAmount;
	private BigDecimal _discountPercentageLevel4WithTaxAmount;
	private boolean _subscription;
	private String _deliveryGroup;
	private long _shippingAddressId;
	private String _printedNote;
	private Date _requestedDeliveryDate;
	private long _bookedQuantityId;
	private boolean _manuallyAdjusted;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceOrderItem, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceOrderItem)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("commerceOrderItemId", _commerceOrderItemId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("commerceOrderId", _commerceOrderId);
		_columnOriginalValues.put("commercePriceListId", _commercePriceListId);
		_columnOriginalValues.put("CProductId", _CProductId);
		_columnOriginalValues.put("CPInstanceId", _CPInstanceId);
		_columnOriginalValues.put(
			"parentCommerceOrderItemId", _parentCommerceOrderItemId);
		_columnOriginalValues.put("quantity", _quantity);
		_columnOriginalValues.put("shippedQuantity", _shippedQuantity);
		_columnOriginalValues.put("json", _json);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("sku", _sku);
		_columnOriginalValues.put("unitPrice", _unitPrice);
		_columnOriginalValues.put("promoPrice", _promoPrice);
		_columnOriginalValues.put("discountAmount", _discountAmount);
		_columnOriginalValues.put("finalPrice", _finalPrice);
		_columnOriginalValues.put(
			"discountPercentageLevel1", _discountPercentageLevel1);
		_columnOriginalValues.put(
			"discountPercentageLevel2", _discountPercentageLevel2);
		_columnOriginalValues.put(
			"discountPercentageLevel3", _discountPercentageLevel3);
		_columnOriginalValues.put(
			"discountPercentageLevel4", _discountPercentageLevel4);
		_columnOriginalValues.put(
			"unitPriceWithTaxAmount", _unitPriceWithTaxAmount);
		_columnOriginalValues.put(
			"promoPriceWithTaxAmount", _promoPriceWithTaxAmount);
		_columnOriginalValues.put(
			"discountWithTaxAmount", _discountWithTaxAmount);
		_columnOriginalValues.put(
			"finalPriceWithTaxAmount", _finalPriceWithTaxAmount);
		_columnOriginalValues.put(
			"discountPctLevel1WithTaxAmount",
			_discountPercentageLevel1WithTaxAmount);
		_columnOriginalValues.put(
			"discountPctLevel2WithTaxAmount",
			_discountPercentageLevel2WithTaxAmount);
		_columnOriginalValues.put(
			"discountPctLevel3WithTaxAmount",
			_discountPercentageLevel3WithTaxAmount);
		_columnOriginalValues.put(
			"discountPctLevel4WithTaxAmount",
			_discountPercentageLevel4WithTaxAmount);
		_columnOriginalValues.put("subscription", _subscription);
		_columnOriginalValues.put("deliveryGroup", _deliveryGroup);
		_columnOriginalValues.put("shippingAddressId", _shippingAddressId);
		_columnOriginalValues.put("printedNote", _printedNote);
		_columnOriginalValues.put(
			"requestedDeliveryDate", _requestedDeliveryDate);
		_columnOriginalValues.put("bookedQuantityId", _bookedQuantityId);
		_columnOriginalValues.put("manuallyAdjusted", _manuallyAdjusted);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put(
			"discountPctLevel1WithTaxAmount",
			"discountPercentageLevel1WithTaxAmount");
		attributeNames.put(
			"discountPctLevel2WithTaxAmount",
			"discountPercentageLevel2WithTaxAmount");
		attributeNames.put(
			"discountPctLevel3WithTaxAmount",
			"discountPercentageLevel3WithTaxAmount");
		attributeNames.put(
			"discountPctLevel4WithTaxAmount",
			"discountPercentageLevel4WithTaxAmount");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("externalReferenceCode", 1L);

		columnBitmasks.put("commerceOrderItemId", 2L);

		columnBitmasks.put("groupId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("commerceOrderId", 256L);

		columnBitmasks.put("commercePriceListId", 512L);

		columnBitmasks.put("CProductId", 1024L);

		columnBitmasks.put("CPInstanceId", 2048L);

		columnBitmasks.put("parentCommerceOrderItemId", 4096L);

		columnBitmasks.put("quantity", 8192L);

		columnBitmasks.put("shippedQuantity", 16384L);

		columnBitmasks.put("json", 32768L);

		columnBitmasks.put("name", 65536L);

		columnBitmasks.put("sku", 131072L);

		columnBitmasks.put("unitPrice", 262144L);

		columnBitmasks.put("promoPrice", 524288L);

		columnBitmasks.put("discountAmount", 1048576L);

		columnBitmasks.put("finalPrice", 2097152L);

		columnBitmasks.put("discountPercentageLevel1", 4194304L);

		columnBitmasks.put("discountPercentageLevel2", 8388608L);

		columnBitmasks.put("discountPercentageLevel3", 16777216L);

		columnBitmasks.put("discountPercentageLevel4", 33554432L);

		columnBitmasks.put("unitPriceWithTaxAmount", 67108864L);

		columnBitmasks.put("promoPriceWithTaxAmount", 134217728L);

		columnBitmasks.put("discountWithTaxAmount", 268435456L);

		columnBitmasks.put("finalPriceWithTaxAmount", 536870912L);

		columnBitmasks.put("discountPctLevel1WithTaxAmount", 1073741824L);

		columnBitmasks.put("discountPctLevel2WithTaxAmount", 2147483648L);

		columnBitmasks.put("discountPctLevel3WithTaxAmount", 4294967296L);

		columnBitmasks.put("discountPctLevel4WithTaxAmount", 8589934592L);

		columnBitmasks.put("subscription", 17179869184L);

		columnBitmasks.put("deliveryGroup", 34359738368L);

		columnBitmasks.put("shippingAddressId", 68719476736L);

		columnBitmasks.put("printedNote", 137438953472L);

		columnBitmasks.put("requestedDeliveryDate", 274877906944L);

		columnBitmasks.put("bookedQuantityId", 549755813888L);

		columnBitmasks.put("manuallyAdjusted", 1099511627776L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceOrderItem _escapedModel;

}