/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.CommerceRegionLocalServiceUtil;
import com.liferay.commerce.util.comparator.CommerceRegionPriorityComparator;
import com.liferay.portal.kernel.dao.orm.QueryUtil;

import java.util.List;

/**
 * @author Alessio Antonio Rendina
 */
public class CommerceCountryImpl extends CommerceCountryBaseImpl {

	public CommerceCountryImpl() {
	}

	@Override
	public List<CommerceRegion> getCommerceRegions() {
		return CommerceRegionLocalServiceUtil.getCommerceRegions(
			getCommerceCountryId(), QueryUtil.ALL_POS, QueryUtil.ALL_POS,
			new CommerceRegionPriorityComparator());
	}

}