/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.model.listener;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Riccardo Alberti
 */
@Component(enabled = false, immediate = true, service = ModelListener.class)
public class CommerceChannelModelListener
	extends BaseModelListener<CommerceChannel> {

	@Override
	public void onBeforeRemove(CommerceChannel commerceChannel) {
		try {
			_commerceShippingMethodLocalService.deleteCommerceShippingMethods(
				commerceChannel.getGroupId());
		}
		catch (PortalException portalException) {
			_log.error(portalException, portalException);
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		CommerceChannelModelListener.class);

	@Reference
	private CommerceShippingMethodLocalService
		_commerceShippingMethodLocalService;

}