/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceAddressModel;
import com.liferay.commerce.model.CommerceAddressSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceAddress service. Represents a row in the &quot;CommerceAddress&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceAddressModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceAddressImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceAddressImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceAddressModelImpl
	extends BaseModelImpl<CommerceAddress> implements CommerceAddressModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce address model instance should use the <code>CommerceAddress</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceAddress";

	public static final Object[][] TABLE_COLUMNS = {
		{"externalReferenceCode", Types.VARCHAR},
		{"commerceAddressId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT}, {"name", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"street1", Types.VARCHAR},
		{"street2", Types.VARCHAR}, {"street3", Types.VARCHAR},
		{"city", Types.VARCHAR}, {"zip", Types.VARCHAR},
		{"commerceRegionId", Types.BIGINT}, {"commerceCountryId", Types.BIGINT},
		{"latitude", Types.DOUBLE}, {"longitude", Types.DOUBLE},
		{"phoneNumber", Types.VARCHAR}, {"defaultBilling", Types.BOOLEAN},
		{"defaultShipping", Types.BOOLEAN}, {"type_", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street1", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street2", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street3", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("city", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("zip", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceRegionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceCountryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("latitude", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("longitude", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("phoneNumber", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("defaultBilling", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("defaultShipping", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("type_", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceAddress (externalReferenceCode VARCHAR(75) null,commerceAddressId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,name VARCHAR(255) null,description STRING null,street1 VARCHAR(255) null,street2 VARCHAR(255) null,street3 VARCHAR(255) null,city VARCHAR(75) null,zip VARCHAR(75) null,commerceRegionId LONG,commerceCountryId LONG,latitude DOUBLE,longitude DOUBLE,phoneNumber VARCHAR(75) null,defaultBilling BOOLEAN,defaultShipping BOOLEAN,type_ INTEGER)";

	public static final String TABLE_SQL_DROP = "drop table CommerceAddress";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceAddress.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceAddress.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCECOUNTRYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEREGIONID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DEFAULTBILLING_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long DEFAULTSHIPPING_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 1024L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static CommerceAddress toModel(CommerceAddressSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceAddress model = new CommerceAddressImpl();

		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setCommerceAddressId(soapModel.getCommerceAddressId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setName(soapModel.getName());
		model.setDescription(soapModel.getDescription());
		model.setStreet1(soapModel.getStreet1());
		model.setStreet2(soapModel.getStreet2());
		model.setStreet3(soapModel.getStreet3());
		model.setCity(soapModel.getCity());
		model.setZip(soapModel.getZip());
		model.setCommerceRegionId(soapModel.getCommerceRegionId());
		model.setCommerceCountryId(soapModel.getCommerceCountryId());
		model.setLatitude(soapModel.getLatitude());
		model.setLongitude(soapModel.getLongitude());
		model.setPhoneNumber(soapModel.getPhoneNumber());
		model.setDefaultBilling(soapModel.isDefaultBilling());
		model.setDefaultShipping(soapModel.isDefaultShipping());
		model.setType(soapModel.getType());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<CommerceAddress> toModels(
		CommerceAddressSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceAddress> models = new ArrayList<CommerceAddress>(
			soapModels.length);

		for (CommerceAddressSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.model.CommerceAddress"));

	public CommerceAddressModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceAddressId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceAddressId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceAddressId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceAddress.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceAddress.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceAddress, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceAddress, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceAddress, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceAddress)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceAddress, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceAddress, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceAddress)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceAddress, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceAddress, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<CommerceAddress, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceAddress, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceAddress, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<CommerceAddress, Object>>();
		Map<String, BiConsumer<CommerceAddress, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<CommerceAddress, ?>>();

		attributeGetterFunctions.put(
			"externalReferenceCode", CommerceAddress::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommerceAddress, String>)
				CommerceAddress::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"commerceAddressId", CommerceAddress::getCommerceAddressId);
		attributeSetterBiConsumers.put(
			"commerceAddressId",
			(BiConsumer<CommerceAddress, Long>)
				CommerceAddress::setCommerceAddressId);
		attributeGetterFunctions.put("groupId", CommerceAddress::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<CommerceAddress, Long>)CommerceAddress::setGroupId);
		attributeGetterFunctions.put(
			"companyId", CommerceAddress::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceAddress, Long>)CommerceAddress::setCompanyId);
		attributeGetterFunctions.put("userId", CommerceAddress::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceAddress, Long>)CommerceAddress::setUserId);
		attributeGetterFunctions.put("userName", CommerceAddress::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceAddress, String>)CommerceAddress::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceAddress::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceAddress, Date>)CommerceAddress::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceAddress::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceAddress, Date>)
				CommerceAddress::setModifiedDate);
		attributeGetterFunctions.put(
			"classNameId", CommerceAddress::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<CommerceAddress, Long>)CommerceAddress::setClassNameId);
		attributeGetterFunctions.put("classPK", CommerceAddress::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK",
			(BiConsumer<CommerceAddress, Long>)CommerceAddress::setClassPK);
		attributeGetterFunctions.put("name", CommerceAddress::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<CommerceAddress, String>)CommerceAddress::setName);
		attributeGetterFunctions.put(
			"description", CommerceAddress::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<CommerceAddress, String>)
				CommerceAddress::setDescription);
		attributeGetterFunctions.put("street1", CommerceAddress::getStreet1);
		attributeSetterBiConsumers.put(
			"street1",
			(BiConsumer<CommerceAddress, String>)CommerceAddress::setStreet1);
		attributeGetterFunctions.put("street2", CommerceAddress::getStreet2);
		attributeSetterBiConsumers.put(
			"street2",
			(BiConsumer<CommerceAddress, String>)CommerceAddress::setStreet2);
		attributeGetterFunctions.put("street3", CommerceAddress::getStreet3);
		attributeSetterBiConsumers.put(
			"street3",
			(BiConsumer<CommerceAddress, String>)CommerceAddress::setStreet3);
		attributeGetterFunctions.put("city", CommerceAddress::getCity);
		attributeSetterBiConsumers.put(
			"city",
			(BiConsumer<CommerceAddress, String>)CommerceAddress::setCity);
		attributeGetterFunctions.put("zip", CommerceAddress::getZip);
		attributeSetterBiConsumers.put(
			"zip",
			(BiConsumer<CommerceAddress, String>)CommerceAddress::setZip);
		attributeGetterFunctions.put(
			"commerceRegionId", CommerceAddress::getCommerceRegionId);
		attributeSetterBiConsumers.put(
			"commerceRegionId",
			(BiConsumer<CommerceAddress, Long>)
				CommerceAddress::setCommerceRegionId);
		attributeGetterFunctions.put(
			"commerceCountryId", CommerceAddress::getCommerceCountryId);
		attributeSetterBiConsumers.put(
			"commerceCountryId",
			(BiConsumer<CommerceAddress, Long>)
				CommerceAddress::setCommerceCountryId);
		attributeGetterFunctions.put("latitude", CommerceAddress::getLatitude);
		attributeSetterBiConsumers.put(
			"latitude",
			(BiConsumer<CommerceAddress, Double>)CommerceAddress::setLatitude);
		attributeGetterFunctions.put(
			"longitude", CommerceAddress::getLongitude);
		attributeSetterBiConsumers.put(
			"longitude",
			(BiConsumer<CommerceAddress, Double>)CommerceAddress::setLongitude);
		attributeGetterFunctions.put(
			"phoneNumber", CommerceAddress::getPhoneNumber);
		attributeSetterBiConsumers.put(
			"phoneNumber",
			(BiConsumer<CommerceAddress, String>)
				CommerceAddress::setPhoneNumber);
		attributeGetterFunctions.put(
			"defaultBilling", CommerceAddress::getDefaultBilling);
		attributeSetterBiConsumers.put(
			"defaultBilling",
			(BiConsumer<CommerceAddress, Boolean>)
				CommerceAddress::setDefaultBilling);
		attributeGetterFunctions.put(
			"defaultShipping", CommerceAddress::getDefaultShipping);
		attributeSetterBiConsumers.put(
			"defaultShipping",
			(BiConsumer<CommerceAddress, Boolean>)
				CommerceAddress::setDefaultShipping);
		attributeGetterFunctions.put("type", CommerceAddress::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<CommerceAddress, Integer>)CommerceAddress::setType);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceAddressId() {
		return _commerceAddressId;
	}

	@Override
	public void setCommerceAddressId(long commerceAddressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceAddressId = commerceAddressId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getStreet1() {
		if (_street1 == null) {
			return "";
		}
		else {
			return _street1;
		}
	}

	@Override
	public void setStreet1(String street1) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_street1 = street1;
	}

	@JSON
	@Override
	public String getStreet2() {
		if (_street2 == null) {
			return "";
		}
		else {
			return _street2;
		}
	}

	@Override
	public void setStreet2(String street2) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_street2 = street2;
	}

	@JSON
	@Override
	public String getStreet3() {
		if (_street3 == null) {
			return "";
		}
		else {
			return _street3;
		}
	}

	@Override
	public void setStreet3(String street3) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_street3 = street3;
	}

	@JSON
	@Override
	public String getCity() {
		if (_city == null) {
			return "";
		}
		else {
			return _city;
		}
	}

	@Override
	public void setCity(String city) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_city = city;
	}

	@JSON
	@Override
	public String getZip() {
		if (_zip == null) {
			return "";
		}
		else {
			return _zip;
		}
	}

	@Override
	public void setZip(String zip) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_zip = zip;
	}

	@JSON
	@Override
	public long getCommerceRegionId() {
		return _commerceRegionId;
	}

	@Override
	public void setCommerceRegionId(long commerceRegionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceRegionId = commerceRegionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceRegionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceRegionId"));
	}

	@JSON
	@Override
	public long getCommerceCountryId() {
		return _commerceCountryId;
	}

	@Override
	public void setCommerceCountryId(long commerceCountryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceCountryId = commerceCountryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceCountryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceCountryId"));
	}

	@JSON
	@Override
	public double getLatitude() {
		return _latitude;
	}

	@Override
	public void setLatitude(double latitude) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_latitude = latitude;
	}

	@JSON
	@Override
	public double getLongitude() {
		return _longitude;
	}

	@Override
	public void setLongitude(double longitude) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_longitude = longitude;
	}

	@JSON
	@Override
	public String getPhoneNumber() {
		if (_phoneNumber == null) {
			return "";
		}
		else {
			return _phoneNumber;
		}
	}

	@Override
	public void setPhoneNumber(String phoneNumber) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_phoneNumber = phoneNumber;
	}

	@JSON
	@Override
	public boolean getDefaultBilling() {
		return _defaultBilling;
	}

	@JSON
	@Override
	public boolean isDefaultBilling() {
		return _defaultBilling;
	}

	@Override
	public void setDefaultBilling(boolean defaultBilling) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultBilling = defaultBilling;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalDefaultBilling() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("defaultBilling"));
	}

	@JSON
	@Override
	public boolean getDefaultShipping() {
		return _defaultShipping;
	}

	@JSON
	@Override
	public boolean isDefaultShipping() {
		return _defaultShipping;
	}

	@Override
	public void setDefaultShipping(boolean defaultShipping) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_defaultShipping = defaultShipping;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalDefaultShipping() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("defaultShipping"));
	}

	@JSON
	@Override
	public int getType() {
		return _type;
	}

	@Override
	public void setType(int type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalType() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("type_"));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceAddress.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceAddress toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceAddress>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceAddressImpl commerceAddressImpl = new CommerceAddressImpl();

		commerceAddressImpl.setExternalReferenceCode(
			getExternalReferenceCode());
		commerceAddressImpl.setCommerceAddressId(getCommerceAddressId());
		commerceAddressImpl.setGroupId(getGroupId());
		commerceAddressImpl.setCompanyId(getCompanyId());
		commerceAddressImpl.setUserId(getUserId());
		commerceAddressImpl.setUserName(getUserName());
		commerceAddressImpl.setCreateDate(getCreateDate());
		commerceAddressImpl.setModifiedDate(getModifiedDate());
		commerceAddressImpl.setClassNameId(getClassNameId());
		commerceAddressImpl.setClassPK(getClassPK());
		commerceAddressImpl.setName(getName());
		commerceAddressImpl.setDescription(getDescription());
		commerceAddressImpl.setStreet1(getStreet1());
		commerceAddressImpl.setStreet2(getStreet2());
		commerceAddressImpl.setStreet3(getStreet3());
		commerceAddressImpl.setCity(getCity());
		commerceAddressImpl.setZip(getZip());
		commerceAddressImpl.setCommerceRegionId(getCommerceRegionId());
		commerceAddressImpl.setCommerceCountryId(getCommerceCountryId());
		commerceAddressImpl.setLatitude(getLatitude());
		commerceAddressImpl.setLongitude(getLongitude());
		commerceAddressImpl.setPhoneNumber(getPhoneNumber());
		commerceAddressImpl.setDefaultBilling(isDefaultBilling());
		commerceAddressImpl.setDefaultShipping(isDefaultShipping());
		commerceAddressImpl.setType(getType());

		commerceAddressImpl.resetOriginalValues();

		return commerceAddressImpl;
	}

	@Override
	public int compareTo(CommerceAddress commerceAddress) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceAddress.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceAddress)) {
			return false;
		}

		CommerceAddress commerceAddress = (CommerceAddress)object;

		long primaryKey = commerceAddress.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceAddress> toCacheModel() {
		CommerceAddressCacheModel commerceAddressCacheModel =
			new CommerceAddressCacheModel();

		commerceAddressCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceAddressCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceAddressCacheModel.externalReferenceCode = null;
		}

		commerceAddressCacheModel.commerceAddressId = getCommerceAddressId();

		commerceAddressCacheModel.groupId = getGroupId();

		commerceAddressCacheModel.companyId = getCompanyId();

		commerceAddressCacheModel.userId = getUserId();

		commerceAddressCacheModel.userName = getUserName();

		String userName = commerceAddressCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceAddressCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceAddressCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceAddressCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceAddressCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceAddressCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceAddressCacheModel.classNameId = getClassNameId();

		commerceAddressCacheModel.classPK = getClassPK();

		commerceAddressCacheModel.name = getName();

		String name = commerceAddressCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceAddressCacheModel.name = null;
		}

		commerceAddressCacheModel.description = getDescription();

		String description = commerceAddressCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			commerceAddressCacheModel.description = null;
		}

		commerceAddressCacheModel.street1 = getStreet1();

		String street1 = commerceAddressCacheModel.street1;

		if ((street1 != null) && (street1.length() == 0)) {
			commerceAddressCacheModel.street1 = null;
		}

		commerceAddressCacheModel.street2 = getStreet2();

		String street2 = commerceAddressCacheModel.street2;

		if ((street2 != null) && (street2.length() == 0)) {
			commerceAddressCacheModel.street2 = null;
		}

		commerceAddressCacheModel.street3 = getStreet3();

		String street3 = commerceAddressCacheModel.street3;

		if ((street3 != null) && (street3.length() == 0)) {
			commerceAddressCacheModel.street3 = null;
		}

		commerceAddressCacheModel.city = getCity();

		String city = commerceAddressCacheModel.city;

		if ((city != null) && (city.length() == 0)) {
			commerceAddressCacheModel.city = null;
		}

		commerceAddressCacheModel.zip = getZip();

		String zip = commerceAddressCacheModel.zip;

		if ((zip != null) && (zip.length() == 0)) {
			commerceAddressCacheModel.zip = null;
		}

		commerceAddressCacheModel.commerceRegionId = getCommerceRegionId();

		commerceAddressCacheModel.commerceCountryId = getCommerceCountryId();

		commerceAddressCacheModel.latitude = getLatitude();

		commerceAddressCacheModel.longitude = getLongitude();

		commerceAddressCacheModel.phoneNumber = getPhoneNumber();

		String phoneNumber = commerceAddressCacheModel.phoneNumber;

		if ((phoneNumber != null) && (phoneNumber.length() == 0)) {
			commerceAddressCacheModel.phoneNumber = null;
		}

		commerceAddressCacheModel.defaultBilling = isDefaultBilling();

		commerceAddressCacheModel.defaultShipping = isDefaultShipping();

		commerceAddressCacheModel.type = getType();

		return commerceAddressCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceAddress, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceAddress, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceAddress, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((CommerceAddress)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceAddress, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceAddress, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceAddress, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceAddress)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceAddress>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					CommerceAddress.class, ModelWrapper.class);

	}

	private String _externalReferenceCode;
	private long _commerceAddressId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private String _name;
	private String _description;
	private String _street1;
	private String _street2;
	private String _street3;
	private String _city;
	private String _zip;
	private long _commerceRegionId;
	private long _commerceCountryId;
	private double _latitude;
	private double _longitude;
	private String _phoneNumber;
	private boolean _defaultBilling;
	private boolean _defaultShipping;
	private int _type;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceAddress, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceAddress)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("commerceAddressId", _commerceAddressId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("street1", _street1);
		_columnOriginalValues.put("street2", _street2);
		_columnOriginalValues.put("street3", _street3);
		_columnOriginalValues.put("city", _city);
		_columnOriginalValues.put("zip", _zip);
		_columnOriginalValues.put("commerceRegionId", _commerceRegionId);
		_columnOriginalValues.put("commerceCountryId", _commerceCountryId);
		_columnOriginalValues.put("latitude", _latitude);
		_columnOriginalValues.put("longitude", _longitude);
		_columnOriginalValues.put("phoneNumber", _phoneNumber);
		_columnOriginalValues.put("defaultBilling", _defaultBilling);
		_columnOriginalValues.put("defaultShipping", _defaultShipping);
		_columnOriginalValues.put("type_", _type);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("externalReferenceCode", 1L);

		columnBitmasks.put("commerceAddressId", 2L);

		columnBitmasks.put("groupId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("classNameId", 256L);

		columnBitmasks.put("classPK", 512L);

		columnBitmasks.put("name", 1024L);

		columnBitmasks.put("description", 2048L);

		columnBitmasks.put("street1", 4096L);

		columnBitmasks.put("street2", 8192L);

		columnBitmasks.put("street3", 16384L);

		columnBitmasks.put("city", 32768L);

		columnBitmasks.put("zip", 65536L);

		columnBitmasks.put("commerceRegionId", 131072L);

		columnBitmasks.put("commerceCountryId", 262144L);

		columnBitmasks.put("latitude", 524288L);

		columnBitmasks.put("longitude", 1048576L);

		columnBitmasks.put("phoneNumber", 2097152L);

		columnBitmasks.put("defaultBilling", 4194304L);

		columnBitmasks.put("defaultShipping", 8388608L);

		columnBitmasks.put("type_", 16777216L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceAddress _escapedModel;

}