/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceRegionNameException;
import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.service.base.CommerceRegionLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;

public class CommerceRegionLocalServiceImpl
extends CommerceRegionLocalServiceBaseImpl {
    public CommerceRegion addCommerceRegion(long commerceCountryId, String name, String code, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        CommerceCountry commerceCountry = this.commerceCountryPersistence.findByPrimaryKey(commerceCountryId);
        this.validate(name);
        long commerceRegionId = this.counterLocalService.increment();
        CommerceRegion commerceRegion = this.commerceRegionPersistence.create(commerceRegionId);
        commerceRegion.setCompanyId(user.getCompanyId());
        commerceRegion.setUserId(user.getUserId());
        commerceRegion.setUserName(user.getFullName());
        commerceRegion.setCommerceCountryId(commerceCountry.getCommerceCountryId());
        commerceRegion.setName(name);
        commerceRegion.setCode(code);
        commerceRegion.setPriority(priority);
        commerceRegion.setActive(active);
        return (CommerceRegion)this.commerceRegionPersistence.update((BaseModel)commerceRegion);
    }

    @Override
    @SystemEvent(type=1)
    public CommerceRegion deleteCommerceRegion(CommerceRegion commerceRegion) throws PortalException {
        this.commerceRegionPersistence.remove((BaseModel)commerceRegion);
        this.commerceAddressLocalService.deleteRegionCommerceAddresses(commerceRegion.getCommerceRegionId());
        return commerceRegion;
    }

    @Override
    public CommerceRegion deleteCommerceRegion(long commerceRegionId) throws PortalException {
        CommerceRegion commerceRegion = this.commerceRegionPersistence.findByPrimaryKey(commerceRegionId);
        return this.commerceRegionLocalService.deleteCommerceRegion(commerceRegion);
    }

    public void deleteCommerceRegions(long commerceCountryId) throws PortalException {
        List commerceRegions = this.commerceRegionPersistence.findByCommerceCountryId(commerceCountryId, -1, -1);
        for (CommerceRegion commerceRegion : commerceRegions) {
            this.deleteCommerceRegion(commerceRegion);
        }
    }

    public CommerceRegion getCommerceRegion(long commerceCountryId, String code) throws PortalException {
        return this.commerceRegionPersistence.findByC_C(commerceCountryId, code);
    }

    public List<CommerceRegion> getCommerceRegions(long commerceCountryId, boolean active) {
        return this.commerceRegionPersistence.findByC_A(commerceCountryId, active);
    }

    public List<CommerceRegion> getCommerceRegions(long commerceCountryId, boolean active, int start, int end, OrderByComparator<CommerceRegion> orderByComparator) {
        return this.commerceRegionPersistence.findByC_A(commerceCountryId, active, start, end, orderByComparator);
    }

    public List<CommerceRegion> getCommerceRegions(long commerceCountryId, int start, int end, OrderByComparator<CommerceRegion> orderByComparator) {
        return this.commerceRegionPersistence.findByCommerceCountryId(commerceCountryId, start, end, orderByComparator);
    }

    public List<CommerceRegion> getCommerceRegions(long companyId, String countryTwoLettersISOCode, boolean active) throws PortalException {
        CommerceCountry commerceCountry = this.commerceCountryLocalService.getCommerceCountry(companyId, countryTwoLettersISOCode);
        return this.commerceRegionPersistence.findByC_A(commerceCountry.getCommerceCountryId(), active);
    }

    public int getCommerceRegionsCount(long commerceCountryId) {
        return this.commerceRegionPersistence.countByCommerceCountryId(commerceCountryId);
    }

    public int getCommerceRegionsCount(long commerceCountryId, boolean active) {
        return this.commerceRegionPersistence.countByC_A(commerceCountryId, active);
    }

    public CommerceRegion setActive(long commerceRegionId, boolean active) throws PortalException {
        CommerceRegion commerceRegion = this.commerceRegionPersistence.findByPrimaryKey(commerceRegionId);
        commerceRegion.setActive(active);
        return (CommerceRegion)this.commerceRegionPersistence.update((BaseModel)commerceRegion);
    }

    public CommerceRegion updateCommerceRegion(long commerceRegionId, String name, String code, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommerceRegion commerceRegion = this.commerceRegionPersistence.findByPrimaryKey(commerceRegionId);
        this.validate(name);
        commerceRegion.setName(name);
        commerceRegion.setCode(code);
        commerceRegion.setPriority(priority);
        commerceRegion.setActive(active);
        return (CommerceRegion)this.commerceRegionPersistence.update((BaseModel)commerceRegion);
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CommerceRegionNameException();
        }
    }
}

