/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceSubscriptionEntry service. Represents a row in the &quot;CommerceSubscriptionEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceSubscriptionEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceSubscriptionEntryImpl
 * @see CommerceSubscriptionEntry
 * @generated
 */
public abstract class CommerceSubscriptionEntryBaseImpl
	extends CommerceSubscriptionEntryModelImpl
	implements CommerceSubscriptionEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce subscription entry model instance should use the <code>CommerceSubscriptionEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceSubscriptionEntryLocalServiceUtil.
				addCommerceSubscriptionEntry(this);
		}
		else {
			CommerceSubscriptionEntryLocalServiceUtil.
				updateCommerceSubscriptionEntry(this);
		}
	}

}