/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.notification;

import com.liferay.commerce.order.CommerceDefinitionTermContributor;
import com.liferay.commerce.order.CommerceDefinitionTermContributorRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Luca Pellizzon
 */
@Component(
	enabled = false, immediate = true,
	service = CommerceDefinitionTermContributorRegistry.class
)
public class CommerceDefinitionTermContributorRegistryImpl
	implements CommerceDefinitionTermContributorRegistry {

	@Override
	public List<CommerceDefinitionTermContributor>
		getDefinitionTermContributorsByContributorKey(String key) {

		return _getCommerceDefinitionTermContributors(
			key, _serviceTrackerMapByTermContributorKey);
	}

	@Override
	public List<CommerceDefinitionTermContributor>
		getDefinitionTermContributorsByNotificationTypeKey(String key) {

		return _getCommerceDefinitionTermContributors(
			key, _serviceTrackerMapByNotificationTypeKey);
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMapByNotificationTypeKey =
			ServiceTrackerMapFactory.openMultiValueMap(
				bundleContext, CommerceDefinitionTermContributor.class,
				"commerce.notification.type.key",
				ServiceTrackerCustomizerFactory.
					<CommerceDefinitionTermContributor>serviceWrapper(
						bundleContext));

		_serviceTrackerMapByTermContributorKey =
			ServiceTrackerMapFactory.openMultiValueMap(
				bundleContext, CommerceDefinitionTermContributor.class,
				"commerce.definition.term.contributor.key",
				ServiceTrackerCustomizerFactory.
					<CommerceDefinitionTermContributor>serviceWrapper(
						bundleContext));
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMapByNotificationTypeKey.close();

		_serviceTrackerMapByTermContributorKey.close();
	}

	private List<CommerceDefinitionTermContributor>
		_getCommerceDefinitionTermContributors(
			String key,
			ServiceTrackerMap
				<String,
				 List
					 <ServiceTrackerCustomizerFactory.ServiceWrapper
						 <CommerceDefinitionTermContributor>>>
							serviceTrackerMap) {

		List
			<ServiceTrackerCustomizerFactory.ServiceWrapper
				<CommerceDefinitionTermContributor>>
					commerceDefinitionTermContributorWrappers =
						serviceTrackerMap.getService(key);

		if (commerceDefinitionTermContributorWrappers == null) {
			return Collections.emptyList();
		}

		List<CommerceDefinitionTermContributor>
			commerceDefinitionTermContributors = new ArrayList<>();

		for (ServiceTrackerCustomizerFactory.ServiceWrapper
				<CommerceDefinitionTermContributor>
					tableActionProviderServiceWrapper :
						commerceDefinitionTermContributorWrappers) {

			commerceDefinitionTermContributors.add(
				tableActionProviderServiceWrapper.getService());
		}

		return commerceDefinitionTermContributors;
	}

	private ServiceTrackerMap
		<String,
		 List
			 <ServiceTrackerCustomizerFactory.ServiceWrapper
				 <CommerceDefinitionTermContributor>>>
					_serviceTrackerMapByNotificationTypeKey;
	private ServiceTrackerMap
		<String,
		 List
			 <ServiceTrackerCustomizerFactory.ServiceWrapper
				 <CommerceDefinitionTermContributor>>>
					_serviceTrackerMapByTermContributorKey;

}