/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.exception.NoSuchOrderItemException;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderItemTable;
import com.liferay.commerce.model.impl.CommerceOrderItemImpl;
import com.liferay.commerce.model.impl.CommerceOrderItemModelImpl;
import com.liferay.commerce.service.persistence.CommerceOrderItemPersistence;
import com.liferay.commerce.service.persistence.CommerceOrderItemUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

public class CommerceOrderItemPersistenceImpl
extends BasePersistenceImpl<CommerceOrderItem>
implements CommerceOrderItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceOrderItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCommerceOrderId;
    private FinderPath _finderPathWithoutPaginationFindByCommerceOrderId;
    private FinderPath _finderPathCountByCommerceOrderId;
    private static final String _FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2 = "commerceOrderItem.commerceOrderId = ?";
    private FinderPath _finderPathWithPaginationFindByCProductId;
    private FinderPath _finderPathWithoutPaginationFindByCProductId;
    private FinderPath _finderPathCountByCProductId;
    private static final String _FINDER_COLUMN_CPRODUCTID_CPRODUCTID_2 = "commerceOrderItem.CProductId = ?";
    private FinderPath _finderPathWithPaginationFindByCPInstanceId;
    private FinderPath _finderPathWithoutPaginationFindByCPInstanceId;
    private FinderPath _finderPathCountByCPInstanceId;
    private static final String _FINDER_COLUMN_CPINSTANCEID_CPINSTANCEID_2 = "commerceOrderItem.CPInstanceId = ?";
    private FinderPath _finderPathWithPaginationFindByParentCommerceOrderItemId;
    private FinderPath _finderPathWithoutPaginationFindByParentCommerceOrderItemId;
    private FinderPath _finderPathCountByParentCommerceOrderItemId;
    private static final String _FINDER_COLUMN_PARENTCOMMERCEORDERITEMID_PARENTCOMMERCEORDERITEMID_2 = "commerceOrderItem.parentCommerceOrderItemId = ?";
    private FinderPath _finderPathFetchByBookedQuantityId;
    private FinderPath _finderPathCountByBookedQuantityId;
    private static final String _FINDER_COLUMN_BOOKEDQUANTITYID_BOOKEDQUANTITYID_2 = "commerceOrderItem.bookedQuantityId = ?";
    private FinderPath _finderPathWithPaginationFindByC_I;
    private FinderPath _finderPathWithoutPaginationFindByC_I;
    private FinderPath _finderPathCountByC_I;
    private static final String _FINDER_COLUMN_C_I_COMMERCEORDERID_2 = "commerceOrderItem.commerceOrderId = ? AND ";
    private static final String _FINDER_COLUMN_C_I_CPINSTANCEID_2 = "commerceOrderItem.CPInstanceId = ?";
    private FinderPath _finderPathWithPaginationFindByC_S;
    private FinderPath _finderPathWithoutPaginationFindByC_S;
    private FinderPath _finderPathCountByC_S;
    private static final String _FINDER_COLUMN_C_S_COMMERCEORDERID_2 = "commerceOrderItem.commerceOrderId = ? AND ";
    private static final String _FINDER_COLUMN_C_S_SUBSCRIPTION_2 = "commerceOrderItem.subscription = ?";
    private FinderPath _finderPathFetchByC_ERC;
    private FinderPath _finderPathCountByC_ERC;
    private static final String _FINDER_COLUMN_C_ERC_COMPANYID_2 = "commerceOrderItem.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2 = "commerceOrderItem.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3 = "(commerceOrderItem.externalReferenceCode IS NULL OR commerceOrderItem.externalReferenceCode = '')";
    private int _valueObjectFinderCacheListThreshold;
    private BundleContext _bundleContext;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCEORDERITEM = "SELECT commerceOrderItem FROM CommerceOrderItem commerceOrderItem";
    private static final String _SQL_SELECT_COMMERCEORDERITEM_WHERE = "SELECT commerceOrderItem FROM CommerceOrderItem commerceOrderItem WHERE ";
    private static final String _SQL_COUNT_COMMERCEORDERITEM = "SELECT COUNT(commerceOrderItem) FROM CommerceOrderItem commerceOrderItem";
    private static final String _SQL_COUNT_COMMERCEORDERITEM_WHERE = "SELECT COUNT(commerceOrderItem) FROM CommerceOrderItem commerceOrderItem WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceOrderItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceOrderItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceOrderItem exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderItemPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"discountPercentageLevel1WithTaxAmount", "discountPercentageLevel2WithTaxAmount", "discountPercentageLevel3WithTaxAmount", "discountPercentageLevel4WithTaxAmount"});
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<CommerceOrderItem> findByCommerceOrderId(long commerceOrderId) {
        return this.findByCommerceOrderId(commerceOrderId, -1, -1, null);
    }

    public List<CommerceOrderItem> findByCommerceOrderId(long commerceOrderId, int start, int end) {
        return this.findByCommerceOrderId(commerceOrderId, start, end, null);
    }

    public List<CommerceOrderItem> findByCommerceOrderId(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByCommerceOrderId(commerceOrderId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByCommerceOrderId(long commerceOrderId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCommerceOrderId;
                finderArgs = new Object[]{commerceOrderId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCommerceOrderId;
            finderArgs = new Object[]{commerceOrderId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (commerceOrderId == commerceOrderItem.getCommerceOrderId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByCommerceOrderId_First(long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCommerceOrderId_First(commerceOrderId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByCommerceOrderId_First(long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByCommerceOrderId(commerceOrderId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByCommerceOrderId_Last(long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCommerceOrderId_Last(commerceOrderId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByCommerceOrderId_Last(long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByCommerceOrderId(commerceOrderId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByCommerceOrderId(commerceOrderId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByCommerceOrderId_PrevAndNext(long commerceOrderItemId, long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByCommerceOrderId_PrevAndNext(session, commerceOrderItem, commerceOrderId, orderByComparator, true), commerceOrderItem, this.getByCommerceOrderId_PrevAndNext(session, commerceOrderItem, commerceOrderId, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByCommerceOrderId_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long commerceOrderId, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        sb.append(_FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(commerceOrderId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByCommerceOrderId(long commerceOrderId) {
        for (CommerceOrderItem commerceOrderItem : this.findByCommerceOrderId(commerceOrderId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByCommerceOrderId(long commerceOrderId) {
        FinderPath finderPath = this._finderPathCountByCommerceOrderId;
        Object[] finderArgs = new Object[]{commerceOrderId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_COMMERCEORDERID_COMMERCEORDERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderItem> findByCProductId(long CProductId) {
        return this.findByCProductId(CProductId, -1, -1, null);
    }

    public List<CommerceOrderItem> findByCProductId(long CProductId, int start, int end) {
        return this.findByCProductId(CProductId, start, end, null);
    }

    public List<CommerceOrderItem> findByCProductId(long CProductId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByCProductId(CProductId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByCProductId(long CProductId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCProductId;
                finderArgs = new Object[]{CProductId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCProductId;
            finderArgs = new Object[]{CProductId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (CProductId == commerceOrderItem.getCProductId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_CPRODUCTID_CPRODUCTID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(CProductId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByCProductId_First(long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCProductId_First(CProductId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("CProductId=");
        sb.append(CProductId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByCProductId_First(long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByCProductId(CProductId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByCProductId_Last(long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCProductId_Last(CProductId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("CProductId=");
        sb.append(CProductId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByCProductId_Last(long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByCProductId(CProductId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByCProductId(CProductId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByCProductId_PrevAndNext(long commerceOrderItemId, long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByCProductId_PrevAndNext(session, commerceOrderItem, CProductId, orderByComparator, true), commerceOrderItem, this.getByCProductId_PrevAndNext(session, commerceOrderItem, CProductId, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByCProductId_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long CProductId, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        sb.append(_FINDER_COLUMN_CPRODUCTID_CPRODUCTID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(CProductId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByCProductId(long CProductId) {
        for (CommerceOrderItem commerceOrderItem : this.findByCProductId(CProductId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByCProductId(long CProductId) {
        FinderPath finderPath = this._finderPathCountByCProductId;
        Object[] finderArgs = new Object[]{CProductId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_CPRODUCTID_CPRODUCTID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(CProductId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderItem> findByCPInstanceId(long CPInstanceId) {
        return this.findByCPInstanceId(CPInstanceId, -1, -1, null);
    }

    public List<CommerceOrderItem> findByCPInstanceId(long CPInstanceId, int start, int end) {
        return this.findByCPInstanceId(CPInstanceId, start, end, null);
    }

    public List<CommerceOrderItem> findByCPInstanceId(long CPInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByCPInstanceId(CPInstanceId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByCPInstanceId(long CPInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCPInstanceId;
                finderArgs = new Object[]{CPInstanceId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCPInstanceId;
            finderArgs = new Object[]{CPInstanceId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (CPInstanceId == commerceOrderItem.getCPInstanceId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            sb.append("commerceOrderItem.CPInstanceId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(CPInstanceId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByCPInstanceId_First(long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCPInstanceId_First(CPInstanceId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("CPInstanceId=");
        sb.append(CPInstanceId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByCPInstanceId_First(long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByCPInstanceId(CPInstanceId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByCPInstanceId_Last(long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByCPInstanceId_Last(CPInstanceId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("CPInstanceId=");
        sb.append(CPInstanceId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByCPInstanceId_Last(long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByCPInstanceId(CPInstanceId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByCPInstanceId(CPInstanceId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByCPInstanceId_PrevAndNext(long commerceOrderItemId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByCPInstanceId_PrevAndNext(session, commerceOrderItem, CPInstanceId, orderByComparator, true), commerceOrderItem, this.getByCPInstanceId_PrevAndNext(session, commerceOrderItem, CPInstanceId, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByCPInstanceId_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        sb.append("commerceOrderItem.CPInstanceId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(CPInstanceId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByCPInstanceId(long CPInstanceId) {
        for (CommerceOrderItem commerceOrderItem : this.findByCPInstanceId(CPInstanceId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByCPInstanceId(long CPInstanceId) {
        FinderPath finderPath = this._finderPathCountByCPInstanceId;
        Object[] finderArgs = new Object[]{CPInstanceId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            sb.append("commerceOrderItem.CPInstanceId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(CPInstanceId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderItem> findByParentCommerceOrderItemId(long parentCommerceOrderItemId) {
        return this.findByParentCommerceOrderItemId(parentCommerceOrderItemId, -1, -1, null);
    }

    public List<CommerceOrderItem> findByParentCommerceOrderItemId(long parentCommerceOrderItemId, int start, int end) {
        return this.findByParentCommerceOrderItemId(parentCommerceOrderItemId, start, end, null);
    }

    public List<CommerceOrderItem> findByParentCommerceOrderItemId(long parentCommerceOrderItemId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByParentCommerceOrderItemId(parentCommerceOrderItemId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByParentCommerceOrderItemId(long parentCommerceOrderItemId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByParentCommerceOrderItemId;
                finderArgs = new Object[]{parentCommerceOrderItemId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByParentCommerceOrderItemId;
            finderArgs = new Object[]{parentCommerceOrderItemId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (parentCommerceOrderItemId == commerceOrderItem.getParentCommerceOrderItemId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_PARENTCOMMERCEORDERITEMID_PARENTCOMMERCEORDERITEMID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(parentCommerceOrderItemId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByParentCommerceOrderItemId_First(long parentCommerceOrderItemId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByParentCommerceOrderItemId_First(parentCommerceOrderItemId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("parentCommerceOrderItemId=");
        sb.append(parentCommerceOrderItemId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByParentCommerceOrderItemId_First(long parentCommerceOrderItemId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByParentCommerceOrderItemId(parentCommerceOrderItemId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByParentCommerceOrderItemId_Last(long parentCommerceOrderItemId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByParentCommerceOrderItemId_Last(parentCommerceOrderItemId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("parentCommerceOrderItemId=");
        sb.append(parentCommerceOrderItemId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByParentCommerceOrderItemId_Last(long parentCommerceOrderItemId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByParentCommerceOrderItemId(parentCommerceOrderItemId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByParentCommerceOrderItemId(parentCommerceOrderItemId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByParentCommerceOrderItemId_PrevAndNext(long commerceOrderItemId, long parentCommerceOrderItemId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByParentCommerceOrderItemId_PrevAndNext(session, commerceOrderItem, parentCommerceOrderItemId, orderByComparator, true), commerceOrderItem, this.getByParentCommerceOrderItemId_PrevAndNext(session, commerceOrderItem, parentCommerceOrderItemId, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByParentCommerceOrderItemId_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long parentCommerceOrderItemId, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        sb.append(_FINDER_COLUMN_PARENTCOMMERCEORDERITEMID_PARENTCOMMERCEORDERITEMID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(parentCommerceOrderItemId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByParentCommerceOrderItemId(long parentCommerceOrderItemId) {
        for (CommerceOrderItem commerceOrderItem : this.findByParentCommerceOrderItemId(parentCommerceOrderItemId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByParentCommerceOrderItemId(long parentCommerceOrderItemId) {
        FinderPath finderPath = this._finderPathCountByParentCommerceOrderItemId;
        Object[] finderArgs = new Object[]{parentCommerceOrderItemId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_PARENTCOMMERCEORDERITEMID_PARENTCOMMERCEORDERITEMID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(parentCommerceOrderItemId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceOrderItem findByBookedQuantityId(long bookedQuantityId) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByBookedQuantityId(bookedQuantityId);
        if (commerceOrderItem == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("bookedQuantityId=");
            sb.append(bookedQuantityId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchOrderItemException(sb.toString());
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem fetchByBookedQuantityId(long bookedQuantityId) {
        return this.fetchByBookedQuantityId(bookedQuantityId, true);
    }

    public CommerceOrderItem fetchByBookedQuantityId(long bookedQuantityId, boolean useFinderCache) {
        CommerceOrderItem commerceOrderItem;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{bookedQuantityId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByBookedQuantityId, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommerceOrderItem && bookedQuantityId != (commerceOrderItem = (CommerceOrderItem)result).getBookedQuantityId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_BOOKEDQUANTITYID_BOOKEDQUANTITYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(bookedQuantityId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByBookedQuantityId, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{bookedQuantityId};
                            }
                            _log.warn((Object)("CommerceOrderItemPersistenceImpl.fetchByBookedQuantityId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    CommerceOrderItem commerceOrderItem2 = (CommerceOrderItem)list.get(0);
                    result = commerceOrderItem2;
                    this.cacheResult(commerceOrderItem2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceOrderItem)result;
    }

    public CommerceOrderItem removeByBookedQuantityId(long bookedQuantityId) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByBookedQuantityId(bookedQuantityId);
        return (CommerceOrderItem)this.remove((BaseModel)commerceOrderItem);
    }

    public int countByBookedQuantityId(long bookedQuantityId) {
        FinderPath finderPath = this._finderPathCountByBookedQuantityId;
        Object[] finderArgs = new Object[]{bookedQuantityId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_BOOKEDQUANTITYID_BOOKEDQUANTITYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(bookedQuantityId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderItem> findByC_I(long commerceOrderId, long CPInstanceId) {
        return this.findByC_I(commerceOrderId, CPInstanceId, -1, -1, null);
    }

    public List<CommerceOrderItem> findByC_I(long commerceOrderId, long CPInstanceId, int start, int end) {
        return this.findByC_I(commerceOrderId, CPInstanceId, start, end, null);
    }

    public List<CommerceOrderItem> findByC_I(long commerceOrderId, long CPInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByC_I(commerceOrderId, CPInstanceId, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByC_I(long commerceOrderId, long CPInstanceId, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_I;
                finderArgs = new Object[]{commerceOrderId, CPInstanceId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_I;
            finderArgs = new Object[]{commerceOrderId, CPInstanceId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (commerceOrderId == commerceOrderItem.getCommerceOrderId() && CPInstanceId == commerceOrderItem.getCPInstanceId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            sb.append("commerceOrderItem.commerceOrderId = ? AND ");
            sb.append("commerceOrderItem.CPInstanceId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                queryPos.add(CPInstanceId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByC_I_First(long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_I_First(commerceOrderId, CPInstanceId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append(", CPInstanceId=");
        sb.append(CPInstanceId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByC_I_First(long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByC_I(commerceOrderId, CPInstanceId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByC_I_Last(long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_I_Last(commerceOrderId, CPInstanceId, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append(", CPInstanceId=");
        sb.append(CPInstanceId);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByC_I_Last(long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByC_I(commerceOrderId, CPInstanceId);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByC_I(commerceOrderId, CPInstanceId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByC_I_PrevAndNext(long commerceOrderItemId, long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByC_I_PrevAndNext(session, commerceOrderItem, commerceOrderId, CPInstanceId, orderByComparator, true), commerceOrderItem, this.getByC_I_PrevAndNext(session, commerceOrderItem, commerceOrderId, CPInstanceId, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByC_I_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long commerceOrderId, long CPInstanceId, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        sb.append("commerceOrderItem.commerceOrderId = ? AND ");
        sb.append("commerceOrderItem.CPInstanceId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(commerceOrderId);
        queryPos.add(CPInstanceId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByC_I(long commerceOrderId, long CPInstanceId) {
        for (CommerceOrderItem commerceOrderItem : this.findByC_I(commerceOrderId, CPInstanceId, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByC_I(long commerceOrderId, long CPInstanceId) {
        FinderPath finderPath = this._finderPathCountByC_I;
        Object[] finderArgs = new Object[]{commerceOrderId, CPInstanceId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            sb.append("commerceOrderItem.commerceOrderId = ? AND ");
            sb.append("commerceOrderItem.CPInstanceId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                queryPos.add(CPInstanceId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceOrderItem> findByC_S(long commerceOrderId, boolean subscription) {
        return this.findByC_S(commerceOrderId, subscription, -1, -1, null);
    }

    public List<CommerceOrderItem> findByC_S(long commerceOrderId, boolean subscription, int start, int end) {
        return this.findByC_S(commerceOrderId, subscription, start, end, null);
    }

    public List<CommerceOrderItem> findByC_S(long commerceOrderId, boolean subscription, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findByC_S(commerceOrderId, subscription, start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findByC_S(long commerceOrderId, boolean subscription, int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_S;
                finderArgs = new Object[]{commerceOrderId, subscription};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_S;
            finderArgs = new Object[]{commerceOrderId, subscription, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceOrderItem commerceOrderItem : list) {
                if (commerceOrderId == commerceOrderItem.getCommerceOrderId() && subscription == commerceOrderItem.isSubscription()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            sb.append("commerceOrderItem.commerceOrderId = ? AND ");
            sb.append(_FINDER_COLUMN_C_S_SUBSCRIPTION_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY commerceOrderItem.createDate ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                queryPos.add(subscription);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceOrderItem findByC_S_First(long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_S_First(commerceOrderId, subscription, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append(", subscription=");
        sb.append(subscription);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByC_S_First(long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) {
        List<CommerceOrderItem> list = this.findByC_S(commerceOrderId, subscription, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem findByC_S_Last(long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_S_Last(commerceOrderId, subscription, orderByComparator);
        if (commerceOrderItem != null) {
            return commerceOrderItem;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("commerceOrderId=");
        sb.append(commerceOrderId);
        sb.append(", subscription=");
        sb.append(subscription);
        sb.append("}");
        throw new NoSuchOrderItemException(sb.toString());
    }

    public CommerceOrderItem fetchByC_S_Last(long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) {
        int count = this.countByC_S(commerceOrderId, subscription);
        if (count == 0) {
            return null;
        }
        List<CommerceOrderItem> list = this.findByC_S(commerceOrderId, subscription, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceOrderItem[] findByC_S_PrevAndNext(long commerceOrderItemId, long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByPrimaryKey(commerceOrderItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem[] array = new CommerceOrderItemImpl[]{this.getByC_S_PrevAndNext(session, commerceOrderItem, commerceOrderId, subscription, orderByComparator, true), commerceOrderItem, this.getByC_S_PrevAndNext(session, commerceOrderItem, commerceOrderId, subscription, orderByComparator, false)};
            CommerceOrderItem[] commerceOrderItemArray = array;
            return commerceOrderItemArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem getByC_S_PrevAndNext(Session session, CommerceOrderItem commerceOrderItem, long commerceOrderId, boolean subscription, OrderByComparator<CommerceOrderItem> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
        sb.append("commerceOrderItem.commerceOrderId = ? AND ");
        sb.append(_FINDER_COLUMN_C_S_SUBSCRIPTION_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY commerceOrderItem.createDate ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(commerceOrderId);
        queryPos.add(subscription);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)commerceOrderItem)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CommerceOrderItem)list.get(1);
        }
        return null;
    }

    public void removeByC_S(long commerceOrderId, boolean subscription) {
        for (CommerceOrderItem commerceOrderItem : this.findByC_S(commerceOrderId, subscription, -1, -1, null)) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countByC_S(long commerceOrderId, boolean subscription) {
        FinderPath finderPath = this._finderPathCountByC_S;
        Object[] finderArgs = new Object[]{commerceOrderId, subscription};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            sb.append("commerceOrderItem.commerceOrderId = ? AND ");
            sb.append(_FINDER_COLUMN_C_S_SUBSCRIPTION_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(commerceOrderId);
                queryPos.add(subscription);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceOrderItem findByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.fetchByC_ERC(companyId, externalReferenceCode);
        if (commerceOrderItem == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchOrderItemException(sb.toString());
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem fetchByC_ERC(long companyId, String externalReferenceCode) {
        return this.fetchByC_ERC(companyId, externalReferenceCode, true);
    }

    public CommerceOrderItem fetchByC_ERC(long companyId, String externalReferenceCode, boolean useFinderCache) {
        CommerceOrderItem commerceOrderItem;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, externalReferenceCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_ERC, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommerceOrderItem && (companyId != (commerceOrderItem = (CommerceOrderItem)result).getCompanyId() || !Objects.equals(externalReferenceCode, commerceOrderItem.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_ERC, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{companyId, externalReferenceCode};
                            }
                            _log.warn((Object)("CommerceOrderItemPersistenceImpl.fetchByC_ERC(long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    CommerceOrderItem commerceOrderItem2 = (CommerceOrderItem)list.get(0);
                    result = commerceOrderItem2;
                    this.cacheResult(commerceOrderItem2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceOrderItem)result;
    }

    public CommerceOrderItem removeByC_ERC(long companyId, String externalReferenceCode) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = this.findByC_ERC(companyId, externalReferenceCode);
        return (CommerceOrderItem)this.remove((BaseModel)commerceOrderItem);
    }

    public int countByC_ERC(long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByC_ERC;
        Object[] finderArgs = new Object[]{companyId, externalReferenceCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_COMMERCEORDERITEM_WHERE);
            sb.append(_FINDER_COLUMN_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceOrderItemPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("discountPercentageLevel1WithTaxAmount", "discountPctLevel1WithTaxAmount");
        dbColumnNames.put("discountPercentageLevel2WithTaxAmount", "discountPctLevel2WithTaxAmount");
        dbColumnNames.put("discountPercentageLevel3WithTaxAmount", "discountPctLevel3WithTaxAmount");
        dbColumnNames.put("discountPercentageLevel4WithTaxAmount", "discountPctLevel4WithTaxAmount");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(CommerceOrderItem.class);
        this.setModelImplClass(CommerceOrderItemImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CommerceOrderItemTable.INSTANCE);
    }

    public void cacheResult(CommerceOrderItem commerceOrderItem) {
        this.entityCache.putResult(CommerceOrderItemImpl.class, (Serializable)Long.valueOf(commerceOrderItem.getPrimaryKey()), (Serializable)commerceOrderItem);
        this.finderCache.putResult(this._finderPathFetchByBookedQuantityId, new Object[]{commerceOrderItem.getBookedQuantityId()}, (Object)commerceOrderItem);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, new Object[]{commerceOrderItem.getCompanyId(), commerceOrderItem.getExternalReferenceCode()}, (Object)commerceOrderItem);
    }

    public void cacheResult(List<CommerceOrderItem> commerceOrderItems) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && commerceOrderItems.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            if (this.entityCache.getResult(CommerceOrderItemImpl.class, (Serializable)Long.valueOf(commerceOrderItem.getPrimaryKey())) != null) continue;
            this.cacheResult(commerceOrderItem);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceOrderItemImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceOrderItem commerceOrderItem) {
        this.entityCache.removeResult(CommerceOrderItemImpl.class, (BaseModel)commerceOrderItem);
    }

    public void clearCache(List<CommerceOrderItem> commerceOrderItems) {
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.entityCache.removeResult(CommerceOrderItemImpl.class, (BaseModel)commerceOrderItem);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CommerceOrderItemImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(CommerceOrderItemModelImpl commerceOrderItemModelImpl) {
        Object[] args = new Object[]{commerceOrderItemModelImpl.getBookedQuantityId()};
        this.finderCache.putResult(this._finderPathCountByBookedQuantityId, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByBookedQuantityId, args, (Object)commerceOrderItemModelImpl, false);
        args = new Object[]{commerceOrderItemModelImpl.getCompanyId(), commerceOrderItemModelImpl.getExternalReferenceCode()};
        this.finderCache.putResult(this._finderPathCountByC_ERC, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_ERC, args, (Object)commerceOrderItemModelImpl, false);
    }

    public CommerceOrderItem create(long commerceOrderItemId) {
        CommerceOrderItemImpl commerceOrderItem = new CommerceOrderItemImpl();
        commerceOrderItem.setNew(true);
        commerceOrderItem.setPrimaryKey(commerceOrderItemId);
        commerceOrderItem.setCompanyId(CompanyThreadLocal.getCompanyId());
        return commerceOrderItem;
    }

    public CommerceOrderItem remove(long commerceOrderItemId) throws NoSuchOrderItemException {
        return this.remove(Long.valueOf(commerceOrderItemId));
    }

    public CommerceOrderItem remove(Serializable primaryKey) throws NoSuchOrderItemException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceOrderItem commerceOrderItem = (CommerceOrderItem)session.get(CommerceOrderItemImpl.class, primaryKey);
            if (commerceOrderItem == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceOrderItem commerceOrderItem2 = (CommerceOrderItem)this.remove((BaseModel)commerceOrderItem);
            return commerceOrderItem2;
        }
        catch (NoSuchOrderItemException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceOrderItem removeImpl(CommerceOrderItem commerceOrderItem) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceOrderItem)) {
                commerceOrderItem = (CommerceOrderItem)session.get(CommerceOrderItemImpl.class, commerceOrderItem.getPrimaryKeyObj());
            }
            if (commerceOrderItem != null) {
                session.delete((Object)commerceOrderItem);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceOrderItem != null) {
            this.clearCache(commerceOrderItem);
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem updateImpl(CommerceOrderItem commerceOrderItem) {
        boolean isNew = commerceOrderItem.isNew();
        if (!(commerceOrderItem instanceof CommerceOrderItemModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceOrderItem.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceOrderItem);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceOrderItem proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceOrderItem implementation " + commerceOrderItem.getClass());
        }
        CommerceOrderItemModelImpl commerceOrderItemModelImpl = (CommerceOrderItemModelImpl)commerceOrderItem;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && commerceOrderItem.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceOrderItem.setCreateDate(date);
            } else {
                commerceOrderItem.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!commerceOrderItemModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceOrderItem.setModifiedDate(date);
            } else {
                commerceOrderItem.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)commerceOrderItem);
            } else {
                commerceOrderItem = (CommerceOrderItem)session.merge((Object)commerceOrderItem);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CommerceOrderItemImpl.class, (BaseModel)commerceOrderItemModelImpl, false, true);
        this.cacheUniqueFindersCache(commerceOrderItemModelImpl);
        if (isNew) {
            commerceOrderItem.setNew(false);
        }
        commerceOrderItem.resetOriginalValues();
        return commerceOrderItem;
    }

    public CommerceOrderItem findByPrimaryKey(Serializable primaryKey) throws NoSuchOrderItemException {
        CommerceOrderItem commerceOrderItem = (CommerceOrderItem)this.fetchByPrimaryKey(primaryKey);
        if (commerceOrderItem == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchOrderItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceOrderItem;
    }

    public CommerceOrderItem findByPrimaryKey(long commerceOrderItemId) throws NoSuchOrderItemException {
        return this.findByPrimaryKey(Long.valueOf(commerceOrderItemId));
    }

    public CommerceOrderItem fetchByPrimaryKey(long commerceOrderItemId) {
        return (CommerceOrderItem)this.fetchByPrimaryKey(Long.valueOf(commerceOrderItemId));
    }

    public List<CommerceOrderItem> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceOrderItem> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceOrderItem> findAll(int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceOrderItem> findAll(int start, int end, OrderByComparator<CommerceOrderItem> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_COMMERCEORDERITEM);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_COMMERCEORDERITEM;
                sql = sql.concat(" ORDER BY commerceOrderItem.createDate ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceOrderItem commerceOrderItem : this.findAll()) {
            this.remove((BaseModel)commerceOrderItem);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_COMMERCEORDERITEM);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "commerceOrderItemId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_COMMERCEORDERITEM;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceOrderItemModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        Bundle bundle = FrameworkUtil.getBundle(CommerceOrderItemPersistenceImpl.class);
        this._bundleContext = bundle.getBundleContext();
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new CommerceOrderItemModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)CommerceOrderItem.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCommerceOrderId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCommerceOrderId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"commerceOrderId"}, true);
        this._finderPathWithoutPaginationFindByCommerceOrderId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCommerceOrderId", new String[]{Long.class.getName()}, new String[]{"commerceOrderId"}, true);
        this._finderPathCountByCommerceOrderId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCommerceOrderId", new String[]{Long.class.getName()}, new String[]{"commerceOrderId"}, false);
        this._finderPathWithPaginationFindByCProductId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCProductId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"CProductId"}, true);
        this._finderPathWithoutPaginationFindByCProductId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCProductId", new String[]{Long.class.getName()}, new String[]{"CProductId"}, true);
        this._finderPathCountByCProductId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCProductId", new String[]{Long.class.getName()}, new String[]{"CProductId"}, false);
        this._finderPathWithPaginationFindByCPInstanceId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCPInstanceId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"CPInstanceId"}, true);
        this._finderPathWithoutPaginationFindByCPInstanceId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCPInstanceId", new String[]{Long.class.getName()}, new String[]{"CPInstanceId"}, true);
        this._finderPathCountByCPInstanceId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCPInstanceId", new String[]{Long.class.getName()}, new String[]{"CPInstanceId"}, false);
        this._finderPathWithPaginationFindByParentCommerceOrderItemId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByParentCommerceOrderItemId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"parentCommerceOrderItemId"}, true);
        this._finderPathWithoutPaginationFindByParentCommerceOrderItemId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByParentCommerceOrderItemId", new String[]{Long.class.getName()}, new String[]{"parentCommerceOrderItemId"}, true);
        this._finderPathCountByParentCommerceOrderItemId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByParentCommerceOrderItemId", new String[]{Long.class.getName()}, new String[]{"parentCommerceOrderItemId"}, false);
        this._finderPathFetchByBookedQuantityId = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByBookedQuantityId", new String[]{Long.class.getName()}, new String[]{"bookedQuantityId"}, true);
        this._finderPathCountByBookedQuantityId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByBookedQuantityId", new String[]{Long.class.getName()}, new String[]{"bookedQuantityId"}, false);
        this._finderPathWithPaginationFindByC_I = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_I", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"commerceOrderId", "CPInstanceId"}, true);
        this._finderPathWithoutPaginationFindByC_I = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_I", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"commerceOrderId", "CPInstanceId"}, true);
        this._finderPathCountByC_I = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_I", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"commerceOrderId", "CPInstanceId"}, false);
        this._finderPathWithPaginationFindByC_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"commerceOrderId", "subscription"}, true);
        this._finderPathWithoutPaginationFindByC_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_S", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"commerceOrderId", "subscription"}, true);
        this._finderPathCountByC_S = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_S", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"commerceOrderId", "subscription"}, false);
        this._finderPathFetchByC_ERC = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, true);
        this._finderPathCountByC_ERC = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_ERC", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"companyId", "externalReferenceCode"}, false);
        this._setCommerceOrderItemUtilPersistence(this);
    }

    public void destroy() {
        this._setCommerceOrderItemUtilPersistence(null);
        this.entityCache.removeCache(CommerceOrderItemImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    private void _setCommerceOrderItemUtilPersistence(CommerceOrderItemPersistence commerceOrderItemPersistence) {
        try {
            Field field = CommerceOrderItemUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, commerceOrderItemPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class CommerceOrderItemModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private CommerceOrderItemModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            CommerceOrderItemModelImpl commerceOrderItemModelImpl = (CommerceOrderItemModelImpl)baseModel;
            long columnBitmask = commerceOrderItemModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return CommerceOrderItemModelArgumentsResolver._getValue(commerceOrderItemModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | CommerceOrderItemModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return CommerceOrderItemModelArgumentsResolver._getValue(commerceOrderItemModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(CommerceOrderItemModelImpl commerceOrderItemModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? commerceOrderItemModelImpl.getColumnOriginalValue(columnName) : commerceOrderItemModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask = 0L;
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask |= CommerceOrderItemModelImpl.getColumnBitmask("createDate");
        }
    }
}

