/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderModel;
import com.liferay.commerce.model.CommerceOrderSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceOrder service. Represents a row in the &quot;CommerceOrder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceOrderModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceOrderImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceOrderImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceOrderModelImpl
	extends BaseModelImpl<CommerceOrder> implements CommerceOrderModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce order model instance should use the <code>CommerceOrder</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceOrder";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"externalReferenceCode", Types.VARCHAR},
		{"commerceOrderId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"commerceAccountId", Types.BIGINT},
		{"commerceCurrencyId", Types.BIGINT},
		{"billingAddressId", Types.BIGINT}, {"shippingAddressId", Types.BIGINT},
		{"commercePaymentMethodKey", Types.VARCHAR},
		{"transactionId", Types.CLOB},
		{"commerceShippingMethodId", Types.BIGINT},
		{"shippingOptionName", Types.VARCHAR},
		{"purchaseOrderNumber", Types.VARCHAR}, {"couponCode", Types.VARCHAR},
		{"lastPriceUpdateDate", Types.TIMESTAMP}, {"subtotal", Types.DECIMAL},
		{"subtotalDiscountAmount", Types.DECIMAL},
		{"subtotalDiscountPercentLevel1", Types.DECIMAL},
		{"subtotalDiscountPercentLevel2", Types.DECIMAL},
		{"subtotalDiscountPercentLevel3", Types.DECIMAL},
		{"subtotalDiscountPercentLevel4", Types.DECIMAL},
		{"shippingAmount", Types.DECIMAL},
		{"shippingDiscountAmount", Types.DECIMAL},
		{"shippingDiscountPercentLevel1", Types.DECIMAL},
		{"shippingDiscountPercentLevel2", Types.DECIMAL},
		{"shippingDiscountPercentLevel3", Types.DECIMAL},
		{"shippingDiscountPercentLevel4", Types.DECIMAL},
		{"taxAmount", Types.DECIMAL}, {"total", Types.DECIMAL},
		{"totalDiscountAmount", Types.DECIMAL},
		{"totalDiscountPercentageLevel1", Types.DECIMAL},
		{"totalDiscountPercentageLevel2", Types.DECIMAL},
		{"totalDiscountPercentageLevel3", Types.DECIMAL},
		{"totalDiscountPercentageLevel4", Types.DECIMAL},
		{"subtotalWithTaxAmount", Types.DECIMAL},
		{"subtotalDiscountWithTaxAmount", Types.DECIMAL},
		{"subtotalDiscountPctLev1WithTax", Types.DECIMAL},
		{"subtotalDiscountPctLev2WithTax", Types.DECIMAL},
		{"subtotalDiscountPctLev3WithTax", Types.DECIMAL},
		{"subtotalDiscountPctLev4WithTax", Types.DECIMAL},
		{"shippingWithTaxAmount", Types.DECIMAL},
		{"shippingDiscountWithTaxAmount", Types.DECIMAL},
		{"shippingDiscountPctLev1WithTax", Types.DECIMAL},
		{"shippingDiscountPctLev2WithTax", Types.DECIMAL},
		{"shippingDiscountPctLev3WithTax", Types.DECIMAL},
		{"shippingDiscountPctLev4WithTax", Types.DECIMAL},
		{"totalWithTaxAmount", Types.DECIMAL},
		{"totalDiscountWithTaxAmount", Types.DECIMAL},
		{"totalDiscountPctLev1WithTax", Types.DECIMAL},
		{"totalDiscountPctLev2WithTax", Types.DECIMAL},
		{"totalDiscountPctLev3WithTax", Types.DECIMAL},
		{"totalDiscountPctLev4WithTax", Types.DECIMAL},
		{"advanceStatus", Types.VARCHAR}, {"paymentStatus", Types.INTEGER},
		{"orderDate", Types.TIMESTAMP}, {"orderStatus", Types.INTEGER},
		{"printedNote", Types.VARCHAR},
		{"requestedDeliveryDate", Types.TIMESTAMP},
		{"manuallyAdjusted", Types.BOOLEAN}, {"status", Types.INTEGER},
		{"statusByUserId", Types.BIGINT}, {"statusByUserName", Types.VARCHAR},
		{"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceOrderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceAccountId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceCurrencyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("billingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shippingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commercePaymentMethodKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("transactionId", Types.CLOB);
		TABLE_COLUMNS_MAP.put("commerceShippingMethodId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shippingOptionName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("purchaseOrderNumber", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("couponCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPriceUpdateDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("subtotal", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("taxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("total", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPctLev1WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPctLev2WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPctLev3WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPctLev4WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPctLev1WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPctLev2WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPctLev3WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPctLev4WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountWithTaxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPctLev1WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPctLev2WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPctLev3WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPctLev4WithTax", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("advanceStatus", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("paymentStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("orderDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("orderStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("printedNote", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("requestedDeliveryDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("manuallyAdjusted", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceOrder (uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commerceOrderId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceAccountId LONG,commerceCurrencyId LONG,billingAddressId LONG,shippingAddressId LONG,commercePaymentMethodKey VARCHAR(75) null,transactionId TEXT null,commerceShippingMethodId LONG,shippingOptionName VARCHAR(255) null,purchaseOrderNumber VARCHAR(75) null,couponCode VARCHAR(75) null,lastPriceUpdateDate DATE null,subtotal DECIMAL(30, 16) null,subtotalDiscountAmount DECIMAL(30, 16) null,subtotalDiscountPercentLevel1 DECIMAL(30, 16) null,subtotalDiscountPercentLevel2 DECIMAL(30, 16) null,subtotalDiscountPercentLevel3 DECIMAL(30, 16) null,subtotalDiscountPercentLevel4 DECIMAL(30, 16) null,shippingAmount DECIMAL(30, 16) null,shippingDiscountAmount DECIMAL(30, 16) null,shippingDiscountPercentLevel1 DECIMAL(30, 16) null,shippingDiscountPercentLevel2 DECIMAL(30, 16) null,shippingDiscountPercentLevel3 DECIMAL(30, 16) null,shippingDiscountPercentLevel4 DECIMAL(30, 16) null,taxAmount DECIMAL(30, 16) null,total DECIMAL(30, 16) null,totalDiscountAmount DECIMAL(30, 16) null,totalDiscountPercentageLevel1 DECIMAL(30, 16) null,totalDiscountPercentageLevel2 DECIMAL(30, 16) null,totalDiscountPercentageLevel3 DECIMAL(30, 16) null,totalDiscountPercentageLevel4 DECIMAL(30, 16) null,subtotalWithTaxAmount DECIMAL(30, 16) null,subtotalDiscountWithTaxAmount DECIMAL(30, 16) null,subtotalDiscountPctLev1WithTax DECIMAL(30, 16) null,subtotalDiscountPctLev2WithTax DECIMAL(30, 16) null,subtotalDiscountPctLev3WithTax DECIMAL(30, 16) null,subtotalDiscountPctLev4WithTax DECIMAL(30, 16) null,shippingWithTaxAmount DECIMAL(30, 16) null,shippingDiscountWithTaxAmount DECIMAL(30, 16) null,shippingDiscountPctLev1WithTax DECIMAL(30, 16) null,shippingDiscountPctLev2WithTax DECIMAL(30, 16) null,shippingDiscountPctLev3WithTax DECIMAL(30, 16) null,shippingDiscountPctLev4WithTax DECIMAL(30, 16) null,totalWithTaxAmount DECIMAL(30, 16) null,totalDiscountWithTaxAmount DECIMAL(30, 16) null,totalDiscountPctLev1WithTax DECIMAL(30, 16) null,totalDiscountPctLev2WithTax DECIMAL(30, 16) null,totalDiscountPctLev3WithTax DECIMAL(30, 16) null,totalDiscountPctLev4WithTax DECIMAL(30, 16) null,advanceStatus VARCHAR(75) null,paymentStatus INTEGER,orderDate DATE null,orderStatus INTEGER,printedNote STRING null,requestedDeliveryDate DATE null,manuallyAdjusted BOOLEAN,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table CommerceOrder";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceOrder.createDate ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceOrder.createDate ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.commerce.model.CommerceOrder"),
		true);

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static CommerceOrder toModel(CommerceOrderSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceOrder model = new CommerceOrderImpl();

		model.setUuid(soapModel.getUuid());
		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setCommerceOrderId(soapModel.getCommerceOrderId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceAccountId(soapModel.getCommerceAccountId());
		model.setCommerceCurrencyId(soapModel.getCommerceCurrencyId());
		model.setBillingAddressId(soapModel.getBillingAddressId());
		model.setShippingAddressId(soapModel.getShippingAddressId());
		model.setCommercePaymentMethodKey(
			soapModel.getCommercePaymentMethodKey());
		model.setTransactionId(soapModel.getTransactionId());
		model.setCommerceShippingMethodId(
			soapModel.getCommerceShippingMethodId());
		model.setShippingOptionName(soapModel.getShippingOptionName());
		model.setPurchaseOrderNumber(soapModel.getPurchaseOrderNumber());
		model.setCouponCode(soapModel.getCouponCode());
		model.setLastPriceUpdateDate(soapModel.getLastPriceUpdateDate());
		model.setSubtotal(soapModel.getSubtotal());
		model.setSubtotalDiscountAmount(soapModel.getSubtotalDiscountAmount());
		model.setSubtotalDiscountPercentageLevel1(
			soapModel.getSubtotalDiscountPercentageLevel1());
		model.setSubtotalDiscountPercentageLevel2(
			soapModel.getSubtotalDiscountPercentageLevel2());
		model.setSubtotalDiscountPercentageLevel3(
			soapModel.getSubtotalDiscountPercentageLevel3());
		model.setSubtotalDiscountPercentageLevel4(
			soapModel.getSubtotalDiscountPercentageLevel4());
		model.setShippingAmount(soapModel.getShippingAmount());
		model.setShippingDiscountAmount(soapModel.getShippingDiscountAmount());
		model.setShippingDiscountPercentageLevel1(
			soapModel.getShippingDiscountPercentageLevel1());
		model.setShippingDiscountPercentageLevel2(
			soapModel.getShippingDiscountPercentageLevel2());
		model.setShippingDiscountPercentageLevel3(
			soapModel.getShippingDiscountPercentageLevel3());
		model.setShippingDiscountPercentageLevel4(
			soapModel.getShippingDiscountPercentageLevel4());
		model.setTaxAmount(soapModel.getTaxAmount());
		model.setTotal(soapModel.getTotal());
		model.setTotalDiscountAmount(soapModel.getTotalDiscountAmount());
		model.setTotalDiscountPercentageLevel1(
			soapModel.getTotalDiscountPercentageLevel1());
		model.setTotalDiscountPercentageLevel2(
			soapModel.getTotalDiscountPercentageLevel2());
		model.setTotalDiscountPercentageLevel3(
			soapModel.getTotalDiscountPercentageLevel3());
		model.setTotalDiscountPercentageLevel4(
			soapModel.getTotalDiscountPercentageLevel4());
		model.setSubtotalWithTaxAmount(soapModel.getSubtotalWithTaxAmount());
		model.setSubtotalDiscountWithTaxAmount(
			soapModel.getSubtotalDiscountWithTaxAmount());
		model.setSubtotalDiscountPercentageLevel1WithTaxAmount(
			soapModel.getSubtotalDiscountPercentageLevel1WithTaxAmount());
		model.setSubtotalDiscountPercentageLevel2WithTaxAmount(
			soapModel.getSubtotalDiscountPercentageLevel2WithTaxAmount());
		model.setSubtotalDiscountPercentageLevel3WithTaxAmount(
			soapModel.getSubtotalDiscountPercentageLevel3WithTaxAmount());
		model.setSubtotalDiscountPercentageLevel4WithTaxAmount(
			soapModel.getSubtotalDiscountPercentageLevel4WithTaxAmount());
		model.setShippingWithTaxAmount(soapModel.getShippingWithTaxAmount());
		model.setShippingDiscountWithTaxAmount(
			soapModel.getShippingDiscountWithTaxAmount());
		model.setShippingDiscountPercentageLevel1WithTaxAmount(
			soapModel.getShippingDiscountPercentageLevel1WithTaxAmount());
		model.setShippingDiscountPercentageLevel2WithTaxAmount(
			soapModel.getShippingDiscountPercentageLevel2WithTaxAmount());
		model.setShippingDiscountPercentageLevel3WithTaxAmount(
			soapModel.getShippingDiscountPercentageLevel3WithTaxAmount());
		model.setShippingDiscountPercentageLevel4WithTaxAmount(
			soapModel.getShippingDiscountPercentageLevel4WithTaxAmount());
		model.setTotalWithTaxAmount(soapModel.getTotalWithTaxAmount());
		model.setTotalDiscountWithTaxAmount(
			soapModel.getTotalDiscountWithTaxAmount());
		model.setTotalDiscountPercentageLevel1WithTaxAmount(
			soapModel.getTotalDiscountPercentageLevel1WithTaxAmount());
		model.setTotalDiscountPercentageLevel2WithTaxAmount(
			soapModel.getTotalDiscountPercentageLevel2WithTaxAmount());
		model.setTotalDiscountPercentageLevel3WithTaxAmount(
			soapModel.getTotalDiscountPercentageLevel3WithTaxAmount());
		model.setTotalDiscountPercentageLevel4WithTaxAmount(
			soapModel.getTotalDiscountPercentageLevel4WithTaxAmount());
		model.setAdvanceStatus(soapModel.getAdvanceStatus());
		model.setPaymentStatus(soapModel.getPaymentStatus());
		model.setOrderDate(soapModel.getOrderDate());
		model.setOrderStatus(soapModel.getOrderStatus());
		model.setPrintedNote(soapModel.getPrintedNote());
		model.setRequestedDeliveryDate(soapModel.getRequestedDeliveryDate());
		model.setManuallyAdjusted(soapModel.isManuallyAdjusted());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<CommerceOrder> toModels(CommerceOrderSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceOrder> models = new ArrayList<CommerceOrder>(
			soapModels.length);

		for (CommerceOrderSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.model.CommerceOrder"));

	public CommerceOrderModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceOrderId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceOrderId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceOrderId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceOrder.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceOrder.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceOrder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrder, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceOrder)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceOrder, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceOrder, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceOrder)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceOrder, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceOrder, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceOrder>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceOrder.class.getClassLoader(), CommerceOrder.class,
			ModelWrapper.class);

		try {
			Constructor<CommerceOrder> constructor =
				(Constructor<CommerceOrder>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<CommerceOrder, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<CommerceOrder, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<CommerceOrder, Object>>();
		Map<String, BiConsumer<CommerceOrder, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<CommerceOrder, ?>>();

		attributeGetterFunctions.put("uuid", CommerceOrder::getUuid);
		attributeSetterBiConsumers.put(
			"uuid", (BiConsumer<CommerceOrder, String>)CommerceOrder::setUuid);
		attributeGetterFunctions.put(
			"externalReferenceCode", CommerceOrder::getExternalReferenceCode);
		attributeSetterBiConsumers.put(
			"externalReferenceCode",
			(BiConsumer<CommerceOrder, String>)
				CommerceOrder::setExternalReferenceCode);
		attributeGetterFunctions.put(
			"commerceOrderId", CommerceOrder::getCommerceOrderId);
		attributeSetterBiConsumers.put(
			"commerceOrderId",
			(BiConsumer<CommerceOrder, Long>)CommerceOrder::setCommerceOrderId);
		attributeGetterFunctions.put("groupId", CommerceOrder::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<CommerceOrder, Long>)CommerceOrder::setGroupId);
		attributeGetterFunctions.put("companyId", CommerceOrder::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceOrder, Long>)CommerceOrder::setCompanyId);
		attributeGetterFunctions.put("userId", CommerceOrder::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceOrder, Long>)CommerceOrder::setUserId);
		attributeGetterFunctions.put("userName", CommerceOrder::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceOrder, String>)CommerceOrder::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceOrder::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceOrder, Date>)CommerceOrder::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceOrder::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceOrder, Date>)CommerceOrder::setModifiedDate);
		attributeGetterFunctions.put(
			"commerceAccountId", CommerceOrder::getCommerceAccountId);
		attributeSetterBiConsumers.put(
			"commerceAccountId",
			(BiConsumer<CommerceOrder, Long>)
				CommerceOrder::setCommerceAccountId);
		attributeGetterFunctions.put(
			"commerceCurrencyId", CommerceOrder::getCommerceCurrencyId);
		attributeSetterBiConsumers.put(
			"commerceCurrencyId",
			(BiConsumer<CommerceOrder, Long>)
				CommerceOrder::setCommerceCurrencyId);
		attributeGetterFunctions.put(
			"billingAddressId", CommerceOrder::getBillingAddressId);
		attributeSetterBiConsumers.put(
			"billingAddressId",
			(BiConsumer<CommerceOrder, Long>)
				CommerceOrder::setBillingAddressId);
		attributeGetterFunctions.put(
			"shippingAddressId", CommerceOrder::getShippingAddressId);
		attributeSetterBiConsumers.put(
			"shippingAddressId",
			(BiConsumer<CommerceOrder, Long>)
				CommerceOrder::setShippingAddressId);
		attributeGetterFunctions.put(
			"commercePaymentMethodKey",
			CommerceOrder::getCommercePaymentMethodKey);
		attributeSetterBiConsumers.put(
			"commercePaymentMethodKey",
			(BiConsumer<CommerceOrder, String>)
				CommerceOrder::setCommercePaymentMethodKey);
		attributeGetterFunctions.put(
			"transactionId", CommerceOrder::getTransactionId);
		attributeSetterBiConsumers.put(
			"transactionId",
			(BiConsumer<CommerceOrder, String>)CommerceOrder::setTransactionId);
		attributeGetterFunctions.put(
			"commerceShippingMethodId",
			CommerceOrder::getCommerceShippingMethodId);
		attributeSetterBiConsumers.put(
			"commerceShippingMethodId",
			(BiConsumer<CommerceOrder, Long>)
				CommerceOrder::setCommerceShippingMethodId);
		attributeGetterFunctions.put(
			"shippingOptionName", CommerceOrder::getShippingOptionName);
		attributeSetterBiConsumers.put(
			"shippingOptionName",
			(BiConsumer<CommerceOrder, String>)
				CommerceOrder::setShippingOptionName);
		attributeGetterFunctions.put(
			"purchaseOrderNumber", CommerceOrder::getPurchaseOrderNumber);
		attributeSetterBiConsumers.put(
			"purchaseOrderNumber",
			(BiConsumer<CommerceOrder, String>)
				CommerceOrder::setPurchaseOrderNumber);
		attributeGetterFunctions.put(
			"couponCode", CommerceOrder::getCouponCode);
		attributeSetterBiConsumers.put(
			"couponCode",
			(BiConsumer<CommerceOrder, String>)CommerceOrder::setCouponCode);
		attributeGetterFunctions.put(
			"lastPriceUpdateDate", CommerceOrder::getLastPriceUpdateDate);
		attributeSetterBiConsumers.put(
			"lastPriceUpdateDate",
			(BiConsumer<CommerceOrder, Date>)
				CommerceOrder::setLastPriceUpdateDate);
		attributeGetterFunctions.put("subtotal", CommerceOrder::getSubtotal);
		attributeSetterBiConsumers.put(
			"subtotal",
			(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::setSubtotal);
		attributeGetterFunctions.put(
			"subtotalDiscountAmount", CommerceOrder::getSubtotalDiscountAmount);
		attributeSetterBiConsumers.put(
			"subtotalDiscountAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setSubtotalDiscountAmount);
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel1",
			CommerceOrder::getSubtotalDiscountPercentageLevel1);
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel1",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setSubtotalDiscountPercentageLevel1);
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel2",
			CommerceOrder::getSubtotalDiscountPercentageLevel2);
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel2",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setSubtotalDiscountPercentageLevel2);
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel3",
			CommerceOrder::getSubtotalDiscountPercentageLevel3);
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel3",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setSubtotalDiscountPercentageLevel3);
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel4",
			CommerceOrder::getSubtotalDiscountPercentageLevel4);
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel4",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setSubtotalDiscountPercentageLevel4);
		attributeGetterFunctions.put(
			"shippingAmount", CommerceOrder::getShippingAmount);
		attributeSetterBiConsumers.put(
			"shippingAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setShippingAmount);
		attributeGetterFunctions.put(
			"shippingDiscountAmount", CommerceOrder::getShippingDiscountAmount);
		attributeSetterBiConsumers.put(
			"shippingDiscountAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setShippingDiscountAmount);
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel1",
			CommerceOrder::getShippingDiscountPercentageLevel1);
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel1",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setShippingDiscountPercentageLevel1);
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel2",
			CommerceOrder::getShippingDiscountPercentageLevel2);
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel2",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setShippingDiscountPercentageLevel2);
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel3",
			CommerceOrder::getShippingDiscountPercentageLevel3);
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel3",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setShippingDiscountPercentageLevel3);
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel4",
			CommerceOrder::getShippingDiscountPercentageLevel4);
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel4",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setShippingDiscountPercentageLevel4);
		attributeGetterFunctions.put("taxAmount", CommerceOrder::getTaxAmount);
		attributeSetterBiConsumers.put(
			"taxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::setTaxAmount);
		attributeGetterFunctions.put("total", CommerceOrder::getTotal);
		attributeSetterBiConsumers.put(
			"total",
			(BiConsumer<CommerceOrder, BigDecimal>)CommerceOrder::setTotal);
		attributeGetterFunctions.put(
			"totalDiscountAmount", CommerceOrder::getTotalDiscountAmount);
		attributeSetterBiConsumers.put(
			"totalDiscountAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountAmount);
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel1",
			CommerceOrder::getTotalDiscountPercentageLevel1);
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel1",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountPercentageLevel1);
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel2",
			CommerceOrder::getTotalDiscountPercentageLevel2);
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel2",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountPercentageLevel2);
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel3",
			CommerceOrder::getTotalDiscountPercentageLevel3);
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel3",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountPercentageLevel3);
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel4",
			CommerceOrder::getTotalDiscountPercentageLevel4);
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel4",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountPercentageLevel4);
		attributeGetterFunctions.put(
			"subtotalWithTaxAmount", CommerceOrder::getSubtotalWithTaxAmount);
		attributeSetterBiConsumers.put(
			"subtotalWithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setSubtotalWithTaxAmount);
		attributeGetterFunctions.put(
			"subtotalDiscountWithTaxAmount",
			CommerceOrder::getSubtotalDiscountWithTaxAmount);
		attributeSetterBiConsumers.put(
			"subtotalDiscountWithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setSubtotalDiscountWithTaxAmount);
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel1WithTaxAmount",
			CommerceOrder::getSubtotalDiscountPercentageLevel1WithTaxAmount);
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel1WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::
					setSubtotalDiscountPercentageLevel1WithTaxAmount);
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel2WithTaxAmount",
			CommerceOrder::getSubtotalDiscountPercentageLevel2WithTaxAmount);
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel2WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::
					setSubtotalDiscountPercentageLevel2WithTaxAmount);
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel3WithTaxAmount",
			CommerceOrder::getSubtotalDiscountPercentageLevel3WithTaxAmount);
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel3WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::
					setSubtotalDiscountPercentageLevel3WithTaxAmount);
		attributeGetterFunctions.put(
			"subtotalDiscountPercentageLevel4WithTaxAmount",
			CommerceOrder::getSubtotalDiscountPercentageLevel4WithTaxAmount);
		attributeSetterBiConsumers.put(
			"subtotalDiscountPercentageLevel4WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::
					setSubtotalDiscountPercentageLevel4WithTaxAmount);
		attributeGetterFunctions.put(
			"shippingWithTaxAmount", CommerceOrder::getShippingWithTaxAmount);
		attributeSetterBiConsumers.put(
			"shippingWithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setShippingWithTaxAmount);
		attributeGetterFunctions.put(
			"shippingDiscountWithTaxAmount",
			CommerceOrder::getShippingDiscountWithTaxAmount);
		attributeSetterBiConsumers.put(
			"shippingDiscountWithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setShippingDiscountWithTaxAmount);
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel1WithTaxAmount",
			CommerceOrder::getShippingDiscountPercentageLevel1WithTaxAmount);
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel1WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::
					setShippingDiscountPercentageLevel1WithTaxAmount);
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel2WithTaxAmount",
			CommerceOrder::getShippingDiscountPercentageLevel2WithTaxAmount);
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel2WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::
					setShippingDiscountPercentageLevel2WithTaxAmount);
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel3WithTaxAmount",
			CommerceOrder::getShippingDiscountPercentageLevel3WithTaxAmount);
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel3WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::
					setShippingDiscountPercentageLevel3WithTaxAmount);
		attributeGetterFunctions.put(
			"shippingDiscountPercentageLevel4WithTaxAmount",
			CommerceOrder::getShippingDiscountPercentageLevel4WithTaxAmount);
		attributeSetterBiConsumers.put(
			"shippingDiscountPercentageLevel4WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::
					setShippingDiscountPercentageLevel4WithTaxAmount);
		attributeGetterFunctions.put(
			"totalWithTaxAmount", CommerceOrder::getTotalWithTaxAmount);
		attributeSetterBiConsumers.put(
			"totalWithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalWithTaxAmount);
		attributeGetterFunctions.put(
			"totalDiscountWithTaxAmount",
			CommerceOrder::getTotalDiscountWithTaxAmount);
		attributeSetterBiConsumers.put(
			"totalDiscountWithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountWithTaxAmount);
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel1WithTaxAmount",
			CommerceOrder::getTotalDiscountPercentageLevel1WithTaxAmount);
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel1WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountPercentageLevel1WithTaxAmount);
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel2WithTaxAmount",
			CommerceOrder::getTotalDiscountPercentageLevel2WithTaxAmount);
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel2WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountPercentageLevel2WithTaxAmount);
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel3WithTaxAmount",
			CommerceOrder::getTotalDiscountPercentageLevel3WithTaxAmount);
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel3WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountPercentageLevel3WithTaxAmount);
		attributeGetterFunctions.put(
			"totalDiscountPercentageLevel4WithTaxAmount",
			CommerceOrder::getTotalDiscountPercentageLevel4WithTaxAmount);
		attributeSetterBiConsumers.put(
			"totalDiscountPercentageLevel4WithTaxAmount",
			(BiConsumer<CommerceOrder, BigDecimal>)
				CommerceOrder::setTotalDiscountPercentageLevel4WithTaxAmount);
		attributeGetterFunctions.put(
			"advanceStatus", CommerceOrder::getAdvanceStatus);
		attributeSetterBiConsumers.put(
			"advanceStatus",
			(BiConsumer<CommerceOrder, String>)CommerceOrder::setAdvanceStatus);
		attributeGetterFunctions.put(
			"paymentStatus", CommerceOrder::getPaymentStatus);
		attributeSetterBiConsumers.put(
			"paymentStatus",
			(BiConsumer<CommerceOrder, Integer>)
				CommerceOrder::setPaymentStatus);
		attributeGetterFunctions.put("orderDate", CommerceOrder::getOrderDate);
		attributeSetterBiConsumers.put(
			"orderDate",
			(BiConsumer<CommerceOrder, Date>)CommerceOrder::setOrderDate);
		attributeGetterFunctions.put(
			"orderStatus", CommerceOrder::getOrderStatus);
		attributeSetterBiConsumers.put(
			"orderStatus",
			(BiConsumer<CommerceOrder, Integer>)CommerceOrder::setOrderStatus);
		attributeGetterFunctions.put(
			"printedNote", CommerceOrder::getPrintedNote);
		attributeSetterBiConsumers.put(
			"printedNote",
			(BiConsumer<CommerceOrder, String>)CommerceOrder::setPrintedNote);
		attributeGetterFunctions.put(
			"requestedDeliveryDate", CommerceOrder::getRequestedDeliveryDate);
		attributeSetterBiConsumers.put(
			"requestedDeliveryDate",
			(BiConsumer<CommerceOrder, Date>)
				CommerceOrder::setRequestedDeliveryDate);
		attributeGetterFunctions.put(
			"manuallyAdjusted", CommerceOrder::getManuallyAdjusted);
		attributeSetterBiConsumers.put(
			"manuallyAdjusted",
			(BiConsumer<CommerceOrder, Boolean>)
				CommerceOrder::setManuallyAdjusted);
		attributeGetterFunctions.put("status", CommerceOrder::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<CommerceOrder, Integer>)CommerceOrder::setStatus);
		attributeGetterFunctions.put(
			"statusByUserId", CommerceOrder::getStatusByUserId);
		attributeSetterBiConsumers.put(
			"statusByUserId",
			(BiConsumer<CommerceOrder, Long>)CommerceOrder::setStatusByUserId);
		attributeGetterFunctions.put(
			"statusByUserName", CommerceOrder::getStatusByUserName);
		attributeSetterBiConsumers.put(
			"statusByUserName",
			(BiConsumer<CommerceOrder, String>)
				CommerceOrder::setStatusByUserName);
		attributeGetterFunctions.put(
			"statusDate", CommerceOrder::getStatusDate);
		attributeSetterBiConsumers.put(
			"statusDate",
			(BiConsumer<CommerceOrder, Date>)CommerceOrder::setStatusDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_externalReferenceCode = externalReferenceCode;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalExternalReferenceCode() {
		return getColumnOriginalValue("externalReferenceCode");
	}

	@JSON
	@Override
	public long getCommerceOrderId() {
		return _commerceOrderId;
	}

	@Override
	public void setCommerceOrderId(long commerceOrderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceOrderId = commerceOrderId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalCreateDate() {
		return getColumnOriginalValue("createDate");
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceAccountId() {
		return _commerceAccountId;
	}

	@Override
	public void setCommerceAccountId(long commerceAccountId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceAccountId = commerceAccountId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceAccountId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceAccountId"));
	}

	@JSON
	@Override
	public long getCommerceCurrencyId() {
		return _commerceCurrencyId;
	}

	@Override
	public void setCommerceCurrencyId(long commerceCurrencyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceCurrencyId = commerceCurrencyId;
	}

	@JSON
	@Override
	public long getBillingAddressId() {
		return _billingAddressId;
	}

	@Override
	public void setBillingAddressId(long billingAddressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_billingAddressId = billingAddressId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalBillingAddressId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("billingAddressId"));
	}

	@JSON
	@Override
	public long getShippingAddressId() {
		return _shippingAddressId;
	}

	@Override
	public void setShippingAddressId(long shippingAddressId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingAddressId = shippingAddressId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalShippingAddressId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("shippingAddressId"));
	}

	@JSON
	@Override
	public String getCommercePaymentMethodKey() {
		if (_commercePaymentMethodKey == null) {
			return "";
		}
		else {
			return _commercePaymentMethodKey;
		}
	}

	@Override
	public void setCommercePaymentMethodKey(String commercePaymentMethodKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePaymentMethodKey = commercePaymentMethodKey;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalCommercePaymentMethodKey() {
		return getColumnOriginalValue("commercePaymentMethodKey");
	}

	@JSON
	@Override
	public String getTransactionId() {
		if (_transactionId == null) {
			return "";
		}
		else {
			return _transactionId;
		}
	}

	@Override
	public void setTransactionId(String transactionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_transactionId = transactionId;
	}

	@JSON
	@Override
	public long getCommerceShippingMethodId() {
		return _commerceShippingMethodId;
	}

	@Override
	public void setCommerceShippingMethodId(long commerceShippingMethodId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceShippingMethodId = commerceShippingMethodId;
	}

	@JSON
	@Override
	public String getShippingOptionName() {
		if (_shippingOptionName == null) {
			return "";
		}
		else {
			return _shippingOptionName;
		}
	}

	@Override
	public void setShippingOptionName(String shippingOptionName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingOptionName = shippingOptionName;
	}

	@JSON
	@Override
	public String getPurchaseOrderNumber() {
		if (_purchaseOrderNumber == null) {
			return "";
		}
		else {
			return _purchaseOrderNumber;
		}
	}

	@Override
	public void setPurchaseOrderNumber(String purchaseOrderNumber) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_purchaseOrderNumber = purchaseOrderNumber;
	}

	@JSON
	@Override
	public String getCouponCode() {
		if (_couponCode == null) {
			return "";
		}
		else {
			return _couponCode;
		}
	}

	@Override
	public void setCouponCode(String couponCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_couponCode = couponCode;
	}

	@JSON
	@Override
	public Date getLastPriceUpdateDate() {
		return _lastPriceUpdateDate;
	}

	@Override
	public void setLastPriceUpdateDate(Date lastPriceUpdateDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPriceUpdateDate = lastPriceUpdateDate;
	}

	@JSON
	@Override
	public BigDecimal getSubtotal() {
		return _subtotal;
	}

	@Override
	public void setSubtotal(BigDecimal subtotal) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotal = subtotal;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountAmount() {
		return _subtotalDiscountAmount;
	}

	@Override
	public void setSubtotalDiscountAmount(BigDecimal subtotalDiscountAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountAmount = subtotalDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel1() {
		return _subtotalDiscountPercentageLevel1;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel1(
		BigDecimal subtotalDiscountPercentageLevel1) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel1 = subtotalDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel2() {
		return _subtotalDiscountPercentageLevel2;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel2(
		BigDecimal subtotalDiscountPercentageLevel2) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel2 = subtotalDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel3() {
		return _subtotalDiscountPercentageLevel3;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel3(
		BigDecimal subtotalDiscountPercentageLevel3) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel3 = subtotalDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel4() {
		return _subtotalDiscountPercentageLevel4;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel4(
		BigDecimal subtotalDiscountPercentageLevel4) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel4 = subtotalDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getShippingAmount() {
		return _shippingAmount;
	}

	@Override
	public void setShippingAmount(BigDecimal shippingAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingAmount = shippingAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountAmount() {
		return _shippingDiscountAmount;
	}

	@Override
	public void setShippingDiscountAmount(BigDecimal shippingDiscountAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountAmount = shippingDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel1() {
		return _shippingDiscountPercentageLevel1;
	}

	@Override
	public void setShippingDiscountPercentageLevel1(
		BigDecimal shippingDiscountPercentageLevel1) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel1 = shippingDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel2() {
		return _shippingDiscountPercentageLevel2;
	}

	@Override
	public void setShippingDiscountPercentageLevel2(
		BigDecimal shippingDiscountPercentageLevel2) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel2 = shippingDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel3() {
		return _shippingDiscountPercentageLevel3;
	}

	@Override
	public void setShippingDiscountPercentageLevel3(
		BigDecimal shippingDiscountPercentageLevel3) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel3 = shippingDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel4() {
		return _shippingDiscountPercentageLevel4;
	}

	@Override
	public void setShippingDiscountPercentageLevel4(
		BigDecimal shippingDiscountPercentageLevel4) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel4 = shippingDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getTaxAmount() {
		return _taxAmount;
	}

	@Override
	public void setTaxAmount(BigDecimal taxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_taxAmount = taxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotal() {
		return _total;
	}

	@Override
	public void setTotal(BigDecimal total) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_total = total;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountAmount() {
		return _totalDiscountAmount;
	}

	@Override
	public void setTotalDiscountAmount(BigDecimal totalDiscountAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountAmount = totalDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel1() {
		return _totalDiscountPercentageLevel1;
	}

	@Override
	public void setTotalDiscountPercentageLevel1(
		BigDecimal totalDiscountPercentageLevel1) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel1 = totalDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel2() {
		return _totalDiscountPercentageLevel2;
	}

	@Override
	public void setTotalDiscountPercentageLevel2(
		BigDecimal totalDiscountPercentageLevel2) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel2 = totalDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel3() {
		return _totalDiscountPercentageLevel3;
	}

	@Override
	public void setTotalDiscountPercentageLevel3(
		BigDecimal totalDiscountPercentageLevel3) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel3 = totalDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel4() {
		return _totalDiscountPercentageLevel4;
	}

	@Override
	public void setTotalDiscountPercentageLevel4(
		BigDecimal totalDiscountPercentageLevel4) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel4 = totalDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalWithTaxAmount() {
		return _subtotalWithTaxAmount;
	}

	@Override
	public void setSubtotalWithTaxAmount(BigDecimal subtotalWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalWithTaxAmount = subtotalWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountWithTaxAmount() {
		return _subtotalDiscountWithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountWithTaxAmount(
		BigDecimal subtotalDiscountWithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountWithTaxAmount = subtotalDiscountWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel1WithTaxAmount() {
		return _subtotalDiscountPercentageLevel1WithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel1WithTaxAmount(
		BigDecimal subtotalDiscountPercentageLevel1WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel1WithTaxAmount =
			subtotalDiscountPercentageLevel1WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel2WithTaxAmount() {
		return _subtotalDiscountPercentageLevel2WithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel2WithTaxAmount(
		BigDecimal subtotalDiscountPercentageLevel2WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel2WithTaxAmount =
			subtotalDiscountPercentageLevel2WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel3WithTaxAmount() {
		return _subtotalDiscountPercentageLevel3WithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel3WithTaxAmount(
		BigDecimal subtotalDiscountPercentageLevel3WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel3WithTaxAmount =
			subtotalDiscountPercentageLevel3WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel4WithTaxAmount() {
		return _subtotalDiscountPercentageLevel4WithTaxAmount;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel4WithTaxAmount(
		BigDecimal subtotalDiscountPercentageLevel4WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subtotalDiscountPercentageLevel4WithTaxAmount =
			subtotalDiscountPercentageLevel4WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingWithTaxAmount() {
		return _shippingWithTaxAmount;
	}

	@Override
	public void setShippingWithTaxAmount(BigDecimal shippingWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingWithTaxAmount = shippingWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountWithTaxAmount() {
		return _shippingDiscountWithTaxAmount;
	}

	@Override
	public void setShippingDiscountWithTaxAmount(
		BigDecimal shippingDiscountWithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountWithTaxAmount = shippingDiscountWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel1WithTaxAmount() {
		return _shippingDiscountPercentageLevel1WithTaxAmount;
	}

	@Override
	public void setShippingDiscountPercentageLevel1WithTaxAmount(
		BigDecimal shippingDiscountPercentageLevel1WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel1WithTaxAmount =
			shippingDiscountPercentageLevel1WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel2WithTaxAmount() {
		return _shippingDiscountPercentageLevel2WithTaxAmount;
	}

	@Override
	public void setShippingDiscountPercentageLevel2WithTaxAmount(
		BigDecimal shippingDiscountPercentageLevel2WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel2WithTaxAmount =
			shippingDiscountPercentageLevel2WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel3WithTaxAmount() {
		return _shippingDiscountPercentageLevel3WithTaxAmount;
	}

	@Override
	public void setShippingDiscountPercentageLevel3WithTaxAmount(
		BigDecimal shippingDiscountPercentageLevel3WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel3WithTaxAmount =
			shippingDiscountPercentageLevel3WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel4WithTaxAmount() {
		return _shippingDiscountPercentageLevel4WithTaxAmount;
	}

	@Override
	public void setShippingDiscountPercentageLevel4WithTaxAmount(
		BigDecimal shippingDiscountPercentageLevel4WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_shippingDiscountPercentageLevel4WithTaxAmount =
			shippingDiscountPercentageLevel4WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalWithTaxAmount() {
		return _totalWithTaxAmount;
	}

	@Override
	public void setTotalWithTaxAmount(BigDecimal totalWithTaxAmount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalWithTaxAmount = totalWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountWithTaxAmount() {
		return _totalDiscountWithTaxAmount;
	}

	@Override
	public void setTotalDiscountWithTaxAmount(
		BigDecimal totalDiscountWithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountWithTaxAmount = totalDiscountWithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel1WithTaxAmount() {
		return _totalDiscountPercentageLevel1WithTaxAmount;
	}

	@Override
	public void setTotalDiscountPercentageLevel1WithTaxAmount(
		BigDecimal totalDiscountPercentageLevel1WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel1WithTaxAmount =
			totalDiscountPercentageLevel1WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel2WithTaxAmount() {
		return _totalDiscountPercentageLevel2WithTaxAmount;
	}

	@Override
	public void setTotalDiscountPercentageLevel2WithTaxAmount(
		BigDecimal totalDiscountPercentageLevel2WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel2WithTaxAmount =
			totalDiscountPercentageLevel2WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel3WithTaxAmount() {
		return _totalDiscountPercentageLevel3WithTaxAmount;
	}

	@Override
	public void setTotalDiscountPercentageLevel3WithTaxAmount(
		BigDecimal totalDiscountPercentageLevel3WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel3WithTaxAmount =
			totalDiscountPercentageLevel3WithTaxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel4WithTaxAmount() {
		return _totalDiscountPercentageLevel4WithTaxAmount;
	}

	@Override
	public void setTotalDiscountPercentageLevel4WithTaxAmount(
		BigDecimal totalDiscountPercentageLevel4WithTaxAmount) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_totalDiscountPercentageLevel4WithTaxAmount =
			totalDiscountPercentageLevel4WithTaxAmount;
	}

	@JSON
	@Override
	public String getAdvanceStatus() {
		if (_advanceStatus == null) {
			return "";
		}
		else {
			return _advanceStatus;
		}
	}

	@Override
	public void setAdvanceStatus(String advanceStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_advanceStatus = advanceStatus;
	}

	@JSON
	@Override
	public int getPaymentStatus() {
		return _paymentStatus;
	}

	@Override
	public void setPaymentStatus(int paymentStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_paymentStatus = paymentStatus;
	}

	@JSON
	@Override
	public Date getOrderDate() {
		return _orderDate;
	}

	@Override
	public void setOrderDate(Date orderDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_orderDate = orderDate;
	}

	@JSON
	@Override
	public int getOrderStatus() {
		return _orderStatus;
	}

	@Override
	public void setOrderStatus(int orderStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_orderStatus = orderStatus;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalOrderStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("orderStatus"));
	}

	@JSON
	@Override
	public String getPrintedNote() {
		if (_printedNote == null) {
			return "";
		}
		else {
			return _printedNote;
		}
	}

	@Override
	public void setPrintedNote(String printedNote) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_printedNote = printedNote;
	}

	@JSON
	@Override
	public Date getRequestedDeliveryDate() {
		return _requestedDeliveryDate;
	}

	@Override
	public void setRequestedDeliveryDate(Date requestedDeliveryDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_requestedDeliveryDate = requestedDeliveryDate;
	}

	@JSON
	@Override
	public boolean getManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@JSON
	@Override
	public boolean isManuallyAdjusted() {
		return _manuallyAdjusted;
	}

	@Override
	public void setManuallyAdjusted(boolean manuallyAdjusted) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_manuallyAdjusted = manuallyAdjusted;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(CommerceOrder.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceOrder.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceOrder toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceOrder>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceOrderImpl commerceOrderImpl = new CommerceOrderImpl();

		commerceOrderImpl.setUuid(getUuid());
		commerceOrderImpl.setExternalReferenceCode(getExternalReferenceCode());
		commerceOrderImpl.setCommerceOrderId(getCommerceOrderId());
		commerceOrderImpl.setGroupId(getGroupId());
		commerceOrderImpl.setCompanyId(getCompanyId());
		commerceOrderImpl.setUserId(getUserId());
		commerceOrderImpl.setUserName(getUserName());
		commerceOrderImpl.setCreateDate(getCreateDate());
		commerceOrderImpl.setModifiedDate(getModifiedDate());
		commerceOrderImpl.setCommerceAccountId(getCommerceAccountId());
		commerceOrderImpl.setCommerceCurrencyId(getCommerceCurrencyId());
		commerceOrderImpl.setBillingAddressId(getBillingAddressId());
		commerceOrderImpl.setShippingAddressId(getShippingAddressId());
		commerceOrderImpl.setCommercePaymentMethodKey(
			getCommercePaymentMethodKey());
		commerceOrderImpl.setTransactionId(getTransactionId());
		commerceOrderImpl.setCommerceShippingMethodId(
			getCommerceShippingMethodId());
		commerceOrderImpl.setShippingOptionName(getShippingOptionName());
		commerceOrderImpl.setPurchaseOrderNumber(getPurchaseOrderNumber());
		commerceOrderImpl.setCouponCode(getCouponCode());
		commerceOrderImpl.setLastPriceUpdateDate(getLastPriceUpdateDate());
		commerceOrderImpl.setSubtotal(getSubtotal());
		commerceOrderImpl.setSubtotalDiscountAmount(
			getSubtotalDiscountAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel1(
			getSubtotalDiscountPercentageLevel1());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel2(
			getSubtotalDiscountPercentageLevel2());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel3(
			getSubtotalDiscountPercentageLevel3());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel4(
			getSubtotalDiscountPercentageLevel4());
		commerceOrderImpl.setShippingAmount(getShippingAmount());
		commerceOrderImpl.setShippingDiscountAmount(
			getShippingDiscountAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel1(
			getShippingDiscountPercentageLevel1());
		commerceOrderImpl.setShippingDiscountPercentageLevel2(
			getShippingDiscountPercentageLevel2());
		commerceOrderImpl.setShippingDiscountPercentageLevel3(
			getShippingDiscountPercentageLevel3());
		commerceOrderImpl.setShippingDiscountPercentageLevel4(
			getShippingDiscountPercentageLevel4());
		commerceOrderImpl.setTaxAmount(getTaxAmount());
		commerceOrderImpl.setTotal(getTotal());
		commerceOrderImpl.setTotalDiscountAmount(getTotalDiscountAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel1(
			getTotalDiscountPercentageLevel1());
		commerceOrderImpl.setTotalDiscountPercentageLevel2(
			getTotalDiscountPercentageLevel2());
		commerceOrderImpl.setTotalDiscountPercentageLevel3(
			getTotalDiscountPercentageLevel3());
		commerceOrderImpl.setTotalDiscountPercentageLevel4(
			getTotalDiscountPercentageLevel4());
		commerceOrderImpl.setSubtotalWithTaxAmount(getSubtotalWithTaxAmount());
		commerceOrderImpl.setSubtotalDiscountWithTaxAmount(
			getSubtotalDiscountWithTaxAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel1WithTaxAmount(
			getSubtotalDiscountPercentageLevel1WithTaxAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel2WithTaxAmount(
			getSubtotalDiscountPercentageLevel2WithTaxAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel3WithTaxAmount(
			getSubtotalDiscountPercentageLevel3WithTaxAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel4WithTaxAmount(
			getSubtotalDiscountPercentageLevel4WithTaxAmount());
		commerceOrderImpl.setShippingWithTaxAmount(getShippingWithTaxAmount());
		commerceOrderImpl.setShippingDiscountWithTaxAmount(
			getShippingDiscountWithTaxAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel1WithTaxAmount(
			getShippingDiscountPercentageLevel1WithTaxAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel2WithTaxAmount(
			getShippingDiscountPercentageLevel2WithTaxAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel3WithTaxAmount(
			getShippingDiscountPercentageLevel3WithTaxAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel4WithTaxAmount(
			getShippingDiscountPercentageLevel4WithTaxAmount());
		commerceOrderImpl.setTotalWithTaxAmount(getTotalWithTaxAmount());
		commerceOrderImpl.setTotalDiscountWithTaxAmount(
			getTotalDiscountWithTaxAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel1WithTaxAmount(
			getTotalDiscountPercentageLevel1WithTaxAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel2WithTaxAmount(
			getTotalDiscountPercentageLevel2WithTaxAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel3WithTaxAmount(
			getTotalDiscountPercentageLevel3WithTaxAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel4WithTaxAmount(
			getTotalDiscountPercentageLevel4WithTaxAmount());
		commerceOrderImpl.setAdvanceStatus(getAdvanceStatus());
		commerceOrderImpl.setPaymentStatus(getPaymentStatus());
		commerceOrderImpl.setOrderDate(getOrderDate());
		commerceOrderImpl.setOrderStatus(getOrderStatus());
		commerceOrderImpl.setPrintedNote(getPrintedNote());
		commerceOrderImpl.setRequestedDeliveryDate(getRequestedDeliveryDate());
		commerceOrderImpl.setManuallyAdjusted(isManuallyAdjusted());
		commerceOrderImpl.setStatus(getStatus());
		commerceOrderImpl.setStatusByUserId(getStatusByUserId());
		commerceOrderImpl.setStatusByUserName(getStatusByUserName());
		commerceOrderImpl.setStatusDate(getStatusDate());

		commerceOrderImpl.resetOriginalValues();

		return commerceOrderImpl;
	}

	@Override
	public int compareTo(CommerceOrder commerceOrder) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceOrder.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceOrder)) {
			return false;
		}

		CommerceOrder commerceOrder = (CommerceOrder)object;

		long primaryKey = commerceOrder.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;
	}

	@Override
	public CacheModel<CommerceOrder> toCacheModel() {
		CommerceOrderCacheModel commerceOrderCacheModel =
			new CommerceOrderCacheModel();

		commerceOrderCacheModel.uuid = getUuid();

		String uuid = commerceOrderCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceOrderCacheModel.uuid = null;
		}

		commerceOrderCacheModel.externalReferenceCode =
			getExternalReferenceCode();

		String externalReferenceCode =
			commerceOrderCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
			(externalReferenceCode.length() == 0)) {

			commerceOrderCacheModel.externalReferenceCode = null;
		}

		commerceOrderCacheModel.commerceOrderId = getCommerceOrderId();

		commerceOrderCacheModel.groupId = getGroupId();

		commerceOrderCacheModel.companyId = getCompanyId();

		commerceOrderCacheModel.userId = getUserId();

		commerceOrderCacheModel.userName = getUserName();

		String userName = commerceOrderCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceOrderCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceOrderCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceOrderCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceOrderCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceOrderCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.commerceAccountId = getCommerceAccountId();

		commerceOrderCacheModel.commerceCurrencyId = getCommerceCurrencyId();

		commerceOrderCacheModel.billingAddressId = getBillingAddressId();

		commerceOrderCacheModel.shippingAddressId = getShippingAddressId();

		commerceOrderCacheModel.commercePaymentMethodKey =
			getCommercePaymentMethodKey();

		String commercePaymentMethodKey =
			commerceOrderCacheModel.commercePaymentMethodKey;

		if ((commercePaymentMethodKey != null) &&
			(commercePaymentMethodKey.length() == 0)) {

			commerceOrderCacheModel.commercePaymentMethodKey = null;
		}

		commerceOrderCacheModel.transactionId = getTransactionId();

		String transactionId = commerceOrderCacheModel.transactionId;

		if ((transactionId != null) && (transactionId.length() == 0)) {
			commerceOrderCacheModel.transactionId = null;
		}

		commerceOrderCacheModel.commerceShippingMethodId =
			getCommerceShippingMethodId();

		commerceOrderCacheModel.shippingOptionName = getShippingOptionName();

		String shippingOptionName = commerceOrderCacheModel.shippingOptionName;

		if ((shippingOptionName != null) &&
			(shippingOptionName.length() == 0)) {

			commerceOrderCacheModel.shippingOptionName = null;
		}

		commerceOrderCacheModel.purchaseOrderNumber = getPurchaseOrderNumber();

		String purchaseOrderNumber =
			commerceOrderCacheModel.purchaseOrderNumber;

		if ((purchaseOrderNumber != null) &&
			(purchaseOrderNumber.length() == 0)) {

			commerceOrderCacheModel.purchaseOrderNumber = null;
		}

		commerceOrderCacheModel.couponCode = getCouponCode();

		String couponCode = commerceOrderCacheModel.couponCode;

		if ((couponCode != null) && (couponCode.length() == 0)) {
			commerceOrderCacheModel.couponCode = null;
		}

		Date lastPriceUpdateDate = getLastPriceUpdateDate();

		if (lastPriceUpdateDate != null) {
			commerceOrderCacheModel.lastPriceUpdateDate =
				lastPriceUpdateDate.getTime();
		}
		else {
			commerceOrderCacheModel.lastPriceUpdateDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.subtotal = getSubtotal();

		commerceOrderCacheModel.subtotalDiscountAmount =
			getSubtotalDiscountAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel1 =
			getSubtotalDiscountPercentageLevel1();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel2 =
			getSubtotalDiscountPercentageLevel2();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel3 =
			getSubtotalDiscountPercentageLevel3();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel4 =
			getSubtotalDiscountPercentageLevel4();

		commerceOrderCacheModel.shippingAmount = getShippingAmount();

		commerceOrderCacheModel.shippingDiscountAmount =
			getShippingDiscountAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel1 =
			getShippingDiscountPercentageLevel1();

		commerceOrderCacheModel.shippingDiscountPercentageLevel2 =
			getShippingDiscountPercentageLevel2();

		commerceOrderCacheModel.shippingDiscountPercentageLevel3 =
			getShippingDiscountPercentageLevel3();

		commerceOrderCacheModel.shippingDiscountPercentageLevel4 =
			getShippingDiscountPercentageLevel4();

		commerceOrderCacheModel.taxAmount = getTaxAmount();

		commerceOrderCacheModel.total = getTotal();

		commerceOrderCacheModel.totalDiscountAmount = getTotalDiscountAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel1 =
			getTotalDiscountPercentageLevel1();

		commerceOrderCacheModel.totalDiscountPercentageLevel2 =
			getTotalDiscountPercentageLevel2();

		commerceOrderCacheModel.totalDiscountPercentageLevel3 =
			getTotalDiscountPercentageLevel3();

		commerceOrderCacheModel.totalDiscountPercentageLevel4 =
			getTotalDiscountPercentageLevel4();

		commerceOrderCacheModel.subtotalWithTaxAmount =
			getSubtotalWithTaxAmount();

		commerceOrderCacheModel.subtotalDiscountWithTaxAmount =
			getSubtotalDiscountWithTaxAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel1WithTaxAmount =
			getSubtotalDiscountPercentageLevel1WithTaxAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel2WithTaxAmount =
			getSubtotalDiscountPercentageLevel2WithTaxAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel3WithTaxAmount =
			getSubtotalDiscountPercentageLevel3WithTaxAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel4WithTaxAmount =
			getSubtotalDiscountPercentageLevel4WithTaxAmount();

		commerceOrderCacheModel.shippingWithTaxAmount =
			getShippingWithTaxAmount();

		commerceOrderCacheModel.shippingDiscountWithTaxAmount =
			getShippingDiscountWithTaxAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel1WithTaxAmount =
			getShippingDiscountPercentageLevel1WithTaxAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel2WithTaxAmount =
			getShippingDiscountPercentageLevel2WithTaxAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel3WithTaxAmount =
			getShippingDiscountPercentageLevel3WithTaxAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel4WithTaxAmount =
			getShippingDiscountPercentageLevel4WithTaxAmount();

		commerceOrderCacheModel.totalWithTaxAmount = getTotalWithTaxAmount();

		commerceOrderCacheModel.totalDiscountWithTaxAmount =
			getTotalDiscountWithTaxAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel1WithTaxAmount =
			getTotalDiscountPercentageLevel1WithTaxAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel2WithTaxAmount =
			getTotalDiscountPercentageLevel2WithTaxAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel3WithTaxAmount =
			getTotalDiscountPercentageLevel3WithTaxAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel4WithTaxAmount =
			getTotalDiscountPercentageLevel4WithTaxAmount();

		commerceOrderCacheModel.advanceStatus = getAdvanceStatus();

		String advanceStatus = commerceOrderCacheModel.advanceStatus;

		if ((advanceStatus != null) && (advanceStatus.length() == 0)) {
			commerceOrderCacheModel.advanceStatus = null;
		}

		commerceOrderCacheModel.paymentStatus = getPaymentStatus();

		Date orderDate = getOrderDate();

		if (orderDate != null) {
			commerceOrderCacheModel.orderDate = orderDate.getTime();
		}
		else {
			commerceOrderCacheModel.orderDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.orderStatus = getOrderStatus();

		commerceOrderCacheModel.printedNote = getPrintedNote();

		String printedNote = commerceOrderCacheModel.printedNote;

		if ((printedNote != null) && (printedNote.length() == 0)) {
			commerceOrderCacheModel.printedNote = null;
		}

		Date requestedDeliveryDate = getRequestedDeliveryDate();

		if (requestedDeliveryDate != null) {
			commerceOrderCacheModel.requestedDeliveryDate =
				requestedDeliveryDate.getTime();
		}
		else {
			commerceOrderCacheModel.requestedDeliveryDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.manuallyAdjusted = isManuallyAdjusted();

		commerceOrderCacheModel.status = getStatus();

		commerceOrderCacheModel.statusByUserId = getStatusByUserId();

		commerceOrderCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = commerceOrderCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commerceOrderCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commerceOrderCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commerceOrderCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commerceOrderCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceOrder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrder, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((CommerceOrder)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceOrder, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceOrder, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceOrder, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((CommerceOrder)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, CommerceOrder>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private String _uuid;
	private String _externalReferenceCode;
	private long _commerceOrderId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceAccountId;
	private long _commerceCurrencyId;
	private long _billingAddressId;
	private long _shippingAddressId;
	private String _commercePaymentMethodKey;
	private String _transactionId;
	private long _commerceShippingMethodId;
	private String _shippingOptionName;
	private String _purchaseOrderNumber;
	private String _couponCode;
	private Date _lastPriceUpdateDate;
	private BigDecimal _subtotal;
	private BigDecimal _subtotalDiscountAmount;
	private BigDecimal _subtotalDiscountPercentageLevel1;
	private BigDecimal _subtotalDiscountPercentageLevel2;
	private BigDecimal _subtotalDiscountPercentageLevel3;
	private BigDecimal _subtotalDiscountPercentageLevel4;
	private BigDecimal _shippingAmount;
	private BigDecimal _shippingDiscountAmount;
	private BigDecimal _shippingDiscountPercentageLevel1;
	private BigDecimal _shippingDiscountPercentageLevel2;
	private BigDecimal _shippingDiscountPercentageLevel3;
	private BigDecimal _shippingDiscountPercentageLevel4;
	private BigDecimal _taxAmount;
	private BigDecimal _total;
	private BigDecimal _totalDiscountAmount;
	private BigDecimal _totalDiscountPercentageLevel1;
	private BigDecimal _totalDiscountPercentageLevel2;
	private BigDecimal _totalDiscountPercentageLevel3;
	private BigDecimal _totalDiscountPercentageLevel4;
	private BigDecimal _subtotalWithTaxAmount;
	private BigDecimal _subtotalDiscountWithTaxAmount;
	private BigDecimal _subtotalDiscountPercentageLevel1WithTaxAmount;
	private BigDecimal _subtotalDiscountPercentageLevel2WithTaxAmount;
	private BigDecimal _subtotalDiscountPercentageLevel3WithTaxAmount;
	private BigDecimal _subtotalDiscountPercentageLevel4WithTaxAmount;
	private BigDecimal _shippingWithTaxAmount;
	private BigDecimal _shippingDiscountWithTaxAmount;
	private BigDecimal _shippingDiscountPercentageLevel1WithTaxAmount;
	private BigDecimal _shippingDiscountPercentageLevel2WithTaxAmount;
	private BigDecimal _shippingDiscountPercentageLevel3WithTaxAmount;
	private BigDecimal _shippingDiscountPercentageLevel4WithTaxAmount;
	private BigDecimal _totalWithTaxAmount;
	private BigDecimal _totalDiscountWithTaxAmount;
	private BigDecimal _totalDiscountPercentageLevel1WithTaxAmount;
	private BigDecimal _totalDiscountPercentageLevel2WithTaxAmount;
	private BigDecimal _totalDiscountPercentageLevel3WithTaxAmount;
	private BigDecimal _totalDiscountPercentageLevel4WithTaxAmount;
	private String _advanceStatus;
	private int _paymentStatus;
	private Date _orderDate;
	private int _orderStatus;
	private String _printedNote;
	private Date _requestedDeliveryDate;
	private boolean _manuallyAdjusted;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceOrder, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceOrder)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"externalReferenceCode", _externalReferenceCode);
		_columnOriginalValues.put("commerceOrderId", _commerceOrderId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("commerceAccountId", _commerceAccountId);
		_columnOriginalValues.put("commerceCurrencyId", _commerceCurrencyId);
		_columnOriginalValues.put("billingAddressId", _billingAddressId);
		_columnOriginalValues.put("shippingAddressId", _shippingAddressId);
		_columnOriginalValues.put(
			"commercePaymentMethodKey", _commercePaymentMethodKey);
		_columnOriginalValues.put("transactionId", _transactionId);
		_columnOriginalValues.put(
			"commerceShippingMethodId", _commerceShippingMethodId);
		_columnOriginalValues.put("shippingOptionName", _shippingOptionName);
		_columnOriginalValues.put("purchaseOrderNumber", _purchaseOrderNumber);
		_columnOriginalValues.put("couponCode", _couponCode);
		_columnOriginalValues.put("lastPriceUpdateDate", _lastPriceUpdateDate);
		_columnOriginalValues.put("subtotal", _subtotal);
		_columnOriginalValues.put(
			"subtotalDiscountAmount", _subtotalDiscountAmount);
		_columnOriginalValues.put(
			"subtotalDiscountPercentLevel1", _subtotalDiscountPercentageLevel1);
		_columnOriginalValues.put(
			"subtotalDiscountPercentLevel2", _subtotalDiscountPercentageLevel2);
		_columnOriginalValues.put(
			"subtotalDiscountPercentLevel3", _subtotalDiscountPercentageLevel3);
		_columnOriginalValues.put(
			"subtotalDiscountPercentLevel4", _subtotalDiscountPercentageLevel4);
		_columnOriginalValues.put("shippingAmount", _shippingAmount);
		_columnOriginalValues.put(
			"shippingDiscountAmount", _shippingDiscountAmount);
		_columnOriginalValues.put(
			"shippingDiscountPercentLevel1", _shippingDiscountPercentageLevel1);
		_columnOriginalValues.put(
			"shippingDiscountPercentLevel2", _shippingDiscountPercentageLevel2);
		_columnOriginalValues.put(
			"shippingDiscountPercentLevel3", _shippingDiscountPercentageLevel3);
		_columnOriginalValues.put(
			"shippingDiscountPercentLevel4", _shippingDiscountPercentageLevel4);
		_columnOriginalValues.put("taxAmount", _taxAmount);
		_columnOriginalValues.put("total", _total);
		_columnOriginalValues.put("totalDiscountAmount", _totalDiscountAmount);
		_columnOriginalValues.put(
			"totalDiscountPercentageLevel1", _totalDiscountPercentageLevel1);
		_columnOriginalValues.put(
			"totalDiscountPercentageLevel2", _totalDiscountPercentageLevel2);
		_columnOriginalValues.put(
			"totalDiscountPercentageLevel3", _totalDiscountPercentageLevel3);
		_columnOriginalValues.put(
			"totalDiscountPercentageLevel4", _totalDiscountPercentageLevel4);
		_columnOriginalValues.put(
			"subtotalWithTaxAmount", _subtotalWithTaxAmount);
		_columnOriginalValues.put(
			"subtotalDiscountWithTaxAmount", _subtotalDiscountWithTaxAmount);
		_columnOriginalValues.put(
			"subtotalDiscountPctLev1WithTax",
			_subtotalDiscountPercentageLevel1WithTaxAmount);
		_columnOriginalValues.put(
			"subtotalDiscountPctLev2WithTax",
			_subtotalDiscountPercentageLevel2WithTaxAmount);
		_columnOriginalValues.put(
			"subtotalDiscountPctLev3WithTax",
			_subtotalDiscountPercentageLevel3WithTaxAmount);
		_columnOriginalValues.put(
			"subtotalDiscountPctLev4WithTax",
			_subtotalDiscountPercentageLevel4WithTaxAmount);
		_columnOriginalValues.put(
			"shippingWithTaxAmount", _shippingWithTaxAmount);
		_columnOriginalValues.put(
			"shippingDiscountWithTaxAmount", _shippingDiscountWithTaxAmount);
		_columnOriginalValues.put(
			"shippingDiscountPctLev1WithTax",
			_shippingDiscountPercentageLevel1WithTaxAmount);
		_columnOriginalValues.put(
			"shippingDiscountPctLev2WithTax",
			_shippingDiscountPercentageLevel2WithTaxAmount);
		_columnOriginalValues.put(
			"shippingDiscountPctLev3WithTax",
			_shippingDiscountPercentageLevel3WithTaxAmount);
		_columnOriginalValues.put(
			"shippingDiscountPctLev4WithTax",
			_shippingDiscountPercentageLevel4WithTaxAmount);
		_columnOriginalValues.put("totalWithTaxAmount", _totalWithTaxAmount);
		_columnOriginalValues.put(
			"totalDiscountWithTaxAmount", _totalDiscountWithTaxAmount);
		_columnOriginalValues.put(
			"totalDiscountPctLev1WithTax",
			_totalDiscountPercentageLevel1WithTaxAmount);
		_columnOriginalValues.put(
			"totalDiscountPctLev2WithTax",
			_totalDiscountPercentageLevel2WithTaxAmount);
		_columnOriginalValues.put(
			"totalDiscountPctLev3WithTax",
			_totalDiscountPercentageLevel3WithTaxAmount);
		_columnOriginalValues.put(
			"totalDiscountPctLev4WithTax",
			_totalDiscountPercentageLevel4WithTaxAmount);
		_columnOriginalValues.put("advanceStatus", _advanceStatus);
		_columnOriginalValues.put("paymentStatus", _paymentStatus);
		_columnOriginalValues.put("orderDate", _orderDate);
		_columnOriginalValues.put("orderStatus", _orderStatus);
		_columnOriginalValues.put("printedNote", _printedNote);
		_columnOriginalValues.put(
			"requestedDeliveryDate", _requestedDeliveryDate);
		_columnOriginalValues.put("manuallyAdjusted", _manuallyAdjusted);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put(
			"subtotalDiscountPercentLevel1",
			"subtotalDiscountPercentageLevel1");
		attributeNames.put(
			"subtotalDiscountPercentLevel2",
			"subtotalDiscountPercentageLevel2");
		attributeNames.put(
			"subtotalDiscountPercentLevel3",
			"subtotalDiscountPercentageLevel3");
		attributeNames.put(
			"subtotalDiscountPercentLevel4",
			"subtotalDiscountPercentageLevel4");
		attributeNames.put(
			"shippingDiscountPercentLevel1",
			"shippingDiscountPercentageLevel1");
		attributeNames.put(
			"shippingDiscountPercentLevel2",
			"shippingDiscountPercentageLevel2");
		attributeNames.put(
			"shippingDiscountPercentLevel3",
			"shippingDiscountPercentageLevel3");
		attributeNames.put(
			"shippingDiscountPercentLevel4",
			"shippingDiscountPercentageLevel4");
		attributeNames.put(
			"subtotalDiscountPctLev1WithTax",
			"subtotalDiscountPercentageLevel1WithTaxAmount");
		attributeNames.put(
			"subtotalDiscountPctLev2WithTax",
			"subtotalDiscountPercentageLevel2WithTaxAmount");
		attributeNames.put(
			"subtotalDiscountPctLev3WithTax",
			"subtotalDiscountPercentageLevel3WithTaxAmount");
		attributeNames.put(
			"subtotalDiscountPctLev4WithTax",
			"subtotalDiscountPercentageLevel4WithTaxAmount");
		attributeNames.put(
			"shippingDiscountPctLev1WithTax",
			"shippingDiscountPercentageLevel1WithTaxAmount");
		attributeNames.put(
			"shippingDiscountPctLev2WithTax",
			"shippingDiscountPercentageLevel2WithTaxAmount");
		attributeNames.put(
			"shippingDiscountPctLev3WithTax",
			"shippingDiscountPercentageLevel3WithTaxAmount");
		attributeNames.put(
			"shippingDiscountPctLev4WithTax",
			"shippingDiscountPercentageLevel4WithTaxAmount");
		attributeNames.put(
			"totalDiscountPctLev1WithTax",
			"totalDiscountPercentageLevel1WithTaxAmount");
		attributeNames.put(
			"totalDiscountPctLev2WithTax",
			"totalDiscountPercentageLevel2WithTaxAmount");
		attributeNames.put(
			"totalDiscountPctLev3WithTax",
			"totalDiscountPercentageLevel3WithTaxAmount");
		attributeNames.put(
			"totalDiscountPctLev4WithTax",
			"totalDiscountPercentageLevel4WithTaxAmount");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;
	private CommerceOrder _escapedModel;

}