/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.model.impl;

import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.model.CommerceSubscriptionEntryModel;
import com.liferay.commerce.model.CommerceSubscriptionEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceSubscriptionEntry service. Represents a row in the &quot;CommerceSubscriptionEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceSubscriptionEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceSubscriptionEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceSubscriptionEntryImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceSubscriptionEntryModelImpl
	extends BaseModelImpl<CommerceSubscriptionEntry>
	implements CommerceSubscriptionEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce subscription entry model instance should use the <code>CommerceSubscriptionEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceSubscriptionEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR}, {"commerceSubscriptionEntryId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"CPInstanceUuid", Types.VARCHAR}, {"CProductId", Types.BIGINT},
		{"commerceOrderItemId", Types.BIGINT},
		{"subscriptionLength", Types.INTEGER},
		{"subscriptionType", Types.VARCHAR},
		{"subscriptionTypeSettings", Types.CLOB},
		{"currentCycle", Types.BIGINT}, {"maxSubscriptionCycles", Types.BIGINT},
		{"subscriptionStatus", Types.INTEGER},
		{"lastIterationDate", Types.TIMESTAMP},
		{"nextIterationDate", Types.TIMESTAMP}, {"startDate", Types.TIMESTAMP},
		{"deliverySubscriptionLength", Types.INTEGER},
		{"deliverySubscriptionType", Types.VARCHAR},
		{"deliverySubTypeSettings", Types.VARCHAR},
		{"deliveryCurrentCycle", Types.BIGINT},
		{"deliveryMaxSubscriptionCycles", Types.BIGINT},
		{"deliverySubscriptionStatus", Types.INTEGER},
		{"deliveryLastIterationDate", Types.TIMESTAMP},
		{"deliveryNextIterationDate", Types.TIMESTAMP},
		{"deliveryStartDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceSubscriptionEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("CPInstanceUuid", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("CProductId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceOrderItemId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("subscriptionLength", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("subscriptionType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subscriptionTypeSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("currentCycle", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("maxSubscriptionCycles", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("subscriptionStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("lastIterationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("nextIterationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("startDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("deliverySubscriptionLength", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("deliverySubscriptionType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("deliverySubTypeSettings", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("deliveryCurrentCycle", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("deliveryMaxSubscriptionCycles", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("deliverySubscriptionStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("deliveryLastIterationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("deliveryNextIterationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("deliveryStartDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceSubscriptionEntry (uuid_ VARCHAR(75) null,commerceSubscriptionEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,CPInstanceUuid VARCHAR(75) null,CProductId LONG,commerceOrderItemId LONG,subscriptionLength INTEGER,subscriptionType VARCHAR(75) null,subscriptionTypeSettings TEXT null,currentCycle LONG,maxSubscriptionCycles LONG,subscriptionStatus INTEGER,lastIterationDate DATE null,nextIterationDate DATE null,startDate DATE null,deliverySubscriptionLength INTEGER,deliverySubscriptionType VARCHAR(75) null,deliverySubTypeSettings VARCHAR(75) null,deliveryCurrentCycle LONG,deliveryMaxSubscriptionCycles LONG,deliverySubscriptionStatus INTEGER,deliveryLastIterationDate DATE null,deliveryNextIterationDate DATE null,deliveryStartDate DATE null)";

	public static final String TABLE_SQL_DROP =
		"drop table CommerceSubscriptionEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceSubscriptionEntry.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceSubscriptionEntry.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPINSTANCEUUID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CPRODUCTID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEORDERITEMID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SUBSCRIPTIONSTATUS_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 256L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static CommerceSubscriptionEntry toModel(
		CommerceSubscriptionEntrySoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		CommerceSubscriptionEntry model = new CommerceSubscriptionEntryImpl();

		model.setUuid(soapModel.getUuid());
		model.setCommerceSubscriptionEntryId(
			soapModel.getCommerceSubscriptionEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCPInstanceUuid(soapModel.getCPInstanceUuid());
		model.setCProductId(soapModel.getCProductId());
		model.setCommerceOrderItemId(soapModel.getCommerceOrderItemId());
		model.setSubscriptionLength(soapModel.getSubscriptionLength());
		model.setSubscriptionType(soapModel.getSubscriptionType());
		model.setSubscriptionTypeSettings(
			soapModel.getSubscriptionTypeSettings());
		model.setCurrentCycle(soapModel.getCurrentCycle());
		model.setMaxSubscriptionCycles(soapModel.getMaxSubscriptionCycles());
		model.setSubscriptionStatus(soapModel.getSubscriptionStatus());
		model.setLastIterationDate(soapModel.getLastIterationDate());
		model.setNextIterationDate(soapModel.getNextIterationDate());
		model.setStartDate(soapModel.getStartDate());
		model.setDeliverySubscriptionLength(
			soapModel.getDeliverySubscriptionLength());
		model.setDeliverySubscriptionType(
			soapModel.getDeliverySubscriptionType());
		model.setDeliverySubscriptionTypeSettings(
			soapModel.getDeliverySubscriptionTypeSettings());
		model.setDeliveryCurrentCycle(soapModel.getDeliveryCurrentCycle());
		model.setDeliveryMaxSubscriptionCycles(
			soapModel.getDeliveryMaxSubscriptionCycles());
		model.setDeliverySubscriptionStatus(
			soapModel.getDeliverySubscriptionStatus());
		model.setDeliveryLastIterationDate(
			soapModel.getDeliveryLastIterationDate());
		model.setDeliveryNextIterationDate(
			soapModel.getDeliveryNextIterationDate());
		model.setDeliveryStartDate(soapModel.getDeliveryStartDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<CommerceSubscriptionEntry> toModels(
		CommerceSubscriptionEntrySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceSubscriptionEntry> models =
			new ArrayList<CommerceSubscriptionEntry>(soapModels.length);

		for (CommerceSubscriptionEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.model.CommerceSubscriptionEntry"));

	public CommerceSubscriptionEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceSubscriptionEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceSubscriptionEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceSubscriptionEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceSubscriptionEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceSubscriptionEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceSubscriptionEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceSubscriptionEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceSubscriptionEntry, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommerceSubscriptionEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceSubscriptionEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceSubscriptionEntry, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceSubscriptionEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceSubscriptionEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceSubscriptionEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceSubscriptionEntry>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceSubscriptionEntry.class.getClassLoader(),
			CommerceSubscriptionEntry.class, ModelWrapper.class);

		try {
			Constructor<CommerceSubscriptionEntry> constructor =
				(Constructor<CommerceSubscriptionEntry>)
					proxyClass.getConstructor(InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map
		<String, Function<CommerceSubscriptionEntry, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<CommerceSubscriptionEntry, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceSubscriptionEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceSubscriptionEntry, Object>>();
		Map<String, BiConsumer<CommerceSubscriptionEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceSubscriptionEntry, ?>>();

		attributeGetterFunctions.put(
			"uuid", CommerceSubscriptionEntry::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<CommerceSubscriptionEntry, String>)
				CommerceSubscriptionEntry::setUuid);
		attributeGetterFunctions.put(
			"commerceSubscriptionEntryId",
			CommerceSubscriptionEntry::getCommerceSubscriptionEntryId);
		attributeSetterBiConsumers.put(
			"commerceSubscriptionEntryId",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setCommerceSubscriptionEntryId);
		attributeGetterFunctions.put(
			"groupId", CommerceSubscriptionEntry::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setGroupId);
		attributeGetterFunctions.put(
			"companyId", CommerceSubscriptionEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setCompanyId);
		attributeGetterFunctions.put(
			"userId", CommerceSubscriptionEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setUserId);
		attributeGetterFunctions.put(
			"userName", CommerceSubscriptionEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceSubscriptionEntry, String>)
				CommerceSubscriptionEntry::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceSubscriptionEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceSubscriptionEntry, Date>)
				CommerceSubscriptionEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceSubscriptionEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceSubscriptionEntry, Date>)
				CommerceSubscriptionEntry::setModifiedDate);
		attributeGetterFunctions.put(
			"CPInstanceUuid", CommerceSubscriptionEntry::getCPInstanceUuid);
		attributeSetterBiConsumers.put(
			"CPInstanceUuid",
			(BiConsumer<CommerceSubscriptionEntry, String>)
				CommerceSubscriptionEntry::setCPInstanceUuid);
		attributeGetterFunctions.put(
			"CProductId", CommerceSubscriptionEntry::getCProductId);
		attributeSetterBiConsumers.put(
			"CProductId",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setCProductId);
		attributeGetterFunctions.put(
			"commerceOrderItemId",
			CommerceSubscriptionEntry::getCommerceOrderItemId);
		attributeSetterBiConsumers.put(
			"commerceOrderItemId",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setCommerceOrderItemId);
		attributeGetterFunctions.put(
			"subscriptionLength",
			CommerceSubscriptionEntry::getSubscriptionLength);
		attributeSetterBiConsumers.put(
			"subscriptionLength",
			(BiConsumer<CommerceSubscriptionEntry, Integer>)
				CommerceSubscriptionEntry::setSubscriptionLength);
		attributeGetterFunctions.put(
			"subscriptionType", CommerceSubscriptionEntry::getSubscriptionType);
		attributeSetterBiConsumers.put(
			"subscriptionType",
			(BiConsumer<CommerceSubscriptionEntry, String>)
				CommerceSubscriptionEntry::setSubscriptionType);
		attributeGetterFunctions.put(
			"subscriptionTypeSettings",
			CommerceSubscriptionEntry::getSubscriptionTypeSettings);
		attributeSetterBiConsumers.put(
			"subscriptionTypeSettings",
			(BiConsumer<CommerceSubscriptionEntry, String>)
				CommerceSubscriptionEntry::setSubscriptionTypeSettings);
		attributeGetterFunctions.put(
			"currentCycle", CommerceSubscriptionEntry::getCurrentCycle);
		attributeSetterBiConsumers.put(
			"currentCycle",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setCurrentCycle);
		attributeGetterFunctions.put(
			"maxSubscriptionCycles",
			CommerceSubscriptionEntry::getMaxSubscriptionCycles);
		attributeSetterBiConsumers.put(
			"maxSubscriptionCycles",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setMaxSubscriptionCycles);
		attributeGetterFunctions.put(
			"subscriptionStatus",
			CommerceSubscriptionEntry::getSubscriptionStatus);
		attributeSetterBiConsumers.put(
			"subscriptionStatus",
			(BiConsumer<CommerceSubscriptionEntry, Integer>)
				CommerceSubscriptionEntry::setSubscriptionStatus);
		attributeGetterFunctions.put(
			"lastIterationDate",
			CommerceSubscriptionEntry::getLastIterationDate);
		attributeSetterBiConsumers.put(
			"lastIterationDate",
			(BiConsumer<CommerceSubscriptionEntry, Date>)
				CommerceSubscriptionEntry::setLastIterationDate);
		attributeGetterFunctions.put(
			"nextIterationDate",
			CommerceSubscriptionEntry::getNextIterationDate);
		attributeSetterBiConsumers.put(
			"nextIterationDate",
			(BiConsumer<CommerceSubscriptionEntry, Date>)
				CommerceSubscriptionEntry::setNextIterationDate);
		attributeGetterFunctions.put(
			"startDate", CommerceSubscriptionEntry::getStartDate);
		attributeSetterBiConsumers.put(
			"startDate",
			(BiConsumer<CommerceSubscriptionEntry, Date>)
				CommerceSubscriptionEntry::setStartDate);
		attributeGetterFunctions.put(
			"deliverySubscriptionLength",
			CommerceSubscriptionEntry::getDeliverySubscriptionLength);
		attributeSetterBiConsumers.put(
			"deliverySubscriptionLength",
			(BiConsumer<CommerceSubscriptionEntry, Integer>)
				CommerceSubscriptionEntry::setDeliverySubscriptionLength);
		attributeGetterFunctions.put(
			"deliverySubscriptionType",
			CommerceSubscriptionEntry::getDeliverySubscriptionType);
		attributeSetterBiConsumers.put(
			"deliverySubscriptionType",
			(BiConsumer<CommerceSubscriptionEntry, String>)
				CommerceSubscriptionEntry::setDeliverySubscriptionType);
		attributeGetterFunctions.put(
			"deliverySubscriptionTypeSettings",
			CommerceSubscriptionEntry::getDeliverySubscriptionTypeSettings);
		attributeSetterBiConsumers.put(
			"deliverySubscriptionTypeSettings",
			(BiConsumer<CommerceSubscriptionEntry, String>)
				CommerceSubscriptionEntry::setDeliverySubscriptionTypeSettings);
		attributeGetterFunctions.put(
			"deliveryCurrentCycle",
			CommerceSubscriptionEntry::getDeliveryCurrentCycle);
		attributeSetterBiConsumers.put(
			"deliveryCurrentCycle",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setDeliveryCurrentCycle);
		attributeGetterFunctions.put(
			"deliveryMaxSubscriptionCycles",
			CommerceSubscriptionEntry::getDeliveryMaxSubscriptionCycles);
		attributeSetterBiConsumers.put(
			"deliveryMaxSubscriptionCycles",
			(BiConsumer<CommerceSubscriptionEntry, Long>)
				CommerceSubscriptionEntry::setDeliveryMaxSubscriptionCycles);
		attributeGetterFunctions.put(
			"deliverySubscriptionStatus",
			CommerceSubscriptionEntry::getDeliverySubscriptionStatus);
		attributeSetterBiConsumers.put(
			"deliverySubscriptionStatus",
			(BiConsumer<CommerceSubscriptionEntry, Integer>)
				CommerceSubscriptionEntry::setDeliverySubscriptionStatus);
		attributeGetterFunctions.put(
			"deliveryLastIterationDate",
			CommerceSubscriptionEntry::getDeliveryLastIterationDate);
		attributeSetterBiConsumers.put(
			"deliveryLastIterationDate",
			(BiConsumer<CommerceSubscriptionEntry, Date>)
				CommerceSubscriptionEntry::setDeliveryLastIterationDate);
		attributeGetterFunctions.put(
			"deliveryNextIterationDate",
			CommerceSubscriptionEntry::getDeliveryNextIterationDate);
		attributeSetterBiConsumers.put(
			"deliveryNextIterationDate",
			(BiConsumer<CommerceSubscriptionEntry, Date>)
				CommerceSubscriptionEntry::setDeliveryNextIterationDate);
		attributeGetterFunctions.put(
			"deliveryStartDate",
			CommerceSubscriptionEntry::getDeliveryStartDate);
		attributeSetterBiConsumers.put(
			"deliveryStartDate",
			(BiConsumer<CommerceSubscriptionEntry, Date>)
				CommerceSubscriptionEntry::setDeliveryStartDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getCommerceSubscriptionEntryId() {
		return _commerceSubscriptionEntryId;
	}

	@Override
	public void setCommerceSubscriptionEntryId(
		long commerceSubscriptionEntryId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceSubscriptionEntryId = commerceSubscriptionEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getCPInstanceUuid() {
		if (_CPInstanceUuid == null) {
			return "";
		}
		else {
			return _CPInstanceUuid;
		}
	}

	@Override
	public void setCPInstanceUuid(String CPInstanceUuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CPInstanceUuid = CPInstanceUuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalCPInstanceUuid() {
		return getColumnOriginalValue("CPInstanceUuid");
	}

	@JSON
	@Override
	public long getCProductId() {
		return _CProductId;
	}

	@Override
	public void setCProductId(long CProductId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_CProductId = CProductId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCProductId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("CProductId"));
	}

	@JSON
	@Override
	public long getCommerceOrderItemId() {
		return _commerceOrderItemId;
	}

	@Override
	public void setCommerceOrderItemId(long commerceOrderItemId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceOrderItemId = commerceOrderItemId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceOrderItemId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commerceOrderItemId"));
	}

	@JSON
	@Override
	public int getSubscriptionLength() {
		return _subscriptionLength;
	}

	@Override
	public void setSubscriptionLength(int subscriptionLength) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subscriptionLength = subscriptionLength;
	}

	@JSON
	@Override
	public String getSubscriptionType() {
		if (_subscriptionType == null) {
			return "";
		}
		else {
			return _subscriptionType;
		}
	}

	@Override
	public void setSubscriptionType(String subscriptionType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subscriptionType = subscriptionType;
	}

	@JSON
	@Override
	public String getSubscriptionTypeSettings() {
		if (_subscriptionTypeSettings == null) {
			return "";
		}
		else {
			return _subscriptionTypeSettings;
		}
	}

	@Override
	public void setSubscriptionTypeSettings(String subscriptionTypeSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subscriptionTypeSettings = subscriptionTypeSettings;
	}

	@JSON
	@Override
	public long getCurrentCycle() {
		return _currentCycle;
	}

	@Override
	public void setCurrentCycle(long currentCycle) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_currentCycle = currentCycle;
	}

	@JSON
	@Override
	public long getMaxSubscriptionCycles() {
		return _maxSubscriptionCycles;
	}

	@Override
	public void setMaxSubscriptionCycles(long maxSubscriptionCycles) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_maxSubscriptionCycles = maxSubscriptionCycles;
	}

	@JSON
	@Override
	public int getSubscriptionStatus() {
		return _subscriptionStatus;
	}

	@Override
	public void setSubscriptionStatus(int subscriptionStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subscriptionStatus = subscriptionStatus;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalSubscriptionStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("subscriptionStatus"));
	}

	@JSON
	@Override
	public Date getLastIterationDate() {
		return _lastIterationDate;
	}

	@Override
	public void setLastIterationDate(Date lastIterationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastIterationDate = lastIterationDate;
	}

	@JSON
	@Override
	public Date getNextIterationDate() {
		return _nextIterationDate;
	}

	@Override
	public void setNextIterationDate(Date nextIterationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_nextIterationDate = nextIterationDate;
	}

	@JSON
	@Override
	public Date getStartDate() {
		return _startDate;
	}

	@Override
	public void setStartDate(Date startDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_startDate = startDate;
	}

	@JSON
	@Override
	public int getDeliverySubscriptionLength() {
		return _deliverySubscriptionLength;
	}

	@Override
	public void setDeliverySubscriptionLength(int deliverySubscriptionLength) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliverySubscriptionLength = deliverySubscriptionLength;
	}

	@JSON
	@Override
	public String getDeliverySubscriptionType() {
		if (_deliverySubscriptionType == null) {
			return "";
		}
		else {
			return _deliverySubscriptionType;
		}
	}

	@Override
	public void setDeliverySubscriptionType(String deliverySubscriptionType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliverySubscriptionType = deliverySubscriptionType;
	}

	@JSON
	@Override
	public String getDeliverySubscriptionTypeSettings() {
		if (_deliverySubscriptionTypeSettings == null) {
			return "";
		}
		else {
			return _deliverySubscriptionTypeSettings;
		}
	}

	@Override
	public void setDeliverySubscriptionTypeSettings(
		String deliverySubscriptionTypeSettings) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliverySubscriptionTypeSettings = deliverySubscriptionTypeSettings;
	}

	@JSON
	@Override
	public long getDeliveryCurrentCycle() {
		return _deliveryCurrentCycle;
	}

	@Override
	public void setDeliveryCurrentCycle(long deliveryCurrentCycle) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryCurrentCycle = deliveryCurrentCycle;
	}

	@JSON
	@Override
	public long getDeliveryMaxSubscriptionCycles() {
		return _deliveryMaxSubscriptionCycles;
	}

	@Override
	public void setDeliveryMaxSubscriptionCycles(
		long deliveryMaxSubscriptionCycles) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryMaxSubscriptionCycles = deliveryMaxSubscriptionCycles;
	}

	@JSON
	@Override
	public int getDeliverySubscriptionStatus() {
		return _deliverySubscriptionStatus;
	}

	@Override
	public void setDeliverySubscriptionStatus(int deliverySubscriptionStatus) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliverySubscriptionStatus = deliverySubscriptionStatus;
	}

	@JSON
	@Override
	public Date getDeliveryLastIterationDate() {
		return _deliveryLastIterationDate;
	}

	@Override
	public void setDeliveryLastIterationDate(Date deliveryLastIterationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryLastIterationDate = deliveryLastIterationDate;
	}

	@JSON
	@Override
	public Date getDeliveryNextIterationDate() {
		return _deliveryNextIterationDate;
	}

	@Override
	public void setDeliveryNextIterationDate(Date deliveryNextIterationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryNextIterationDate = deliveryNextIterationDate;
	}

	@JSON
	@Override
	public Date getDeliveryStartDate() {
		return _deliveryStartDate;
	}

	@Override
	public void setDeliveryStartDate(Date deliveryStartDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_deliveryStartDate = deliveryStartDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(
				CommerceSubscriptionEntry.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceSubscriptionEntry.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceSubscriptionEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceSubscriptionEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceSubscriptionEntryImpl commerceSubscriptionEntryImpl =
			new CommerceSubscriptionEntryImpl();

		commerceSubscriptionEntryImpl.setUuid(getUuid());
		commerceSubscriptionEntryImpl.setCommerceSubscriptionEntryId(
			getCommerceSubscriptionEntryId());
		commerceSubscriptionEntryImpl.setGroupId(getGroupId());
		commerceSubscriptionEntryImpl.setCompanyId(getCompanyId());
		commerceSubscriptionEntryImpl.setUserId(getUserId());
		commerceSubscriptionEntryImpl.setUserName(getUserName());
		commerceSubscriptionEntryImpl.setCreateDate(getCreateDate());
		commerceSubscriptionEntryImpl.setModifiedDate(getModifiedDate());
		commerceSubscriptionEntryImpl.setCPInstanceUuid(getCPInstanceUuid());
		commerceSubscriptionEntryImpl.setCProductId(getCProductId());
		commerceSubscriptionEntryImpl.setCommerceOrderItemId(
			getCommerceOrderItemId());
		commerceSubscriptionEntryImpl.setSubscriptionLength(
			getSubscriptionLength());
		commerceSubscriptionEntryImpl.setSubscriptionType(
			getSubscriptionType());
		commerceSubscriptionEntryImpl.setSubscriptionTypeSettings(
			getSubscriptionTypeSettings());
		commerceSubscriptionEntryImpl.setCurrentCycle(getCurrentCycle());
		commerceSubscriptionEntryImpl.setMaxSubscriptionCycles(
			getMaxSubscriptionCycles());
		commerceSubscriptionEntryImpl.setSubscriptionStatus(
			getSubscriptionStatus());
		commerceSubscriptionEntryImpl.setLastIterationDate(
			getLastIterationDate());
		commerceSubscriptionEntryImpl.setNextIterationDate(
			getNextIterationDate());
		commerceSubscriptionEntryImpl.setStartDate(getStartDate());
		commerceSubscriptionEntryImpl.setDeliverySubscriptionLength(
			getDeliverySubscriptionLength());
		commerceSubscriptionEntryImpl.setDeliverySubscriptionType(
			getDeliverySubscriptionType());
		commerceSubscriptionEntryImpl.setDeliverySubscriptionTypeSettings(
			getDeliverySubscriptionTypeSettings());
		commerceSubscriptionEntryImpl.setDeliveryCurrentCycle(
			getDeliveryCurrentCycle());
		commerceSubscriptionEntryImpl.setDeliveryMaxSubscriptionCycles(
			getDeliveryMaxSubscriptionCycles());
		commerceSubscriptionEntryImpl.setDeliverySubscriptionStatus(
			getDeliverySubscriptionStatus());
		commerceSubscriptionEntryImpl.setDeliveryLastIterationDate(
			getDeliveryLastIterationDate());
		commerceSubscriptionEntryImpl.setDeliveryNextIterationDate(
			getDeliveryNextIterationDate());
		commerceSubscriptionEntryImpl.setDeliveryStartDate(
			getDeliveryStartDate());

		commerceSubscriptionEntryImpl.resetOriginalValues();

		return commerceSubscriptionEntryImpl;
	}

	@Override
	public int compareTo(CommerceSubscriptionEntry commerceSubscriptionEntry) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commerceSubscriptionEntry.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceSubscriptionEntry)) {
			return false;
		}

		CommerceSubscriptionEntry commerceSubscriptionEntry =
			(CommerceSubscriptionEntry)object;

		long primaryKey = commerceSubscriptionEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceSubscriptionEntry> toCacheModel() {
		CommerceSubscriptionEntryCacheModel
			commerceSubscriptionEntryCacheModel =
				new CommerceSubscriptionEntryCacheModel();

		commerceSubscriptionEntryCacheModel.uuid = getUuid();

		String uuid = commerceSubscriptionEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceSubscriptionEntryCacheModel.uuid = null;
		}

		commerceSubscriptionEntryCacheModel.commerceSubscriptionEntryId =
			getCommerceSubscriptionEntryId();

		commerceSubscriptionEntryCacheModel.groupId = getGroupId();

		commerceSubscriptionEntryCacheModel.companyId = getCompanyId();

		commerceSubscriptionEntryCacheModel.userId = getUserId();

		commerceSubscriptionEntryCacheModel.userName = getUserName();

		String userName = commerceSubscriptionEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceSubscriptionEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceSubscriptionEntryCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceSubscriptionEntryCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceSubscriptionEntryCacheModel.CPInstanceUuid =
			getCPInstanceUuid();

		String CPInstanceUuid =
			commerceSubscriptionEntryCacheModel.CPInstanceUuid;

		if ((CPInstanceUuid != null) && (CPInstanceUuid.length() == 0)) {
			commerceSubscriptionEntryCacheModel.CPInstanceUuid = null;
		}

		commerceSubscriptionEntryCacheModel.CProductId = getCProductId();

		commerceSubscriptionEntryCacheModel.commerceOrderItemId =
			getCommerceOrderItemId();

		commerceSubscriptionEntryCacheModel.subscriptionLength =
			getSubscriptionLength();

		commerceSubscriptionEntryCacheModel.subscriptionType =
			getSubscriptionType();

		String subscriptionType =
			commerceSubscriptionEntryCacheModel.subscriptionType;

		if ((subscriptionType != null) && (subscriptionType.length() == 0)) {
			commerceSubscriptionEntryCacheModel.subscriptionType = null;
		}

		commerceSubscriptionEntryCacheModel.subscriptionTypeSettings =
			getSubscriptionTypeSettings();

		String subscriptionTypeSettings =
			commerceSubscriptionEntryCacheModel.subscriptionTypeSettings;

		if ((subscriptionTypeSettings != null) &&
			(subscriptionTypeSettings.length() == 0)) {

			commerceSubscriptionEntryCacheModel.subscriptionTypeSettings = null;
		}

		commerceSubscriptionEntryCacheModel.currentCycle = getCurrentCycle();

		commerceSubscriptionEntryCacheModel.maxSubscriptionCycles =
			getMaxSubscriptionCycles();

		commerceSubscriptionEntryCacheModel.subscriptionStatus =
			getSubscriptionStatus();

		Date lastIterationDate = getLastIterationDate();

		if (lastIterationDate != null) {
			commerceSubscriptionEntryCacheModel.lastIterationDate =
				lastIterationDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.lastIterationDate =
				Long.MIN_VALUE;
		}

		Date nextIterationDate = getNextIterationDate();

		if (nextIterationDate != null) {
			commerceSubscriptionEntryCacheModel.nextIterationDate =
				nextIterationDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.nextIterationDate =
				Long.MIN_VALUE;
		}

		Date startDate = getStartDate();

		if (startDate != null) {
			commerceSubscriptionEntryCacheModel.startDate = startDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.startDate = Long.MIN_VALUE;
		}

		commerceSubscriptionEntryCacheModel.deliverySubscriptionLength =
			getDeliverySubscriptionLength();

		commerceSubscriptionEntryCacheModel.deliverySubscriptionType =
			getDeliverySubscriptionType();

		String deliverySubscriptionType =
			commerceSubscriptionEntryCacheModel.deliverySubscriptionType;

		if ((deliverySubscriptionType != null) &&
			(deliverySubscriptionType.length() == 0)) {

			commerceSubscriptionEntryCacheModel.deliverySubscriptionType = null;
		}

		commerceSubscriptionEntryCacheModel.deliverySubscriptionTypeSettings =
			getDeliverySubscriptionTypeSettings();

		String deliverySubscriptionTypeSettings =
			commerceSubscriptionEntryCacheModel.
				deliverySubscriptionTypeSettings;

		if ((deliverySubscriptionTypeSettings != null) &&
			(deliverySubscriptionTypeSettings.length() == 0)) {

			commerceSubscriptionEntryCacheModel.
				deliverySubscriptionTypeSettings = null;
		}

		commerceSubscriptionEntryCacheModel.deliveryCurrentCycle =
			getDeliveryCurrentCycle();

		commerceSubscriptionEntryCacheModel.deliveryMaxSubscriptionCycles =
			getDeliveryMaxSubscriptionCycles();

		commerceSubscriptionEntryCacheModel.deliverySubscriptionStatus =
			getDeliverySubscriptionStatus();

		Date deliveryLastIterationDate = getDeliveryLastIterationDate();

		if (deliveryLastIterationDate != null) {
			commerceSubscriptionEntryCacheModel.deliveryLastIterationDate =
				deliveryLastIterationDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.deliveryLastIterationDate =
				Long.MIN_VALUE;
		}

		Date deliveryNextIterationDate = getDeliveryNextIterationDate();

		if (deliveryNextIterationDate != null) {
			commerceSubscriptionEntryCacheModel.deliveryNextIterationDate =
				deliveryNextIterationDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.deliveryNextIterationDate =
				Long.MIN_VALUE;
		}

		Date deliveryStartDate = getDeliveryStartDate();

		if (deliveryStartDate != null) {
			commerceSubscriptionEntryCacheModel.deliveryStartDate =
				deliveryStartDate.getTime();
		}
		else {
			commerceSubscriptionEntryCacheModel.deliveryStartDate =
				Long.MIN_VALUE;
		}

		return commerceSubscriptionEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceSubscriptionEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceSubscriptionEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceSubscriptionEntry, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceSubscriptionEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceSubscriptionEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceSubscriptionEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceSubscriptionEntry, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((CommerceSubscriptionEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceSubscriptionEntry>
				_escapedModelProxyProviderFunction =
					_getProxyProviderFunction();

	}

	private String _uuid;
	private long _commerceSubscriptionEntryId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _CPInstanceUuid;
	private long _CProductId;
	private long _commerceOrderItemId;
	private int _subscriptionLength;
	private String _subscriptionType;
	private String _subscriptionTypeSettings;
	private long _currentCycle;
	private long _maxSubscriptionCycles;
	private int _subscriptionStatus;
	private Date _lastIterationDate;
	private Date _nextIterationDate;
	private Date _startDate;
	private int _deliverySubscriptionLength;
	private String _deliverySubscriptionType;
	private String _deliverySubscriptionTypeSettings;
	private long _deliveryCurrentCycle;
	private long _deliveryMaxSubscriptionCycles;
	private int _deliverySubscriptionStatus;
	private Date _deliveryLastIterationDate;
	private Date _deliveryNextIterationDate;
	private Date _deliveryStartDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceSubscriptionEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceSubscriptionEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"commerceSubscriptionEntryId", _commerceSubscriptionEntryId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("CPInstanceUuid", _CPInstanceUuid);
		_columnOriginalValues.put("CProductId", _CProductId);
		_columnOriginalValues.put("commerceOrderItemId", _commerceOrderItemId);
		_columnOriginalValues.put("subscriptionLength", _subscriptionLength);
		_columnOriginalValues.put("subscriptionType", _subscriptionType);
		_columnOriginalValues.put(
			"subscriptionTypeSettings", _subscriptionTypeSettings);
		_columnOriginalValues.put("currentCycle", _currentCycle);
		_columnOriginalValues.put(
			"maxSubscriptionCycles", _maxSubscriptionCycles);
		_columnOriginalValues.put("subscriptionStatus", _subscriptionStatus);
		_columnOriginalValues.put("lastIterationDate", _lastIterationDate);
		_columnOriginalValues.put("nextIterationDate", _nextIterationDate);
		_columnOriginalValues.put("startDate", _startDate);
		_columnOriginalValues.put(
			"deliverySubscriptionLength", _deliverySubscriptionLength);
		_columnOriginalValues.put(
			"deliverySubscriptionType", _deliverySubscriptionType);
		_columnOriginalValues.put(
			"deliverySubTypeSettings", _deliverySubscriptionTypeSettings);
		_columnOriginalValues.put(
			"deliveryCurrentCycle", _deliveryCurrentCycle);
		_columnOriginalValues.put(
			"deliveryMaxSubscriptionCycles", _deliveryMaxSubscriptionCycles);
		_columnOriginalValues.put(
			"deliverySubscriptionStatus", _deliverySubscriptionStatus);
		_columnOriginalValues.put(
			"deliveryLastIterationDate", _deliveryLastIterationDate);
		_columnOriginalValues.put(
			"deliveryNextIterationDate", _deliveryNextIterationDate);
		_columnOriginalValues.put("deliveryStartDate", _deliveryStartDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put(
			"deliverySubTypeSettings", "deliverySubscriptionTypeSettings");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("uuid_", 1L);

		columnBitmasks.put("commerceSubscriptionEntryId", 2L);

		columnBitmasks.put("groupId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("CPInstanceUuid", 256L);

		columnBitmasks.put("CProductId", 512L);

		columnBitmasks.put("commerceOrderItemId", 1024L);

		columnBitmasks.put("subscriptionLength", 2048L);

		columnBitmasks.put("subscriptionType", 4096L);

		columnBitmasks.put("subscriptionTypeSettings", 8192L);

		columnBitmasks.put("currentCycle", 16384L);

		columnBitmasks.put("maxSubscriptionCycles", 32768L);

		columnBitmasks.put("subscriptionStatus", 65536L);

		columnBitmasks.put("lastIterationDate", 131072L);

		columnBitmasks.put("nextIterationDate", 262144L);

		columnBitmasks.put("startDate", 524288L);

		columnBitmasks.put("deliverySubscriptionLength", 1048576L);

		columnBitmasks.put("deliverySubscriptionType", 2097152L);

		columnBitmasks.put("deliverySubTypeSettings", 4194304L);

		columnBitmasks.put("deliveryCurrentCycle", 8388608L);

		columnBitmasks.put("deliveryMaxSubscriptionCycles", 16777216L);

		columnBitmasks.put("deliverySubscriptionStatus", 33554432L);

		columnBitmasks.put("deliveryLastIterationDate", 67108864L);

		columnBitmasks.put("deliveryNextIterationDate", 134217728L);

		columnBitmasks.put("deliveryStartDate", 268435456L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceSubscriptionEntry _escapedModel;

}