/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.instance.lifecycle;

import com.liferay.commerce.constants.CommerceSAPConstants;
import com.liferay.oauth2.provider.scope.spi.scope.finder.ScopeFinder;
import com.liferay.oauth2.provider.scope.spi.scope.mapper.ScopeMapper;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.resource.bundle.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ClassResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"sap.scope.finder=true"}, service={PortalInstanceLifecycleListener.class, ScopeFinder.class, ScopeMapper.class})
public class CommerceServicePortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener
implements ScopeFinder,
ScopeMapper {
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    private List<String> _scopeAliasesList;
    @Reference
    private UserLocalService _userLocalService;

    public Collection<String> findScopes() {
        return this._scopeAliasesList;
    }

    public Set<String> map(String scope) {
        return Collections.singleton(scope);
    }

    public void portalInstanceRegistered(Company company) throws Exception {
        User user = this._userLocalService.getDefaultUser(company.getCompanyId());
        this._addSAPEntries(company.getCompanyId(), user.getUserId());
    }

    @Activate
    protected void activate() {
        Stream<String[]> stream = Arrays.stream(CommerceSAPConstants.SAP_ENTRY_OBJECT_ARRAYS);
        this._scopeAliasesList = stream.map((? super T sapEntryObjectArray) -> StringUtil.replaceFirst((String)sapEntryObjectArray[0], (String)"OAUTH2_", (String)"")).collect(Collectors.toList());
    }

    private void _addSAPEntries(long companyId, long userId) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        AggregateResourceBundleLoader resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{new ClassResourceBundleLoader("content.Language", clazz.getClassLoader()), LanguageResources.PORTAL_RESOURCE_BUNDLE_LOADER});
        for (String[] sapEntryObjectArray : CommerceSAPConstants.SAP_ENTRY_OBJECT_ARRAYS) {
            String sapEntryName = sapEntryObjectArray[0];
            SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(companyId, sapEntryName);
            if (sapEntry != null) continue;
            Map titleMap = ResourceBundleUtil.getLocalizationMap((ResourceBundleLoader)resourceBundleLoader, (String)"public-access-to-the-commerce-service-apis");
            this._sapEntryLocalService.addSAPEntry(userId, sapEntryObjectArray[1], true, true, sapEntryName, titleMap, new ServiceContext());
        }
    }
}

