/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order.engine;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.configuration.CommerceOrderCheckoutConfiguration;
import com.liferay.commerce.constants.CommerceOrderConstants;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.context.CommerceContextFactory;
import com.liferay.commerce.discount.exception.CommerceDiscountLimitationTimesException;
import com.liferay.commerce.discount.model.CommerceDiscount;
import com.liferay.commerce.discount.service.CommerceDiscountLocalService;
import com.liferay.commerce.discount.service.CommerceDiscountUsageEntryLocalService;
import com.liferay.commerce.exception.CommerceOrderBillingAddressException;
import com.liferay.commerce.exception.CommerceOrderGuestCheckoutException;
import com.liferay.commerce.exception.CommerceOrderShippingAddressException;
import com.liferay.commerce.exception.CommerceOrderShippingMethodException;
import com.liferay.commerce.exception.CommerceOrderStatusException;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.inventory.engine.CommerceInventoryEngine;
import com.liferay.commerce.inventory.model.CommerceInventoryBookedQuantity;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.order.CommerceOrderValidatorRegistry;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.order.status.CommerceOrderStatus;
import com.liferay.commerce.order.status.CommerceOrderStatusRegistry;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.CommercePaymentMethodRegistry;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.commerce.service.CommerceAddressLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceShipmentLocalService;
import com.liferay.commerce.service.CommerceShippingMethodLocalService;
import com.liferay.commerce.stock.activity.CommerceLowStockActivity;
import com.liferay.commerce.stock.activity.CommerceLowStockActivityRegistry;
import com.liferay.commerce.subscription.CommerceSubscriptionEntryHelperUtil;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceOrderEngine.class})
public class CommerceOrderEngineImpl
implements CommerceOrderEngine {
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    @Reference
    private CommerceAddressLocalService _commerceAddressLocalService;
    @Reference
    private CommerceContextFactory _commerceContextFactory;
    @Reference
    private CommerceDiscountLocalService _commerceDiscountLocalService;
    @Reference
    private CommerceDiscountUsageEntryLocalService _commerceDiscountUsageEntryLocalService;
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CommerceInventoryEngine _commerceInventoryEngine;
    @Reference
    private CommerceLowStockActivityRegistry _commerceLowStockActivityRegistry;
    @Reference
    private CommerceNotificationHelper _commerceNotificationHelper;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    @Reference
    private CommerceOrderStatusRegistry _commerceOrderStatusRegistry;
    @Reference
    private CommerceOrderValidatorRegistry _commerceOrderValidatorRegistry;
    @Reference
    private CommercePaymentMethodRegistry _commercePaymentMethodRegistry;
    @Reference
    private CommerceShipmentLocalService _commerceShipmentLocalService;
    @Reference
    private CommerceShippingHelper _commerceShippingHelper;
    @Reference
    private CommerceShippingMethodLocalService _commerceShippingMethodLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceOrder checkCommerceOrderShipmentStatus(final CommerceOrder commerceOrder) throws PortalException {
        return this._executeInTransaction(new Callable<CommerceOrder>(){

            @Override
            public CommerceOrder call() throws Exception {
                return CommerceOrderEngineImpl.this._checkCommerceOrderShipmentStatus(commerceOrder);
            }
        });
    }

    public CommerceOrder checkoutCommerceOrder(final CommerceOrder commerceOrder, final long userId) throws PortalException {
        return this._executeInTransaction(new Callable<CommerceOrder>(){

            @Override
            public CommerceOrder call() throws Exception {
                return CommerceOrderEngineImpl.this._checkoutCommerceOrder(commerceOrder, userId);
            }
        });
    }

    public CommerceOrderStatus getCurrentCommerceOrderStatus(CommerceOrder commerceOrder) {
        return this._commerceOrderStatusRegistry.getCommerceOrderStatus(commerceOrder.getOrderStatus());
    }

    public List<CommerceOrderStatus> getNextCommerceOrderStatuses(CommerceOrder commerceOrder) throws PortalException {
        CommerceOrderStatus currentCommerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(commerceOrder.getOrderStatus());
        ArrayList<CommerceOrderStatus> nextCommerceOrderStatuses = new ArrayList<CommerceOrderStatus>();
        if (currentCommerceOrderStatus == null) {
            return nextCommerceOrderStatuses;
        }
        if (currentCommerceOrderStatus.getKey() == 20) {
            nextCommerceOrderStatuses.add(this._commerceOrderStatusRegistry.getCommerceOrderStatus(20));
            return nextCommerceOrderStatuses;
        }
        List commerceOrderStatuses = this._commerceOrderStatusRegistry.getCommerceOrderStatuses();
        int currentOrderStatusIndex = commerceOrderStatuses.indexOf(currentCommerceOrderStatus);
        if (currentOrderStatusIndex != commerceOrderStatuses.size() - 1) {
            CommerceOrderStatus nextCommerceOrderStatus = (CommerceOrderStatus)commerceOrderStatuses.get(currentOrderStatusIndex + 1);
            for (CommerceOrderStatus commerceOrderStatus : commerceOrderStatuses) {
                if ((!commerceOrderStatus.isTransitionCriteriaMet(commerceOrder) || (commerceOrderStatus.getPriority() != -1 || currentCommerceOrderStatus.getKey() == 2) && commerceOrderStatus.getPriority() != nextCommerceOrderStatus.getPriority()) && (this._commerceShippingHelper.isShippable(commerceOrder) || !commerceOrderStatus.isValidForOrder(commerceOrder) || commerceOrderStatus.getPriority() <= currentCommerceOrderStatus.getPriority())) continue;
                nextCommerceOrderStatuses.add(commerceOrderStatus);
            }
        }
        return nextCommerceOrderStatuses;
    }

    public CommerceOrder transitionCommerceOrder(final CommerceOrder commerceOrder, final int orderStatus, final long userId) throws PortalException {
        return this._executeInTransaction(new Callable<CommerceOrder>(){

            @Override
            public CommerceOrder call() throws Exception {
                return CommerceOrderEngineImpl.this._transitionCommerceOrder(commerceOrder, orderStatus, userId);
            }
        });
    }

    private void _bookQuantities(long commerceOrderId) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        List commerceOrderItems = commerceOrder.getCommerceOrderItems();
        CommerceAccount commerceAccount = commerceOrder.getCommerceAccount();
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            CommerceInventoryBookedQuantity commerceInventoryBookedQuantity = this._commerceInventoryBookedQuantityLocalService.addCommerceBookedQuantity(commerceOrderItem.getUserId(), commerceOrderItem.getSku(), commerceOrderItem.getQuantity(), null, (Map)HashMapBuilder.put((Object)"accountName", (Object)commerceAccount.getName()).put((Object)"orderId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderId())).put((Object)"orderItemId", (Object)String.valueOf(commerceOrderItem.getCommerceOrderItemId())).build());
            this._commerceOrderItemLocalService.updateCommerceOrderItem(commerceOrderItem.getCommerceOrderItemId(), commerceInventoryBookedQuantity.getCommerceInventoryBookedQuantityId());
        }
        long companyId = commerceOrder.getCompanyId();
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            CPDefinitionInventoryEngine cpDefinitionInventoryEngine;
            CPInstance cpInstance = this._cpInstanceLocalService.getCPInstance(commerceOrderItem.getCPInstanceId());
            CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
            CommerceLowStockActivity commerceLowStockActivity = this._commerceLowStockActivityRegistry.getCommerceLowStockActivity(cpDefinitionInventory);
            if (commerceLowStockActivity == null) {
                return;
            }
            int stockQuantity = this._commerceInventoryEngine.getStockQuantity(companyId, commerceOrderItem.getSku());
            if (stockQuantity > (cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory)).getMinStockQuantity(cpInstance)) continue;
            commerceLowStockActivity.execute(cpInstance);
        }
    }

    private CommerceOrder _checkCommerceOrderShipmentStatus(CommerceOrder commerceOrder) throws Exception {
        CommerceOrderStatus shippedCommerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(15);
        CommerceOrderStatus completedCommerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(0);
        int[] commerceShipmentStatuses = this._commerceShipmentLocalService.getCommerceShipmentStatusesByCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrder = completedCommerceOrderStatus.isTransitionCriteriaMet(commerceOrder) && commerceShipmentStatuses.length == 1 && commerceShipmentStatuses[0] == 3 ? this.transitionCommerceOrder(commerceOrder, 0, 0L) : (shippedCommerceOrderStatus.isTransitionCriteriaMet(commerceOrder) ? this.transitionCommerceOrder(commerceOrder, 15, 0L) : this.transitionCommerceOrder(commerceOrder, 14, 0L));
        return commerceOrder;
    }

    private CommerceOrder _checkoutCommerceOrder(CommerceOrder commerceOrder, long userId) throws Exception {
        CommerceAddress commerceAddress;
        if (commerceOrder.isGuestOrder() && !this._isGuestCheckoutEnabled(commerceOrder.getGroupId())) {
            throw new CommerceOrderGuestCheckoutException();
        }
        this._commerceOrderModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)commerceOrder, "CHECKOUT_COMMERCE_ORDER");
        CommerceOrderStatus currentCommerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(commerceOrder.getOrderStatus());
        if (currentCommerceOrderStatus == null || currentCommerceOrderStatus.getKey() != 2) {
            throw new CommerceOrderStatusException();
        }
        this._validateCheckout(commerceOrder);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        if (userId == 0L) {
            User defaultUser = this._userLocalService.getDefaultUser(commerceOrder.getCompanyId());
            userId = defaultUser.getUserId();
        }
        serviceContext.setUserId(userId);
        final long commerceOrderId = commerceOrder.getCommerceOrderId();
        CommerceContext commerceContext = this._commerceContextFactory.create(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), userId, commerceOrderId, commerceOrder.getCommerceAccountId());
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                CommerceOrderEngineImpl.this._bookQuantities(commerceOrderId);
                return null;
            }
        });
        commerceOrder = this._commerceOrderLocalService.recalculatePrice(commerceOrderId, commerceContext);
        commerceOrder.setOrderDate(new Date());
        this._updateCommerceDiscountUsageEntry(commerceOrder.getCompanyId(), commerceOrder.getCommerceAccountId(), commerceOrderId, commerceOrder.getCouponCode(), serviceContext);
        if (commerceOrder.getBillingAddressId() > 0L) {
            commerceAddress = this._commerceAddressLocalService.copyCommerceAddress(commerceOrder.getBillingAddressId(), commerceOrder.getModelClassName(), commerceOrderId, serviceContext);
            commerceOrder.setBillingAddressId(commerceAddress.getCommerceAddressId());
        }
        if (commerceOrder.getShippingAddressId() > 0L) {
            commerceAddress = this._commerceAddressLocalService.copyCommerceAddress(commerceOrder.getShippingAddressId(), commerceOrder.getModelClassName(), commerceOrderId, serviceContext);
            commerceOrder.setShippingAddressId(commerceAddress.getCommerceAddressId());
        }
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(commerceOrder.getCommercePaymentMethodKey());
        if (commerceOrder.getPaymentStatus() == 0 || commercePaymentMethod == null || commercePaymentMethod != null && commercePaymentMethod.getPaymentType() == 2 && commerceOrder.getPaymentStatus() == 1) {
            return this.transitionCommerceOrder(commerceOrder, 1, userId);
        }
        return this.transitionCommerceOrder(commerceOrder, 6, userId);
    }

    private CommerceOrder _executeInTransaction(Callable<CommerceOrder> callable) throws PortalException {
        try {
            return (CommerceOrder)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, callable);
        }
        catch (Throwable throwable) {
            throw new PortalException(throwable);
        }
    }

    private boolean _isGuestCheckoutEnabled(long groupId) throws Exception {
        CommerceOrderCheckoutConfiguration commerceOrderCheckoutConfiguration = (CommerceOrderCheckoutConfiguration)this._configurationProvider.getConfiguration(CommerceOrderCheckoutConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.order"));
        return commerceOrderCheckoutConfiguration.guestCheckoutEnabled();
    }

    private void _sendOrderStatusMessage(final CommerceOrder commerceOrder, final int orderStatus) {
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (orderStatus == 1 && commerceOrder.getPaymentStatus() == 0) {
                    CommerceSubscriptionEntryHelperUtil.checkCommerceSubscriptions((CommerceOrder)commerceOrder);
                }
                CommerceOrderEngineImpl.this._commerceNotificationHelper.sendNotifications(commerceOrder.getGroupId(), commerceOrder.getUserId(), CommerceOrderConstants.getNotificationKey((int)orderStatus), (Object)commerceOrder);
                Message message = new Message();
                message.put("commerceOrderId", (Object)commerceOrder.getCommerceOrderId());
                MessageBusUtil.sendMessage((String)"liferay/order_status", (Message)message);
                return null;
            }
        });
    }

    private CommerceOrder _transitionCommerceOrder(CommerceOrder commerceOrder, int orderStatus, long userId) throws Exception {
        CommerceOrderStatus commerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(orderStatus);
        if (commerceOrderStatus == null) {
            throw new CommerceOrderStatusException();
        }
        CommerceOrderStatus currentCommerceOrderStatus = this._commerceOrderStatusRegistry.getCommerceOrderStatus(commerceOrder.getOrderStatus());
        if (!currentCommerceOrderStatus.isComplete(commerceOrder) || !commerceOrderStatus.isTransitionCriteriaMet(commerceOrder) || currentCommerceOrderStatus.getKey() == 20 && commerceOrderStatus.getKey() != 20 && commerceOrderStatus.getKey() != 10) {
            throw new CommerceOrderStatusException();
        }
        this._sendOrderStatusMessage(commerceOrder, commerceOrderStatus.getKey());
        return commerceOrderStatus.doTransition(commerceOrder, userId);
    }

    private void _updateCommerceDiscountUsageEntry(long companyId, long commerceAccountId, long commerceOrderId, String couponCode, ServiceContext serviceContext) throws Exception {
        if (!Validator.isBlank((String)couponCode)) {
            CommerceDiscount commerceDiscount = this._commerceDiscountLocalService.getActiveCommerceDiscount(companyId, couponCode, true);
            if (!this._commerceDiscountUsageEntryLocalService.validateDiscountLimitationUsage(commerceAccountId, commerceDiscount.getCommerceDiscountId())) {
                throw new CommerceDiscountLimitationTimesException();
            }
            this._commerceDiscountUsageEntryLocalService.addCommerceDiscountUsageEntry(commerceAccountId, commerceOrderId, commerceDiscount.getCommerceDiscountId(), serviceContext);
        }
    }

    private void _validateCheckout(CommerceOrder commerceOrder) throws Exception {
        if (!this._commerceOrderValidatorRegistry.isValid(null, commerceOrder)) {
            throw new CommerceOrderValidatorException();
        }
        if (commerceOrder.isB2B() && commerceOrder.getBillingAddressId() <= 0L) {
            throw new CommerceOrderBillingAddressException();
        }
        CommerceShippingMethod commerceShippingMethod = null;
        long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
        if (commerceShippingMethodId > 0L) {
            commerceShippingMethod = this._commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
            if (!commerceShippingMethod.isActive()) {
                commerceShippingMethod = null;
            } else if (commerceOrder.getShippingAddressId() <= 0L) {
                throw new CommerceOrderShippingAddressException();
            }
        }
        int count = this._commerceShippingMethodLocalService.getCommerceShippingMethodsCount(commerceOrder.getGroupId(), true);
        if (commerceShippingMethod == null && count > 0 && this._commerceShippingHelper.isShippable(commerceOrder) && !this._commerceShippingHelper.isFreeShipping(commerceOrder)) {
            throw new CommerceOrderShippingMethodException();
        }
    }
}

