/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.internal.util.CommercePriceConverterUtil;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.price.CommerceOrderItemPrice;
import com.liferay.commerce.price.CommerceOrderPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.price.CommerceOrderPriceImpl;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.util.CommerceBigDecimalUtil;
import com.liferay.portal.kernel.exception.PortalException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;

public abstract class BaseCommerceOrderPriceCalculation
implements CommerceOrderPriceCalculation {
    protected final CommerceChannelLocalService commerceChannelLocalService;
    protected final CommerceMoneyFactory commerceMoneyFactory;
    private static final BigDecimal _ONE_HUNDRED = BigDecimal.valueOf(100L);

    public BaseCommerceOrderPriceCalculation(CommerceChannelLocalService commerceChannelLocalService, CommerceMoneyFactory commerceMoneyFactory) {
        this.commerceChannelLocalService = commerceChannelLocalService;
        this.commerceMoneyFactory = commerceMoneyFactory;
    }

    public CommerceOrderItemPrice getCommerceOrderItemPrice(CommerceCurrency commerceCurrency, CommerceOrderItem commerceOrderItem) throws PortalException {
        return this._getCommerceOrderItemPrice(commerceCurrency, commerceOrderItem, false);
    }

    public CommerceOrderItemPrice getCommerceOrderItemPricePerUnit(CommerceCurrency commerceCurrency, CommerceOrderItem commerceOrderItem) throws PortalException {
        return this._getCommerceOrderItemPrice(commerceCurrency, commerceOrderItem, true);
    }

    protected CommerceOrderPrice getCommerceOrderPriceFromOrder(CommerceOrder commerceOrder) throws PortalException {
        CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        CommerceDiscountValue shippingDiscountValue = this._createCommerceDiscountValue(commerceOrder.getShippingAmount(), commerceCurrency, commerceOrder.getShippingDiscountAmount(), commerceOrder.getShippingDiscountPercentageLevel1(), commerceOrder.getShippingDiscountPercentageLevel2(), commerceOrder.getShippingDiscountPercentageLevel3(), commerceOrder.getShippingDiscountPercentageLevel4());
        CommerceDiscountValue shippingDiscountValueWithTaxAmount = this._createCommerceDiscountValue(commerceOrder.getShippingWithTaxAmount(), commerceCurrency, commerceOrder.getShippingDiscountWithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel1WithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel2WithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel3WithTaxAmount(), commerceOrder.getShippingDiscountPercentageLevel4WithTaxAmount());
        CommerceDiscountValue subtotalDiscountValue = this._createCommerceDiscountValue(commerceOrder.getSubtotal(), commerceCurrency, commerceOrder.getSubtotalDiscountAmount(), commerceOrder.getSubtotalDiscountPercentageLevel1(), commerceOrder.getSubtotalDiscountPercentageLevel2(), commerceOrder.getSubtotalDiscountPercentageLevel3(), commerceOrder.getSubtotalDiscountPercentageLevel4());
        CommerceDiscountValue subtotalDiscountValueWithTaxAmount = this._createCommerceDiscountValue(commerceOrder.getSubtotalWithTaxAmount(), commerceCurrency, commerceOrder.getSubtotalDiscountWithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel1WithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel2WithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel3WithTaxAmount(), commerceOrder.getSubtotalDiscountPercentageLevel4WithTaxAmount());
        BigDecimal total = commerceOrder.getTotal();
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        if (commerceOrder.getTotalDiscountAmount() != null) {
            totalDiscountAmount = commerceOrder.getTotalDiscountAmount();
        }
        CommerceDiscountValue totalDiscountValue = this._createCommerceDiscountValue(total.add(totalDiscountAmount), commerceCurrency, commerceOrder.getTotalDiscountAmount(), commerceOrder.getTotalDiscountPercentageLevel1(), commerceOrder.getTotalDiscountPercentageLevel2(), commerceOrder.getTotalDiscountPercentageLevel3(), commerceOrder.getTotalDiscountPercentageLevel4());
        BigDecimal totalWithTaxAmount = commerceOrder.getTotalWithTaxAmount();
        BigDecimal totalDiscountWithTaxAmount = BigDecimal.ZERO;
        if (commerceOrder.getTotalDiscountWithTaxAmount() != null) {
            totalDiscountWithTaxAmount = commerceOrder.getTotalDiscountWithTaxAmount();
        }
        CommerceDiscountValue totalDiscountValueWithTaxAmount = this._createCommerceDiscountValue(totalWithTaxAmount.add(totalDiscountWithTaxAmount), commerceCurrency, commerceOrder.getTotalDiscountWithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel1WithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel2WithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel3WithTaxAmount(), commerceOrder.getTotalDiscountPercentageLevel4WithTaxAmount());
        CommerceOrderPriceImpl commerceOrderPriceImpl = new CommerceOrderPriceImpl();
        commerceOrderPriceImpl.setShippingDiscountValue(shippingDiscountValue);
        commerceOrderPriceImpl.setShippingDiscountValueWithTaxAmount(shippingDiscountValueWithTaxAmount);
        commerceOrderPriceImpl.setShippingValue(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getShippingAmount()));
        commerceOrderPriceImpl.setShippingValueWithTaxAmount(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getShippingWithTaxAmount()));
        commerceOrderPriceImpl.setSubtotal(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getSubtotal()));
        commerceOrderPriceImpl.setSubtotalDiscountValue(subtotalDiscountValue);
        commerceOrderPriceImpl.setSubtotalDiscountValueWithTaxAmount(subtotalDiscountValueWithTaxAmount);
        commerceOrderPriceImpl.setSubtotalWithTaxAmount(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getSubtotalWithTaxAmount()));
        commerceOrderPriceImpl.setTaxValue(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getTaxAmount()));
        commerceOrderPriceImpl.setTotal(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getTotal()));
        commerceOrderPriceImpl.setTotalDiscountValue(totalDiscountValue);
        commerceOrderPriceImpl.setTotalDiscountValueWithTaxAmount(totalDiscountValueWithTaxAmount);
        commerceOrderPriceImpl.setTotalWithTaxAmount(this.commerceMoneyFactory.create(commerceOrder.getCommerceCurrency(), commerceOrder.getTotalWithTaxAmount()));
        return commerceOrderPriceImpl;
    }

    protected CommerceOrderPriceImpl getEmptyCommerceOrderPrice(CommerceCurrency commerceCurrency) {
        CommerceMoney zero = this.commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO);
        CommerceOrderPriceImpl commerceOrderPriceImpl = new CommerceOrderPriceImpl();
        commerceOrderPriceImpl.setShippingDiscountValue(null);
        commerceOrderPriceImpl.setShippingDiscountValueWithTaxAmount(null);
        commerceOrderPriceImpl.setShippingValue(zero);
        commerceOrderPriceImpl.setShippingValueWithTaxAmount(zero);
        commerceOrderPriceImpl.setSubtotal(zero);
        commerceOrderPriceImpl.setSubtotalDiscountValue(null);
        commerceOrderPriceImpl.setSubtotalDiscountValueWithTaxAmount(null);
        commerceOrderPriceImpl.setSubtotalWithTaxAmount(zero);
        commerceOrderPriceImpl.setTaxValue(zero);
        commerceOrderPriceImpl.setTotal(zero);
        commerceOrderPriceImpl.setTotalDiscountValue(null);
        commerceOrderPriceImpl.setTotalDiscountValueWithTaxAmount(null);
        commerceOrderPriceImpl.setTotalWithTaxAmount(zero);
        return commerceOrderPriceImpl;
    }

    protected void setDiscountValues(boolean discountsTargetNetPrice, BigDecimal shippingAmount, BigDecimal shippingDiscounted, CommerceDiscountValue orderShippingCommerceDiscountValue, BigDecimal subtotalAmount, BigDecimal subtotalDiscounted, CommerceDiscountValue orderSubtotalCommerceDiscountValue, BigDecimal totalAmount, BigDecimal totalDiscounted, CommerceDiscountValue orderTotalCommerceDiscountValue, CommerceOrderPriceImpl commerceOrderPriceImpl, CommerceOrder commerceOrder) throws PortalException {
        CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        if (discountsTargetNetPrice) {
            commerceOrderPriceImpl.setShippingDiscountValue(orderShippingCommerceDiscountValue);
            commerceOrderPriceImpl.setSubtotalDiscountValue(orderSubtotalCommerceDiscountValue);
            commerceOrderPriceImpl.setTotalDiscountValue(orderTotalCommerceDiscountValue);
        } else {
            RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
            commerceOrderPriceImpl.setShippingDiscountValue(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(orderShippingCommerceDiscountValue, shippingAmount, shippingDiscounted, this.commerceMoneyFactory, roundingMode));
            commerceOrderPriceImpl.setSubtotalDiscountValue(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(orderSubtotalCommerceDiscountValue, subtotalAmount, subtotalDiscounted, this.commerceMoneyFactory, roundingMode));
            commerceOrderPriceImpl.setTotalDiscountValue(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(orderTotalCommerceDiscountValue, totalAmount, totalDiscounted, this.commerceMoneyFactory, roundingMode));
        }
    }

    protected void setDiscountValuesWithTaxAmount(boolean discountsTargetNetPrice, BigDecimal shippingWithTaxAmount, BigDecimal shippingDiscountedWithTaxAmount, CommerceDiscountValue orderShippingCommerceDiscountValue, BigDecimal subtotalWithTaxAmount, BigDecimal subtotalDiscountedWithTaxAmount, CommerceDiscountValue orderSubtotalCommerceDiscountValue, BigDecimal totalWithTaxAmount, BigDecimal totalDiscountedWithTaxAmount, CommerceDiscountValue orderTotalCommerceDiscountValue, CommerceOrderPriceImpl commerceOrderPriceImpl, CommerceOrder commerceOrder) throws PortalException {
        CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        RoundingMode roundingMode = RoundingMode.valueOf(commerceCurrency.getRoundingMode());
        if (discountsTargetNetPrice) {
            commerceOrderPriceImpl.setShippingDiscountValueWithTaxAmount(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(orderShippingCommerceDiscountValue, shippingWithTaxAmount, shippingDiscountedWithTaxAmount, this.commerceMoneyFactory, roundingMode));
            commerceOrderPriceImpl.setSubtotalDiscountValueWithTaxAmount(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(orderSubtotalCommerceDiscountValue, subtotalWithTaxAmount, subtotalDiscountedWithTaxAmount, this.commerceMoneyFactory, roundingMode));
            commerceOrderPriceImpl.setTotalDiscountValueWithTaxAmount(CommercePriceConverterUtil.getConvertedCommerceDiscountValue(orderTotalCommerceDiscountValue, totalWithTaxAmount, totalDiscountedWithTaxAmount, this.commerceMoneyFactory, roundingMode));
        } else {
            commerceOrderPriceImpl.setShippingDiscountValueWithTaxAmount(orderShippingCommerceDiscountValue);
            commerceOrderPriceImpl.setSubtotalDiscountValueWithTaxAmount(orderSubtotalCommerceDiscountValue);
            commerceOrderPriceImpl.setTotalDiscountValueWithTaxAmount(orderTotalCommerceDiscountValue);
        }
    }

    private CommerceDiscountValue _createCommerceDiscountValue(BigDecimal amount, CommerceCurrency commerceCurrency, BigDecimal discountAmount, BigDecimal level1, BigDecimal level2, BigDecimal level3, BigDecimal level4) {
        if (discountAmount == null || amount == null || CommerceBigDecimalUtil.lte((BigDecimal)amount, (BigDecimal)BigDecimal.ZERO)) {
            return new CommerceDiscountValue(0L, this.commerceMoneyFactory.create(commerceCurrency, BigDecimal.ZERO), BigDecimal.ZERO, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO});
        }
        BigDecimal[] discountPercentageValues = new BigDecimal[]{level1, level2, level3, level4};
        BigDecimal discountPercentage = discountAmount.divide(amount, RoundingMode.valueOf(commerceCurrency.getRoundingMode()));
        discountPercentage = discountPercentage.multiply(BigDecimal.valueOf(100L));
        return new CommerceDiscountValue(0L, this.commerceMoneyFactory.create(commerceCurrency, discountAmount), discountPercentage, discountPercentageValues);
    }

    private boolean _equalsZero(BigDecimal value) {
        return value != null && CommerceBigDecimalUtil.isZero((BigDecimal)value);
    }

    private CommerceOrderItemPrice _getCommerceOrderItemPrice(CommerceCurrency commerceCurrency, CommerceOrderItem commerceOrderItem, boolean unit) throws PortalException {
        int parentQuantity = commerceOrderItem.getQuantity();
        CommerceMoney unitPriceMoney = commerceOrderItem.getUnitPriceMoney();
        CommerceMoney promoPriceMoney = commerceOrderItem.getPromoPriceMoney();
        CommerceMoney discountAmountMoney = commerceOrderItem.getDiscountAmountMoney();
        CommerceMoney finalPriceMoney = commerceOrderItem.getFinalPriceMoney();
        BigDecimal discountPercentageLevel1 = commerceOrderItem.getDiscountPercentageLevel1();
        BigDecimal discountPercentageLevel2 = commerceOrderItem.getDiscountPercentageLevel2();
        BigDecimal discountPercentageLevel3 = commerceOrderItem.getDiscountPercentageLevel3();
        BigDecimal discountPercentageLevel4 = commerceOrderItem.getDiscountPercentageLevel4();
        CommerceChannel commerceChannel = this.commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrderItem.getGroupId());
        String priceDisplayType = commerceChannel.getPriceDisplayType();
        if (priceDisplayType.equals("tax-included")) {
            unitPriceMoney = commerceOrderItem.getUnitPriceWithTaxAmountMoney();
            promoPriceMoney = commerceOrderItem.getPromoPriceWithTaxAmountMoney();
            discountAmountMoney = commerceOrderItem.getDiscountWithTaxAmountMoney();
            discountPercentageLevel1 = commerceOrderItem.getDiscountPercentageLevel1WithTaxAmount();
            discountPercentageLevel2 = commerceOrderItem.getDiscountPercentageLevel2WithTaxAmount();
            discountPercentageLevel3 = commerceOrderItem.getDiscountPercentageLevel3WithTaxAmount();
            discountPercentageLevel4 = commerceOrderItem.getDiscountPercentageLevel4WithTaxAmount();
            finalPriceMoney = commerceOrderItem.getFinalPriceWithTaxAmountMoney();
        }
        BigDecimal unitPrice = unitPriceMoney.getPrice();
        BigDecimal promoPrice = promoPriceMoney.getPrice();
        BigDecimal finalPrice = finalPriceMoney.getPrice();
        BigDecimal discountAmount = discountAmountMoney.getPrice();
        List childCommerceOrderItems = commerceOrderItem.getChildCommerceOrderItems();
        for (CommerceOrderItem childCommerceOrderItem : childCommerceOrderItems) {
            BigDecimal childUnitPrice = childCommerceOrderItem.getUnitPrice();
            BigDecimal childPromoPrice = childCommerceOrderItem.getPromoPrice();
            BigDecimal childDiscountAmount = childCommerceOrderItem.getDiscountAmount();
            BigDecimal childFinalPrice = childCommerceOrderItem.getFinalPrice();
            if (priceDisplayType.equals("tax-included")) {
                childUnitPrice = childCommerceOrderItem.getUnitPriceWithTaxAmount();
                childPromoPrice = childCommerceOrderItem.getPromoPriceWithTaxAmount();
                childDiscountAmount = childCommerceOrderItem.getDiscountWithTaxAmount();
                childFinalPrice = childCommerceOrderItem.getFinalPriceWithTaxAmount();
            }
            if (this._equalsZero(promoPrice) && this._greaterThanZero(childPromoPrice)) {
                promoPrice = promoPrice.add(unitPrice);
            } else if (this._equalsZero(childPromoPrice) && this._greaterThanZero(promoPrice)) {
                promoPrice = promoPrice.add(this._getPricePerUnit(commerceCurrency, childUnitPrice, childCommerceOrderItem.getQuantity(), parentQuantity));
            }
            unitPrice = unitPrice.add(this._getPricePerUnit(commerceCurrency, childUnitPrice, childCommerceOrderItem.getQuantity(), parentQuantity));
            promoPrice = promoPrice.add(this._getPricePerUnit(commerceCurrency, childPromoPrice, childCommerceOrderItem.getQuantity(), parentQuantity));
            discountAmount = discountAmount.add(childDiscountAmount);
            finalPrice = finalPrice.add(childFinalPrice);
        }
        if (unit) {
            finalPrice = finalPrice.divide(BigDecimal.valueOf(parentQuantity), RoundingMode.valueOf(commerceCurrency.getRoundingMode()));
        }
        CommerceOrderItemPrice commerceOrderItemPrice = new CommerceOrderItemPrice(this.commerceMoneyFactory.create(commerceCurrency, unitPrice));
        this._updatePromoPrice(commerceCurrency, commerceOrderItemPrice, promoPrice);
        this._updateFinalPrice(commerceCurrency, commerceOrderItemPrice, finalPrice);
        this._updateDiscounts(commerceCurrency, commerceOrderItemPrice, discountAmount, discountPercentageLevel1, discountPercentageLevel2, discountPercentageLevel3, discountPercentageLevel4, commerceOrderItem.getQuantity(), unitPrice);
        return commerceOrderItemPrice;
    }

    private BigDecimal _getDiscountPercentage(BigDecimal amount, BigDecimal discount, RoundingMode roundingMode) {
        if (amount == null || CommerceBigDecimalUtil.isZero((BigDecimal)amount)) {
            return BigDecimal.ZERO;
        }
        BigDecimal discountedAmount = amount.subtract(discount);
        double percentage = discountedAmount.doubleValue() / amount.doubleValue();
        BigDecimal discountPercentage = new BigDecimal(percentage);
        discountPercentage = discountPercentage.multiply(_ONE_HUNDRED);
        MathContext mathContext = new MathContext(discountPercentage.precision(), roundingMode);
        return _ONE_HUNDRED.subtract(discountPercentage, mathContext);
    }

    private BigDecimal _getPricePerUnit(CommerceCurrency commerceCurrency, BigDecimal price, int quantity, int parentQuantity) {
        BigDecimal pricePerUnit = price.multiply(BigDecimal.valueOf(quantity));
        return pricePerUnit.divide(BigDecimal.valueOf(parentQuantity), RoundingMode.valueOf(commerceCurrency.getRoundingMode()));
    }

    private boolean _greaterThanZero(BigDecimal value) {
        return value != null || CommerceBigDecimalUtil.gt((BigDecimal)value, (BigDecimal)BigDecimal.ZERO);
    }

    private void _updateDiscounts(CommerceCurrency commerceCurrency, CommerceOrderItemPrice commerceOrderItemPrice, BigDecimal discountAmount, BigDecimal discountPercentageLevel1, BigDecimal discountPercentageLevel2, BigDecimal discountPercentageLevel3, BigDecimal discountPercentageLevel4, int quantity, BigDecimal unitPrice) {
        BigDecimal activePrice = unitPrice;
        CommerceMoney promoPrice = commerceOrderItemPrice.getPromoPrice();
        if (promoPrice != null && !promoPrice.isEmpty() && CommerceBigDecimalUtil.gt((BigDecimal)promoPrice.getPrice(), (BigDecimal)BigDecimal.ZERO) && CommerceBigDecimalUtil.gt((BigDecimal)unitPrice, (BigDecimal)promoPrice.getPrice())) {
            activePrice = promoPrice.getPrice();
        }
        commerceOrderItemPrice.setDiscountAmount(this.commerceMoneyFactory.create(commerceCurrency, discountAmount));
        BigDecimal discountPercentage = this._getDiscountPercentage(activePrice.multiply(BigDecimal.valueOf(quantity)), discountAmount, RoundingMode.valueOf(commerceCurrency.getRoundingMode()));
        commerceOrderItemPrice.setDiscountPercentage(discountPercentage);
        commerceOrderItemPrice.setDiscountPercentageLevel1(discountPercentageLevel1);
        commerceOrderItemPrice.setDiscountPercentageLevel2(discountPercentageLevel2);
        commerceOrderItemPrice.setDiscountPercentageLevel3(discountPercentageLevel3);
        commerceOrderItemPrice.setDiscountPercentageLevel4(discountPercentageLevel4);
    }

    private void _updateFinalPrice(CommerceCurrency commerceCurrency, CommerceOrderItemPrice commerceOrderItemPrice, BigDecimal finalPrice) {
        commerceOrderItemPrice.setFinalPrice(this.commerceMoneyFactory.create(commerceCurrency, finalPrice));
    }

    private void _updatePromoPrice(CommerceCurrency commerceCurrency, CommerceOrderItemPrice commerceOrderItemPrice, BigDecimal promoPrice) {
        if (!this._greaterThanZero(promoPrice)) {
            return;
        }
        commerceOrderItemPrice.setPromoPrice(this.commerceMoneyFactory.create(commerceCurrency, promoPrice));
    }
}

