/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.configuration.CommerceOrderCheckoutConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.exception.CommerceOrderValidatorException;
import com.liferay.commerce.internal.order.VersionCommerceOrderValidatorImpl;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderItemLocalService;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletURL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceOrderHttpHelper.class})
public class CommerceOrderHttpHelperImpl
implements CommerceOrderHttpHelper {
    private static ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    private static final ThreadLocal<CommerceOrder> _commerceOrderUuidThreadLocal;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderItemLocalService _commerceOrderItemLocalService;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletURLFactory _portletURLFactory;

    public CommerceOrder addCommerceOrder(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceAccount commerceAccount;
        CommerceContext commerceContext = this._getCommerceContext(httpServletRequest);
        CommerceOrder commerceOrder = null;
        long commerceCurrencyId = 0L;
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        if (commerceCurrency != null) {
            commerceCurrencyId = commerceCurrency.getCommerceCurrencyId();
        }
        if ((commerceAccount = commerceContext.getCommerceAccount()) != null) {
            commerceOrder = this._commerceOrderService.addCommerceOrder(this._portal.getUserId(httpServletRequest), commerceContext.getCommerceChannelGroupId(), commerceAccount.getCommerceAccountId(), commerceCurrencyId);
        }
        if (commerceAccount == null) {
            throw new CommerceOrderValidatorException(Collections.singletonList(new CommerceOrderValidatorResult(false, this._getLocalizedMessage(this._portal.getLocale(httpServletRequest), "please-select-a-valid-account"))));
        }
        this.setCurrentCommerceOrder(httpServletRequest, commerceOrder);
        return commerceOrder;
    }

    public PortletURL getCommerceCartPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        return this.getCommerceCartPortletURL(httpServletRequest, commerceOrder);
    }

    public PortletURL getCommerceCartPortletURL(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        return this.getCommerceCartPortletURL(groupId, httpServletRequest, commerceOrder);
    }

    public PortletURL getCommerceCartPortletURL(long groupId, HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        long plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet");
        if (plid > 0L && commerceOrder != null && !commerceOrder.isOpen()) {
            PortletURL portletURL = this._getPortletURL(groupId, httpServletRequest, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet");
            if (commerceOrder != null) {
                portletURL.setParameter("mvcRenderCommandName", "viewCommerceOrderDetails");
                portletURL.setParameter("commerceOrderUuid", String.valueOf(commerceOrder.getUuid()));
            }
            return portletURL;
        }
        plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet");
        if (plid > 0L) {
            return this._getPortletURL(groupId, httpServletRequest, "com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet");
        }
        plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet");
        if (plid > 0L && commerceOrder != null && commerceOrder.isOpen()) {
            PortletURL portletURL = this._getPortletURL(groupId, httpServletRequest, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOpenOrderContentPortlet");
            if (commerceOrder != null) {
                portletURL.setParameter("mvcRenderCommandName", "editCommerceOrder");
                portletURL.setParameter("commerceOrderUuid", String.valueOf(commerceOrder.getUuid()));
            }
            return portletURL;
        }
        return null;
    }

    public PortletURL getCommerceCheckoutPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        PortletURL portletURL = this._getPortletURL(httpServletRequest, "com_liferay_commerce_checkout_web_internal_portlet_CommerceCheckoutPortlet");
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        if (commerceOrder != null && commerceOrder.isGuestOrder()) {
            Layout currentLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
            String friendlyURL = "/authentication";
            Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(this._portal.getScopeGroupId(httpServletRequest), false, friendlyURL);
            if (!friendlyURL.equals(currentLayout.getFriendlyURL()) && layout != null) {
                portletURL = this._portletURLFactory.create(httpServletRequest, "com_liferay_login_web_portlet_LoginPortlet", layout, "RENDER_PHASE");
            } else {
                portletURL.setParameter("continueAsGuest", Boolean.TRUE.toString());
                Cookie cookie = new Cookie("continueAsGuest", Boolean.TRUE.toString());
                String domain = CookieKeys.getDomain((HttpServletRequest)httpServletRequest);
                if (Validator.isNotNull((String)domain)) {
                    cookie.setDomain(domain);
                }
                ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                cookie.setMaxAge(31536000);
                cookie.setPath("/");
                CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)themeDisplay.getResponse(), (Cookie)cookie);
            }
        }
        return portletURL;
    }

    public int getCommerceOrderItemsQuantity(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        if (commerceOrder == null) {
            return 0;
        }
        return this._commerceOrderItemService.getCommerceOrderItemsQuantity(commerceOrder.getCommerceOrderId());
    }

    public String getCookieName(long groupId) {
        return CommerceOrder.class.getName() + "#" + groupId;
    }

    public CommerceOrder getCurrentCommerceOrder(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceContext commerceContext = (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT");
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        if (commerceAccount == null) {
            return null;
        }
        CommerceOrder commerceOrder = this._getCurrentCommerceOrder(commerceContext, httpServletRequest);
        if (commerceOrder != null && commerceOrder.isGuestOrder()) {
            commerceOrder = this._checkGuestOrder(commerceContext, commerceOrder, httpServletRequest);
        }
        if (commerceOrder != null && !commerceOrder.isOpen() || commerceOrder != null && !_commerceOrderModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), (ClassedModel)commerceOrder, "UPDATE")) {
            return null;
        }
        return commerceOrder;
    }

    public boolean isGuestCheckoutEnabled(HttpServletRequest httpServletRequest) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        groupId = this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(groupId);
        CommerceOrderCheckoutConfiguration commerceOrderCheckoutConfiguration = (CommerceOrderCheckoutConfiguration)this._configurationProvider.getConfiguration(CommerceOrderCheckoutConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.order"));
        return commerceOrderCheckoutConfiguration.guestCheckoutEnabled();
    }

    public void setCurrentCommerceOrder(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        commerceOrder = this._commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), this._getCommerceContext(httpServletRequest));
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker.isSignedIn()) {
            return;
        }
        this._setGuestCommerceOrder(commerceOrder, httpServletRequest, themeDisplay.getResponse());
    }

    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<CommerceOrder> modelResourcePermission) {
        _commerceOrderModelResourcePermission = modelResourcePermission;
    }

    private CommerceOrder _checkGuestOrder(CommerceContext commerceContext, CommerceOrder commerceOrder, HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder userCommerceOrder;
        if (commerceOrder == null) {
            return null;
        }
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        if (commerceAccount == null) {
            return null;
        }
        User user = this._portal.getUser(httpServletRequest);
        if (user == null || user.isDefaultUser()) {
            return commerceOrder;
        }
        HttpSession httpSession = httpServletRequest.getSession();
        String commerceOrderUuidWebKey = this.getCookieName(commerceOrder.getGroupId());
        CommerceOrder threadLocalCommerceOrder = _commerceOrderUuidThreadLocal.get();
        if (threadLocalCommerceOrder != null && threadLocalCommerceOrder.isGuestOrder()) {
            httpSession.removeAttribute(commerceOrderUuidWebKey);
            _commerceOrderUuidThreadLocal.remove();
        }
        if ((userCommerceOrder = this._commerceOrderService.fetchCommerceOrder(commerceAccount.getCommerceAccountId(), commerceContext.getCommerceChannelGroupId(), user.getUserId(), 2)) == null) {
            httpSession.removeAttribute(commerceOrderUuidWebKey);
            return this._commerceOrderLocalService.updateAccount(commerceOrder.getCommerceOrderId(), user.getUserId(), commerceAccount.getCommerceAccountId());
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        this._commerceOrderService.mergeGuestCommerceOrder(commerceOrder.getCommerceOrderId(), userCommerceOrder.getCommerceOrderId(), this._getCommerceContext(httpServletRequest), serviceContext);
        httpSession.removeAttribute(commerceOrderUuidWebKey);
        return userCommerceOrder;
    }

    private CommerceContext _getCommerceContext(HttpServletRequest httpServletRequest) {
        return (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT");
    }

    private CommerceOrder _getCurrentCommerceOrder(CommerceContext commerceContext, HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = _commerceOrderUuidThreadLocal.get();
        if (commerceOrder != null) {
            return commerceOrder;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.fetchCommerceChannel(commerceContext.getCommerceChannelId());
        if (commerceChannel == null) {
            return null;
        }
        CommerceAccount commerceAccount = commerceContext.getCommerceAccount();
        if (commerceAccount == null) {
            return null;
        }
        String cookieName = this.getCookieName(commerceChannel.getGroupId());
        HttpSession httpSession = httpServletRequest.getSession();
        String commerceOrderUuid = (String)httpSession.getAttribute(cookieName);
        if (commerceAccount.getCommerceAccountId() != -1L) {
            commerceOrder = this._commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(commerceOrderUuid, commerceChannel.getGroupId());
            if (commerceOrder == null) {
                commerceOrder = this._commerceOrderService.fetchCommerceOrder(commerceAccount.getCommerceAccountId(), commerceChannel.getGroupId(), this._portal.getUserId(httpServletRequest), 2);
            }
            if (commerceOrder != null) {
                this._validateCommerceOrderItemVersions(commerceOrder, this._portal.getLocale(httpServletRequest));
                _commerceOrderUuidThreadLocal.set(commerceOrder);
                return commerceOrder;
            }
        }
        if (Validator.isNotNull((String)commerceOrderUuid) && (commerceOrder = this._commerceOrderLocalService.fetchCommerceOrderByUuidAndGroupId(commerceOrderUuid, commerceChannel.getGroupId())) != null) {
            _commerceOrderUuidThreadLocal.set(commerceOrder);
        }
        return commerceOrder;
    }

    private String _getLocalizedMessage(Locale locale, String key) {
        if (locale == null) {
            return key;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)key);
    }

    private PortletURL _getPortletURL(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        return this._getPortletURL(groupId, httpServletRequest, portletId);
    }

    private PortletURL _getPortletURL(long groupId, HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        LiferayPortletURL portletURL = null;
        long plid = this._portal.getPlidFromPortletId(groupId, portletId);
        portletURL = plid > 0L ? this._portletURLFactory.create(httpServletRequest, portletId, plid, "RENDER_PHASE") : this._portletURLFactory.create(httpServletRequest, portletId, "RENDER_PHASE");
        return portletURL;
    }

    private void _setGuestCommerceOrder(CommerceOrder commerceOrder, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        User user = this._portal.getUser(httpServletRequest);
        if (user != null && !user.isDefaultUser()) {
            return;
        }
        String commerceOrderUuidWebKey = this.getCookieName(commerceOrder.getGroupId());
        Cookie cookie = new Cookie(commerceOrderUuidWebKey, commerceOrder.getUuid());
        String domain = CookieKeys.getDomain((HttpServletRequest)httpServletRequest);
        if (Validator.isNotNull((String)domain)) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(31536000);
        cookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Cookie)cookie);
    }

    private void _validateCommerceOrderItemVersions(CommerceOrder commerceOrder, Locale locale) throws PortalException {
        VersionCommerceOrderValidatorImpl versionCommerceOrderValidatorImpl = new VersionCommerceOrderValidatorImpl();
        versionCommerceOrderValidatorImpl.setCommerceOrderItemLocalService(this._commerceOrderItemLocalService);
        versionCommerceOrderValidatorImpl.setCPInstanceLocalService(this._cpInstanceLocalService);
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            versionCommerceOrderValidatorImpl.validate(locale, commerceOrderItem);
        }
    }

    static {
        _commerceOrderUuidThreadLocal = new CentralizedThreadLocal(CommerceOrderHttpHelperImpl.class.getName());
    }
}

