/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search;

import com.liferay.commerce.model.CommerceCountry;
import com.liferay.commerce.service.CommerceCountryLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommerceCountryIndexer
extends BaseIndexer<CommerceCountry> {
    public static final String CLASS_NAME = CommerceCountry.class.getName();
    public static final String FIELD_ACTIVE = "active";
    public static final String FIELD_NUMERIC_ISO_CODE = "numericISOCode";
    public static final String FIELD_THREE_LETTERS_ISO_CODE = "threeLettersISOCode";
    public static final String FIELD_TWO_LETTERS_ISO_CODE = "twoLettersISOCode";
    private static final Log _log = LogFactoryUtil.getLog(CommerceCountryIndexer.class);
    @Reference
    private CommerceCountryLocalService _commerceCountryLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        Boolean active = (Boolean)searchContext.getAttribute(FIELD_ACTIVE);
        if (active != null) {
            contextBooleanFilter.addTerm(FIELD_ACTIVE, String.valueOf(active), BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "name", false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_NUMERIC_ISO_CODE, false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_THREE_LETTERS_ISO_CODE, false);
        this.addSearchTerm(searchQuery, searchContext, FIELD_TWO_LETTERS_ISO_CODE, false);
    }

    protected void doDelete(CommerceCountry commerceCountry) throws Exception {
        this.deleteDocument(commerceCountry.getCompanyId(), commerceCountry.getCommerceCountryId());
    }

    protected Document doGetDocument(CommerceCountry commerceCountry) throws Exception {
        String[] languageIds;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing commerce country " + commerceCountry));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceCountry);
        String commerceCountryDefaultLanguageId = commerceCountry.getDefaultLanguageId();
        for (String languageId : languageIds = commerceCountry.getAvailableLanguageIds()) {
            String name = commerceCountry.getName(languageId);
            if (languageId.equals(commerceCountryDefaultLanguageId)) {
                document.addText("name", name);
                document.addText("defaultLanguageId", languageId);
            }
            document.addKeyword(FIELD_ACTIVE, commerceCountry.isActive());
            document.addText(LocalizationUtil.getLocalizedName((String)"name", (String)languageId), name);
            document.addNumber(FIELD_NUMERIC_ISO_CODE, commerceCountry.getNumericISOCode());
            document.addNumberSortable("priority", Double.valueOf(commerceCountry.getPriority()));
            document.addText(FIELD_THREE_LETTERS_ISO_CODE, commerceCountry.getThreeLettersISOCode());
            document.addText(FIELD_TWO_LETTERS_ISO_CODE, commerceCountry.getTwoLettersISOCode());
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceCountry + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "entryClassPK", "name");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(CommerceCountry commerceCountry) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceCountry.getCompanyId(), this.getDocument(commerceCountry), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._commerceCountryLocalService.getCommerceCountry(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceCountries(companyId);
    }

    protected void reindexCommerceCountries(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceCountryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(commerceCountry -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(commerceCountry)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index commerce country " + commerceCountry.getCommerceCountryId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

