/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.price;

import com.liferay.commerce.currency.model.CommerceMoneyFactory;
import com.liferay.commerce.discount.CommerceDiscountCalculation;
import com.liferay.commerce.internal.price.CommerceOrderPriceCalculationImpl;
import com.liferay.commerce.internal.price.CommerceOrderPriceCalculationV2Impl;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.price.CommerceOrderPriceCalculationFactory;
import com.liferay.commerce.pricing.configuration.CommercePricingConfiguration;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.tax.CommerceTaxCalculation;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.pricing.configuration.CommercePricingConfiguration"}, immediate=true, service={CommerceOrderPriceCalculationFactory.class})
public class CommerceOrderPriceCalculationFactoryImpl
implements CommerceOrderPriceCalculationFactory {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference(target="(commerce.discount.calculation.key=v1.0)")
    private CommerceDiscountCalculation _commerceDiscountCalculation;
    @Reference(target="(commerce.discount.calculation.key=v2.0)")
    private CommerceDiscountCalculation _commerceDiscountCalculationV2;
    @Reference
    private CommerceMoneyFactory _commerceMoneyFactory;
    private volatile CommercePricingConfiguration _commercePricingConfiguration;
    @Reference
    private CommerceTaxCalculation _commerceTaxCalculation;

    public CommerceOrderPriceCalculation getCommerceOrderPriceCalculation() {
        if (this._commercePricingConfiguration == null || Objects.equals(this._commercePricingConfiguration.commercePricingCalculationKey(), "v2.0")) {
            return new CommerceOrderPriceCalculationV2Impl(this._commerceChannelLocalService, this._commerceDiscountCalculationV2, this._commerceMoneyFactory, this._commerceTaxCalculation);
        }
        return new CommerceOrderPriceCalculationImpl(this._commerceChannelLocalService, this._commerceDiscountCalculation, this._commerceMoneyFactory, this._commerceTaxCalculation);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._commercePricingConfiguration = (CommercePricingConfiguration)ConfigurableUtil.createConfigurable(CommercePricingConfiguration.class, properties);
    }
}

