/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderModel;
import com.liferay.commerce.model.CommerceOrderSoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.exportimport.kernel.lar.StagedModelType;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.math.BigDecimal;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceOrder service. Represents a row in the &quot;CommerceOrder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceOrderModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceOrderImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceOrderImpl
 * @see CommerceOrder
 * @see CommerceOrderModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceOrderModelImpl extends BaseModelImpl<CommerceOrder>
	implements CommerceOrderModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce order model instance should use the {@link CommerceOrder} interface instead.
	 */
	public static final String TABLE_NAME = "CommerceOrder";
	public static final Object[][] TABLE_COLUMNS = {
			{ "uuid_", Types.VARCHAR },
			{ "externalReferenceCode", Types.VARCHAR },
			{ "commerceOrderId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "siteGroupId", Types.BIGINT },
			{ "orderOrganizationId", Types.BIGINT },
			{ "orderUserId", Types.BIGINT },
			{ "commerceCurrencyId", Types.BIGINT },
			{ "billingAddressId", Types.BIGINT },
			{ "shippingAddressId", Types.BIGINT },
			{ "commercePaymentMethodId", Types.BIGINT },
			{ "commerceShippingMethodId", Types.BIGINT },
			{ "shippingOptionName", Types.VARCHAR },
			{ "purchaseOrderNumber", Types.VARCHAR },
			{ "subtotal", Types.DECIMAL },
			{ "subtotalDiscountAmount", Types.DECIMAL },
			{ "subtotalDiscountPercentLevel1", Types.DECIMAL },
			{ "subtotalDiscountPercentLevel2", Types.DECIMAL },
			{ "subtotalDiscountPercentLevel3", Types.DECIMAL },
			{ "subtotalDiscountPercentLevel4", Types.DECIMAL },
			{ "shippingAmount", Types.DECIMAL },
			{ "shippingDiscountAmount", Types.DECIMAL },
			{ "shippingDiscountPercentLevel1", Types.DECIMAL },
			{ "shippingDiscountPercentLevel2", Types.DECIMAL },
			{ "shippingDiscountPercentLevel3", Types.DECIMAL },
			{ "shippingDiscountPercentLevel4", Types.DECIMAL },
			{ "taxAmount", Types.DECIMAL },
			{ "total", Types.DECIMAL },
			{ "totalDiscountAmount", Types.DECIMAL },
			{ "totalDiscountPercentageLevel1", Types.DECIMAL },
			{ "totalDiscountPercentageLevel2", Types.DECIMAL },
			{ "totalDiscountPercentageLevel3", Types.DECIMAL },
			{ "totalDiscountPercentageLevel4", Types.DECIMAL },
			{ "advanceStatus", Types.VARCHAR },
			{ "paymentStatus", Types.INTEGER },
			{ "orderStatus", Types.INTEGER },
			{ "status", Types.INTEGER },
			{ "statusByUserId", Types.BIGINT },
			{ "statusByUserName", Types.VARCHAR },
			{ "statusDate", Types.TIMESTAMP }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("externalReferenceCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceOrderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("siteGroupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("orderOrganizationId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("orderUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceCurrencyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("billingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shippingAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commercePaymentMethodId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceShippingMethodId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shippingOptionName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("purchaseOrderNumber", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subtotal", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("subtotalDiscountPercentLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("shippingDiscountPercentLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("taxAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("total", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountAmount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel1", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel2", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel3", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("totalDiscountPercentageLevel4", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("advanceStatus", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("paymentStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("orderStatus", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE = "create table CommerceOrder (uuid_ VARCHAR(75) null,externalReferenceCode VARCHAR(75) null,commerceOrderId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,siteGroupId LONG,orderOrganizationId LONG,orderUserId LONG,commerceCurrencyId LONG,billingAddressId LONG,shippingAddressId LONG,commercePaymentMethodId LONG,commerceShippingMethodId LONG,shippingOptionName VARCHAR(255) null,purchaseOrderNumber VARCHAR(75) null,subtotal DECIMAL(30, 16) null,subtotalDiscountAmount DECIMAL(30, 16) null,subtotalDiscountPercentLevel1 DECIMAL(30, 16) null,subtotalDiscountPercentLevel2 DECIMAL(30, 16) null,subtotalDiscountPercentLevel3 DECIMAL(30, 16) null,subtotalDiscountPercentLevel4 DECIMAL(30, 16) null,shippingAmount DECIMAL(30, 16) null,shippingDiscountAmount DECIMAL(30, 16) null,shippingDiscountPercentLevel1 DECIMAL(30, 16) null,shippingDiscountPercentLevel2 DECIMAL(30, 16) null,shippingDiscountPercentLevel3 DECIMAL(30, 16) null,shippingDiscountPercentLevel4 DECIMAL(30, 16) null,taxAmount DECIMAL(30, 16) null,total DECIMAL(30, 16) null,totalDiscountAmount DECIMAL(30, 16) null,totalDiscountPercentageLevel1 DECIMAL(30, 16) null,totalDiscountPercentageLevel2 DECIMAL(30, 16) null,totalDiscountPercentageLevel3 DECIMAL(30, 16) null,totalDiscountPercentageLevel4 DECIMAL(30, 16) null,advanceStatus VARCHAR(75) null,paymentStatus INTEGER,orderStatus INTEGER,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";
	public static final String TABLE_SQL_DROP = "drop table CommerceOrder";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceOrder.createDate ASC";
	public static final String ORDER_BY_SQL = " ORDER BY CommerceOrder.createDate ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.model.CommerceOrder"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.model.CommerceOrder"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.model.CommerceOrder"),
			true);
	public static final long BILLINGADDRESSID_COLUMN_BITMASK = 1L;
	public static final long COMPANYID_COLUMN_BITMASK = 2L;
	public static final long CREATEDATE_COLUMN_BITMASK = 4L;
	public static final long EXTERNALREFERENCECODE_COLUMN_BITMASK = 8L;
	public static final long GROUPID_COLUMN_BITMASK = 16L;
	public static final long ORDERSTATUS_COLUMN_BITMASK = 32L;
	public static final long ORDERUSERID_COLUMN_BITMASK = 64L;
	public static final long SHIPPINGADDRESSID_COLUMN_BITMASK = 128L;
	public static final long USERID_COLUMN_BITMASK = 256L;
	public static final long UUID_COLUMN_BITMASK = 512L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceOrder toModel(CommerceOrderSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceOrder model = new CommerceOrderImpl();

		model.setUuid(soapModel.getUuid());
		model.setExternalReferenceCode(soapModel.getExternalReferenceCode());
		model.setCommerceOrderId(soapModel.getCommerceOrderId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setSiteGroupId(soapModel.getSiteGroupId());
		model.setOrderOrganizationId(soapModel.getOrderOrganizationId());
		model.setOrderUserId(soapModel.getOrderUserId());
		model.setCommerceCurrencyId(soapModel.getCommerceCurrencyId());
		model.setBillingAddressId(soapModel.getBillingAddressId());
		model.setShippingAddressId(soapModel.getShippingAddressId());
		model.setCommercePaymentMethodId(soapModel.getCommercePaymentMethodId());
		model.setCommerceShippingMethodId(soapModel.getCommerceShippingMethodId());
		model.setShippingOptionName(soapModel.getShippingOptionName());
		model.setPurchaseOrderNumber(soapModel.getPurchaseOrderNumber());
		model.setSubtotal(soapModel.getSubtotal());
		model.setSubtotalDiscountAmount(soapModel.getSubtotalDiscountAmount());
		model.setSubtotalDiscountPercentageLevel1(soapModel.getSubtotalDiscountPercentageLevel1());
		model.setSubtotalDiscountPercentageLevel2(soapModel.getSubtotalDiscountPercentageLevel2());
		model.setSubtotalDiscountPercentageLevel3(soapModel.getSubtotalDiscountPercentageLevel3());
		model.setSubtotalDiscountPercentageLevel4(soapModel.getSubtotalDiscountPercentageLevel4());
		model.setShippingAmount(soapModel.getShippingAmount());
		model.setShippingDiscountAmount(soapModel.getShippingDiscountAmount());
		model.setShippingDiscountPercentageLevel1(soapModel.getShippingDiscountPercentageLevel1());
		model.setShippingDiscountPercentageLevel2(soapModel.getShippingDiscountPercentageLevel2());
		model.setShippingDiscountPercentageLevel3(soapModel.getShippingDiscountPercentageLevel3());
		model.setShippingDiscountPercentageLevel4(soapModel.getShippingDiscountPercentageLevel4());
		model.setTaxAmount(soapModel.getTaxAmount());
		model.setTotal(soapModel.getTotal());
		model.setTotalDiscountAmount(soapModel.getTotalDiscountAmount());
		model.setTotalDiscountPercentageLevel1(soapModel.getTotalDiscountPercentageLevel1());
		model.setTotalDiscountPercentageLevel2(soapModel.getTotalDiscountPercentageLevel2());
		model.setTotalDiscountPercentageLevel3(soapModel.getTotalDiscountPercentageLevel3());
		model.setTotalDiscountPercentageLevel4(soapModel.getTotalDiscountPercentageLevel4());
		model.setAdvanceStatus(soapModel.getAdvanceStatus());
		model.setPaymentStatus(soapModel.getPaymentStatus());
		model.setOrderStatus(soapModel.getOrderStatus());
		model.setStatus(soapModel.getStatus());
		model.setStatusByUserId(soapModel.getStatusByUserId());
		model.setStatusByUserName(soapModel.getStatusByUserName());
		model.setStatusDate(soapModel.getStatusDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceOrder> toModels(CommerceOrderSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceOrder> models = new ArrayList<CommerceOrder>(soapModels.length);

		for (CommerceOrderSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.model.CommerceOrder"));

	public CommerceOrderModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceOrderId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceOrderId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceOrderId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceOrder.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceOrder.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("uuid", getUuid());
		attributes.put("externalReferenceCode", getExternalReferenceCode());
		attributes.put("commerceOrderId", getCommerceOrderId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("siteGroupId", getSiteGroupId());
		attributes.put("orderOrganizationId", getOrderOrganizationId());
		attributes.put("orderUserId", getOrderUserId());
		attributes.put("commerceCurrencyId", getCommerceCurrencyId());
		attributes.put("billingAddressId", getBillingAddressId());
		attributes.put("shippingAddressId", getShippingAddressId());
		attributes.put("commercePaymentMethodId", getCommercePaymentMethodId());
		attributes.put("commerceShippingMethodId", getCommerceShippingMethodId());
		attributes.put("shippingOptionName", getShippingOptionName());
		attributes.put("purchaseOrderNumber", getPurchaseOrderNumber());
		attributes.put("subtotal", getSubtotal());
		attributes.put("subtotalDiscountAmount", getSubtotalDiscountAmount());
		attributes.put("subtotalDiscountPercentageLevel1",
			getSubtotalDiscountPercentageLevel1());
		attributes.put("subtotalDiscountPercentageLevel2",
			getSubtotalDiscountPercentageLevel2());
		attributes.put("subtotalDiscountPercentageLevel3",
			getSubtotalDiscountPercentageLevel3());
		attributes.put("subtotalDiscountPercentageLevel4",
			getSubtotalDiscountPercentageLevel4());
		attributes.put("shippingAmount", getShippingAmount());
		attributes.put("shippingDiscountAmount", getShippingDiscountAmount());
		attributes.put("shippingDiscountPercentageLevel1",
			getShippingDiscountPercentageLevel1());
		attributes.put("shippingDiscountPercentageLevel2",
			getShippingDiscountPercentageLevel2());
		attributes.put("shippingDiscountPercentageLevel3",
			getShippingDiscountPercentageLevel3());
		attributes.put("shippingDiscountPercentageLevel4",
			getShippingDiscountPercentageLevel4());
		attributes.put("taxAmount", getTaxAmount());
		attributes.put("total", getTotal());
		attributes.put("totalDiscountAmount", getTotalDiscountAmount());
		attributes.put("totalDiscountPercentageLevel1",
			getTotalDiscountPercentageLevel1());
		attributes.put("totalDiscountPercentageLevel2",
			getTotalDiscountPercentageLevel2());
		attributes.put("totalDiscountPercentageLevel3",
			getTotalDiscountPercentageLevel3());
		attributes.put("totalDiscountPercentageLevel4",
			getTotalDiscountPercentageLevel4());
		attributes.put("advanceStatus", getAdvanceStatus());
		attributes.put("paymentStatus", getPaymentStatus());
		attributes.put("orderStatus", getOrderStatus());
		attributes.put("status", getStatus());
		attributes.put("statusByUserId", getStatusByUserId());
		attributes.put("statusByUserName", getStatusByUserName());
		attributes.put("statusDate", getStatusDate());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		String uuid = (String)attributes.get("uuid");

		if (uuid != null) {
			setUuid(uuid);
		}

		String externalReferenceCode = (String)attributes.get(
				"externalReferenceCode");

		if (externalReferenceCode != null) {
			setExternalReferenceCode(externalReferenceCode);
		}

		Long commerceOrderId = (Long)attributes.get("commerceOrderId");

		if (commerceOrderId != null) {
			setCommerceOrderId(commerceOrderId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long siteGroupId = (Long)attributes.get("siteGroupId");

		if (siteGroupId != null) {
			setSiteGroupId(siteGroupId);
		}

		Long orderOrganizationId = (Long)attributes.get("orderOrganizationId");

		if (orderOrganizationId != null) {
			setOrderOrganizationId(orderOrganizationId);
		}

		Long orderUserId = (Long)attributes.get("orderUserId");

		if (orderUserId != null) {
			setOrderUserId(orderUserId);
		}

		Long commerceCurrencyId = (Long)attributes.get("commerceCurrencyId");

		if (commerceCurrencyId != null) {
			setCommerceCurrencyId(commerceCurrencyId);
		}

		Long billingAddressId = (Long)attributes.get("billingAddressId");

		if (billingAddressId != null) {
			setBillingAddressId(billingAddressId);
		}

		Long shippingAddressId = (Long)attributes.get("shippingAddressId");

		if (shippingAddressId != null) {
			setShippingAddressId(shippingAddressId);
		}

		Long commercePaymentMethodId = (Long)attributes.get(
				"commercePaymentMethodId");

		if (commercePaymentMethodId != null) {
			setCommercePaymentMethodId(commercePaymentMethodId);
		}

		Long commerceShippingMethodId = (Long)attributes.get(
				"commerceShippingMethodId");

		if (commerceShippingMethodId != null) {
			setCommerceShippingMethodId(commerceShippingMethodId);
		}

		String shippingOptionName = (String)attributes.get("shippingOptionName");

		if (shippingOptionName != null) {
			setShippingOptionName(shippingOptionName);
		}

		String purchaseOrderNumber = (String)attributes.get(
				"purchaseOrderNumber");

		if (purchaseOrderNumber != null) {
			setPurchaseOrderNumber(purchaseOrderNumber);
		}

		BigDecimal subtotal = (BigDecimal)attributes.get("subtotal");

		if (subtotal != null) {
			setSubtotal(subtotal);
		}

		BigDecimal subtotalDiscountAmount = (BigDecimal)attributes.get(
				"subtotalDiscountAmount");

		if (subtotalDiscountAmount != null) {
			setSubtotalDiscountAmount(subtotalDiscountAmount);
		}

		BigDecimal subtotalDiscountPercentageLevel1 = (BigDecimal)attributes.get(
				"subtotalDiscountPercentageLevel1");

		if (subtotalDiscountPercentageLevel1 != null) {
			setSubtotalDiscountPercentageLevel1(subtotalDiscountPercentageLevel1);
		}

		BigDecimal subtotalDiscountPercentageLevel2 = (BigDecimal)attributes.get(
				"subtotalDiscountPercentageLevel2");

		if (subtotalDiscountPercentageLevel2 != null) {
			setSubtotalDiscountPercentageLevel2(subtotalDiscountPercentageLevel2);
		}

		BigDecimal subtotalDiscountPercentageLevel3 = (BigDecimal)attributes.get(
				"subtotalDiscountPercentageLevel3");

		if (subtotalDiscountPercentageLevel3 != null) {
			setSubtotalDiscountPercentageLevel3(subtotalDiscountPercentageLevel3);
		}

		BigDecimal subtotalDiscountPercentageLevel4 = (BigDecimal)attributes.get(
				"subtotalDiscountPercentageLevel4");

		if (subtotalDiscountPercentageLevel4 != null) {
			setSubtotalDiscountPercentageLevel4(subtotalDiscountPercentageLevel4);
		}

		BigDecimal shippingAmount = (BigDecimal)attributes.get("shippingAmount");

		if (shippingAmount != null) {
			setShippingAmount(shippingAmount);
		}

		BigDecimal shippingDiscountAmount = (BigDecimal)attributes.get(
				"shippingDiscountAmount");

		if (shippingDiscountAmount != null) {
			setShippingDiscountAmount(shippingDiscountAmount);
		}

		BigDecimal shippingDiscountPercentageLevel1 = (BigDecimal)attributes.get(
				"shippingDiscountPercentageLevel1");

		if (shippingDiscountPercentageLevel1 != null) {
			setShippingDiscountPercentageLevel1(shippingDiscountPercentageLevel1);
		}

		BigDecimal shippingDiscountPercentageLevel2 = (BigDecimal)attributes.get(
				"shippingDiscountPercentageLevel2");

		if (shippingDiscountPercentageLevel2 != null) {
			setShippingDiscountPercentageLevel2(shippingDiscountPercentageLevel2);
		}

		BigDecimal shippingDiscountPercentageLevel3 = (BigDecimal)attributes.get(
				"shippingDiscountPercentageLevel3");

		if (shippingDiscountPercentageLevel3 != null) {
			setShippingDiscountPercentageLevel3(shippingDiscountPercentageLevel3);
		}

		BigDecimal shippingDiscountPercentageLevel4 = (BigDecimal)attributes.get(
				"shippingDiscountPercentageLevel4");

		if (shippingDiscountPercentageLevel4 != null) {
			setShippingDiscountPercentageLevel4(shippingDiscountPercentageLevel4);
		}

		BigDecimal taxAmount = (BigDecimal)attributes.get("taxAmount");

		if (taxAmount != null) {
			setTaxAmount(taxAmount);
		}

		BigDecimal total = (BigDecimal)attributes.get("total");

		if (total != null) {
			setTotal(total);
		}

		BigDecimal totalDiscountAmount = (BigDecimal)attributes.get(
				"totalDiscountAmount");

		if (totalDiscountAmount != null) {
			setTotalDiscountAmount(totalDiscountAmount);
		}

		BigDecimal totalDiscountPercentageLevel1 = (BigDecimal)attributes.get(
				"totalDiscountPercentageLevel1");

		if (totalDiscountPercentageLevel1 != null) {
			setTotalDiscountPercentageLevel1(totalDiscountPercentageLevel1);
		}

		BigDecimal totalDiscountPercentageLevel2 = (BigDecimal)attributes.get(
				"totalDiscountPercentageLevel2");

		if (totalDiscountPercentageLevel2 != null) {
			setTotalDiscountPercentageLevel2(totalDiscountPercentageLevel2);
		}

		BigDecimal totalDiscountPercentageLevel3 = (BigDecimal)attributes.get(
				"totalDiscountPercentageLevel3");

		if (totalDiscountPercentageLevel3 != null) {
			setTotalDiscountPercentageLevel3(totalDiscountPercentageLevel3);
		}

		BigDecimal totalDiscountPercentageLevel4 = (BigDecimal)attributes.get(
				"totalDiscountPercentageLevel4");

		if (totalDiscountPercentageLevel4 != null) {
			setTotalDiscountPercentageLevel4(totalDiscountPercentageLevel4);
		}

		String advanceStatus = (String)attributes.get("advanceStatus");

		if (advanceStatus != null) {
			setAdvanceStatus(advanceStatus);
		}

		Integer paymentStatus = (Integer)attributes.get("paymentStatus");

		if (paymentStatus != null) {
			setPaymentStatus(paymentStatus);
		}

		Integer orderStatus = (Integer)attributes.get("orderStatus");

		if (orderStatus != null) {
			setOrderStatus(orderStatus);
		}

		Integer status = (Integer)attributes.get("status");

		if (status != null) {
			setStatus(status);
		}

		Long statusByUserId = (Long)attributes.get("statusByUserId");

		if (statusByUserId != null) {
			setStatusByUserId(statusByUserId);
		}

		String statusByUserName = (String)attributes.get("statusByUserName");

		if (statusByUserName != null) {
			setStatusByUserName(statusByUserName);
		}

		Date statusDate = (Date)attributes.get("statusDate");

		if (statusDate != null) {
			setStatusDate(statusDate);
		}
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public String getExternalReferenceCode() {
		if (_externalReferenceCode == null) {
			return "";
		}
		else {
			return _externalReferenceCode;
		}
	}

	@Override
	public void setExternalReferenceCode(String externalReferenceCode) {
		_columnBitmask |= EXTERNALREFERENCECODE_COLUMN_BITMASK;

		if (_originalExternalReferenceCode == null) {
			_originalExternalReferenceCode = _externalReferenceCode;
		}

		_externalReferenceCode = externalReferenceCode;
	}

	public String getOriginalExternalReferenceCode() {
		return GetterUtil.getString(_originalExternalReferenceCode);
	}

	@JSON
	@Override
	public long getCommerceOrderId() {
		return _commerceOrderId;
	}

	@Override
	public void setCommerceOrderId(long commerceOrderId) {
		_commerceOrderId = commerceOrderId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		if (_originalCreateDate == null) {
			_originalCreateDate = _createDate;
		}

		_createDate = createDate;
	}

	public Date getOriginalCreateDate() {
		return _originalCreateDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getSiteGroupId() {
		return _siteGroupId;
	}

	@Override
	public void setSiteGroupId(long siteGroupId) {
		_siteGroupId = siteGroupId;
	}

	@JSON
	@Override
	public long getOrderOrganizationId() {
		return _orderOrganizationId;
	}

	@Override
	public void setOrderOrganizationId(long orderOrganizationId) {
		_orderOrganizationId = orderOrganizationId;
	}

	@JSON
	@Override
	public long getOrderUserId() {
		return _orderUserId;
	}

	@Override
	public void setOrderUserId(long orderUserId) {
		_columnBitmask |= ORDERUSERID_COLUMN_BITMASK;

		if (!_setOriginalOrderUserId) {
			_setOriginalOrderUserId = true;

			_originalOrderUserId = _orderUserId;
		}

		_orderUserId = orderUserId;
	}

	@Override
	public String getOrderUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getOrderUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setOrderUserUuid(String orderUserUuid) {
	}

	public long getOriginalOrderUserId() {
		return _originalOrderUserId;
	}

	@JSON
	@Override
	public long getCommerceCurrencyId() {
		return _commerceCurrencyId;
	}

	@Override
	public void setCommerceCurrencyId(long commerceCurrencyId) {
		_commerceCurrencyId = commerceCurrencyId;
	}

	@JSON
	@Override
	public long getBillingAddressId() {
		return _billingAddressId;
	}

	@Override
	public void setBillingAddressId(long billingAddressId) {
		_columnBitmask |= BILLINGADDRESSID_COLUMN_BITMASK;

		if (!_setOriginalBillingAddressId) {
			_setOriginalBillingAddressId = true;

			_originalBillingAddressId = _billingAddressId;
		}

		_billingAddressId = billingAddressId;
	}

	public long getOriginalBillingAddressId() {
		return _originalBillingAddressId;
	}

	@JSON
	@Override
	public long getShippingAddressId() {
		return _shippingAddressId;
	}

	@Override
	public void setShippingAddressId(long shippingAddressId) {
		_columnBitmask |= SHIPPINGADDRESSID_COLUMN_BITMASK;

		if (!_setOriginalShippingAddressId) {
			_setOriginalShippingAddressId = true;

			_originalShippingAddressId = _shippingAddressId;
		}

		_shippingAddressId = shippingAddressId;
	}

	public long getOriginalShippingAddressId() {
		return _originalShippingAddressId;
	}

	@JSON
	@Override
	public long getCommercePaymentMethodId() {
		return _commercePaymentMethodId;
	}

	@Override
	public void setCommercePaymentMethodId(long commercePaymentMethodId) {
		_commercePaymentMethodId = commercePaymentMethodId;
	}

	@JSON
	@Override
	public long getCommerceShippingMethodId() {
		return _commerceShippingMethodId;
	}

	@Override
	public void setCommerceShippingMethodId(long commerceShippingMethodId) {
		_commerceShippingMethodId = commerceShippingMethodId;
	}

	@JSON
	@Override
	public String getShippingOptionName() {
		if (_shippingOptionName == null) {
			return "";
		}
		else {
			return _shippingOptionName;
		}
	}

	@Override
	public void setShippingOptionName(String shippingOptionName) {
		_shippingOptionName = shippingOptionName;
	}

	@JSON
	@Override
	public String getPurchaseOrderNumber() {
		if (_purchaseOrderNumber == null) {
			return "";
		}
		else {
			return _purchaseOrderNumber;
		}
	}

	@Override
	public void setPurchaseOrderNumber(String purchaseOrderNumber) {
		_purchaseOrderNumber = purchaseOrderNumber;
	}

	@JSON
	@Override
	public BigDecimal getSubtotal() {
		return _subtotal;
	}

	@Override
	public void setSubtotal(BigDecimal subtotal) {
		_subtotal = subtotal;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountAmount() {
		return _subtotalDiscountAmount;
	}

	@Override
	public void setSubtotalDiscountAmount(BigDecimal subtotalDiscountAmount) {
		_subtotalDiscountAmount = subtotalDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel1() {
		return _subtotalDiscountPercentageLevel1;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel1(
		BigDecimal subtotalDiscountPercentageLevel1) {
		_subtotalDiscountPercentageLevel1 = subtotalDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel2() {
		return _subtotalDiscountPercentageLevel2;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel2(
		BigDecimal subtotalDiscountPercentageLevel2) {
		_subtotalDiscountPercentageLevel2 = subtotalDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel3() {
		return _subtotalDiscountPercentageLevel3;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel3(
		BigDecimal subtotalDiscountPercentageLevel3) {
		_subtotalDiscountPercentageLevel3 = subtotalDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getSubtotalDiscountPercentageLevel4() {
		return _subtotalDiscountPercentageLevel4;
	}

	@Override
	public void setSubtotalDiscountPercentageLevel4(
		BigDecimal subtotalDiscountPercentageLevel4) {
		_subtotalDiscountPercentageLevel4 = subtotalDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getShippingAmount() {
		return _shippingAmount;
	}

	@Override
	public void setShippingAmount(BigDecimal shippingAmount) {
		_shippingAmount = shippingAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountAmount() {
		return _shippingDiscountAmount;
	}

	@Override
	public void setShippingDiscountAmount(BigDecimal shippingDiscountAmount) {
		_shippingDiscountAmount = shippingDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel1() {
		return _shippingDiscountPercentageLevel1;
	}

	@Override
	public void setShippingDiscountPercentageLevel1(
		BigDecimal shippingDiscountPercentageLevel1) {
		_shippingDiscountPercentageLevel1 = shippingDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel2() {
		return _shippingDiscountPercentageLevel2;
	}

	@Override
	public void setShippingDiscountPercentageLevel2(
		BigDecimal shippingDiscountPercentageLevel2) {
		_shippingDiscountPercentageLevel2 = shippingDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel3() {
		return _shippingDiscountPercentageLevel3;
	}

	@Override
	public void setShippingDiscountPercentageLevel3(
		BigDecimal shippingDiscountPercentageLevel3) {
		_shippingDiscountPercentageLevel3 = shippingDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getShippingDiscountPercentageLevel4() {
		return _shippingDiscountPercentageLevel4;
	}

	@Override
	public void setShippingDiscountPercentageLevel4(
		BigDecimal shippingDiscountPercentageLevel4) {
		_shippingDiscountPercentageLevel4 = shippingDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public BigDecimal getTaxAmount() {
		return _taxAmount;
	}

	@Override
	public void setTaxAmount(BigDecimal taxAmount) {
		_taxAmount = taxAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotal() {
		return _total;
	}

	@Override
	public void setTotal(BigDecimal total) {
		_total = total;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountAmount() {
		return _totalDiscountAmount;
	}

	@Override
	public void setTotalDiscountAmount(BigDecimal totalDiscountAmount) {
		_totalDiscountAmount = totalDiscountAmount;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel1() {
		return _totalDiscountPercentageLevel1;
	}

	@Override
	public void setTotalDiscountPercentageLevel1(
		BigDecimal totalDiscountPercentageLevel1) {
		_totalDiscountPercentageLevel1 = totalDiscountPercentageLevel1;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel2() {
		return _totalDiscountPercentageLevel2;
	}

	@Override
	public void setTotalDiscountPercentageLevel2(
		BigDecimal totalDiscountPercentageLevel2) {
		_totalDiscountPercentageLevel2 = totalDiscountPercentageLevel2;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel3() {
		return _totalDiscountPercentageLevel3;
	}

	@Override
	public void setTotalDiscountPercentageLevel3(
		BigDecimal totalDiscountPercentageLevel3) {
		_totalDiscountPercentageLevel3 = totalDiscountPercentageLevel3;
	}

	@JSON
	@Override
	public BigDecimal getTotalDiscountPercentageLevel4() {
		return _totalDiscountPercentageLevel4;
	}

	@Override
	public void setTotalDiscountPercentageLevel4(
		BigDecimal totalDiscountPercentageLevel4) {
		_totalDiscountPercentageLevel4 = totalDiscountPercentageLevel4;
	}

	@JSON
	@Override
	public String getAdvanceStatus() {
		if (_advanceStatus == null) {
			return "";
		}
		else {
			return _advanceStatus;
		}
	}

	@Override
	public void setAdvanceStatus(String advanceStatus) {
		_advanceStatus = advanceStatus;
	}

	@JSON
	@Override
	public int getPaymentStatus() {
		return _paymentStatus;
	}

	@Override
	public void setPaymentStatus(int paymentStatus) {
		_paymentStatus = paymentStatus;
	}

	@JSON
	@Override
	public int getOrderStatus() {
		return _orderStatus;
	}

	@Override
	public void setOrderStatus(int orderStatus) {
		_columnBitmask |= ORDERSTATUS_COLUMN_BITMASK;

		if (!_setOriginalOrderStatus) {
			_setOriginalOrderStatus = true;

			_originalOrderStatus = _orderStatus;
		}

		_orderStatus = orderStatus;
	}

	public int getOriginalOrderStatus() {
		return _originalOrderStatus;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_status = status;
	}

	@JSON
	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@JSON
	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		_statusByUserName = statusByUserName;
	}

	@JSON
	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(PortalUtil.getClassNameId(
				CommerceOrder.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceOrder.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceOrder toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceOrder)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceOrderImpl commerceOrderImpl = new CommerceOrderImpl();

		commerceOrderImpl.setUuid(getUuid());
		commerceOrderImpl.setExternalReferenceCode(getExternalReferenceCode());
		commerceOrderImpl.setCommerceOrderId(getCommerceOrderId());
		commerceOrderImpl.setGroupId(getGroupId());
		commerceOrderImpl.setCompanyId(getCompanyId());
		commerceOrderImpl.setUserId(getUserId());
		commerceOrderImpl.setUserName(getUserName());
		commerceOrderImpl.setCreateDate(getCreateDate());
		commerceOrderImpl.setModifiedDate(getModifiedDate());
		commerceOrderImpl.setSiteGroupId(getSiteGroupId());
		commerceOrderImpl.setOrderOrganizationId(getOrderOrganizationId());
		commerceOrderImpl.setOrderUserId(getOrderUserId());
		commerceOrderImpl.setCommerceCurrencyId(getCommerceCurrencyId());
		commerceOrderImpl.setBillingAddressId(getBillingAddressId());
		commerceOrderImpl.setShippingAddressId(getShippingAddressId());
		commerceOrderImpl.setCommercePaymentMethodId(getCommercePaymentMethodId());
		commerceOrderImpl.setCommerceShippingMethodId(getCommerceShippingMethodId());
		commerceOrderImpl.setShippingOptionName(getShippingOptionName());
		commerceOrderImpl.setPurchaseOrderNumber(getPurchaseOrderNumber());
		commerceOrderImpl.setSubtotal(getSubtotal());
		commerceOrderImpl.setSubtotalDiscountAmount(getSubtotalDiscountAmount());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel1(getSubtotalDiscountPercentageLevel1());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel2(getSubtotalDiscountPercentageLevel2());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel3(getSubtotalDiscountPercentageLevel3());
		commerceOrderImpl.setSubtotalDiscountPercentageLevel4(getSubtotalDiscountPercentageLevel4());
		commerceOrderImpl.setShippingAmount(getShippingAmount());
		commerceOrderImpl.setShippingDiscountAmount(getShippingDiscountAmount());
		commerceOrderImpl.setShippingDiscountPercentageLevel1(getShippingDiscountPercentageLevel1());
		commerceOrderImpl.setShippingDiscountPercentageLevel2(getShippingDiscountPercentageLevel2());
		commerceOrderImpl.setShippingDiscountPercentageLevel3(getShippingDiscountPercentageLevel3());
		commerceOrderImpl.setShippingDiscountPercentageLevel4(getShippingDiscountPercentageLevel4());
		commerceOrderImpl.setTaxAmount(getTaxAmount());
		commerceOrderImpl.setTotal(getTotal());
		commerceOrderImpl.setTotalDiscountAmount(getTotalDiscountAmount());
		commerceOrderImpl.setTotalDiscountPercentageLevel1(getTotalDiscountPercentageLevel1());
		commerceOrderImpl.setTotalDiscountPercentageLevel2(getTotalDiscountPercentageLevel2());
		commerceOrderImpl.setTotalDiscountPercentageLevel3(getTotalDiscountPercentageLevel3());
		commerceOrderImpl.setTotalDiscountPercentageLevel4(getTotalDiscountPercentageLevel4());
		commerceOrderImpl.setAdvanceStatus(getAdvanceStatus());
		commerceOrderImpl.setPaymentStatus(getPaymentStatus());
		commerceOrderImpl.setOrderStatus(getOrderStatus());
		commerceOrderImpl.setStatus(getStatus());
		commerceOrderImpl.setStatusByUserId(getStatusByUserId());
		commerceOrderImpl.setStatusByUserName(getStatusByUserName());
		commerceOrderImpl.setStatusDate(getStatusDate());

		commerceOrderImpl.resetOriginalValues();

		return commerceOrderImpl;
	}

	@Override
	public int compareTo(CommerceOrder commerceOrder) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(),
				commerceOrder.getCreateDate());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceOrder)) {
			return false;
		}

		CommerceOrder commerceOrder = (CommerceOrder)obj;

		long primaryKey = commerceOrder.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceOrderModelImpl commerceOrderModelImpl = this;

		commerceOrderModelImpl._originalUuid = commerceOrderModelImpl._uuid;

		commerceOrderModelImpl._originalExternalReferenceCode = commerceOrderModelImpl._externalReferenceCode;

		commerceOrderModelImpl._originalGroupId = commerceOrderModelImpl._groupId;

		commerceOrderModelImpl._setOriginalGroupId = false;

		commerceOrderModelImpl._originalCompanyId = commerceOrderModelImpl._companyId;

		commerceOrderModelImpl._setOriginalCompanyId = false;

		commerceOrderModelImpl._originalUserId = commerceOrderModelImpl._userId;

		commerceOrderModelImpl._setOriginalUserId = false;

		commerceOrderModelImpl._originalCreateDate = commerceOrderModelImpl._createDate;

		commerceOrderModelImpl._setModifiedDate = false;

		commerceOrderModelImpl._originalOrderUserId = commerceOrderModelImpl._orderUserId;

		commerceOrderModelImpl._setOriginalOrderUserId = false;

		commerceOrderModelImpl._originalBillingAddressId = commerceOrderModelImpl._billingAddressId;

		commerceOrderModelImpl._setOriginalBillingAddressId = false;

		commerceOrderModelImpl._originalShippingAddressId = commerceOrderModelImpl._shippingAddressId;

		commerceOrderModelImpl._setOriginalShippingAddressId = false;

		commerceOrderModelImpl._originalOrderStatus = commerceOrderModelImpl._orderStatus;

		commerceOrderModelImpl._setOriginalOrderStatus = false;

		commerceOrderModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceOrder> toCacheModel() {
		CommerceOrderCacheModel commerceOrderCacheModel = new CommerceOrderCacheModel();

		commerceOrderCacheModel.uuid = getUuid();

		String uuid = commerceOrderCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceOrderCacheModel.uuid = null;
		}

		commerceOrderCacheModel.externalReferenceCode = getExternalReferenceCode();

		String externalReferenceCode = commerceOrderCacheModel.externalReferenceCode;

		if ((externalReferenceCode != null) &&
				(externalReferenceCode.length() == 0)) {
			commerceOrderCacheModel.externalReferenceCode = null;
		}

		commerceOrderCacheModel.commerceOrderId = getCommerceOrderId();

		commerceOrderCacheModel.groupId = getGroupId();

		commerceOrderCacheModel.companyId = getCompanyId();

		commerceOrderCacheModel.userId = getUserId();

		commerceOrderCacheModel.userName = getUserName();

		String userName = commerceOrderCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceOrderCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceOrderCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceOrderCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceOrderCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceOrderCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceOrderCacheModel.siteGroupId = getSiteGroupId();

		commerceOrderCacheModel.orderOrganizationId = getOrderOrganizationId();

		commerceOrderCacheModel.orderUserId = getOrderUserId();

		commerceOrderCacheModel.commerceCurrencyId = getCommerceCurrencyId();

		commerceOrderCacheModel.billingAddressId = getBillingAddressId();

		commerceOrderCacheModel.shippingAddressId = getShippingAddressId();

		commerceOrderCacheModel.commercePaymentMethodId = getCommercePaymentMethodId();

		commerceOrderCacheModel.commerceShippingMethodId = getCommerceShippingMethodId();

		commerceOrderCacheModel.shippingOptionName = getShippingOptionName();

		String shippingOptionName = commerceOrderCacheModel.shippingOptionName;

		if ((shippingOptionName != null) && (shippingOptionName.length() == 0)) {
			commerceOrderCacheModel.shippingOptionName = null;
		}

		commerceOrderCacheModel.purchaseOrderNumber = getPurchaseOrderNumber();

		String purchaseOrderNumber = commerceOrderCacheModel.purchaseOrderNumber;

		if ((purchaseOrderNumber != null) &&
				(purchaseOrderNumber.length() == 0)) {
			commerceOrderCacheModel.purchaseOrderNumber = null;
		}

		commerceOrderCacheModel.subtotal = getSubtotal();

		commerceOrderCacheModel.subtotalDiscountAmount = getSubtotalDiscountAmount();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel1 = getSubtotalDiscountPercentageLevel1();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel2 = getSubtotalDiscountPercentageLevel2();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel3 = getSubtotalDiscountPercentageLevel3();

		commerceOrderCacheModel.subtotalDiscountPercentageLevel4 = getSubtotalDiscountPercentageLevel4();

		commerceOrderCacheModel.shippingAmount = getShippingAmount();

		commerceOrderCacheModel.shippingDiscountAmount = getShippingDiscountAmount();

		commerceOrderCacheModel.shippingDiscountPercentageLevel1 = getShippingDiscountPercentageLevel1();

		commerceOrderCacheModel.shippingDiscountPercentageLevel2 = getShippingDiscountPercentageLevel2();

		commerceOrderCacheModel.shippingDiscountPercentageLevel3 = getShippingDiscountPercentageLevel3();

		commerceOrderCacheModel.shippingDiscountPercentageLevel4 = getShippingDiscountPercentageLevel4();

		commerceOrderCacheModel.taxAmount = getTaxAmount();

		commerceOrderCacheModel.total = getTotal();

		commerceOrderCacheModel.totalDiscountAmount = getTotalDiscountAmount();

		commerceOrderCacheModel.totalDiscountPercentageLevel1 = getTotalDiscountPercentageLevel1();

		commerceOrderCacheModel.totalDiscountPercentageLevel2 = getTotalDiscountPercentageLevel2();

		commerceOrderCacheModel.totalDiscountPercentageLevel3 = getTotalDiscountPercentageLevel3();

		commerceOrderCacheModel.totalDiscountPercentageLevel4 = getTotalDiscountPercentageLevel4();

		commerceOrderCacheModel.advanceStatus = getAdvanceStatus();

		String advanceStatus = commerceOrderCacheModel.advanceStatus;

		if ((advanceStatus != null) && (advanceStatus.length() == 0)) {
			commerceOrderCacheModel.advanceStatus = null;
		}

		commerceOrderCacheModel.paymentStatus = getPaymentStatus();

		commerceOrderCacheModel.orderStatus = getOrderStatus();

		commerceOrderCacheModel.status = getStatus();

		commerceOrderCacheModel.statusByUserId = getStatusByUserId();

		commerceOrderCacheModel.statusByUserName = getStatusByUserName();

		String statusByUserName = commerceOrderCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			commerceOrderCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			commerceOrderCacheModel.statusDate = statusDate.getTime();
		}
		else {
			commerceOrderCacheModel.statusDate = Long.MIN_VALUE;
		}

		return commerceOrderCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(91);

		sb.append("{uuid=");
		sb.append(getUuid());
		sb.append(", externalReferenceCode=");
		sb.append(getExternalReferenceCode());
		sb.append(", commerceOrderId=");
		sb.append(getCommerceOrderId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", siteGroupId=");
		sb.append(getSiteGroupId());
		sb.append(", orderOrganizationId=");
		sb.append(getOrderOrganizationId());
		sb.append(", orderUserId=");
		sb.append(getOrderUserId());
		sb.append(", commerceCurrencyId=");
		sb.append(getCommerceCurrencyId());
		sb.append(", billingAddressId=");
		sb.append(getBillingAddressId());
		sb.append(", shippingAddressId=");
		sb.append(getShippingAddressId());
		sb.append(", commercePaymentMethodId=");
		sb.append(getCommercePaymentMethodId());
		sb.append(", commerceShippingMethodId=");
		sb.append(getCommerceShippingMethodId());
		sb.append(", shippingOptionName=");
		sb.append(getShippingOptionName());
		sb.append(", purchaseOrderNumber=");
		sb.append(getPurchaseOrderNumber());
		sb.append(", subtotal=");
		sb.append(getSubtotal());
		sb.append(", subtotalDiscountAmount=");
		sb.append(getSubtotalDiscountAmount());
		sb.append(", subtotalDiscountPercentageLevel1=");
		sb.append(getSubtotalDiscountPercentageLevel1());
		sb.append(", subtotalDiscountPercentageLevel2=");
		sb.append(getSubtotalDiscountPercentageLevel2());
		sb.append(", subtotalDiscountPercentageLevel3=");
		sb.append(getSubtotalDiscountPercentageLevel3());
		sb.append(", subtotalDiscountPercentageLevel4=");
		sb.append(getSubtotalDiscountPercentageLevel4());
		sb.append(", shippingAmount=");
		sb.append(getShippingAmount());
		sb.append(", shippingDiscountAmount=");
		sb.append(getShippingDiscountAmount());
		sb.append(", shippingDiscountPercentageLevel1=");
		sb.append(getShippingDiscountPercentageLevel1());
		sb.append(", shippingDiscountPercentageLevel2=");
		sb.append(getShippingDiscountPercentageLevel2());
		sb.append(", shippingDiscountPercentageLevel3=");
		sb.append(getShippingDiscountPercentageLevel3());
		sb.append(", shippingDiscountPercentageLevel4=");
		sb.append(getShippingDiscountPercentageLevel4());
		sb.append(", taxAmount=");
		sb.append(getTaxAmount());
		sb.append(", total=");
		sb.append(getTotal());
		sb.append(", totalDiscountAmount=");
		sb.append(getTotalDiscountAmount());
		sb.append(", totalDiscountPercentageLevel1=");
		sb.append(getTotalDiscountPercentageLevel1());
		sb.append(", totalDiscountPercentageLevel2=");
		sb.append(getTotalDiscountPercentageLevel2());
		sb.append(", totalDiscountPercentageLevel3=");
		sb.append(getTotalDiscountPercentageLevel3());
		sb.append(", totalDiscountPercentageLevel4=");
		sb.append(getTotalDiscountPercentageLevel4());
		sb.append(", advanceStatus=");
		sb.append(getAdvanceStatus());
		sb.append(", paymentStatus=");
		sb.append(getPaymentStatus());
		sb.append(", orderStatus=");
		sb.append(getOrderStatus());
		sb.append(", status=");
		sb.append(getStatus());
		sb.append(", statusByUserId=");
		sb.append(getStatusByUserId());
		sb.append(", statusByUserName=");
		sb.append(getStatusByUserName());
		sb.append(", statusDate=");
		sb.append(getStatusDate());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(139);

		sb.append("<model><model-name>");
		sb.append("com.liferay.commerce.model.CommerceOrder");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>uuid</column-name><column-value><![CDATA[");
		sb.append(getUuid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>externalReferenceCode</column-name><column-value><![CDATA[");
		sb.append(getExternalReferenceCode());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceOrderId</column-name><column-value><![CDATA[");
		sb.append(getCommerceOrderId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>siteGroupId</column-name><column-value><![CDATA[");
		sb.append(getSiteGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>orderOrganizationId</column-name><column-value><![CDATA[");
		sb.append(getOrderOrganizationId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>orderUserId</column-name><column-value><![CDATA[");
		sb.append(getOrderUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceCurrencyId</column-name><column-value><![CDATA[");
		sb.append(getCommerceCurrencyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingAddressId</column-name><column-value><![CDATA[");
		sb.append(getBillingAddressId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingAddressId</column-name><column-value><![CDATA[");
		sb.append(getShippingAddressId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commercePaymentMethodId</column-name><column-value><![CDATA[");
		sb.append(getCommercePaymentMethodId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceShippingMethodId</column-name><column-value><![CDATA[");
		sb.append(getCommerceShippingMethodId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingOptionName</column-name><column-value><![CDATA[");
		sb.append(getShippingOptionName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>purchaseOrderNumber</column-name><column-value><![CDATA[");
		sb.append(getPurchaseOrderNumber());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>subtotal</column-name><column-value><![CDATA[");
		sb.append(getSubtotal());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>subtotalDiscountAmount</column-name><column-value><![CDATA[");
		sb.append(getSubtotalDiscountAmount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>subtotalDiscountPercentageLevel1</column-name><column-value><![CDATA[");
		sb.append(getSubtotalDiscountPercentageLevel1());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>subtotalDiscountPercentageLevel2</column-name><column-value><![CDATA[");
		sb.append(getSubtotalDiscountPercentageLevel2());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>subtotalDiscountPercentageLevel3</column-name><column-value><![CDATA[");
		sb.append(getSubtotalDiscountPercentageLevel3());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>subtotalDiscountPercentageLevel4</column-name><column-value><![CDATA[");
		sb.append(getSubtotalDiscountPercentageLevel4());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingAmount</column-name><column-value><![CDATA[");
		sb.append(getShippingAmount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingDiscountAmount</column-name><column-value><![CDATA[");
		sb.append(getShippingDiscountAmount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingDiscountPercentageLevel1</column-name><column-value><![CDATA[");
		sb.append(getShippingDiscountPercentageLevel1());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingDiscountPercentageLevel2</column-name><column-value><![CDATA[");
		sb.append(getShippingDiscountPercentageLevel2());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingDiscountPercentageLevel3</column-name><column-value><![CDATA[");
		sb.append(getShippingDiscountPercentageLevel3());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingDiscountPercentageLevel4</column-name><column-value><![CDATA[");
		sb.append(getShippingDiscountPercentageLevel4());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>taxAmount</column-name><column-value><![CDATA[");
		sb.append(getTaxAmount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>total</column-name><column-value><![CDATA[");
		sb.append(getTotal());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>totalDiscountAmount</column-name><column-value><![CDATA[");
		sb.append(getTotalDiscountAmount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>totalDiscountPercentageLevel1</column-name><column-value><![CDATA[");
		sb.append(getTotalDiscountPercentageLevel1());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>totalDiscountPercentageLevel2</column-name><column-value><![CDATA[");
		sb.append(getTotalDiscountPercentageLevel2());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>totalDiscountPercentageLevel3</column-name><column-value><![CDATA[");
		sb.append(getTotalDiscountPercentageLevel3());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>totalDiscountPercentageLevel4</column-name><column-value><![CDATA[");
		sb.append(getTotalDiscountPercentageLevel4());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>advanceStatus</column-name><column-value><![CDATA[");
		sb.append(getAdvanceStatus());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>paymentStatus</column-name><column-value><![CDATA[");
		sb.append(getPaymentStatus());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>orderStatus</column-name><column-value><![CDATA[");
		sb.append(getOrderStatus());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>status</column-name><column-value><![CDATA[");
		sb.append(getStatus());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>statusByUserId</column-name><column-value><![CDATA[");
		sb.append(getStatusByUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>statusByUserName</column-name><column-value><![CDATA[");
		sb.append(getStatusByUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>statusDate</column-name><column-value><![CDATA[");
		sb.append(getStatusDate());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceOrder.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceOrder.class, ModelWrapper.class
		};
	private String _uuid;
	private String _originalUuid;
	private String _externalReferenceCode;
	private String _originalExternalReferenceCode;
	private long _commerceOrderId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private Date _originalCreateDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _siteGroupId;
	private long _orderOrganizationId;
	private long _orderUserId;
	private long _originalOrderUserId;
	private boolean _setOriginalOrderUserId;
	private long _commerceCurrencyId;
	private long _billingAddressId;
	private long _originalBillingAddressId;
	private boolean _setOriginalBillingAddressId;
	private long _shippingAddressId;
	private long _originalShippingAddressId;
	private boolean _setOriginalShippingAddressId;
	private long _commercePaymentMethodId;
	private long _commerceShippingMethodId;
	private String _shippingOptionName;
	private String _purchaseOrderNumber;
	private BigDecimal _subtotal;
	private BigDecimal _subtotalDiscountAmount;
	private BigDecimal _subtotalDiscountPercentageLevel1;
	private BigDecimal _subtotalDiscountPercentageLevel2;
	private BigDecimal _subtotalDiscountPercentageLevel3;
	private BigDecimal _subtotalDiscountPercentageLevel4;
	private BigDecimal _shippingAmount;
	private BigDecimal _shippingDiscountAmount;
	private BigDecimal _shippingDiscountPercentageLevel1;
	private BigDecimal _shippingDiscountPercentageLevel2;
	private BigDecimal _shippingDiscountPercentageLevel3;
	private BigDecimal _shippingDiscountPercentageLevel4;
	private BigDecimal _taxAmount;
	private BigDecimal _total;
	private BigDecimal _totalDiscountAmount;
	private BigDecimal _totalDiscountPercentageLevel1;
	private BigDecimal _totalDiscountPercentageLevel2;
	private BigDecimal _totalDiscountPercentageLevel3;
	private BigDecimal _totalDiscountPercentageLevel4;
	private String _advanceStatus;
	private int _paymentStatus;
	private int _orderStatus;
	private int _originalOrderStatus;
	private boolean _setOriginalOrderStatus;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;
	private long _columnBitmask;
	private CommerceOrder _escapedModel;
}