/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.commerce.exception.NoSuchShipmentException;
import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.impl.CommerceShipmentImpl;
import com.liferay.commerce.model.impl.CommerceShipmentModelImpl;
import com.liferay.commerce.service.persistence.CommerceShipmentPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class CommerceShipmentPersistenceImpl
extends BasePersistenceImpl<CommerceShipment>
implements CommerceShipmentPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceShipmentImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 9L);
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "commerceShipment.groupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_SITEGROUPID = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findBySiteGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SITEGROUPID = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findBySiteGroupId", new String[]{Long.class.getName()}, 10L);
    public static final FinderPath FINDER_PATH_COUNT_BY_SITEGROUPID = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySiteGroupId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_SITEGROUPID_SITEGROUPID_2 = "commerceShipment.siteGroupId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_G_S = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_S", new String[]{Long.class.getName(), Integer.class.getName()}, 13L);
    public static final FinderPath FINDER_PATH_COUNT_BY_G_S = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_S", new String[]{Long.class.getName(), Integer.class.getName()});
    private static final String _FINDER_COLUMN_G_S_GROUPID_2 = "commerceShipment.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_S_STATUS_2 = "commerceShipment.status = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_S_S = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByS_S", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, CommerceShipmentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByS_S", new String[]{Long.class.getName(), Integer.class.getName()}, 14L);
    public static final FinderPath FINDER_PATH_COUNT_BY_S_S = new FinderPath(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByS_S", new String[]{Long.class.getName(), Integer.class.getName()});
    private static final String _FINDER_COLUMN_S_S_SITEGROUPID_2 = "commerceShipment.siteGroupId = ? AND ";
    private static final String _FINDER_COLUMN_S_S_STATUS_2 = "commerceShipment.status = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCESHIPMENT = "SELECT commerceShipment FROM CommerceShipment commerceShipment";
    private static final String _SQL_SELECT_COMMERCESHIPMENT_WHERE_PKS_IN = "SELECT commerceShipment FROM CommerceShipment commerceShipment WHERE commerceShipmentId IN (";
    private static final String _SQL_SELECT_COMMERCESHIPMENT_WHERE = "SELECT commerceShipment FROM CommerceShipment commerceShipment WHERE ";
    private static final String _SQL_COUNT_COMMERCESHIPMENT = "SELECT COUNT(commerceShipment) FROM CommerceShipment commerceShipment";
    private static final String _SQL_COUNT_COMMERCESHIPMENT_WHERE = "SELECT COUNT(commerceShipment) FROM CommerceShipment commerceShipment WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceShipment.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceShipment exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceShipment exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceShipmentPersistenceImpl.class);

    public List<CommerceShipment> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    public List<CommerceShipment> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<CommerceShipment> findByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_GROUPID;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List<CommerceShipment> list = null;
        if (retrieveFromCache && (list = (List<CommerceShipment>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (groupId == commerceShipment.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByGroupId_First(long groupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByGroupId_First(groupId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchShipmentException(msg.toString());
    }

    public CommerceShipment fetchByGroupId_First(long groupId, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByGroupId_Last(long groupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchShipmentException(msg.toString());
    }

    public CommerceShipment fetchByGroupId_Last(long groupId, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByGroupId_PrevAndNext(long commerceShipmentId, long groupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByGroupId_PrevAndNext(session, commerceShipment, groupId, orderByComparator, true), commerceShipment, this.getByGroupId_PrevAndNext(session, commerceShipment, groupId, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByGroupId_PrevAndNext(Session session, CommerceShipment commerceShipment, long groupId, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public void removeByGroupId(long groupId) {
        for (CommerceShipment commerceShipment : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByGroupId(long groupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_GROUPID;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipment> findBySiteGroupId(long siteGroupId) {
        return this.findBySiteGroupId(siteGroupId, -1, -1, null);
    }

    public List<CommerceShipment> findBySiteGroupId(long siteGroupId, int start, int end) {
        return this.findBySiteGroupId(siteGroupId, start, end, null);
    }

    public List<CommerceShipment> findBySiteGroupId(long siteGroupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findBySiteGroupId(siteGroupId, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findBySiteGroupId(long siteGroupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SITEGROUPID;
            finderArgs = new Object[]{siteGroupId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_SITEGROUPID;
            finderArgs = new Object[]{siteGroupId, start, end, orderByComparator};
        }
        List<CommerceShipment> list = null;
        if (retrieveFromCache && (list = (List<CommerceShipment>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (siteGroupId == commerceShipment.getSiteGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            query.append(_FINDER_COLUMN_SITEGROUPID_SITEGROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(siteGroupId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findBySiteGroupId_First(long siteGroupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchBySiteGroupId_First(siteGroupId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("siteGroupId=");
        msg.append(siteGroupId);
        msg.append("}");
        throw new NoSuchShipmentException(msg.toString());
    }

    public CommerceShipment fetchBySiteGroupId_First(long siteGroupId, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findBySiteGroupId(siteGroupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findBySiteGroupId_Last(long siteGroupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchBySiteGroupId_Last(siteGroupId, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("siteGroupId=");
        msg.append(siteGroupId);
        msg.append("}");
        throw new NoSuchShipmentException(msg.toString());
    }

    public CommerceShipment fetchBySiteGroupId_Last(long siteGroupId, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countBySiteGroupId(siteGroupId);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findBySiteGroupId(siteGroupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findBySiteGroupId_PrevAndNext(long commerceShipmentId, long siteGroupId, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getBySiteGroupId_PrevAndNext(session, commerceShipment, siteGroupId, orderByComparator, true), commerceShipment, this.getBySiteGroupId_PrevAndNext(session, commerceShipment, siteGroupId, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getBySiteGroupId_PrevAndNext(Session session, CommerceShipment commerceShipment, long siteGroupId, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        query.append(_FINDER_COLUMN_SITEGROUPID_SITEGROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(siteGroupId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public void removeBySiteGroupId(long siteGroupId) {
        for (CommerceShipment commerceShipment : this.findBySiteGroupId(siteGroupId, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countBySiteGroupId(long siteGroupId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_SITEGROUPID;
        Object[] finderArgs = new Object[]{siteGroupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            query.append(_FINDER_COLUMN_SITEGROUPID_SITEGROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(siteGroupId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipment> findByG_S(long groupId, int status) {
        return this.findByG_S(groupId, status, -1, -1, null);
    }

    public List<CommerceShipment> findByG_S(long groupId, int status, int start, int end) {
        return this.findByG_S(groupId, status, start, end, null);
    }

    public List<CommerceShipment> findByG_S(long groupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByG_S(groupId, status, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByG_S(long groupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S;
            finderArgs = new Object[]{groupId, status};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_G_S;
            finderArgs = new Object[]{groupId, status, start, end, orderByComparator};
        }
        List<CommerceShipment> list = null;
        if (retrieveFromCache && (list = (List<CommerceShipment>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (groupId == commerceShipment.getGroupId() && status == commerceShipment.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            query.append(_FINDER_COLUMN_G_S_GROUPID_2);
            query.append("commerceShipment.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByG_S_First(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_S_First(groupId, status, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchShipmentException(msg.toString());
    }

    public CommerceShipment fetchByG_S_First(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByG_S(groupId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByG_S_Last(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByG_S_Last(groupId, status, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchShipmentException(msg.toString());
    }

    public CommerceShipment fetchByG_S_Last(long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByG_S(groupId, status);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByG_S(groupId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByG_S_PrevAndNext(long commerceShipmentId, long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByG_S_PrevAndNext(session, commerceShipment, groupId, status, orderByComparator, true), commerceShipment, this.getByG_S_PrevAndNext(session, commerceShipment, groupId, status, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByG_S_PrevAndNext(Session session, CommerceShipment commerceShipment, long groupId, int status, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        query.append(_FINDER_COLUMN_G_S_GROUPID_2);
        query.append("commerceShipment.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(groupId);
        qPos.add(status);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public void removeByG_S(long groupId, int status) {
        for (CommerceShipment commerceShipment : this.findByG_S(groupId, status, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByG_S(long groupId, int status) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_G_S;
        Object[] finderArgs = new Object[]{groupId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            query.append(_FINDER_COLUMN_G_S_GROUPID_2);
            query.append("commerceShipment.status = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(status);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceShipment> findByS_S(long siteGroupId, int status) {
        return this.findByS_S(siteGroupId, status, -1, -1, null);
    }

    public List<CommerceShipment> findByS_S(long siteGroupId, int status, int start, int end) {
        return this.findByS_S(siteGroupId, status, start, end, null);
    }

    public List<CommerceShipment> findByS_S(long siteGroupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findByS_S(siteGroupId, status, start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findByS_S(long siteGroupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S;
            finderArgs = new Object[]{siteGroupId, status};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_S_S;
            finderArgs = new Object[]{siteGroupId, status, start, end, orderByComparator};
        }
        List<CommerceShipment> list = null;
        if (retrieveFromCache && (list = (List<CommerceShipment>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceShipment commerceShipment : list) {
                if (siteGroupId == commerceShipment.getSiteGroupId() && status == commerceShipment.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            query.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
            query.append(_FINDER_COLUMN_S_S_SITEGROUPID_2);
            query.append("commerceShipment.status = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY commerceShipment.createDate DESC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(siteGroupId);
                qPos.add(status);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceShipment findByS_S_First(long siteGroupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByS_S_First(siteGroupId, status, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("siteGroupId=");
        msg.append(siteGroupId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchShipmentException(msg.toString());
    }

    public CommerceShipment fetchByS_S_First(long siteGroupId, int status, OrderByComparator<CommerceShipment> orderByComparator) {
        List<CommerceShipment> list = this.findByS_S(siteGroupId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment findByS_S_Last(long siteGroupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByS_S_Last(siteGroupId, status, orderByComparator);
        if (commerceShipment != null) {
            return commerceShipment;
        }
        StringBundler msg = new StringBundler(6);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("siteGroupId=");
        msg.append(siteGroupId);
        msg.append(", status=");
        msg.append(status);
        msg.append("}");
        throw new NoSuchShipmentException(msg.toString());
    }

    public CommerceShipment fetchByS_S_Last(long siteGroupId, int status, OrderByComparator<CommerceShipment> orderByComparator) {
        int count = this.countByS_S(siteGroupId, status);
        if (count == 0) {
            return null;
        }
        List<CommerceShipment> list = this.findByS_S(siteGroupId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceShipment[] findByS_S_PrevAndNext(long commerceShipmentId, long siteGroupId, int status, OrderByComparator<CommerceShipment> orderByComparator) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.findByPrimaryKey(commerceShipmentId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment[] array = new CommerceShipmentImpl[]{this.getByS_S_PrevAndNext(session, commerceShipment, siteGroupId, status, orderByComparator, true), commerceShipment, this.getByS_S_PrevAndNext(session, commerceShipment, siteGroupId, status, orderByComparator, false)};
            CommerceShipment[] commerceShipmentArray = array;
            return commerceShipmentArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment getByS_S_PrevAndNext(Session session, CommerceShipment commerceShipment, long siteGroupId, int status, OrderByComparator<CommerceShipment> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        query.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE);
        query.append(_FINDER_COLUMN_S_S_SITEGROUPID_2);
        query.append("commerceShipment.status = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceShipment.createDate DESC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(siteGroupId);
        qPos.add(status);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)commerceShipment)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceShipment)list.get(1);
        }
        return null;
    }

    public void removeByS_S(long siteGroupId, int status) {
        for (CommerceShipment commerceShipment : this.findByS_S(siteGroupId, status, -1, -1, null)) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countByS_S(long siteGroupId, int status) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_S_S;
        Object[] finderArgs = new Object[]{siteGroupId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_COMMERCESHIPMENT_WHERE);
            query.append(_FINDER_COLUMN_S_S_SITEGROUPID_2);
            query.append("commerceShipment.status = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(siteGroupId);
                qPos.add(status);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceShipmentPersistenceImpl() {
        this.setModelClass(CommerceShipment.class);
    }

    public void cacheResult(CommerceShipment commerceShipment) {
        this.entityCache.putResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, (Serializable)Long.valueOf(commerceShipment.getPrimaryKey()), (Serializable)commerceShipment);
        commerceShipment.resetOriginalValues();
    }

    public void cacheResult(List<CommerceShipment> commerceShipments) {
        for (CommerceShipment commerceShipment : commerceShipments) {
            if (this.entityCache.getResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, (Serializable)Long.valueOf(commerceShipment.getPrimaryKey())) == null) {
                this.cacheResult(commerceShipment);
                continue;
            }
            commerceShipment.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceShipmentImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceShipment commerceShipment) {
        this.entityCache.removeResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, (Serializable)Long.valueOf(commerceShipment.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(List<CommerceShipment> commerceShipments) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (CommerceShipment commerceShipment : commerceShipments) {
            this.entityCache.removeResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, (Serializable)Long.valueOf(commerceShipment.getPrimaryKey()));
        }
    }

    public CommerceShipment create(long commerceShipmentId) {
        CommerceShipmentImpl commerceShipment = new CommerceShipmentImpl();
        commerceShipment.setNew(true);
        commerceShipment.setPrimaryKey(commerceShipmentId);
        commerceShipment.setCompanyId(this.companyProvider.getCompanyId());
        return commerceShipment;
    }

    public CommerceShipment remove(long commerceShipmentId) throws NoSuchShipmentException {
        return this.remove(Long.valueOf(commerceShipmentId));
    }

    public CommerceShipment remove(Serializable primaryKey) throws NoSuchShipmentException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceShipment commerceShipment = (CommerceShipment)session.get(CommerceShipmentImpl.class, primaryKey);
            if (commerceShipment == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchShipmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceShipment commerceShipment2 = (CommerceShipment)this.remove((BaseModel)commerceShipment);
            return commerceShipment2;
        }
        catch (NoSuchShipmentException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceShipment removeImpl(CommerceShipment commerceShipment) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceShipment)) {
                commerceShipment = (CommerceShipment)session.get(CommerceShipmentImpl.class, commerceShipment.getPrimaryKeyObj());
            }
            if (commerceShipment != null) {
                session.delete((Object)commerceShipment);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceShipment != null) {
            this.clearCache(commerceShipment);
        }
        return commerceShipment;
    }

    public CommerceShipment updateImpl(CommerceShipment commerceShipment) {
        boolean isNew = commerceShipment.isNew();
        if (!(commerceShipment instanceof CommerceShipmentModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceShipment.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceShipment);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceShipment proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceShipment implementation " + commerceShipment.getClass());
        }
        CommerceShipmentModelImpl commerceShipmentModelImpl = (CommerceShipmentModelImpl)commerceShipment;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && commerceShipment.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceShipment.setCreateDate(now);
            } else {
                commerceShipment.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!commerceShipmentModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceShipment.setModifiedDate(now);
            } else {
                commerceShipment.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (commerceShipment.isNew()) {
                session.save((Object)commerceShipment);
                commerceShipment.setNew(false);
            } else {
                commerceShipment = (CommerceShipment)session.merge((Object)commerceShipment);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CommerceShipmentModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{commerceShipmentModelImpl.getGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
            args = new Object[]{commerceShipmentModelImpl.getSiteGroupId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_SITEGROUPID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SITEGROUPID, args);
            args = new Object[]{commerceShipmentModelImpl.getGroupId(), commerceShipmentModelImpl.getStatus()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_S, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S, args);
            args = new Object[]{commerceShipmentModelImpl.getSiteGroupId(), commerceShipmentModelImpl.getStatus()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_S_S, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((commerceShipmentModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentModelImpl.getOriginalGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
                args = new Object[]{commerceShipmentModelImpl.getGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_GROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_GROUPID, args);
            }
            if ((commerceShipmentModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SITEGROUPID.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentModelImpl.getOriginalSiteGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_SITEGROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SITEGROUPID, args);
                args = new Object[]{commerceShipmentModelImpl.getSiteGroupId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_SITEGROUPID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SITEGROUPID, args);
            }
            if ((commerceShipmentModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentModelImpl.getOriginalGroupId(), commerceShipmentModelImpl.getOriginalStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S, args);
                args = new Object[]{commerceShipmentModelImpl.getGroupId(), commerceShipmentModelImpl.getStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_G_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_G_S, args);
            }
            if ((commerceShipmentModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceShipmentModelImpl.getOriginalSiteGroupId(), commerceShipmentModelImpl.getOriginalStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_S_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S, args);
                args = new Object[]{commerceShipmentModelImpl.getSiteGroupId(), commerceShipmentModelImpl.getStatus()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_S_S, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_S_S, args);
            }
        }
        this.entityCache.putResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, (Serializable)Long.valueOf(commerceShipment.getPrimaryKey()), (Serializable)commerceShipment, false);
        commerceShipment.resetOriginalValues();
        return commerceShipment;
    }

    public CommerceShipment findByPrimaryKey(Serializable primaryKey) throws NoSuchShipmentException {
        CommerceShipment commerceShipment = this.fetchByPrimaryKey(primaryKey);
        if (commerceShipment == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchShipmentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceShipment;
    }

    public CommerceShipment findByPrimaryKey(long commerceShipmentId) throws NoSuchShipmentException {
        return this.findByPrimaryKey(Long.valueOf(commerceShipmentId));
    }

    public CommerceShipment fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        CommerceShipment commerceShipment = (CommerceShipment)serializable;
        if (commerceShipment == null) {
            Session session = null;
            try {
                session = this.openSession();
                commerceShipment = (CommerceShipment)session.get(CommerceShipmentImpl.class, primaryKey);
                if (commerceShipment != null) {
                    this.cacheResult(commerceShipment);
                } else {
                    this.entityCache.putResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return commerceShipment;
    }

    public CommerceShipment fetchByPrimaryKey(long commerceShipmentId) {
        return this.fetchByPrimaryKey(Long.valueOf(commerceShipmentId));
    }

    public Map<Serializable, CommerceShipment> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, CommerceShipment> map = new HashMap<Serializable, CommerceShipment>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            CommerceShipment commerceShipment = this.fetchByPrimaryKey(primaryKey);
            if (commerceShipment != null) {
                map.put(primaryKey, commerceShipment);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (CommerceShipment)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_COMMERCESHIPMENT_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (CommerceShipment commerceShipment : q.list()) {
                map.put(commerceShipment.getPrimaryKeyObj(), commerceShipment);
                this.cacheResult(commerceShipment);
                uncachedPrimaryKeys.remove(commerceShipment.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(CommerceShipmentModelImpl.ENTITY_CACHE_ENABLED, CommerceShipmentImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<CommerceShipment> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceShipment> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceShipment> findAll(int start, int end, OrderByComparator<CommerceShipment> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceShipment> findAll(int start, int end, OrderByComparator<CommerceShipment> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_COMMERCESHIPMENT);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COMMERCESHIPMENT;
                if (pagination) {
                    sql = sql.concat(" ORDER BY commerceShipment.createDate DESC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceShipment commerceShipment : this.findAll()) {
            this.remove((BaseModel)commerceShipment);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COMMERCESHIPMENT);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceShipmentModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceShipmentImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

