/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.service.base.CommerceShipmentServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceShipmentServiceImpl
extends CommerceShipmentServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(CommerceShipmentServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.commerce");

    public CommerceShipment addCommerceShipment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.addCommerceShipment(commerceOrderId, serviceContext);
    }

    public void deleteCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipment.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        this.commerceShipmentLocalService.deleteCommerceShipment(commerceShipment);
    }

    public CommerceShipment getCommerceShipment(long commerceShipmentId) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipment.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipment(commerceShipmentId);
    }

    public List<CommerceShipment> getCommerceShipmentsByG_S(long groupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsByG_S(groupId, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipmentsByGroupId(long groupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipmentsByS_S(long siteGroupId, int status, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), siteGroupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsByS_S(siteGroupId, status, start, end, orderByComparator);
    }

    public List<CommerceShipment> getCommerceShipmentsBySiteGroupId(long siteGroupId, int start, int end, OrderByComparator<CommerceShipment> orderByComparator) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), siteGroupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsBySiteGroupId(siteGroupId, start, end, orderByComparator);
    }

    public int getCommerceShipmentsCountByG_S(long groupId, int status) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsCountByG_S(groupId, status);
    }

    public int getCommerceShipmentsCountByGroupId(long groupId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), groupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsCountByGroupId(groupId);
    }

    public int getCommerceShipmentsCountByS_S(long siteGroupId, int status) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), siteGroupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsCountByS_S(siteGroupId, status);
    }

    public int getCommerceShipmentsCountBySiteGroupId(long siteGroupId) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), siteGroupId, "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.getCommerceShipmentsCountBySiteGroupId(siteGroupId);
    }

    public CommerceShipment updateCommerceShipment(long commerceShipmentId, String carrier, String trackingNumber, int status, int shippingDateMonth, int shippingDateDay, int shippingDateYear, int shippingDateHour, int shippingDateMinute, int expectedDateMonth, int expectedDateDay, int expectedDateYear, int expectedDateHour, int expectedDateMinute) throws PortalException {
        CommerceShipment commerceShipment = this.commerceShipmentPersistence.findByPrimaryKey(commerceShipmentId);
        _portletResourcePermission.check(this.getPermissionChecker(), commerceShipment.getGroupId(), "MANAGE_COMMERCE_SHIPMENTS");
        return this.commerceShipmentLocalService.updateCommerceShipment(commerceShipmentId, carrier, trackingNumber, status, shippingDateMonth, shippingDateDay, shippingDateYear, shippingDateHour, shippingDateMinute, expectedDateMonth, expectedDateDay, expectedDateYear, expectedDateHour, expectedDateMinute);
    }
}

