/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderPayment;
import com.liferay.commerce.service.base.CommerceOrderPaymentLocalServiceBaseImpl;
import com.liferay.commerce.util.comparator.CommerceOrderPaymentCreateDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;

public class CommerceOrderPaymentLocalServiceImpl
extends CommerceOrderPaymentLocalServiceBaseImpl {
    public CommerceOrderPayment addCommerceOrderPayment(long commerceOrderId, int status, String content, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long commerceOrderPaymentId = this.counterLocalService.increment();
        CommerceOrderPayment commerceOrderPayment = this.commerceOrderPaymentPersistence.create(commerceOrderPaymentId);
        commerceOrderPayment.setGroupId(commerceOrder.getGroupId());
        commerceOrderPayment.setCompanyId(user.getCompanyId());
        commerceOrderPayment.setUserId(user.getUserId());
        commerceOrderPayment.setUserName(user.getFullName());
        commerceOrderPayment.setCommerceOrderId(commerceOrder.getCommerceOrderId());
        commerceOrderPayment.setCommercePaymentMethodId(commerceOrder.getCommercePaymentMethodId());
        commerceOrderPayment.setStatus(status);
        commerceOrderPayment.setContent(content);
        this.commerceOrderPaymentPersistence.update((BaseModel)commerceOrderPayment);
        return commerceOrderPayment;
    }

    public void deleteCommerceOrderPayments(long commerceOrderId) {
        this.commerceOrderPaymentPersistence.removeByCommerceOrderId(commerceOrderId);
    }

    public CommerceOrderPayment fetchLatestCommerceOrderPayment(long commerceOrderId) throws PortalException {
        return this.commerceOrderPaymentPersistence.fetchByCommerceOrderId_First(commerceOrderId, (OrderByComparator)new CommerceOrderPaymentCreateDateComparator());
    }
}

