/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.CommerceOrderHttpHelper;
import com.liferay.commerce.organization.service.CommerceOrganizationLocalService;
import com.liferay.commerce.organization.util.CommerceOrganizationHelper;
import com.liferay.commerce.service.CommerceOrderItemService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SessionParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletURL;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class CommerceOrderHttpHelperImpl
implements CommerceOrderHttpHelper {
    private static ModelResourcePermission<CommerceOrder> _commerceOrderModelResourcePermission;
    private static final ThreadLocal<CommerceOrder> _commerceOrderUuidThreadLocal;
    @Reference
    private CommerceOrderItemService _commerceOrderItemService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommerceOrganizationHelper _commerceOrganizationHelper;
    @Reference
    private CommerceOrganizationLocalService _commerceOrganizationLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletURLFactory _portletURLFactory;

    public CommerceOrder addCommerceOrder(HttpServletRequest httpServletRequest) throws PortalException {
        Organization organization;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        CommerceContext commerceContext = this._getCommerceContext(httpServletRequest);
        CommerceOrder commerceOrder = null;
        long commerceCurrencyId = 0L;
        CommerceCurrency commerceCurrency = commerceContext.getCommerceCurrency();
        if (commerceCurrency != null) {
            commerceCurrencyId = commerceCurrency.getCommerceCurrencyId();
        }
        commerceOrder = (organization = this._commerceOrganizationHelper.getCurrentOrganization(httpServletRequest)) != null ? this._commerceOrderService.addOrganizationCommerceOrder(organization.getGroupId(), themeDisplay.getSiteGroupId(), organization.getOrganizationId(), commerceCurrencyId, 0L, null) : this._commerceOrderLocalService.addUserCommerceOrder(themeDisplay.getScopeGroupId(), themeDisplay.getUserId(), themeDisplay.getUserId(), commerceCurrencyId);
        this.setCurrentCommerceOrder(httpServletRequest, commerceOrder);
        return commerceOrder;
    }

    public PortletURL getCommerceCartPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        return this.getCommerceCartPortletURL(httpServletRequest, commerceOrder);
    }

    public PortletURL getCommerceCartPortletURL(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        long plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet");
        if (plid > 0L) {
            return this._getPortletURL(httpServletRequest, "com_liferay_commerce_cart_content_web_internal_portlet_CommerceCartContentPortlet");
        }
        plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet");
        if (plid > 0L) {
            PortletURL portletURL = this._getPortletURL(httpServletRequest, "com_liferay_commerce_order_content_web_internal_portlet_CommerceOrderContentPortlet");
            if (commerceOrder != null) {
                portletURL.setParameter("mvcRenderCommandName", "viewCommerceOrderItems");
                portletURL.setParameter("commerceOrderId", String.valueOf(commerceOrder.getCommerceOrderId()));
            }
            return portletURL;
        }
        plid = this._portal.getPlidFromPortletId(groupId, "com_liferay_commerce_organization_order_web_internal_portlet_CommerceOrganizationOrderPortlet");
        if (plid > 0L) {
            PortletURL portletURL = this._getPortletURL(httpServletRequest, "com_liferay_commerce_organization_order_web_internal_portlet_CommerceOrganizationOrderPortlet");
            if (commerceOrder != null) {
                portletURL.setParameter("mvcRenderCommandName", "editCommerceOrder");
                portletURL.setParameter("commerceOrderId", String.valueOf(commerceOrder.getCommerceOrderId()));
            }
            return portletURL;
        }
        return null;
    }

    public PortletURL getCommerceCheckoutPortletURL(HttpServletRequest httpServletRequest) throws PortalException {
        return this._getPortletURL(httpServletRequest, "com_liferay_commerce_checkout_web_internal_portlet_CommerceCheckoutPortlet");
    }

    public int getCommerceOrderItemsQuantity(HttpServletRequest httpServletRequest) throws PortalException {
        CommerceOrder commerceOrder = this.getCurrentCommerceOrder(httpServletRequest);
        if (commerceOrder == null) {
            return 0;
        }
        return this._commerceOrderItemService.getCommerceOrderItemsQuantity(commerceOrder.getCommerceOrderId());
    }

    public CommerceOrder getCurrentCommerceOrder(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        CommerceOrder commerceOrder = null;
        Organization organization = this._commerceOrganizationHelper.getCurrentOrganization(httpServletRequest);
        commerceOrder = organization != null ? this._getOrganizationCurrentCommerceOrder(themeDisplay, organization) : this._getUserCurrentCommerceOrder(themeDisplay);
        if (commerceOrder != null && !commerceOrder.isOpen() || commerceOrder != null && !_commerceOrderModelResourcePermission.contains(themeDisplay.getPermissionChecker(), (ClassedModel)commerceOrder, "UPDATE")) {
            return null;
        }
        return this._checkGuestOrder(themeDisplay, commerceOrder);
    }

    public void setCurrentCommerceOrder(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        commerceOrder = this._commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), this._getCommerceContext(httpServletRequest));
        if (!themeDisplay.isSignedIn()) {
            this._setGuestCommerceOrder(themeDisplay, commerceOrder);
            return;
        }
        httpServletRequest = this._portal.getOriginalServletRequest(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession();
        httpSession.setAttribute(this._getCookieName(commerceOrder.getGroupId()), (Object)commerceOrder.getUuid());
    }

    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)", unbind="-")
    protected void setModelResourcePermission(ModelResourcePermission<CommerceOrder> modelResourcePermission) {
        _commerceOrderModelResourcePermission = modelResourcePermission;
    }

    private CommerceOrder _checkGuestOrder(ThemeDisplay themeDisplay, CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder == null) {
            return null;
        }
        User user = themeDisplay.getUser();
        if (user == null || user.isDefaultUser()) {
            return commerceOrder;
        }
        long groupId = themeDisplay.getScopeGroupId();
        String domain = CookieKeys.getDomain((HttpServletRequest)themeDisplay.getRequest());
        String commerceOrderUuidWebKey = this._getCookieName(groupId);
        if (commerceOrder.isGuestOrder()) {
            CookieKeys.deleteCookies((HttpServletRequest)themeDisplay.getRequest(), (HttpServletResponse)themeDisplay.getResponse(), (String)domain, (String[])new String[]{commerceOrderUuidWebKey});
            return this._commerceOrderService.updateUser(commerceOrder.getCommerceOrderId(), user.getUserId());
        }
        String commerceOrderUuid = CookieKeys.getCookie((HttpServletRequest)themeDisplay.getRequest(), (String)commerceOrderUuidWebKey, (boolean)false);
        if (Validator.isNull((String)commerceOrderUuid)) {
            return commerceOrder;
        }
        CommerceOrder cookieCommerceOrder = this._commerceOrderService.fetchCommerceOrder(commerceOrderUuid, groupId);
        if (cookieCommerceOrder == null || !cookieCommerceOrder.isGuestOrder()) {
            return commerceOrder;
        }
        ServiceContext serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)themeDisplay.getRequest());
        this._commerceOrderService.mergeGuestCommerceOrder(cookieCommerceOrder.getCommerceOrderId(), commerceOrder.getCommerceOrderId(), this._getCommerceContext(themeDisplay.getRequest()), serviceContext);
        CookieKeys.deleteCookies((HttpServletRequest)themeDisplay.getRequest(), (HttpServletResponse)themeDisplay.getResponse(), (String)domain, (String[])new String[]{commerceOrderUuidWebKey});
        return commerceOrder;
    }

    private CommerceContext _getCommerceContext(HttpServletRequest httpServletRequest) {
        return (CommerceContext)httpServletRequest.getAttribute("COMMERCE_CONTEXT");
    }

    private String _getCookieName(long groupId) {
        return CommerceOrder.class.getName() + "#" + groupId;
    }

    private CommerceOrder _getOrganizationCurrentCommerceOrder(ThemeDisplay themeDisplay, Organization organization) throws PortalException {
        long groupId;
        CommerceOrder commerceOrder = _commerceOrderUuidThreadLocal.get();
        if (commerceOrder != null) {
            return commerceOrder;
        }
        HttpServletRequest httpServletRequest = this._portal.getOriginalServletRequest(themeDisplay.getRequest());
        String uuid = SessionParamUtil.getString((HttpServletRequest)httpServletRequest, (String)this._getCookieName(groupId = organization.getGroupId()));
        if (Validator.isNotNull((String)uuid)) {
            commerceOrder = this._commerceOrderService.fetchCommerceOrder(uuid, groupId);
        }
        if (commerceOrder == null) {
            commerceOrder = this._commerceOrderService.fetchCommerceOrder(groupId, 2);
        }
        return commerceOrder;
    }

    private PortletURL _getPortletURL(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        LiferayPortletURL portletURL = null;
        long groupId = this._portal.getScopeGroupId(httpServletRequest);
        long plid = this._portal.getPlidFromPortletId(groupId, portletId);
        portletURL = plid > 0L ? this._portletURLFactory.create(httpServletRequest, portletId, plid, "RENDER_PHASE") : this._portletURLFactory.create(httpServletRequest, portletId, "RENDER_PHASE");
        return portletURL;
    }

    private CommerceOrder _getUserCurrentCommerceOrder(ThemeDisplay themeDisplay) throws PortalException {
        CommerceOrder commerceOrder = _commerceOrderUuidThreadLocal.get();
        if (commerceOrder != null) {
            return commerceOrder;
        }
        User user = themeDisplay.getUser();
        if (user != null && !user.isDefaultUser() && (commerceOrder = this._commerceOrderService.fetchCommerceOrder(themeDisplay.getScopeGroupId(), 2)) != null) {
            _commerceOrderUuidThreadLocal.set(commerceOrder);
            return commerceOrder;
        }
        String cookieName = this._getCookieName(themeDisplay.getScopeGroupId());
        String commerceOrderUuid = CookieKeys.getCookie((HttpServletRequest)themeDisplay.getRequest(), (String)cookieName, (boolean)true);
        if (Validator.isNotNull((String)commerceOrderUuid) && (commerceOrder = this._commerceOrderService.fetchCommerceOrder(commerceOrderUuid, themeDisplay.getScopeGroupId())) != null) {
            _commerceOrderUuidThreadLocal.set(commerceOrder);
            return commerceOrder;
        }
        return commerceOrder;
    }

    private void _setGuestCommerceOrder(ThemeDisplay themeDisplay, CommerceOrder commerceOrder) throws PortalException {
        User user = themeDisplay.getUser();
        if (user != null && !user.isDefaultUser()) {
            return;
        }
        String commerceOrderUuidWebKey = this._getCookieName(commerceOrder.getSiteGroupId());
        Cookie cookie = new Cookie(commerceOrderUuidWebKey, commerceOrder.getUuid());
        String domain = CookieKeys.getDomain((HttpServletRequest)themeDisplay.getRequest());
        if (Validator.isNotNull((String)domain)) {
            cookie.setDomain(domain);
        }
        cookie.setMaxAge(31536000);
        cookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)themeDisplay.getRequest(), (HttpServletResponse)themeDisplay.getResponse(), (Cookie)cookie);
    }

    static {
        _commerceOrderUuidThreadLocal = new CentralizedThreadLocal(CommerceOrderHttpHelperImpl.class.getName());
    }
}

