/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.service.persistence.CommerceOrderPersistence;

import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;

import java.lang.reflect.Field;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author Alessio Antonio Rendina
 * @generated
 */
public class CommerceOrderFinderBaseImpl extends BasePersistenceImpl<CommerceOrder> {
	public CommerceOrderFinderBaseImpl() {
		setModelClass(CommerceOrder.class);

		try {
			Field field = BasePersistenceImpl.class.getDeclaredField(
					"_dbColumnNames");

			field.setAccessible(true);

			Map<String, String> dbColumnNames = new HashMap<String, String>();

			dbColumnNames.put("uuid", "uuid_");
			dbColumnNames.put("subtotalDiscountPercentageLevel1",
				"subtotalDiscountPercentLevel1");
			dbColumnNames.put("subtotalDiscountPercentageLevel2",
				"subtotalDiscountPercentLevel2");
			dbColumnNames.put("subtotalDiscountPercentageLevel3",
				"subtotalDiscountPercentLevel3");
			dbColumnNames.put("subtotalDiscountPercentageLevel4",
				"subtotalDiscountPercentLevel4");
			dbColumnNames.put("shippingDiscountPercentageLevel1",
				"shippingDiscountPercentLevel1");
			dbColumnNames.put("shippingDiscountPercentageLevel2",
				"shippingDiscountPercentLevel2");
			dbColumnNames.put("shippingDiscountPercentageLevel3",
				"shippingDiscountPercentLevel3");
			dbColumnNames.put("shippingDiscountPercentageLevel4",
				"shippingDiscountPercentLevel4");

			field.set(this, dbColumnNames);
		}
		catch (Exception e) {
			if (_log.isDebugEnabled()) {
				_log.debug(e, e);
			}
		}
	}

	@Override
	public Set<String> getBadColumnNames() {
		return getCommerceOrderPersistence().getBadColumnNames();
	}

	/**
	 * Returns the commerce order persistence.
	 *
	 * @return the commerce order persistence
	 */
	public CommerceOrderPersistence getCommerceOrderPersistence() {
		return commerceOrderPersistence;
	}

	/**
	 * Sets the commerce order persistence.
	 *
	 * @param commerceOrderPersistence the commerce order persistence
	 */
	public void setCommerceOrderPersistence(
		CommerceOrderPersistence commerceOrderPersistence) {
		this.commerceOrderPersistence = commerceOrderPersistence;
	}

	@BeanReference(type = CommerceOrderPersistence.class)
	protected CommerceOrderPersistence commerceOrderPersistence;
	private static final Log _log = LogFactoryUtil.getLog(CommerceOrderFinderBaseImpl.class);
}