/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceAddressModel;
import com.liferay.commerce.model.CommerceAddressSoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceAddress service. Represents a row in the &quot;CommerceAddress&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceAddressModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceAddressImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceAddressImpl
 * @see CommerceAddress
 * @see CommerceAddressModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceAddressModelImpl extends BaseModelImpl<CommerceAddress>
	implements CommerceAddressModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce address model instance should use the {@link CommerceAddress} interface instead.
	 */
	public static final String TABLE_NAME = "CommerceAddress";
	public static final Object[][] TABLE_COLUMNS = {
			{ "commerceAddressId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "classNameId", Types.BIGINT },
			{ "classPK", Types.BIGINT },
			{ "name", Types.VARCHAR },
			{ "description", Types.VARCHAR },
			{ "street1", Types.VARCHAR },
			{ "street2", Types.VARCHAR },
			{ "street3", Types.VARCHAR },
			{ "city", Types.VARCHAR },
			{ "zip", Types.VARCHAR },
			{ "commerceRegionId", Types.BIGINT },
			{ "commerceCountryId", Types.BIGINT },
			{ "latitude", Types.DOUBLE },
			{ "longitude", Types.DOUBLE },
			{ "phoneNumber", Types.VARCHAR },
			{ "defaultBilling", Types.BOOLEAN },
			{ "defaultShipping", Types.BOOLEAN }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("commerceAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street1", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street2", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("street3", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("city", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("zip", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceRegionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceCountryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("latitude", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("longitude", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("phoneNumber", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("defaultBilling", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("defaultShipping", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE = "create table CommerceAddress (commerceAddressId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,name VARCHAR(75) null,description STRING null,street1 VARCHAR(75) null,street2 VARCHAR(75) null,street3 VARCHAR(75) null,city VARCHAR(75) null,zip VARCHAR(75) null,commerceRegionId LONG,commerceCountryId LONG,latitude DOUBLE,longitude DOUBLE,phoneNumber VARCHAR(75) null,defaultBilling BOOLEAN,defaultShipping BOOLEAN)";
	public static final String TABLE_SQL_DROP = "drop table CommerceAddress";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceAddress.createDate DESC";
	public static final String ORDER_BY_SQL = " ORDER BY CommerceAddress.createDate DESC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.model.CommerceAddress"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.model.CommerceAddress"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.model.CommerceAddress"),
			true);
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;
	public static final long CLASSPK_COLUMN_BITMASK = 2L;
	public static final long COMMERCECOUNTRYID_COLUMN_BITMASK = 4L;
	public static final long COMMERCEREGIONID_COLUMN_BITMASK = 8L;
	public static final long DEFAULTBILLING_COLUMN_BITMASK = 16L;
	public static final long DEFAULTSHIPPING_COLUMN_BITMASK = 32L;
	public static final long GROUPID_COLUMN_BITMASK = 64L;
	public static final long CREATEDATE_COLUMN_BITMASK = 128L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceAddress toModel(CommerceAddressSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceAddress model = new CommerceAddressImpl();

		model.setCommerceAddressId(soapModel.getCommerceAddressId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setName(soapModel.getName());
		model.setDescription(soapModel.getDescription());
		model.setStreet1(soapModel.getStreet1());
		model.setStreet2(soapModel.getStreet2());
		model.setStreet3(soapModel.getStreet3());
		model.setCity(soapModel.getCity());
		model.setZip(soapModel.getZip());
		model.setCommerceRegionId(soapModel.getCommerceRegionId());
		model.setCommerceCountryId(soapModel.getCommerceCountryId());
		model.setLatitude(soapModel.getLatitude());
		model.setLongitude(soapModel.getLongitude());
		model.setPhoneNumber(soapModel.getPhoneNumber());
		model.setDefaultBilling(soapModel.isDefaultBilling());
		model.setDefaultShipping(soapModel.isDefaultShipping());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceAddress> toModels(
		CommerceAddressSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceAddress> models = new ArrayList<CommerceAddress>(soapModels.length);

		for (CommerceAddressSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.model.CommerceAddress"));

	public CommerceAddressModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceAddressId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceAddressId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceAddressId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceAddress.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceAddress.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceAddressId", getCommerceAddressId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("classNameId", getClassNameId());
		attributes.put("classPK", getClassPK());
		attributes.put("name", getName());
		attributes.put("description", getDescription());
		attributes.put("street1", getStreet1());
		attributes.put("street2", getStreet2());
		attributes.put("street3", getStreet3());
		attributes.put("city", getCity());
		attributes.put("zip", getZip());
		attributes.put("commerceRegionId", getCommerceRegionId());
		attributes.put("commerceCountryId", getCommerceCountryId());
		attributes.put("latitude", getLatitude());
		attributes.put("longitude", getLongitude());
		attributes.put("phoneNumber", getPhoneNumber());
		attributes.put("defaultBilling", isDefaultBilling());
		attributes.put("defaultShipping", isDefaultShipping());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceAddressId = (Long)attributes.get("commerceAddressId");

		if (commerceAddressId != null) {
			setCommerceAddressId(commerceAddressId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long classNameId = (Long)attributes.get("classNameId");

		if (classNameId != null) {
			setClassNameId(classNameId);
		}

		Long classPK = (Long)attributes.get("classPK");

		if (classPK != null) {
			setClassPK(classPK);
		}

		String name = (String)attributes.get("name");

		if (name != null) {
			setName(name);
		}

		String description = (String)attributes.get("description");

		if (description != null) {
			setDescription(description);
		}

		String street1 = (String)attributes.get("street1");

		if (street1 != null) {
			setStreet1(street1);
		}

		String street2 = (String)attributes.get("street2");

		if (street2 != null) {
			setStreet2(street2);
		}

		String street3 = (String)attributes.get("street3");

		if (street3 != null) {
			setStreet3(street3);
		}

		String city = (String)attributes.get("city");

		if (city != null) {
			setCity(city);
		}

		String zip = (String)attributes.get("zip");

		if (zip != null) {
			setZip(zip);
		}

		Long commerceRegionId = (Long)attributes.get("commerceRegionId");

		if (commerceRegionId != null) {
			setCommerceRegionId(commerceRegionId);
		}

		Long commerceCountryId = (Long)attributes.get("commerceCountryId");

		if (commerceCountryId != null) {
			setCommerceCountryId(commerceCountryId);
		}

		Double latitude = (Double)attributes.get("latitude");

		if (latitude != null) {
			setLatitude(latitude);
		}

		Double longitude = (Double)attributes.get("longitude");

		if (longitude != null) {
			setLongitude(longitude);
		}

		String phoneNumber = (String)attributes.get("phoneNumber");

		if (phoneNumber != null) {
			setPhoneNumber(phoneNumber);
		}

		Boolean defaultBilling = (Boolean)attributes.get("defaultBilling");

		if (defaultBilling != null) {
			setDefaultBilling(defaultBilling);
		}

		Boolean defaultShipping = (Boolean)attributes.get("defaultShipping");

		if (defaultShipping != null) {
			setDefaultShipping(defaultShipping);
		}
	}

	@JSON
	@Override
	public long getCommerceAddressId() {
		return _commerceAddressId;
	}

	@Override
	public void setCommerceAddressId(long commerceAddressId) {
		_commerceAddressId = commerceAddressId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		_columnBitmask |= CLASSNAMEID_COLUMN_BITMASK;

		if (!_setOriginalClassNameId) {
			_setOriginalClassNameId = true;

			_originalClassNameId = _classNameId;
		}

		_classNameId = classNameId;
	}

	public long getOriginalClassNameId() {
		return _originalClassNameId;
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		_columnBitmask |= CLASSPK_COLUMN_BITMASK;

		if (!_setOriginalClassPK) {
			_setOriginalClassPK = true;

			_originalClassPK = _classPK;
		}

		_classPK = classPK;
	}

	public long getOriginalClassPK() {
		return _originalClassPK;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_name = name;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@JSON
	@Override
	public String getStreet1() {
		if (_street1 == null) {
			return "";
		}
		else {
			return _street1;
		}
	}

	@Override
	public void setStreet1(String street1) {
		_street1 = street1;
	}

	@JSON
	@Override
	public String getStreet2() {
		if (_street2 == null) {
			return "";
		}
		else {
			return _street2;
		}
	}

	@Override
	public void setStreet2(String street2) {
		_street2 = street2;
	}

	@JSON
	@Override
	public String getStreet3() {
		if (_street3 == null) {
			return "";
		}
		else {
			return _street3;
		}
	}

	@Override
	public void setStreet3(String street3) {
		_street3 = street3;
	}

	@JSON
	@Override
	public String getCity() {
		if (_city == null) {
			return "";
		}
		else {
			return _city;
		}
	}

	@Override
	public void setCity(String city) {
		_city = city;
	}

	@JSON
	@Override
	public String getZip() {
		if (_zip == null) {
			return "";
		}
		else {
			return _zip;
		}
	}

	@Override
	public void setZip(String zip) {
		_zip = zip;
	}

	@JSON
	@Override
	public long getCommerceRegionId() {
		return _commerceRegionId;
	}

	@Override
	public void setCommerceRegionId(long commerceRegionId) {
		_columnBitmask |= COMMERCEREGIONID_COLUMN_BITMASK;

		if (!_setOriginalCommerceRegionId) {
			_setOriginalCommerceRegionId = true;

			_originalCommerceRegionId = _commerceRegionId;
		}

		_commerceRegionId = commerceRegionId;
	}

	public long getOriginalCommerceRegionId() {
		return _originalCommerceRegionId;
	}

	@JSON
	@Override
	public long getCommerceCountryId() {
		return _commerceCountryId;
	}

	@Override
	public void setCommerceCountryId(long commerceCountryId) {
		_columnBitmask |= COMMERCECOUNTRYID_COLUMN_BITMASK;

		if (!_setOriginalCommerceCountryId) {
			_setOriginalCommerceCountryId = true;

			_originalCommerceCountryId = _commerceCountryId;
		}

		_commerceCountryId = commerceCountryId;
	}

	public long getOriginalCommerceCountryId() {
		return _originalCommerceCountryId;
	}

	@JSON
	@Override
	public double getLatitude() {
		return _latitude;
	}

	@Override
	public void setLatitude(double latitude) {
		_latitude = latitude;
	}

	@JSON
	@Override
	public double getLongitude() {
		return _longitude;
	}

	@Override
	public void setLongitude(double longitude) {
		_longitude = longitude;
	}

	@JSON
	@Override
	public String getPhoneNumber() {
		if (_phoneNumber == null) {
			return "";
		}
		else {
			return _phoneNumber;
		}
	}

	@Override
	public void setPhoneNumber(String phoneNumber) {
		_phoneNumber = phoneNumber;
	}

	@JSON
	@Override
	public boolean getDefaultBilling() {
		return _defaultBilling;
	}

	@JSON
	@Override
	public boolean isDefaultBilling() {
		return _defaultBilling;
	}

	@Override
	public void setDefaultBilling(boolean defaultBilling) {
		_columnBitmask |= DEFAULTBILLING_COLUMN_BITMASK;

		if (!_setOriginalDefaultBilling) {
			_setOriginalDefaultBilling = true;

			_originalDefaultBilling = _defaultBilling;
		}

		_defaultBilling = defaultBilling;
	}

	public boolean getOriginalDefaultBilling() {
		return _originalDefaultBilling;
	}

	@JSON
	@Override
	public boolean getDefaultShipping() {
		return _defaultShipping;
	}

	@JSON
	@Override
	public boolean isDefaultShipping() {
		return _defaultShipping;
	}

	@Override
	public void setDefaultShipping(boolean defaultShipping) {
		_columnBitmask |= DEFAULTSHIPPING_COLUMN_BITMASK;

		if (!_setOriginalDefaultShipping) {
			_setOriginalDefaultShipping = true;

			_originalDefaultShipping = _defaultShipping;
		}

		_defaultShipping = defaultShipping;
	}

	public boolean getOriginalDefaultShipping() {
		return _originalDefaultShipping;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceAddress.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceAddress toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceAddress)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceAddressImpl commerceAddressImpl = new CommerceAddressImpl();

		commerceAddressImpl.setCommerceAddressId(getCommerceAddressId());
		commerceAddressImpl.setGroupId(getGroupId());
		commerceAddressImpl.setCompanyId(getCompanyId());
		commerceAddressImpl.setUserId(getUserId());
		commerceAddressImpl.setUserName(getUserName());
		commerceAddressImpl.setCreateDate(getCreateDate());
		commerceAddressImpl.setModifiedDate(getModifiedDate());
		commerceAddressImpl.setClassNameId(getClassNameId());
		commerceAddressImpl.setClassPK(getClassPK());
		commerceAddressImpl.setName(getName());
		commerceAddressImpl.setDescription(getDescription());
		commerceAddressImpl.setStreet1(getStreet1());
		commerceAddressImpl.setStreet2(getStreet2());
		commerceAddressImpl.setStreet3(getStreet3());
		commerceAddressImpl.setCity(getCity());
		commerceAddressImpl.setZip(getZip());
		commerceAddressImpl.setCommerceRegionId(getCommerceRegionId());
		commerceAddressImpl.setCommerceCountryId(getCommerceCountryId());
		commerceAddressImpl.setLatitude(getLatitude());
		commerceAddressImpl.setLongitude(getLongitude());
		commerceAddressImpl.setPhoneNumber(getPhoneNumber());
		commerceAddressImpl.setDefaultBilling(isDefaultBilling());
		commerceAddressImpl.setDefaultShipping(isDefaultShipping());

		commerceAddressImpl.resetOriginalValues();

		return commerceAddressImpl;
	}

	@Override
	public int compareTo(CommerceAddress commerceAddress) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(),
				commerceAddress.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceAddress)) {
			return false;
		}

		CommerceAddress commerceAddress = (CommerceAddress)obj;

		long primaryKey = commerceAddress.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceAddressModelImpl commerceAddressModelImpl = this;

		commerceAddressModelImpl._originalGroupId = commerceAddressModelImpl._groupId;

		commerceAddressModelImpl._setOriginalGroupId = false;

		commerceAddressModelImpl._setModifiedDate = false;

		commerceAddressModelImpl._originalClassNameId = commerceAddressModelImpl._classNameId;

		commerceAddressModelImpl._setOriginalClassNameId = false;

		commerceAddressModelImpl._originalClassPK = commerceAddressModelImpl._classPK;

		commerceAddressModelImpl._setOriginalClassPK = false;

		commerceAddressModelImpl._originalCommerceRegionId = commerceAddressModelImpl._commerceRegionId;

		commerceAddressModelImpl._setOriginalCommerceRegionId = false;

		commerceAddressModelImpl._originalCommerceCountryId = commerceAddressModelImpl._commerceCountryId;

		commerceAddressModelImpl._setOriginalCommerceCountryId = false;

		commerceAddressModelImpl._originalDefaultBilling = commerceAddressModelImpl._defaultBilling;

		commerceAddressModelImpl._setOriginalDefaultBilling = false;

		commerceAddressModelImpl._originalDefaultShipping = commerceAddressModelImpl._defaultShipping;

		commerceAddressModelImpl._setOriginalDefaultShipping = false;

		commerceAddressModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceAddress> toCacheModel() {
		CommerceAddressCacheModel commerceAddressCacheModel = new CommerceAddressCacheModel();

		commerceAddressCacheModel.commerceAddressId = getCommerceAddressId();

		commerceAddressCacheModel.groupId = getGroupId();

		commerceAddressCacheModel.companyId = getCompanyId();

		commerceAddressCacheModel.userId = getUserId();

		commerceAddressCacheModel.userName = getUserName();

		String userName = commerceAddressCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceAddressCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceAddressCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceAddressCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceAddressCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceAddressCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceAddressCacheModel.classNameId = getClassNameId();

		commerceAddressCacheModel.classPK = getClassPK();

		commerceAddressCacheModel.name = getName();

		String name = commerceAddressCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceAddressCacheModel.name = null;
		}

		commerceAddressCacheModel.description = getDescription();

		String description = commerceAddressCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			commerceAddressCacheModel.description = null;
		}

		commerceAddressCacheModel.street1 = getStreet1();

		String street1 = commerceAddressCacheModel.street1;

		if ((street1 != null) && (street1.length() == 0)) {
			commerceAddressCacheModel.street1 = null;
		}

		commerceAddressCacheModel.street2 = getStreet2();

		String street2 = commerceAddressCacheModel.street2;

		if ((street2 != null) && (street2.length() == 0)) {
			commerceAddressCacheModel.street2 = null;
		}

		commerceAddressCacheModel.street3 = getStreet3();

		String street3 = commerceAddressCacheModel.street3;

		if ((street3 != null) && (street3.length() == 0)) {
			commerceAddressCacheModel.street3 = null;
		}

		commerceAddressCacheModel.city = getCity();

		String city = commerceAddressCacheModel.city;

		if ((city != null) && (city.length() == 0)) {
			commerceAddressCacheModel.city = null;
		}

		commerceAddressCacheModel.zip = getZip();

		String zip = commerceAddressCacheModel.zip;

		if ((zip != null) && (zip.length() == 0)) {
			commerceAddressCacheModel.zip = null;
		}

		commerceAddressCacheModel.commerceRegionId = getCommerceRegionId();

		commerceAddressCacheModel.commerceCountryId = getCommerceCountryId();

		commerceAddressCacheModel.latitude = getLatitude();

		commerceAddressCacheModel.longitude = getLongitude();

		commerceAddressCacheModel.phoneNumber = getPhoneNumber();

		String phoneNumber = commerceAddressCacheModel.phoneNumber;

		if ((phoneNumber != null) && (phoneNumber.length() == 0)) {
			commerceAddressCacheModel.phoneNumber = null;
		}

		commerceAddressCacheModel.defaultBilling = isDefaultBilling();

		commerceAddressCacheModel.defaultShipping = isDefaultShipping();

		return commerceAddressCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(47);

		sb.append("{commerceAddressId=");
		sb.append(getCommerceAddressId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", classNameId=");
		sb.append(getClassNameId());
		sb.append(", classPK=");
		sb.append(getClassPK());
		sb.append(", name=");
		sb.append(getName());
		sb.append(", description=");
		sb.append(getDescription());
		sb.append(", street1=");
		sb.append(getStreet1());
		sb.append(", street2=");
		sb.append(getStreet2());
		sb.append(", street3=");
		sb.append(getStreet3());
		sb.append(", city=");
		sb.append(getCity());
		sb.append(", zip=");
		sb.append(getZip());
		sb.append(", commerceRegionId=");
		sb.append(getCommerceRegionId());
		sb.append(", commerceCountryId=");
		sb.append(getCommerceCountryId());
		sb.append(", latitude=");
		sb.append(getLatitude());
		sb.append(", longitude=");
		sb.append(getLongitude());
		sb.append(", phoneNumber=");
		sb.append(getPhoneNumber());
		sb.append(", defaultBilling=");
		sb.append(isDefaultBilling());
		sb.append(", defaultShipping=");
		sb.append(isDefaultShipping());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(73);

		sb.append("<model><model-name>");
		sb.append("com.liferay.commerce.model.CommerceAddress");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>commerceAddressId</column-name><column-value><![CDATA[");
		sb.append(getCommerceAddressId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>classNameId</column-name><column-value><![CDATA[");
		sb.append(getClassNameId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>classPK</column-name><column-value><![CDATA[");
		sb.append(getClassPK());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>name</column-name><column-value><![CDATA[");
		sb.append(getName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>description</column-name><column-value><![CDATA[");
		sb.append(getDescription());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>street1</column-name><column-value><![CDATA[");
		sb.append(getStreet1());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>street2</column-name><column-value><![CDATA[");
		sb.append(getStreet2());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>street3</column-name><column-value><![CDATA[");
		sb.append(getStreet3());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>city</column-name><column-value><![CDATA[");
		sb.append(getCity());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>zip</column-name><column-value><![CDATA[");
		sb.append(getZip());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceRegionId</column-name><column-value><![CDATA[");
		sb.append(getCommerceRegionId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceCountryId</column-name><column-value><![CDATA[");
		sb.append(getCommerceCountryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>latitude</column-name><column-value><![CDATA[");
		sb.append(getLatitude());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>longitude</column-name><column-value><![CDATA[");
		sb.append(getLongitude());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>phoneNumber</column-name><column-value><![CDATA[");
		sb.append(getPhoneNumber());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>defaultBilling</column-name><column-value><![CDATA[");
		sb.append(isDefaultBilling());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>defaultShipping</column-name><column-value><![CDATA[");
		sb.append(isDefaultShipping());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceAddress.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceAddress.class, ModelWrapper.class
		};
	private long _commerceAddressId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _originalClassNameId;
	private boolean _setOriginalClassNameId;
	private long _classPK;
	private long _originalClassPK;
	private boolean _setOriginalClassPK;
	private String _name;
	private String _description;
	private String _street1;
	private String _street2;
	private String _street3;
	private String _city;
	private String _zip;
	private long _commerceRegionId;
	private long _originalCommerceRegionId;
	private boolean _setOriginalCommerceRegionId;
	private long _commerceCountryId;
	private long _originalCommerceCountryId;
	private boolean _setOriginalCommerceCountryId;
	private double _latitude;
	private double _longitude;
	private String _phoneNumber;
	private boolean _defaultBilling;
	private boolean _originalDefaultBilling;
	private boolean _setOriginalDefaultBilling;
	private boolean _defaultShipping;
	private boolean _originalDefaultShipping;
	private boolean _setOriginalDefaultShipping;
	private long _columnBitmask;
	private CommerceAddress _escapedModel;
}