/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.price;

import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.price.CommerceProductPrice;

import java.math.BigDecimal;

/**
 * @author Marco Leo
 */
public class CommerceProductPriceImpl implements CommerceProductPrice {

	@Override
	public CommerceDiscountValue getDiscountValue() {
		return _commerceDiscountValue;
	}

	@Override
	public CommerceMoney getFinalPrice() {
		return _finalPrice;
	}

	@Override
	public int getQuantity() {
		return _quantity;
	}

	@Override
	public BigDecimal getTaxValue() {
		return _taxValue;
	}

	@Override
	public CommerceMoney getUnitPrice() {
		return _unitPrice;
	}

	@Override
	public CommerceMoney getUnitPromoPrice() {
		return _unitPromoPrice;
	}

	public void setCommerceDiscountValue(
		CommerceDiscountValue commerceDiscountValue) {

		_commerceDiscountValue = commerceDiscountValue;
	}

	public void setFinalPrice(CommerceMoney finalPrice) {
		_finalPrice = finalPrice;
	}

	public void setQuantity(int quantity) {
		_quantity = quantity;
	}

	public void setTaxValue(BigDecimal taxValue) {
		_taxValue = taxValue;
	}

	public void setUnitPrice(CommerceMoney unitPrice) {
		_unitPrice = unitPrice;
	}

	public void setUnitPromoPrice(CommerceMoney unitPromoPrice) {
		_unitPromoPrice = unitPromoPrice;
	}

	private CommerceDiscountValue _commerceDiscountValue;
	private CommerceMoney _finalPrice;
	private int _quantity;
	private BigDecimal _taxValue;
	private CommerceMoney _unitPrice;
	private CommerceMoney _unitPromoPrice;

}