/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.internal.price;

import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.price.CommerceOrderPrice;

/**
 * @author Alessio Antonio Rendina
 */
public class CommerceOrderPriceImpl implements CommerceOrderPrice {

	@Override
	public CommerceDiscountValue getShippingDiscountValue() {
		return _shippingDiscountValue;
	}

	@Override
	public CommerceMoney getShippingValue() {
		return _shippingValue;
	}

	@Override
	public CommerceMoney getSubtotal() {
		return _subtotal;
	}

	@Override
	public CommerceDiscountValue getSubtotalDiscountValue() {
		return _subtotalDiscountValue;
	}

	@Override
	public CommerceMoney getTaxValue() {
		return _taxValue;
	}

	@Override
	public CommerceMoney getTotal() {
		return _total;
	}

	@Override
	public CommerceDiscountValue getTotalDiscountValue() {
		return _totalDiscountValue;
	}

	public void setShippingDiscountValue(
		CommerceDiscountValue shippingDiscountValue) {

		_shippingDiscountValue = shippingDiscountValue;
	}

	public void setShippingValue(CommerceMoney shippingValue) {
		_shippingValue = shippingValue;
	}

	public void setSubtotal(CommerceMoney subtotal) {
		_subtotal = subtotal;
	}

	public void setSubtotalDiscountValue(
		CommerceDiscountValue subtotalDiscountValue) {

		_subtotalDiscountValue = subtotalDiscountValue;
	}

	public void setTaxValue(CommerceMoney taxValue) {
		_taxValue = taxValue;
	}

	public void setTotal(CommerceMoney total) {
		_total = total;
	}

	public void setTotalDiscountValue(
		CommerceDiscountValue totalDiscountValue) {

		_totalDiscountValue = totalDiscountValue;
	}

	private CommerceDiscountValue _shippingDiscountValue;
	private CommerceMoney _shippingValue;
	private CommerceMoney _subtotal;
	private CommerceDiscountValue _subtotalDiscountValue;
	private CommerceMoney _taxValue;
	private CommerceMoney _total;
	private CommerceDiscountValue _totalDiscountValue;

}