/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceWarehouseItem;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.service.CPDefinitionService;
import com.liferay.commerce.product.service.CPInstanceService;
import com.liferay.commerce.service.base.CommerceWarehouseItemServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceWarehouseItemServiceImpl
extends CommerceWarehouseItemServiceBaseImpl {
    private static volatile ModelResourcePermission<CPDefinition> _cpDefinitionModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommerceWarehouseItemServiceImpl.class, (String)"_cpDefinitionModelResourcePermission", CPDefinition.class);
    @ServiceReference(type=CPDefinitionService.class)
    private CPDefinitionService _cpDefinitionService;
    @ServiceReference(type=CPInstanceService.class)
    private CPInstanceService _cpInstanceService;

    public CommerceWarehouseItem addCommerceWarehouseItem(long commerceWarehouseId, long cpInstanceId, int quantity, ServiceContext serviceContext) throws PortalException {
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceId);
        _cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpInstance.getCPDefinitionId(), "UPDATE");
        return this.commerceWarehouseItemLocalService.addCommerceWarehouseItem(commerceWarehouseId, cpInstanceId, quantity, serviceContext);
    }

    public void deleteCommerceWarehouseItem(long commerceWarehouseItemId) throws PortalException {
        CommerceWarehouseItem commerceWarehouseItem = this.commerceWarehouseItemLocalService.getCommerceWarehouseItem(commerceWarehouseItemId);
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(commerceWarehouseItem.getCPInstanceId());
        _cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpInstance.getCPDefinitionId(), "UPDATE");
        this.commerceWarehouseItemLocalService.deleteCommerceWarehouseItem(commerceWarehouseItem);
    }

    public CommerceWarehouseItem fetchCommerceWarehouseItem(long commerceWarehouseId, long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceId);
        _cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpInstance.getCPDefinitionId(), "UPDATE");
        return this.commerceWarehouseItemLocalService.fetchCommerceWarehouseItem(commerceWarehouseId, cpInstanceId);
    }

    public CommerceWarehouseItem getCommerceWarehouseItem(long commerceWarehouseItemId) throws PortalException {
        CommerceWarehouseItem commerceWarehouseItem = this.commerceWarehouseItemLocalService.getCommerceWarehouseItem(commerceWarehouseItemId);
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(commerceWarehouseItem.getCPInstanceId());
        _cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpInstance.getCPDefinitionId(), "UPDATE");
        return commerceWarehouseItem;
    }

    public List<CommerceWarehouseItem> getCommerceWarehouseItems(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceId);
        _cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpInstance.getCPDefinitionId(), "VIEW");
        return this.commerceWarehouseItemLocalService.getCommerceWarehouseItems(cpInstanceId);
    }

    public List<CommerceWarehouseItem> getCommerceWarehouseItems(long cpInstanceId, int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator) throws PortalException {
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceId);
        _cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpInstance.getCPDefinitionId(), "VIEW");
        return this.commerceWarehouseItemLocalService.getCommerceWarehouseItems(cpInstanceId, start, end, orderByComparator);
    }

    public int getCommerceWarehouseItemsCount(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceId);
        _cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpInstance.getCPDefinitionId(), "VIEW");
        return this.commerceWarehouseItemLocalService.getCommerceWarehouseItemsCount(cpInstanceId);
    }

    public int getCPInstanceQuantity(long cpInstanceId) throws PortalException {
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(cpInstanceId);
        _cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpInstance.getCPDefinitionId(), "VIEW");
        return this.commerceWarehouseItemLocalService.getCPInstanceQuantity(cpInstanceId);
    }

    public CommerceWarehouseItem updateCommerceWarehouseItem(long commerceWarehouseItemId, int quantity, ServiceContext serviceContext) throws PortalException {
        CommerceWarehouseItem commerceWarehouseItem = this.commerceWarehouseItemLocalService.getCommerceWarehouseItem(commerceWarehouseItemId);
        CPInstance cpInstance = this._cpInstanceService.getCPInstance(commerceWarehouseItem.getCPInstanceId());
        _cpDefinitionModelResourcePermission.check(this.getPermissionChecker(), cpInstance.getCPDefinitionId(), "UPDATE");
        return this.commerceWarehouseItemLocalService.updateCommerceWarehouseItem(commerceWarehouseItemId, quantity, serviceContext);
    }
}

