/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.configuration.CommerceOrderConfiguration;
import com.liferay.commerce.context.CommerceContext;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.currency.model.CommerceMoney;
import com.liferay.commerce.currency.service.CommerceCurrencyLocalService;
import com.liferay.commerce.discount.CommerceDiscountValue;
import com.liferay.commerce.exception.CommerceOrderBillingAddressException;
import com.liferay.commerce.exception.CommerceOrderPaymentMethodException;
import com.liferay.commerce.exception.CommerceOrderPurchaseOrderNumberException;
import com.liferay.commerce.exception.CommerceOrderShippingAddressException;
import com.liferay.commerce.exception.CommerceOrderShippingMethodException;
import com.liferay.commerce.exception.CommerceOrderStatusException;
import com.liferay.commerce.exception.CommercePaymentEngineException;
import com.liferay.commerce.exception.GuestCartMaxAllowedException;
import com.liferay.commerce.exception.NoSuchPaymentMethodException;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceOrderModel;
import com.liferay.commerce.model.CommercePaymentEngine;
import com.liferay.commerce.model.CommercePaymentEngineResult;
import com.liferay.commerce.model.CommercePaymentMethod;
import com.liferay.commerce.model.CommerceShippingMethod;
import com.liferay.commerce.organization.service.CommerceOrganizationLocalService;
import com.liferay.commerce.price.CommerceOrderPrice;
import com.liferay.commerce.price.CommerceOrderPriceCalculation;
import com.liferay.commerce.product.util.DDMFormValuesHelper;
import com.liferay.commerce.service.base.CommerceOrderLocalServiceBaseImpl;
import com.liferay.commerce.util.CommercePaymentEngineRegistry;
import com.liferay.commerce.util.CommerceShippingHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowTask;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class CommerceOrderLocalServiceImpl
extends CommerceOrderLocalServiceBaseImpl {
    protected static final int[] AVAILABLE_ORDER_STATUSES = new int[]{1, 10, 11, 13, 12, 19, 14, 17, 15, 0, 8, 16, 18};
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderLocalServiceImpl.class);
    @ServiceReference(type=CommerceCurrencyLocalService.class)
    private CommerceCurrencyLocalService _commerceCurrencyLocalService;
    @ServiceReference(type=CommerceOrderConfiguration.class)
    private CommerceOrderConfiguration _commerceOrderConfiguration;
    @ServiceReference(type=CommerceOrderPriceCalculation.class)
    private CommerceOrderPriceCalculation _commerceOrderPriceCalculation;
    @ServiceReference(type=CommerceOrganizationLocalService.class)
    private CommerceOrganizationLocalService _commerceOrganizationLocalService;
    @ServiceReference(type=CommercePaymentEngineRegistry.class)
    private CommercePaymentEngineRegistry _commercePaymentEngineRegistry;
    @ServiceReference(type=CommerceShippingHelper.class)
    private CommerceShippingHelper _commerceShippingHelper;
    @ServiceReference(type=DDMFormValuesHelper.class)
    private DDMFormValuesHelper _ddmFormValuesHelper;
    @ServiceReference(type=Portal.class)
    private Portal _portal;
    @ServiceReference(type=WorkflowTaskManager.class)
    private WorkflowTaskManager _workflowTaskManager;

    public CommerceOrder addCommerceOrder(long siteGroupId, long orderOrganizationId, long orderUserId, long commerceCurrencyId, long billingAddressId, long shippingAddressId, long commercePaymentMethodId, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, int paymentStatus, int orderStatus, ServiceContext serviceContext) throws PortalException {
        CommerceCurrency commerceCurrency;
        long scopeGroupId = serviceContext.getScopeGroupId();
        long userId = serviceContext.getUserId();
        User user = this.userLocalService.getUser(userId);
        if (user.isDefaultUser()) {
            userId = 0L;
        }
        this.validateGuestOrders();
        if (commerceCurrencyId <= 0L && (commerceCurrency = this._commerceCurrencyLocalService.fetchPrimaryCommerceCurrency(siteGroupId)) != null) {
            commerceCurrencyId = commerceCurrency.getCommerceCurrencyId();
        }
        long commerceOrderId = this.counterLocalService.increment();
        CommerceOrder commerceOrder = this.commerceOrderPersistence.create(commerceOrderId);
        commerceOrder.setUuid(serviceContext.getUuid());
        commerceOrder.setGroupId(scopeGroupId);
        commerceOrder.setCompanyId(user.getCompanyId());
        commerceOrder.setUserId(userId);
        commerceOrder.setUserName(user.getFullName());
        commerceOrder.setSiteGroupId(siteGroupId);
        commerceOrder.setOrderOrganizationId(orderOrganizationId);
        commerceOrder.setOrderUserId(orderUserId);
        commerceOrder.setCommerceCurrencyId(commerceCurrencyId);
        commerceOrder.setBillingAddressId(billingAddressId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        commerceOrder.setCommercePaymentMethodId(commercePaymentMethodId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingOptionName(shippingOptionName);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setSubtotal(subtotal);
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setPaymentStatus(paymentStatus);
        commerceOrder.setOrderStatus(orderStatus);
        commerceOrder.setStatus(2);
        commerceOrder.setStatusByUserId(user.getUserId());
        commerceOrder.setStatusByUserName(user.getFullName());
        commerceOrder.setStatusDate(serviceContext.getModifiedDate(null));
        commerceOrder.setExpandoBridgeAttributes(serviceContext);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return this.startWorkflowInstance(user.getUserId(), commerceOrder, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder addOrganizationCommerceOrder(long groupId, long userId, long siteGroupId, long orderOrganizationId, long shippingAddressId, String purchaseOrderNumber) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        if (this.hasWorkflowDefinition(siteGroupId, 0L)) {
            serviceContext.setWorkflowAction(2);
        }
        return this.addCommerceOrder(siteGroupId, orderOrganizationId, userId, 0L, 0L, shippingAddressId, 0L, 0L, null, purchaseOrderNumber, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1, 2, serviceContext);
    }

    public CommerceOrder addUserCommerceOrder(long groupId, long userId) throws PortalException {
        return this.commerceOrderLocalService.addUserCommerceOrder(groupId, userId, userId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder addUserCommerceOrder(long groupId, long userId, long orderUserId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        serviceContext.setUserId(userId);
        if (this.hasWorkflowDefinition(groupId, 0L)) {
            serviceContext.setWorkflowAction(2);
        }
        return this.addCommerceOrder(groupId, 0L, orderUserId, 0L, 0L, 0L, 0L, 0L, null, null, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, 1, 2, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder approveCommerceOrder(long userId, long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.updateStatus(userId, commerceOrderId, 0, new ServiceContext(), null);
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId());
        return commerceOrder;
    }

    public CommerceOrder cancelCommerceOrderPayment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommercePaymentEngine commercePaymentEngine = this.getCommercePaymentEngine(commerceOrder);
        if (commercePaymentEngine == null) {
            return commerceOrder;
        }
        String content = null;
        int status = 8;
        try {
            CommercePaymentEngineResult commercePaymentEngineResult = commercePaymentEngine.cancelPayment(commerceOrder, serviceContext);
            content = commercePaymentEngineResult.getContent();
        }
        catch (CommercePaymentEngineException cpee) {
            _log.error((Object)("Unable to cancel payment of order " + commerceOrder.getCommerceOrderId()), (Throwable)cpee);
            content = this.getCommerceOrderPaymentContent(cpee);
        }
        this.commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrder.getCommerceOrderId(), status, content, serviceContext);
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder checkoutCommerceOrder(long commerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        long shippingAddressId;
        CommerceOrder commerceOrder = this.commerceOrderLocalService.recalculatePrice(commerceOrderId, commerceContext);
        commerceOrder = this.commerceOrderLocalService.approveCommerceOrder(serviceContext.getUserId(), commerceOrderId);
        this.validateCheckout(commerceOrder);
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        CommerceOrderPrice commerceOrderPrice = this._commerceOrderPriceCalculation.getCommerceOrderPrice(commerceOrder, commerceContext);
        CommerceMoney subtotal = commerceOrderPrice.getSubtotal();
        CommerceMoney shippingValue = commerceOrderPrice.getShippingValue();
        CommerceMoney taxValue = commerceOrderPrice.getTaxValue();
        CommerceMoney total = commerceOrderPrice.getTotal();
        BigDecimal subtotalAmount = subtotal.getPrice();
        BigDecimal shippingAmount = shippingValue.getPrice();
        BigDecimal taxAmount = taxValue.getPrice();
        BigDecimal totalAmount = total.getPrice();
        commerceOrder.setSubtotal(subtotalAmount);
        commerceOrder.setSubtotalDiscounts(commerceOrderPrice.getSubtotalDiscountValue());
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setShippingDiscounts(commerceOrderPrice.getShippingDiscountValue());
        commerceOrder.setTaxAmount(taxAmount);
        commerceOrder.setTotal(totalAmount);
        commerceOrder.setTotalDiscounts(commerceOrderPrice.getTotalDiscountValue());
        commerceOrder.setOrderStatus(6);
        long billingAddressId = commerceOrder.getBillingAddressId();
        if (billingAddressId > 0L) {
            CommerceAddress commerceAddress = this.commerceAddressLocalService.copyCommerceAddress(billingAddressId, commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId(), serviceContext);
            billingAddressId = commerceAddress.getCommerceAddressId();
        }
        if ((shippingAddressId = commerceOrder.getShippingAddressId()) > 0L) {
            CommerceAddress commerceAddress = this.commerceAddressLocalService.copyCommerceAddress(shippingAddressId, commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId(), serviceContext);
            shippingAddressId = commerceAddress.getCommerceAddressId();
        }
        if (billingAddressId > 0L || shippingAddressId > 0L) {
            commerceOrder.setBillingAddressId(billingAddressId);
            commerceOrder.setShippingAddressId(shippingAddressId);
        }
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public CommerceOrder completeCommerceOrderPayment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommercePaymentEngine commercePaymentEngine = this.getCommercePaymentEngine(commerceOrder);
        if (commercePaymentEngine == null) {
            return commerceOrder;
        }
        String content = null;
        int status = 0;
        try {
            CommercePaymentEngineResult commercePaymentEngineResult = commercePaymentEngine.completePayment(commerceOrder, serviceContext);
            content = commercePaymentEngineResult.getContent();
            commerceOrder = this.updatePaymentStatus(commerceOrder.getCommerceOrderId(), 0, serviceContext);
        }
        catch (CommercePaymentEngineException cpee) {
            _log.error((Object)("Unable to complete payment of order " + commerceOrder.getCommerceOrderId()), (Throwable)cpee);
            content = this.getCommerceOrderPaymentContent(cpee);
            status = 4;
        }
        this.commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrder.getCommerceOrderId(), status, content, serviceContext);
        return commerceOrder;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CommerceOrder deleteCommerceOrder(CommerceOrder commerceOrder) throws PortalException {
        this.commerceOrderItemLocalService.deleteCommerceOrderItems(commerceOrder.getCommerceOrderId());
        this.commerceOrderNoteLocalService.deleteCommerceOrderNotes(commerceOrder.getCommerceOrderId());
        this.commerceOrderPaymentLocalService.deleteCommerceOrderPayments(commerceOrder.getCommerceOrderId());
        this.commerceAddressLocalService.deleteCommerceAddresses(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId());
        this.commerceOrderPersistence.remove((BaseModel)commerceOrder);
        this.expandoRowLocalService.deleteRows(commerceOrder.getCommerceOrderId());
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(commerceOrder.getCompanyId(), commerceOrder.getGroupId(), CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId());
        return commerceOrder;
    }

    @Override
    public CommerceOrder deleteCommerceOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        return this.commerceOrderLocalService.deleteCommerceOrder(commerceOrder);
    }

    public void deleteCommerceOrders(long groupId) throws PortalException {
        List commerceOrders = this.commerceOrderPersistence.findByGroupId(groupId);
        for (CommerceOrder commerceOrder : commerceOrders) {
            this.commerceOrderLocalService.deleteCommerceOrder(commerceOrder);
        }
    }

    public void deleteCommerceOrders(long userId, Date date, int status) {
        this.commerceOrderPersistence.removeByU_LtC_O(userId, date, status);
    }

    public CommerceOrder executeWorkflowTransition(long userId, long commerceOrderId, long workflowTaskId, String transitionName, String comment) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        long companyId = commerceOrder.getCompanyId();
        WorkflowTask workflowTask = this._workflowTaskManager.getWorkflowTask(companyId, workflowTaskId);
        if (!workflowTask.isAssignedToSingleUser()) {
            workflowTask = this._workflowTaskManager.assignWorkflowTaskToUser(companyId, userId, workflowTask.getWorkflowTaskId(), userId, comment, null, null);
        }
        this._workflowTaskManager.completeWorkflowTask(companyId, userId, workflowTask.getWorkflowTaskId(), transitionName, comment, null);
        return commerceOrder;
    }

    public CommerceOrder fetchCommerceOrder(long groupId, long userId, int orderStatus) {
        return this.commerceOrderPersistence.fetchByG_U_O_First(groupId, userId, orderStatus, null);
    }

    public int[] getAvailableOrderStatuses(long commerceOrderId) throws PortalException {
        if (commerceOrderId <= 0L) {
            return AVAILABLE_ORDER_STATUSES;
        }
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        if (!commerceOrder.isPending() && ArrayUtil.contains((int[])AVAILABLE_ORDER_STATUSES, (int)commerceOrder.getOrderStatus())) {
            return AVAILABLE_ORDER_STATUSES;
        }
        return new int[]{commerceOrder.getOrderStatus()};
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrders(long siteGroupId, int[] orderStatuses) {
        return this.commerceOrderFinder.findByS_O(siteGroupId, orderStatuses);
    }

    public List<CommerceOrder> getCommerceOrders(long groupId, long orderUserId, int start, int end, OrderByComparator<CommerceOrder> orderByComparator) {
        return this.commerceOrderPersistence.findByG_O(groupId, orderUserId, start, end, orderByComparator);
    }

    public List<CommerceOrder> getCommerceOrdersByBillingAddress(long billingAddressId) {
        return this.commerceOrderPersistence.findByBillingAddressId(billingAddressId);
    }

    public List<CommerceOrder> getCommerceOrdersByShippingAddress(long shippingAddressId) {
        return this.commerceOrderPersistence.findByShippingAddressId(shippingAddressId);
    }

    public int getCommerceOrdersCount(long groupId) {
        return this.commerceOrderPersistence.countByGroupId(groupId);
    }

    public int getCommerceOrdersCount(long groupId, long orderUserId) {
        return this.commerceOrderPersistence.countByG_O(groupId, orderUserId);
    }

    public void mergeGuestCommerceOrder(long guestCommerceOrderId, long userCommerceOrderId, CommerceContext commerceContext, ServiceContext serviceContext) throws PortalException {
        List guestCommerceOrderItems = this.commerceOrderItemPersistence.findByCommerceOrderId(guestCommerceOrderId);
        for (CommerceOrderItem guestCommerceOrderItem : guestCommerceOrderItems) {
            List userCommerceOrderItems = this.commerceOrderItemPersistence.findByC_I(userCommerceOrderId, guestCommerceOrderItem.getCPInstanceId());
            if (!userCommerceOrderItems.isEmpty()) {
                boolean found = false;
                for (CommerceOrderItem userCommerceOrderItem : userCommerceOrderItems) {
                    if (!this._ddmFormValuesHelper.equals(guestCommerceOrderItem.getJson(), userCommerceOrderItem.getJson())) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            this.commerceOrderItemLocalService.addCommerceOrderItem(userCommerceOrderId, guestCommerceOrderItem.getCPInstanceId(), guestCommerceOrderItem.getQuantity(), guestCommerceOrderItem.getShippedQuantity(), guestCommerceOrderItem.getJson(), commerceContext, serviceContext);
        }
        this.commerceOrderLocalService.deleteCommerceOrder(guestCommerceOrderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder recalculatePrice(long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            this.commerceOrderItemLocalService.updateCommerceOrderItemPrice(commerceOrderItem.getCommerceOrderItemId(), commerceContext);
        }
        CommerceOrderPrice commerceOrderPrice = this._commerceOrderPriceCalculation.getCommerceOrderPrice(commerceOrder, commerceContext);
        CommerceMoney shippingValue = commerceOrderPrice.getShippingValue();
        CommerceMoney subtotal = commerceOrderPrice.getSubtotal();
        CommerceMoney taxValue = commerceOrderPrice.getTaxValue();
        CommerceMoney total = commerceOrderPrice.getTotal();
        commerceOrder.setShippingAmount(shippingValue.getPrice());
        commerceOrder.setSubtotal(subtotal.getPrice());
        commerceOrder.setTaxAmount(taxValue.getPrice());
        commerceOrder.setTotal(total.getPrice());
        CommerceDiscountValue shippingDiscountValue = commerceOrderPrice.getShippingDiscountValue();
        CommerceDiscountValue subtotalDiscountValue = commerceOrderPrice.getSubtotalDiscountValue();
        CommerceDiscountValue totalDiscountValue = commerceOrderPrice.getTotalDiscountValue();
        this._setCommerceOrderShippingDiscountValue(commerceOrder, shippingDiscountValue);
        this._setCommerceOrderSubtotalDiscountValue(commerceOrder, subtotalDiscountValue);
        this._setCommerceOrderTotalDiscountValue(commerceOrder, totalDiscountValue);
        return commerceOrder;
    }

    public CommerceOrder reorderCommerceOrder(long userId, long commerceOrderId, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        serviceContext.setUserId(userId);
        long billingAddressId = 0L;
        long shippingAddressId = 0L;
        CommerceAddress billingAddress = this.getNewCommerceAddress(commerceOrder, commerceOrder.getBillingAddress(), serviceContext);
        CommerceAddress shippingAddress = this.getNewCommerceAddress(commerceOrder, commerceOrder.getShippingAddress(), serviceContext);
        if (billingAddress != null) {
            billingAddressId = billingAddress.getCommerceAddressId();
        }
        if (shippingAddress != null) {
            shippingAddressId = shippingAddress.getCommerceAddressId();
        }
        CommerceOrder newCommerceOrder = this.addCommerceOrder(commerceOrder.getSiteGroupId(), commerceOrder.getOrderOrganizationId(), commerceOrder.getOrderUserId(), commerceOrder.getCommerceCurrencyId(), billingAddressId, shippingAddressId, commerceOrder.getCommercePaymentMethodId(), commerceOrder.getCommerceShippingMethodId(), commerceOrder.getShippingOptionName(), "", commerceOrder.getSubtotal(), commerceOrder.getShippingAmount(), commerceOrder.getTotal(), 1, 2, serviceContext);
        List commerceOrderItems = this.commerceOrderItemLocalService.getCommerceOrderItems(commerceOrder.getCommerceOrderId(), -1, -1);
        for (CommerceOrderItem commerceOrderItem : commerceOrderItems) {
            this.commerceOrderItemLocalService.addCommerceOrderItem(newCommerceOrder.getCommerceOrderId(), commerceOrderItem.getCPInstanceId(), commerceOrderItem.getQuantity(), 0, commerceOrderItem.getJson(), commerceContext, serviceContext);
        }
        return newCommerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder resetCommerceOrderShipping(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        commerceOrder.setCommerceShippingMethodId(0L);
        commerceOrder.setShippingOptionName(null);
        commerceOrder.setShippingAmount(BigDecimal.ZERO);
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    public BaseModelSearchResult<CommerceOrder> searchCommerceOrders(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceOrder.class.getName());
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<CommerceOrder> commerceOrders = this.getCommerceOrders(hits);
            if (commerceOrders == null) continue;
            return new BaseModelSearchResult(commerceOrders, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public long searchCommerceOrdersCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer((String)CommerceOrder.class.getName());
        return indexer.searchCount(searchContext);
    }

    public String startCommerceOrderPayment(long commerceOrderId, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommercePaymentEngine commercePaymentEngine = this.getCommercePaymentEngine(commerceOrder);
        if (commercePaymentEngine == null) {
            this.updatePaymentStatus(commerceOrder.getCommerceOrderId(), 0, serviceContext);
            return null;
        }
        StringBundler sb = new StringBundler(13);
        sb.append(serviceContext.getPortalURL());
        sb.append(this._portal.getPathModule());
        sb.append('/');
        sb.append("commerce-payment");
        sb.append('?');
        sb.append("groupId=");
        sb.append(commerceOrder.getGroupId());
        sb.append("&uuid=");
        sb.append(URLCodec.encodeURL((String)commerceOrder.getUuid()));
        String redirect = ParamUtil.getString((ServiceContext)serviceContext, (String)"redirect");
        if (Validator.isNotNull((String)redirect)) {
            sb.append("&redirect=");
            sb.append(URLCodec.encodeURL((String)redirect));
        }
        String returnURL = sb.toString();
        sb.append("&cancel=");
        sb.append("true");
        String cancelURL = sb.toString();
        String output = null;
        String content = null;
        int status = 1;
        try {
            CommercePaymentEngineResult.StartPayment startPayment = commercePaymentEngine.startPayment(commerceOrder, cancelURL, returnURL, serviceContext);
            content = startPayment.getContent();
            output = startPayment.getOutput();
        }
        catch (CommercePaymentEngineException cpee) {
            _log.error((Object)("Unable to start payment of order " + commerceOrder.getCommerceOrderId()), (Throwable)cpee);
            content = this.getCommerceOrderPaymentContent(cpee);
            status = 4;
        }
        if (status == 4 || Validator.isNotNull((String)content)) {
            this.commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrder.getCommerceOrderId(), status, content, serviceContext);
        }
        if (status == 1 && Validator.isNull((String)output)) {
            this.setCommerceOrderToTransmit(commerceOrder, serviceContext);
        }
        return output;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder submitCommerceOrder(long userId, long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        if (!commerceOrder.isDraft() || commerceOrder.isEmpty()) {
            return commerceOrder;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        serviceContext.setUserId(userId);
        serviceContext.setWorkflowAction(1);
        return this.startWorkflowInstance(serviceContext.getUserId(), commerceOrder, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateBillingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this.updateAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, CommerceOrderModel::getBillingAddressId, CommerceOrderModel::setBillingAddressId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateCommerceOrder(long commerceOrderId, long billingAddressId, long shippingAddressId, long commercePaymentMethodId, long commerceShippingMethodId, String shippingOptionName, String purchaseOrderNumber, BigDecimal subtotal, BigDecimal shippingAmount, BigDecimal total, String advanceStatus, CommerceContext commerceContext) throws PortalException {
        CommerceOrderPrice commerceOrderPrice;
        CommerceDiscountValue shippingDiscountValue;
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setBillingAddressId(billingAddressId);
        commerceOrder.setShippingAddressId(shippingAddressId);
        commerceOrder.setCommercePaymentMethodId(commercePaymentMethodId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingOptionName(shippingOptionName);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setSubtotal(subtotal);
        if (commerceContext != null && (shippingDiscountValue = (commerceOrderPrice = this._commerceOrderPriceCalculation.getCommerceOrderPrice(commerceOrder, commerceContext)).getShippingDiscountValue()) != null) {
            CommerceMoney shippingDiscountAmount = shippingDiscountValue.getDiscountAmount();
            shippingAmount = shippingAmount.subtract(shippingDiscountAmount.getPrice());
        }
        commerceOrder.setShippingAmount(shippingAmount);
        commerceOrder.setTotal(total);
        commerceOrder.setAdvanceStatus(advanceStatus);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateOrderStatus(long commerceOrderId, int orderStatus) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        int previousOrderStatus = commerceOrder.getOrderStatus();
        this.validateOrderStatus(commerceOrder.getCommerceOrderId(), orderStatus);
        commerceOrder.setOrderStatus(orderStatus);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        this.sendMessage(commerceOrder.getCommerceOrderId(), commerceOrder.getOrderStatus(), previousOrderStatus);
        return commerceOrder;
    }

    public CommerceOrder updatePaymentStatus(long commerceOrderId, int paymentStatus, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setPaymentStatus(paymentStatus);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        if (commerceOrder.getOrderStatus() == 6 && commerceOrder.getPaymentStatus() == 0) {
            commerceOrder = this.setCommerceOrderToTransmit(commerceOrder, serviceContext);
        }
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updatePurchaseOrderNumber(long commerceOrderId, String purchaseOrderNumber) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        this.validatePurchaseOrderNumber(purchaseOrderNumber);
        commerceOrder.setPurchaseOrderNumber(purchaseOrderNumber);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateShippingAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, ServiceContext serviceContext) throws PortalException {
        return this.updateAddress(commerceOrderId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, CommerceOrderModel::getShippingAddressId, CommerceOrderModel::setShippingAddressId, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateShippingMethod(long commerceOrderId, long commerceShippingMethodId, String shippingOptionName, BigDecimal shippingAmount, CommerceContext commerceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setCommerceShippingMethodId(commerceShippingMethodId);
        commerceOrder.setShippingOptionName(shippingOptionName);
        commerceOrder.setShippingAmount(shippingAmount);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        commerceOrder = this.commerceOrderLocalService.recalculatePrice(commerceOrder.getCommerceOrderId(), commerceContext);
        return commerceOrder;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceOrder updateStatus(long userId, long commerceOrderId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        commerceOrder.setStatus(status);
        commerceOrder.setStatusByUserId(user.getUserId());
        commerceOrder.setStatusByUserName(user.getFullName());
        commerceOrder.setStatusDate(serviceContext.getModifiedDate(now));
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        return commerceOrder;
    }

    public CommerceOrder updateUser(long commerceOrderId, long userId) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        User user = this.userLocalService.getUser(userId);
        commerceOrder.setUserId(user.getUserId());
        commerceOrder.setUserName(user.getFullName());
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    protected String getCommerceOrderPaymentContent(CommercePaymentEngineException cpee) {
        return StackTraceUtil.getStackTrace((Throwable)cpee);
    }

    protected List<CommerceOrder> getCommerceOrders(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceOrder> commerceOrders = new ArrayList<CommerceOrder>(documents.size());
        for (Document document : documents) {
            long commerceOrderId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceOrder commerceOrder = this.fetchCommerceOrder(commerceOrderId);
            if (commerceOrder == null) {
                commerceOrders = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceOrder.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceOrders == null) continue;
            commerceOrders.add(commerceOrder);
        }
        return commerceOrders;
    }

    protected CommercePaymentEngine getCommercePaymentEngine(CommerceOrder commerceOrder) throws PortalException {
        CommercePaymentMethod commercePaymentMethod = commerceOrder.getCommercePaymentMethod();
        if (commercePaymentMethod == null) {
            return null;
        }
        if (!commercePaymentMethod.isActive()) {
            throw new NoSuchPaymentMethodException("Payment method " + commercePaymentMethod + " is not active");
        }
        return this._commercePaymentEngineRegistry.getCommercePaymentEngine(commercePaymentMethod.getEngineKey());
    }

    protected CommerceAddress getNewCommerceAddress(CommerceOrder commerceOrder, CommerceAddress commerceAddress, ServiceContext serviceContext) throws PortalException {
        if (commerceAddress == null) {
            return commerceAddress;
        }
        long groupId = serviceContext.getScopeGroupId();
        String className = commerceOrder.getClassName();
        long classPK = commerceOrder.getClassPK();
        List commerceAddresses = this.commerceAddressLocalService.getCommerceAddresses(groupId, className, classPK);
        for (CommerceAddress newCommerceAddress : commerceAddresses) {
            if (!commerceAddress.isSameAddress(newCommerceAddress)) continue;
            return newCommerceAddress;
        }
        return this.commerceAddressLocalService.copyCommerceAddress(commerceAddress.getCommerceAddressId(), className, classPK, serviceContext);
    }

    protected boolean hasWorkflowDefinition(long siteGroupId, long typePK) throws PortalException {
        Group group = this.groupLocalService.getGroup(siteGroupId);
        return this.workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(group.getCompanyId(), group.getGroupId(), CommerceOrder.class.getName(), 0L, typePK);
    }

    protected void sendMessage(final long commerceOrderId, final int orderStatus, final int previousOrderStatus) {
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("commerceOrderId", (Object)commerceOrderId);
                message.put("orderStatus", (Object)orderStatus);
                message.put("previousOrderStatus", (Object)previousOrderStatus);
                MessageBusUtil.sendMessage((String)"liferay/order_status", (Message)message);
                return null;
            }
        });
    }

    protected CommerceOrder setCommerceOrderToTransmit(CommerceOrder commerceOrder, ServiceContext serviceContext) throws PortalException {
        int previousOrderStatus = commerceOrder.getOrderStatus();
        commerceOrder.setOrderStatus(1);
        commerceOrder.setStatus(1);
        this.commerceOrderPersistence.update((BaseModel)commerceOrder);
        this.sendMessage(commerceOrder.getCommerceOrderId(), commerceOrder.getOrderStatus(), previousOrderStatus);
        serviceContext.setScopeGroupId(commerceOrder.getGroupId());
        return this.startWorkflowInstance(serviceContext.getUserId(), commerceOrder, serviceContext);
    }

    protected CommerceOrder startWorkflowInstance(long userId, CommerceOrder commerceOrder, ServiceContext serviceContext) throws PortalException {
        HashMap workflowContext = new HashMap();
        return (CommerceOrder)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)commerceOrder.getCompanyId(), (long)commerceOrder.getGroupId(), (long)userId, (String)CommerceOrder.class.getName(), (long)commerceOrder.getCommerceOrderId(), (Object)commerceOrder, (ServiceContext)serviceContext, workflowContext);
    }

    protected CommerceOrder updateAddress(long commerceOrderId, String name, String description, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, String phoneNumber, Function<CommerceOrder, Long> commerceAddressIdGetter, BiConsumer<CommerceOrder, Long> commerceAddressIdSetter, ServiceContext serviceContext) throws PortalException {
        CommerceOrder commerceOrder = this.commerceOrderPersistence.findByPrimaryKey(commerceOrderId);
        CommerceAddress commerceAddress = null;
        long commerceAddressId = commerceAddressIdGetter.apply(commerceOrder);
        commerceAddress = commerceAddressId > 0L ? this.commerceAddressLocalService.updateCommerceAddress(commerceAddressId, name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, false, false, serviceContext) : this.commerceAddressLocalService.addCommerceAddress(commerceOrder.getModelClassName(), commerceOrder.getCommerceOrderId(), name, description, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, phoneNumber, false, false, serviceContext);
        commerceAddressIdSetter.accept(commerceOrder, commerceAddress.getCommerceAddressId());
        return (CommerceOrder)this.commerceOrderPersistence.update((BaseModel)commerceOrder);
    }

    protected void validateCheckout(CommerceOrder commerceOrder) throws PortalException {
        if (commerceOrder.isDraft() || !commerceOrder.isOpen()) {
            throw new CommerceOrderStatusException();
        }
        CommercePaymentMethod commercePaymentMethod = null;
        long commercePaymentMethodId = commerceOrder.getCommercePaymentMethodId();
        if (commercePaymentMethodId > 0L) {
            commercePaymentMethod = this.commercePaymentMethodLocalService.getCommercePaymentMethod(commercePaymentMethodId);
            if (!commercePaymentMethod.isActive()) {
                commercePaymentMethod = null;
            } else if (!commerceOrder.isB2B() && commerceOrder.getBillingAddressId() <= 0L) {
                throw new CommerceOrderBillingAddressException();
            }
        }
        if (commercePaymentMethod == null && this.commercePaymentMethodLocalService.getCommercePaymentMethodsCount(commerceOrder.getGroupId(), true) > 0) {
            throw new CommerceOrderPaymentMethodException();
        }
        CommerceShippingMethod commerceShippingMethod = null;
        long commerceShippingMethodId = commerceOrder.getCommerceShippingMethodId();
        if (commerceShippingMethodId > 0L) {
            commerceShippingMethod = this.commerceShippingMethodLocalService.getCommerceShippingMethod(commerceShippingMethodId);
            if (!commerceShippingMethod.isActive()) {
                commerceShippingMethod = null;
            } else if (commerceOrder.getShippingAddressId() <= 0L) {
                throw new CommerceOrderShippingAddressException();
            }
        }
        if (commerceShippingMethod == null && this.commerceShippingMethodLocalService.getCommerceShippingMethodsCount(commerceOrder.getGroupId(), true) > 0 && this._commerceShippingHelper.isShippable(commerceOrder)) {
            throw new CommerceOrderShippingMethodException();
        }
    }

    protected void validateGuestOrders() throws PortalException {
        int count = this.commerceOrderPersistence.countByUserId(0L);
        if (count >= this._commerceOrderConfiguration.guestCartMaxAllowed()) {
            throw new GuestCartMaxAllowedException();
        }
    }

    protected void validateOrderStatus(long commerceOrderId, int orderStatus) throws PortalException {
        int[] availableOrderStatuses = this.getAvailableOrderStatuses(commerceOrderId);
        if (!ArrayUtil.contains((int[])availableOrderStatuses, (int)orderStatus)) {
            throw new CommerceOrderStatusException();
        }
    }

    protected void validatePurchaseOrderNumber(String purchaseOrderNumber) throws PortalException {
        if (Validator.isNull((String)purchaseOrderNumber)) {
            throw new CommerceOrderPurchaseOrderNumberException();
        }
    }

    private void _setCommerceOrderShippingDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel1 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel1 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel1 = percentages[3];
            }
        }
        commerceOrder.setShippingDiscountAmount(discountAmount);
        commerceOrder.setShippingDiscountPercentageLevel1(discountPercentageLevel1);
        commerceOrder.setShippingDiscountPercentageLevel2(discountPercentageLevel2);
        commerceOrder.setShippingDiscountPercentageLevel3(discountPercentageLevel3);
        commerceOrder.setShippingDiscountPercentageLevel4(discountPercentageLevel4);
    }

    private void _setCommerceOrderSubtotalDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel1 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel1 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel1 = percentages[3];
            }
        }
        commerceOrder.setSubtotalDiscountAmount(discountAmount);
        commerceOrder.setSubtotalDiscountPercentageLevel1(discountPercentageLevel1);
        commerceOrder.setSubtotalDiscountPercentageLevel2(discountPercentageLevel2);
        commerceOrder.setSubtotalDiscountPercentageLevel3(discountPercentageLevel3);
        commerceOrder.setSubtotalDiscountPercentageLevel4(discountPercentageLevel4);
    }

    private void _setCommerceOrderTotalDiscountValue(CommerceOrder commerceOrder, CommerceDiscountValue commerceDiscountValue) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel1 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel2 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel3 = BigDecimal.ZERO;
        BigDecimal discountPercentageLevel4 = BigDecimal.ZERO;
        if (commerceDiscountValue != null) {
            CommerceMoney discountAmountCommerceMoney = commerceDiscountValue.getDiscountAmount();
            discountAmount = discountAmountCommerceMoney.getPrice();
            BigDecimal[] percentages = commerceDiscountValue.getPercentages();
            if (percentages.length >= 1) {
                discountPercentageLevel1 = percentages[0];
            }
            if (percentages.length >= 2) {
                discountPercentageLevel1 = percentages[1];
            }
            if (percentages.length >= 3) {
                discountPercentageLevel1 = percentages[2];
            }
            if (percentages.length >= 4) {
                discountPercentageLevel1 = percentages[3];
            }
        }
        commerceOrder.setTotalDiscountAmount(discountAmount);
        commerceOrder.setTotalDiscountPercentageLevel1(discountPercentageLevel1);
        commerceOrder.setTotalDiscountPercentageLevel2(discountPercentageLevel2);
        commerceOrder.setTotalDiscountPercentageLevel3(discountPercentageLevel3);
        commerceOrder.setTotalDiscountPercentageLevel4(discountPercentageLevel4);
    }
}

