/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.search;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class CommerceOrderIndexer
extends BaseIndexer<CommerceOrder> {
    public static final String CLASS_NAME = CommerceOrder.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderIndexer.class);
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference(target="(model.class.name=com.liferay.commerce.model.CommerceOrder)")
    private ModelResourcePermission<CommerceOrder> _modelResourcePermission;

    public CommerceOrderIndexer() {
        this.setFilterSearch(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._modelResourcePermission.contains(permissionChecker, entryClassPK, actionId);
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long siteGroupId = GetterUtil.getLong((Object)searchContext.getAttribute("siteGroupId"));
        if (siteGroupId > 0L) {
            TermFilter termFilter = new TermFilter("siteGroupId", String.valueOf(siteGroupId));
            contextBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.MUST);
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        super.postProcessSearchQuery(searchQuery, fullQueryBooleanFilter, searchContext);
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "purchaseOrderNumber", false);
    }

    protected void doDelete(CommerceOrder commerceOrder) throws Exception {
        this.deleteDocument(commerceOrder.getCompanyId(), commerceOrder.getCommerceOrderId());
    }

    protected Document doGetDocument(CommerceOrder commerceOrder) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing order item " + commerceOrder));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)commerceOrder);
        document.addNumberSortable("entryClassPK", Long.valueOf(commerceOrder.getCommerceOrderId()));
        document.addKeyword("advanceStatus", commerceOrder.getAdvanceStatus());
        document.addNumber("itemsQuantity", this.getItemsQuantity(commerceOrder));
        document.addKeyword("orderOrganizationId", commerceOrder.getOrderOrganizationId());
        document.addKeyword("orderStatus", commerceOrder.getOrderStatus());
        document.addKeyword("purchaseOrderNumber", commerceOrder.getPurchaseOrderNumber());
        document.addKeyword("siteGroupId", commerceOrder.getSiteGroupId());
        document.addNumber("total", commerceOrder.getTotal());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + commerceOrder + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        return null;
    }

    protected void doReindex(CommerceOrder commerceOrder) throws Exception {
        Document document = this.getDocument(commerceOrder);
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), commerceOrder.getCompanyId(), document, this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(classPK);
        this.doReindex(commerceOrder);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCommerceOrders(companyId);
    }

    protected int getItemsQuantity(CommerceOrder commerceOrder) {
        int count = 0;
        for (CommerceOrderItem commerceOrderItem : commerceOrder.getCommerceOrderItems()) {
            count += commerceOrderItem.getQuantity();
        }
        return count;
    }

    protected boolean isUseSearchResultPermissionFilter(SearchContext searchContext) {
        Boolean useSearchResultPermissionFilter = (Boolean)searchContext.getAttribute("useSearchResultPermissionFilter");
        if (useSearchResultPermissionFilter != null) {
            return useSearchResultPermissionFilter;
        }
        return super.isUseSearchResultPermissionFilter(searchContext);
    }

    protected void reindexCommerceOrders(long companyId) throws Exception {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._commerceOrderLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<CommerceOrder>(){

            public void performAction(CommerceOrder commerceOrder) {
                block2: {
                    try {
                        Document document = CommerceOrderIndexer.this.getDocument(commerceOrder);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block2;
                        _log.warn((Object)("Unable to index commerce order item " + commerceOrder.getCommerceOrderId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

