/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.exception.CommerceWarehouseActiveException;
import com.liferay.commerce.exception.CommerceWarehouseCommerceRegionIdException;
import com.liferay.commerce.exception.CommerceWarehouseNameException;
import com.liferay.commerce.model.CommerceGeocoder;
import com.liferay.commerce.model.CommerceRegion;
import com.liferay.commerce.model.CommerceWarehouse;
import com.liferay.commerce.service.base.CommerceWarehouseLocalServiceBaseImpl;
import com.liferay.commerce.util.comparator.CommerceWarehouseNameComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.List;

public class CommerceWarehouseLocalServiceImpl
extends CommerceWarehouseLocalServiceBaseImpl {
    @ServiceReference(type=CommerceGeocoder.class)
    private CommerceGeocoder _commerceGeocoder;

    public CommerceWarehouse addCommerceWarehouse(String name, String description, boolean active, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        this.validate(name, active, commerceRegionId, commerceCountryId, latitude, longitude);
        long commerceWarehouseId = this.counterLocalService.increment();
        CommerceWarehouse commerceWarehouse = this.commerceWarehousePersistence.create(commerceWarehouseId);
        commerceWarehouse.setGroupId(groupId);
        commerceWarehouse.setCompanyId(user.getCompanyId());
        commerceWarehouse.setUserId(user.getUserId());
        commerceWarehouse.setUserName(user.getFullName());
        commerceWarehouse.setName(name);
        commerceWarehouse.setDescription(description);
        commerceWarehouse.setActive(active);
        commerceWarehouse.setStreet1(street1);
        commerceWarehouse.setStreet2(street2);
        commerceWarehouse.setStreet3(street3);
        commerceWarehouse.setCity(city);
        commerceWarehouse.setZip(zip);
        commerceWarehouse.setCommerceRegionId(commerceRegionId);
        commerceWarehouse.setCommerceCountryId(commerceCountryId);
        commerceWarehouse.setLatitude(latitude);
        commerceWarehouse.setLongitude(longitude);
        this.commerceWarehousePersistence.update((BaseModel)commerceWarehouse);
        return commerceWarehouse;
    }

    @Override
    public CommerceWarehouse deleteCommerceWarehouse(CommerceWarehouse commerceWarehouse) {
        this.commerceWarehousePersistence.remove((BaseModel)commerceWarehouse);
        this.commerceWarehouseItemLocalService.deleteCommerceWarehouseItems(commerceWarehouse.getCommerceWarehouseId());
        return commerceWarehouse;
    }

    @Override
    public CommerceWarehouse deleteCommerceWarehouse(long commerceWarehouseId) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehousePersistence.findByPrimaryKey(commerceWarehouseId);
        return this.commerceWarehouseLocalService.deleteCommerceWarehouse(commerceWarehouse);
    }

    public void deleteCommerceWarehouses(long groupId) {
        List commerceWarehouses = this.commerceWarehousePersistence.findByGroupId(groupId);
        for (CommerceWarehouse commerceWarehouse : commerceWarehouses) {
            this.commerceWarehouseLocalService.deleteCommerceWarehouse(commerceWarehouse);
        }
    }

    public CommerceWarehouse fetchDefaultCommerceWarehouse(long groupId) {
        return this.commerceWarehousePersistence.fetchByG_P_First(groupId, true, (OrderByComparator)new CommerceWarehouseNameComparator(true));
    }

    public CommerceWarehouse geolocateCommerceWarehouse(long commerceWarehouseId) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehousePersistence.findByPrimaryKey(commerceWarehouseId);
        double[] coordinates = this._commerceGeocoder.getCoordinates(commerceWarehouse.getStreet1(), commerceWarehouse.getCity(), commerceWarehouse.getZip(), commerceWarehouse.getCommerceRegion(), commerceWarehouse.getCommerceCountry());
        commerceWarehouse.setLatitude(coordinates[0]);
        commerceWarehouse.setLongitude(coordinates[1]);
        return (CommerceWarehouse)this.commerceWarehousePersistence.update((BaseModel)commerceWarehouse);
    }

    public List<CommerceWarehouse> getCommerceWarehouses(long groupId) {
        return this.commerceWarehousePersistence.findByGroupId(groupId);
    }

    public List<CommerceWarehouse> getCommerceWarehouses(long groupId, boolean active, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) {
        return this.commerceWarehousePersistence.findByG_A(groupId, active, start, end, orderByComparator);
    }

    public List<CommerceWarehouse> getCommerceWarehouses(long groupId, boolean active, long commerceCountryId, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) {
        if (commerceCountryId >= 0L) {
            return this.commerceWarehousePersistence.findByG_A_C(groupId, active, commerceCountryId, start, end, orderByComparator);
        }
        return this.commerceWarehousePersistence.findByG_A(groupId, active, start, end, orderByComparator);
    }

    public List<CommerceWarehouse> getCommerceWarehouses(long cpInstanceId, int start, int end) {
        return this.commerceWarehouseFinder.findByCPInstanceId(cpInstanceId, start, end);
    }

    public List<CommerceWarehouse> getCommerceWarehouses(long groupId, long commerceCountryId, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) {
        if (commerceCountryId >= 0L) {
            return this.commerceWarehousePersistence.findByG_C(groupId, commerceCountryId, start, end, orderByComparator);
        }
        return this.commerceWarehousePersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public int getCommerceWarehousesCount(long groupId, boolean active, long commerceCountryId) {
        if (commerceCountryId >= 0L) {
            return this.commerceWarehousePersistence.countByG_A_C(groupId, active, commerceCountryId);
        }
        return this.commerceWarehousePersistence.countByG_A(groupId, active);
    }

    public int getCommerceWarehousesCount(long groupId, long commerceCountryId) {
        if (commerceCountryId >= 0L) {
            return this.commerceWarehousePersistence.countByG_C(groupId, commerceCountryId);
        }
        return this.commerceWarehousePersistence.countByGroupId(groupId);
    }

    public CommerceWarehouse importDefaultCommerceWarehouse(ServiceContext serviceContext) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehousePersistence.fetchByG_P_First(serviceContext.getScopeGroupId(), true, (OrderByComparator)new CommerceWarehouseNameComparator(true));
        if (commerceWarehouse != null) {
            return commerceWarehouse;
        }
        return this._addDefaultCommerceWarehouse("default", null, null, null, null, null, 0L, 0L, -1.0, -1.0, serviceContext);
    }

    public List<CommerceWarehouse> search(long groupId, String keywords, Boolean active, long commerceCountryId, int start, int end, OrderByComparator<CommerceWarehouse> orderByComparator) {
        return this.commerceWarehouseFinder.findByKeywords(groupId, keywords, active, commerceCountryId, start, end, orderByComparator);
    }

    public int searchCount(long groupId, String keywords, Boolean active, long commerceCountryId) {
        return this.commerceWarehouseFinder.countByKeywords(groupId, keywords, active, commerceCountryId);
    }

    public CommerceWarehouse setActive(long commerceWarehouseId, boolean active) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehousePersistence.findByPrimaryKey(commerceWarehouseId);
        commerceWarehouse.setActive(active);
        this.commerceWarehousePersistence.update((BaseModel)commerceWarehouse);
        return commerceWarehouse;
    }

    public CommerceWarehouse updateCommerceWarehouse(long commerceWarehouseId, String name, String description, boolean active, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehousePersistence.findByPrimaryKey(commerceWarehouseId);
        this.validate(name, active, commerceRegionId, commerceCountryId, latitude, longitude);
        commerceWarehouse.setName(name);
        commerceWarehouse.setDescription(description);
        commerceWarehouse.setActive(active);
        commerceWarehouse.setStreet1(street1);
        commerceWarehouse.setStreet2(street2);
        commerceWarehouse.setStreet3(street3);
        commerceWarehouse.setCity(city);
        commerceWarehouse.setZip(zip);
        commerceWarehouse.setCommerceRegionId(commerceRegionId);
        commerceWarehouse.setCommerceCountryId(commerceCountryId);
        commerceWarehouse.setLatitude(latitude);
        commerceWarehouse.setLongitude(longitude);
        this.commerceWarehousePersistence.update((BaseModel)commerceWarehouse);
        return commerceWarehouse;
    }

    public CommerceWarehouse updateDefaultCommerceWarehouse(String name, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        List commerceWarehouses = this.commerceWarehousePersistence.findByG_A(serviceContext.getScopeGroupId(), true);
        for (CommerceWarehouse commerceWarehouse : commerceWarehouses) {
            this.commerceWarehouseLocalService.setActive(commerceWarehouse.getCommerceWarehouseId(), false);
        }
        CommerceWarehouse commerceWarehouse = this.commerceWarehousePersistence.fetchByG_P_First(serviceContext.getScopeGroupId(), true, (OrderByComparator)new CommerceWarehouseNameComparator(true));
        if (commerceWarehouse == null) {
            return this._addDefaultCommerceWarehouse(name, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, latitude, longitude, serviceContext);
        }
        return this.commerceWarehouseLocalService.updateCommerceWarehouse(commerceWarehouse.getCommerceWarehouseId(), name, commerceWarehouse.getDescription(), true, street1, street2, street3, city, zip, commerceRegionId, commerceCountryId, latitude, longitude, serviceContext);
    }

    protected void validate(String name, boolean active, long commerceRegionId, long commerceCountryId, double latitude, double longitude) throws PortalException {
        CommerceRegion commerceRegion;
        if (Validator.isNull((String)name)) {
            throw new CommerceWarehouseNameException();
        }
        if (commerceRegionId > 0L && (commerceRegion = this.commerceRegionLocalService.getCommerceRegion(commerceRegionId)).getCommerceCountryId() != commerceCountryId) {
            throw new CommerceWarehouseCommerceRegionIdException();
        }
        if (active && latitude == 0.0 && longitude == 0.0) {
            throw new CommerceWarehouseActiveException();
        }
    }

    private CommerceWarehouse _addDefaultCommerceWarehouse(String name, String street1, String street2, String street3, String city, String zip, long commerceRegionId, long commerceCountryId, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        this.validate(name, true, commerceRegionId, commerceCountryId, latitude, longitude);
        long commerceWarehouseId = this.counterLocalService.increment();
        CommerceWarehouse commerceWarehouse = this.commerceWarehousePersistence.create(commerceWarehouseId);
        commerceWarehouse.setGroupId(groupId);
        commerceWarehouse.setCompanyId(user.getCompanyId());
        commerceWarehouse.setUserId(user.getUserId());
        commerceWarehouse.setUserName(user.getFullName());
        commerceWarehouse.setName(name);
        commerceWarehouse.setActive(true);
        commerceWarehouse.setStreet1(street1);
        commerceWarehouse.setStreet2(street2);
        commerceWarehouse.setStreet3(street3);
        commerceWarehouse.setCity(city);
        commerceWarehouse.setZip(zip);
        commerceWarehouse.setCommerceRegionId(commerceRegionId);
        commerceWarehouse.setCommerceCountryId(commerceCountryId);
        commerceWarehouse.setLatitude(latitude);
        commerceWarehouse.setLongitude(longitude);
        commerceWarehouse.setPrimary(true);
        this.commerceWarehousePersistence.update((BaseModel)commerceWarehouse);
        return commerceWarehouse;
    }
}

