/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.impl;

import com.liferay.commerce.model.CommerceWarehouse;
import com.liferay.commerce.model.CommerceWarehouseItem;
import com.liferay.commerce.service.base.CommerceWarehouseItemLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

public class CommerceWarehouseItemLocalServiceImpl
extends CommerceWarehouseItemLocalServiceBaseImpl {
    public CommerceWarehouseItem addCommerceWarehouseItem(long commerceWarehouseId, long cpInstanceId, int quantity, ServiceContext serviceContext) throws PortalException {
        CommerceWarehouse commerceWarehouse = this.commerceWarehouseLocalService.getCommerceWarehouse(commerceWarehouseId);
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long commerceWarehouseItemId = this.counterLocalService.increment();
        CommerceWarehouseItem commerceWarehouseItem = this.commerceWarehouseItemPersistence.create(commerceWarehouseItemId);
        commerceWarehouseItem.setGroupId(commerceWarehouse.getGroupId());
        commerceWarehouseItem.setCompanyId(user.getCompanyId());
        commerceWarehouseItem.setUserId(user.getUserId());
        commerceWarehouseItem.setUserName(user.getFullName());
        commerceWarehouseItem.setCommerceWarehouseId(commerceWarehouseId);
        commerceWarehouseItem.setCPInstanceId(cpInstanceId);
        commerceWarehouseItem.setQuantity(quantity);
        this.commerceWarehouseItemPersistence.update((BaseModel)commerceWarehouseItem);
        return commerceWarehouseItem;
    }

    public void deleteCommerceWarehouseItems(long commerceWarehouseId) {
        this.commerceWarehouseItemPersistence.removeByCommerceWarehouseId(commerceWarehouseId);
    }

    public void deleteCommerceWarehouseItemsByCPInstanceId(long cpInstanceId) {
        this.commerceWarehouseItemPersistence.removeByCPInstanceId(cpInstanceId);
    }

    public CommerceWarehouseItem fetchCommerceWarehouseItem(long commerceWarehouseId, long cpInstanceId) {
        return this.commerceWarehouseItemPersistence.fetchByC_C(commerceWarehouseId, cpInstanceId);
    }

    public List<CommerceWarehouseItem> getCommerceWarehouseItems(long cpInstanceId) {
        return this.commerceWarehouseItemPersistence.findByCPInstanceId(cpInstanceId);
    }

    public List<CommerceWarehouseItem> getCommerceWarehouseItems(long cpInstanceId, int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        return this.commerceWarehouseItemFinder.findByCPInstanceId(cpInstanceId, start, end, orderByComparator);
    }

    public List<CommerceWarehouseItem> getCommerceWarehouseItemsByCommerceWarehouseId(long commerceWarehouseId) {
        return this.commerceWarehouseItemPersistence.findByCommerceWarehouseId(commerceWarehouseId);
    }

    public int getCommerceWarehouseItemsCount(long cpInstanceId) {
        return this.commerceWarehouseItemPersistence.countByCPInstanceId(cpInstanceId);
    }

    public int getCPInstanceQuantity(long cpInstanceId) {
        return this.commerceWarehouseItemFinder.getCPInstanceQuantity(cpInstanceId);
    }

    public CommerceWarehouseItem updateCommerceWarehouseItem(long commerceWarehouseItemId, int quantity, ServiceContext serviceContext) throws PortalException {
        CommerceWarehouseItem commerceWarehouseItem = this.commerceWarehouseItemPersistence.findByPrimaryKey(commerceWarehouseItemId);
        commerceWarehouseItem.setQuantity(quantity);
        this.commerceWarehouseItemPersistence.update((BaseModel)commerceWarehouseItem);
        return commerceWarehouseItem;
    }
}

