/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.commerce.exception.NoSuchWarehouseItemException;
import com.liferay.commerce.model.CommerceWarehouseItem;
import com.liferay.commerce.model.impl.CommerceWarehouseItemImpl;
import com.liferay.commerce.model.impl.CommerceWarehouseItemModelImpl;
import com.liferay.commerce.service.persistence.CommerceWarehouseItemPersistence;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ProviderType
public class CommerceWarehouseItemPersistenceImpl
extends BasePersistenceImpl<CommerceWarehouseItem>
implements CommerceWarehouseItemPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CommerceWarehouseItemImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, CommerceWarehouseItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, CommerceWarehouseItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_COMMERCEWAREHOUSEID = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, CommerceWarehouseItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCommerceWarehouseId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMMERCEWAREHOUSEID = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, CommerceWarehouseItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCommerceWarehouseId", new String[]{Long.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_COMMERCEWAREHOUSEID = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCommerceWarehouseId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_COMMERCEWAREHOUSEID_COMMERCEWAREHOUSEID_2 = "commerceWarehouseItem.commerceWarehouseId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_CPINSTANCEID = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, CommerceWarehouseItemImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCPInstanceId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CPINSTANCEID = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, CommerceWarehouseItemImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCPInstanceId", new String[]{Long.class.getName()}, 1L);
    public static final FinderPath FINDER_PATH_COUNT_BY_CPINSTANCEID = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCPInstanceId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_CPINSTANCEID_CPINSTANCEID_2 = "commerceWarehouseItem.CPInstanceId = ?";
    public static final FinderPath FINDER_PATH_FETCH_BY_C_C = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, CommerceWarehouseItemImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
    public static final FinderPath FINDER_PATH_COUNT_BY_C_C = new FinderPath(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()});
    private static final String _FINDER_COLUMN_C_C_COMMERCEWAREHOUSEID_2 = "commerceWarehouseItem.commerceWarehouseId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CPINSTANCEID_2 = "commerceWarehouseItem.CPInstanceId = ?";
    @ServiceReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMMERCEWAREHOUSEITEM = "SELECT commerceWarehouseItem FROM CommerceWarehouseItem commerceWarehouseItem";
    private static final String _SQL_SELECT_COMMERCEWAREHOUSEITEM_WHERE_PKS_IN = "SELECT commerceWarehouseItem FROM CommerceWarehouseItem commerceWarehouseItem WHERE commerceWarehouseItemId IN (";
    private static final String _SQL_SELECT_COMMERCEWAREHOUSEITEM_WHERE = "SELECT commerceWarehouseItem FROM CommerceWarehouseItem commerceWarehouseItem WHERE ";
    private static final String _SQL_COUNT_COMMERCEWAREHOUSEITEM = "SELECT COUNT(commerceWarehouseItem) FROM CommerceWarehouseItem commerceWarehouseItem";
    private static final String _SQL_COUNT_COMMERCEWAREHOUSEITEM_WHERE = "SELECT COUNT(commerceWarehouseItem) FROM CommerceWarehouseItem commerceWarehouseItem WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "commerceWarehouseItem.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CommerceWarehouseItem exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CommerceWarehouseItem exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CommerceWarehouseItemPersistenceImpl.class);

    public List<CommerceWarehouseItem> findByCommerceWarehouseId(long commerceWarehouseId) {
        return this.findByCommerceWarehouseId(commerceWarehouseId, -1, -1, null);
    }

    public List<CommerceWarehouseItem> findByCommerceWarehouseId(long commerceWarehouseId, int start, int end) {
        return this.findByCommerceWarehouseId(commerceWarehouseId, start, end, null);
    }

    public List<CommerceWarehouseItem> findByCommerceWarehouseId(long commerceWarehouseId, int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        return this.findByCommerceWarehouseId(commerceWarehouseId, start, end, orderByComparator, true);
    }

    public List<CommerceWarehouseItem> findByCommerceWarehouseId(long commerceWarehouseId, int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMMERCEWAREHOUSEID;
            finderArgs = new Object[]{commerceWarehouseId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_COMMERCEWAREHOUSEID;
            finderArgs = new Object[]{commerceWarehouseId, start, end, orderByComparator};
        }
        List<CommerceWarehouseItem> list = null;
        if (retrieveFromCache && (list = (List<CommerceWarehouseItem>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceWarehouseItem commerceWarehouseItem : list) {
                if (commerceWarehouseId == commerceWarehouseItem.getCommerceWarehouseId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCEWAREHOUSEITEM_WHERE);
            query.append(_FINDER_COLUMN_COMMERCEWAREHOUSEID_COMMERCEWAREHOUSEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY commerceWarehouseItem.commerceWarehouseItemId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceWarehouseId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceWarehouseItem findByCommerceWarehouseId_First(long commerceWarehouseId, OrderByComparator<CommerceWarehouseItem> orderByComparator) throws NoSuchWarehouseItemException {
        CommerceWarehouseItem commerceWarehouseItem = this.fetchByCommerceWarehouseId_First(commerceWarehouseId, orderByComparator);
        if (commerceWarehouseItem != null) {
            return commerceWarehouseItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceWarehouseId=");
        msg.append(commerceWarehouseId);
        msg.append("}");
        throw new NoSuchWarehouseItemException(msg.toString());
    }

    public CommerceWarehouseItem fetchByCommerceWarehouseId_First(long commerceWarehouseId, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        List<CommerceWarehouseItem> list = this.findByCommerceWarehouseId(commerceWarehouseId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceWarehouseItem findByCommerceWarehouseId_Last(long commerceWarehouseId, OrderByComparator<CommerceWarehouseItem> orderByComparator) throws NoSuchWarehouseItemException {
        CommerceWarehouseItem commerceWarehouseItem = this.fetchByCommerceWarehouseId_Last(commerceWarehouseId, orderByComparator);
        if (commerceWarehouseItem != null) {
            return commerceWarehouseItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("commerceWarehouseId=");
        msg.append(commerceWarehouseId);
        msg.append("}");
        throw new NoSuchWarehouseItemException(msg.toString());
    }

    public CommerceWarehouseItem fetchByCommerceWarehouseId_Last(long commerceWarehouseId, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        int count = this.countByCommerceWarehouseId(commerceWarehouseId);
        if (count == 0) {
            return null;
        }
        List<CommerceWarehouseItem> list = this.findByCommerceWarehouseId(commerceWarehouseId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceWarehouseItem[] findByCommerceWarehouseId_PrevAndNext(long commerceWarehouseItemId, long commerceWarehouseId, OrderByComparator<CommerceWarehouseItem> orderByComparator) throws NoSuchWarehouseItemException {
        CommerceWarehouseItem commerceWarehouseItem = this.findByPrimaryKey(commerceWarehouseItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceWarehouseItem[] array = new CommerceWarehouseItemImpl[]{this.getByCommerceWarehouseId_PrevAndNext(session, commerceWarehouseItem, commerceWarehouseId, orderByComparator, true), commerceWarehouseItem, this.getByCommerceWarehouseId_PrevAndNext(session, commerceWarehouseItem, commerceWarehouseId, orderByComparator, false)};
            CommerceWarehouseItem[] commerceWarehouseItemArray = array;
            return commerceWarehouseItemArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceWarehouseItem getByCommerceWarehouseId_PrevAndNext(Session session, CommerceWarehouseItem commerceWarehouseItem, long commerceWarehouseId, OrderByComparator<CommerceWarehouseItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCEWAREHOUSEITEM_WHERE);
        query.append(_FINDER_COLUMN_COMMERCEWAREHOUSEID_COMMERCEWAREHOUSEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceWarehouseItem.commerceWarehouseItemId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(commerceWarehouseId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)commerceWarehouseItem)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceWarehouseItem)list.get(1);
        }
        return null;
    }

    public void removeByCommerceWarehouseId(long commerceWarehouseId) {
        for (CommerceWarehouseItem commerceWarehouseItem : this.findByCommerceWarehouseId(commerceWarehouseId, -1, -1, null)) {
            this.remove((BaseModel)commerceWarehouseItem);
        }
    }

    public int countByCommerceWarehouseId(long commerceWarehouseId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_COMMERCEWAREHOUSEID;
        Object[] finderArgs = new Object[]{commerceWarehouseId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCEWAREHOUSEITEM_WHERE);
            query.append(_FINDER_COLUMN_COMMERCEWAREHOUSEID_COMMERCEWAREHOUSEID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceWarehouseId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CommerceWarehouseItem> findByCPInstanceId(long CPInstanceId) {
        return this.findByCPInstanceId(CPInstanceId, -1, -1, null);
    }

    public List<CommerceWarehouseItem> findByCPInstanceId(long CPInstanceId, int start, int end) {
        return this.findByCPInstanceId(CPInstanceId, start, end, null);
    }

    public List<CommerceWarehouseItem> findByCPInstanceId(long CPInstanceId, int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        return this.findByCPInstanceId(CPInstanceId, start, end, orderByComparator, true);
    }

    public List<CommerceWarehouseItem> findByCPInstanceId(long CPInstanceId, int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CPINSTANCEID;
            finderArgs = new Object[]{CPInstanceId};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_CPINSTANCEID;
            finderArgs = new Object[]{CPInstanceId, start, end, orderByComparator};
        }
        List<CommerceWarehouseItem> list = null;
        if (retrieveFromCache && (list = (List<CommerceWarehouseItem>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (CommerceWarehouseItem commerceWarehouseItem : list) {
                if (CPInstanceId == commerceWarehouseItem.getCPInstanceId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMMERCEWAREHOUSEITEM_WHERE);
            query.append("commerceWarehouseItem.CPInstanceId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY commerceWarehouseItem.commerceWarehouseItemId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(CPInstanceId);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CommerceWarehouseItem findByCPInstanceId_First(long CPInstanceId, OrderByComparator<CommerceWarehouseItem> orderByComparator) throws NoSuchWarehouseItemException {
        CommerceWarehouseItem commerceWarehouseItem = this.fetchByCPInstanceId_First(CPInstanceId, orderByComparator);
        if (commerceWarehouseItem != null) {
            return commerceWarehouseItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("CPInstanceId=");
        msg.append(CPInstanceId);
        msg.append("}");
        throw new NoSuchWarehouseItemException(msg.toString());
    }

    public CommerceWarehouseItem fetchByCPInstanceId_First(long CPInstanceId, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        List<CommerceWarehouseItem> list = this.findByCPInstanceId(CPInstanceId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceWarehouseItem findByCPInstanceId_Last(long CPInstanceId, OrderByComparator<CommerceWarehouseItem> orderByComparator) throws NoSuchWarehouseItemException {
        CommerceWarehouseItem commerceWarehouseItem = this.fetchByCPInstanceId_Last(CPInstanceId, orderByComparator);
        if (commerceWarehouseItem != null) {
            return commerceWarehouseItem;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("CPInstanceId=");
        msg.append(CPInstanceId);
        msg.append("}");
        throw new NoSuchWarehouseItemException(msg.toString());
    }

    public CommerceWarehouseItem fetchByCPInstanceId_Last(long CPInstanceId, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        int count = this.countByCPInstanceId(CPInstanceId);
        if (count == 0) {
            return null;
        }
        List<CommerceWarehouseItem> list = this.findByCPInstanceId(CPInstanceId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CommerceWarehouseItem[] findByCPInstanceId_PrevAndNext(long commerceWarehouseItemId, long CPInstanceId, OrderByComparator<CommerceWarehouseItem> orderByComparator) throws NoSuchWarehouseItemException {
        CommerceWarehouseItem commerceWarehouseItem = this.findByPrimaryKey(commerceWarehouseItemId);
        Session session = null;
        try {
            session = this.openSession();
            CommerceWarehouseItem[] array = new CommerceWarehouseItemImpl[]{this.getByCPInstanceId_PrevAndNext(session, commerceWarehouseItem, CPInstanceId, orderByComparator, true), commerceWarehouseItem, this.getByCPInstanceId_PrevAndNext(session, commerceWarehouseItem, CPInstanceId, orderByComparator, false)};
            CommerceWarehouseItem[] commerceWarehouseItemArray = array;
            return commerceWarehouseItemArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceWarehouseItem getByCPInstanceId_PrevAndNext(Session session, CommerceWarehouseItem commerceWarehouseItem, long CPInstanceId, OrderByComparator<CommerceWarehouseItem> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMMERCEWAREHOUSEITEM_WHERE);
        query.append("commerceWarehouseItem.CPInstanceId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY commerceWarehouseItem.commerceWarehouseItemId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(CPInstanceId);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)commerceWarehouseItem)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (CommerceWarehouseItem)list.get(1);
        }
        return null;
    }

    public void removeByCPInstanceId(long CPInstanceId) {
        for (CommerceWarehouseItem commerceWarehouseItem : this.findByCPInstanceId(CPInstanceId, -1, -1, null)) {
            this.remove((BaseModel)commerceWarehouseItem);
        }
    }

    public int countByCPInstanceId(long CPInstanceId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_CPINSTANCEID;
        Object[] finderArgs = new Object[]{CPInstanceId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMMERCEWAREHOUSEITEM_WHERE);
            query.append("commerceWarehouseItem.CPInstanceId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(CPInstanceId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceWarehouseItem findByC_C(long commerceWarehouseId, long CPInstanceId) throws NoSuchWarehouseItemException {
        CommerceWarehouseItem commerceWarehouseItem = this.fetchByC_C(commerceWarehouseId, CPInstanceId);
        if (commerceWarehouseItem == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("commerceWarehouseId=");
            msg.append(commerceWarehouseId);
            msg.append(", CPInstanceId=");
            msg.append(CPInstanceId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchWarehouseItemException(msg.toString());
        }
        return commerceWarehouseItem;
    }

    public CommerceWarehouseItem fetchByC_C(long commerceWarehouseId, long CPInstanceId) {
        return this.fetchByC_C(commerceWarehouseId, CPInstanceId, true);
    }

    public CommerceWarehouseItem fetchByC_C(long commerceWarehouseId, long CPInstanceId, boolean retrieveFromCache) {
        CommerceWarehouseItem commerceWarehouseItem;
        Object[] finderArgs = new Object[]{commerceWarehouseId, CPInstanceId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_C_C, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof CommerceWarehouseItem && (commerceWarehouseId != (commerceWarehouseItem = (CommerceWarehouseItem)result).getCommerceWarehouseId() || CPInstanceId != commerceWarehouseItem.getCPInstanceId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_COMMERCEWAREHOUSEITEM_WHERE);
            query.append(_FINDER_COLUMN_C_C_COMMERCEWAREHOUSEID_2);
            query.append("commerceWarehouseItem.CPInstanceId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceWarehouseId);
                qPos.add(CPInstanceId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_C, finderArgs, (Object)list);
                } else {
                    CommerceWarehouseItem commerceWarehouseItem2 = (CommerceWarehouseItem)list.get(0);
                    result = commerceWarehouseItem2;
                    this.cacheResult(commerceWarehouseItem2);
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_C, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (CommerceWarehouseItem)result;
    }

    public CommerceWarehouseItem removeByC_C(long commerceWarehouseId, long CPInstanceId) throws NoSuchWarehouseItemException {
        CommerceWarehouseItem commerceWarehouseItem = this.findByC_C(commerceWarehouseId, CPInstanceId);
        return (CommerceWarehouseItem)this.remove((BaseModel)commerceWarehouseItem);
    }

    public int countByC_C(long commerceWarehouseId, long CPInstanceId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_C_C;
        Object[] finderArgs = new Object[]{commerceWarehouseId, CPInstanceId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_COMMERCEWAREHOUSEITEM_WHERE);
            query.append(_FINDER_COLUMN_C_C_COMMERCEWAREHOUSEID_2);
            query.append("commerceWarehouseItem.CPInstanceId = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(commerceWarehouseId);
                qPos.add(CPInstanceId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CommerceWarehouseItemPersistenceImpl() {
        this.setModelClass(CommerceWarehouseItem.class);
    }

    public void cacheResult(CommerceWarehouseItem commerceWarehouseItem) {
        this.entityCache.putResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, (Serializable)Long.valueOf(commerceWarehouseItem.getPrimaryKey()), (Serializable)commerceWarehouseItem);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_C, new Object[]{commerceWarehouseItem.getCommerceWarehouseId(), commerceWarehouseItem.getCPInstanceId()}, (Object)commerceWarehouseItem);
        commerceWarehouseItem.resetOriginalValues();
    }

    public void cacheResult(List<CommerceWarehouseItem> commerceWarehouseItems) {
        for (CommerceWarehouseItem commerceWarehouseItem : commerceWarehouseItems) {
            if (this.entityCache.getResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, (Serializable)Long.valueOf(commerceWarehouseItem.getPrimaryKey())) == null) {
                this.cacheResult(commerceWarehouseItem);
                continue;
            }
            commerceWarehouseItem.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CommerceWarehouseItemImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(CommerceWarehouseItem commerceWarehouseItem) {
        this.entityCache.removeResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, (Serializable)Long.valueOf(commerceWarehouseItem.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((CommerceWarehouseItemModelImpl)commerceWarehouseItem, true);
    }

    public void clearCache(List<CommerceWarehouseItem> commerceWarehouseItems) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (CommerceWarehouseItem commerceWarehouseItem : commerceWarehouseItems) {
            this.entityCache.removeResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, (Serializable)Long.valueOf(commerceWarehouseItem.getPrimaryKey()));
            this.clearUniqueFindersCache((CommerceWarehouseItemModelImpl)commerceWarehouseItem, true);
        }
    }

    protected void cacheUniqueFindersCache(CommerceWarehouseItemModelImpl commerceWarehouseItemModelImpl) {
        Object[] args = new Object[]{commerceWarehouseItemModelImpl.getCommerceWarehouseId(), commerceWarehouseItemModelImpl.getCPInstanceId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_C_C, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_C_C, args, (Object)commerceWarehouseItemModelImpl, false);
    }

    protected void clearUniqueFindersCache(CommerceWarehouseItemModelImpl commerceWarehouseItemModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{commerceWarehouseItemModelImpl.getCommerceWarehouseId(), commerceWarehouseItemModelImpl.getCPInstanceId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_C, args);
        }
        if ((commerceWarehouseItemModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_C_C.getColumnBitmask()) != 0L) {
            args = new Object[]{commerceWarehouseItemModelImpl.getOriginalCommerceWarehouseId(), commerceWarehouseItemModelImpl.getOriginalCPInstanceId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_C_C, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_C_C, args);
        }
    }

    public CommerceWarehouseItem create(long commerceWarehouseItemId) {
        CommerceWarehouseItemImpl commerceWarehouseItem = new CommerceWarehouseItemImpl();
        commerceWarehouseItem.setNew(true);
        commerceWarehouseItem.setPrimaryKey(commerceWarehouseItemId);
        commerceWarehouseItem.setCompanyId(this.companyProvider.getCompanyId());
        return commerceWarehouseItem;
    }

    public CommerceWarehouseItem remove(long commerceWarehouseItemId) throws NoSuchWarehouseItemException {
        return this.remove(Long.valueOf(commerceWarehouseItemId));
    }

    public CommerceWarehouseItem remove(Serializable primaryKey) throws NoSuchWarehouseItemException {
        Session session = null;
        try {
            session = this.openSession();
            CommerceWarehouseItem commerceWarehouseItem = (CommerceWarehouseItem)session.get(CommerceWarehouseItemImpl.class, primaryKey);
            if (commerceWarehouseItem == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchWarehouseItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CommerceWarehouseItem commerceWarehouseItem2 = (CommerceWarehouseItem)this.remove((BaseModel)commerceWarehouseItem);
            return commerceWarehouseItem2;
        }
        catch (NoSuchWarehouseItemException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CommerceWarehouseItem removeImpl(CommerceWarehouseItem commerceWarehouseItem) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)commerceWarehouseItem)) {
                commerceWarehouseItem = (CommerceWarehouseItem)session.get(CommerceWarehouseItemImpl.class, commerceWarehouseItem.getPrimaryKeyObj());
            }
            if (commerceWarehouseItem != null) {
                session.delete((Object)commerceWarehouseItem);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (commerceWarehouseItem != null) {
            this.clearCache(commerceWarehouseItem);
        }
        return commerceWarehouseItem;
    }

    public CommerceWarehouseItem updateImpl(CommerceWarehouseItem commerceWarehouseItem) {
        boolean isNew = commerceWarehouseItem.isNew();
        if (!(commerceWarehouseItem instanceof CommerceWarehouseItemModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(commerceWarehouseItem.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)commerceWarehouseItem);
                throw new IllegalArgumentException("Implement ModelWrapper in commerceWarehouseItem proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CommerceWarehouseItem implementation " + commerceWarehouseItem.getClass());
        }
        CommerceWarehouseItemModelImpl commerceWarehouseItemModelImpl = (CommerceWarehouseItemModelImpl)commerceWarehouseItem;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && commerceWarehouseItem.getCreateDate() == null) {
            if (serviceContext == null) {
                commerceWarehouseItem.setCreateDate(now);
            } else {
                commerceWarehouseItem.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!commerceWarehouseItemModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                commerceWarehouseItem.setModifiedDate(now);
            } else {
                commerceWarehouseItem.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (commerceWarehouseItem.isNew()) {
                session.save((Object)commerceWarehouseItem);
                commerceWarehouseItem.setNew(false);
            } else {
                commerceWarehouseItem = (CommerceWarehouseItem)session.merge((Object)commerceWarehouseItem);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CommerceWarehouseItemModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{commerceWarehouseItemModelImpl.getCommerceWarehouseId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMMERCEWAREHOUSEID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMMERCEWAREHOUSEID, args);
            args = new Object[]{commerceWarehouseItemModelImpl.getCPInstanceId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_CPINSTANCEID, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CPINSTANCEID, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((commerceWarehouseItemModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMMERCEWAREHOUSEID.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceWarehouseItemModelImpl.getOriginalCommerceWarehouseId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMMERCEWAREHOUSEID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMMERCEWAREHOUSEID, args);
                args = new Object[]{commerceWarehouseItemModelImpl.getCommerceWarehouseId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_COMMERCEWAREHOUSEID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_COMMERCEWAREHOUSEID, args);
            }
            if ((commerceWarehouseItemModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CPINSTANCEID.getColumnBitmask()) != 0L) {
                args = new Object[]{commerceWarehouseItemModelImpl.getOriginalCPInstanceId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_CPINSTANCEID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CPINSTANCEID, args);
                args = new Object[]{commerceWarehouseItemModelImpl.getCPInstanceId()};
                this.finderCache.removeResult(FINDER_PATH_COUNT_BY_CPINSTANCEID, args);
                this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_CPINSTANCEID, args);
            }
        }
        this.entityCache.putResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, (Serializable)Long.valueOf(commerceWarehouseItem.getPrimaryKey()), (Serializable)commerceWarehouseItem, false);
        this.clearUniqueFindersCache(commerceWarehouseItemModelImpl, false);
        this.cacheUniqueFindersCache(commerceWarehouseItemModelImpl);
        commerceWarehouseItem.resetOriginalValues();
        return commerceWarehouseItem;
    }

    public CommerceWarehouseItem findByPrimaryKey(Serializable primaryKey) throws NoSuchWarehouseItemException {
        CommerceWarehouseItem commerceWarehouseItem = this.fetchByPrimaryKey(primaryKey);
        if (commerceWarehouseItem == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchWarehouseItemException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return commerceWarehouseItem;
    }

    public CommerceWarehouseItem findByPrimaryKey(long commerceWarehouseItemId) throws NoSuchWarehouseItemException {
        return this.findByPrimaryKey(Long.valueOf(commerceWarehouseItemId));
    }

    public CommerceWarehouseItem fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        CommerceWarehouseItem commerceWarehouseItem = (CommerceWarehouseItem)serializable;
        if (commerceWarehouseItem == null) {
            Session session = null;
            try {
                session = this.openSession();
                commerceWarehouseItem = (CommerceWarehouseItem)session.get(CommerceWarehouseItemImpl.class, primaryKey);
                if (commerceWarehouseItem != null) {
                    this.cacheResult(commerceWarehouseItem);
                } else {
                    this.entityCache.putResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return commerceWarehouseItem;
    }

    public CommerceWarehouseItem fetchByPrimaryKey(long commerceWarehouseItemId) {
        return this.fetchByPrimaryKey(Long.valueOf(commerceWarehouseItemId));
    }

    public Map<Serializable, CommerceWarehouseItem> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, CommerceWarehouseItem> map = new HashMap<Serializable, CommerceWarehouseItem>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            CommerceWarehouseItem commerceWarehouseItem = this.fetchByPrimaryKey(primaryKey);
            if (commerceWarehouseItem != null) {
                map.put(primaryKey, commerceWarehouseItem);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (CommerceWarehouseItem)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_COMMERCEWAREHOUSEITEM_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (CommerceWarehouseItem commerceWarehouseItem : q.list()) {
                map.put(commerceWarehouseItem.getPrimaryKeyObj(), commerceWarehouseItem);
                this.cacheResult(commerceWarehouseItem);
                uncachedPrimaryKeys.remove(commerceWarehouseItem.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(CommerceWarehouseItemModelImpl.ENTITY_CACHE_ENABLED, CommerceWarehouseItemImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<CommerceWarehouseItem> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CommerceWarehouseItem> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CommerceWarehouseItem> findAll(int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CommerceWarehouseItem> findAll(int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_COMMERCEWAREHOUSEITEM);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COMMERCEWAREHOUSEITEM;
                if (pagination) {
                    sql = sql.concat(" ORDER BY commerceWarehouseItem.commerceWarehouseItemId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CommerceWarehouseItem commerceWarehouseItem : this.findAll()) {
            this.remove((BaseModel)commerceWarehouseItem);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COMMERCEWAREHOUSEITEM);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CommerceWarehouseItemModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(CommerceWarehouseItemImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

