/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.service.persistence.impl;

import com.liferay.commerce.model.CommerceWarehouseItem;
import com.liferay.commerce.model.impl.CommerceWarehouseItemImpl;
import com.liferay.commerce.service.persistence.CommerceWarehouseItemFinder;
import com.liferay.commerce.service.persistence.impl.CommerceWarehouseItemFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Iterator;
import java.util.List;

public class CommerceWarehouseItemFinderImpl
extends CommerceWarehouseItemFinderBaseImpl
implements CommerceWarehouseItemFinder {
    public static final String FIND_BY_CP_INSTANCE_ID = CommerceWarehouseItemFinder.class.getName() + ".findByCPInstanceId";
    public static final String GET_CP_INSTANCE_QUANTITY = CommerceWarehouseItemFinder.class.getName() + ".getCPInstanceQuantity";
    public static final String SUM_VALUE = "SUM_VALUE";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public List<CommerceWarehouseItem> findByCPInstanceId(long cpInstanceId, int start, int end, OrderByComparator<CommerceWarehouseItem> orderByComparator) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_CP_INSTANCE_ID);
            sql = this._customSQL.replaceOrderBy(sql, orderByComparator);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("CommerceWarehouseItem", CommerceWarehouseItemImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(cpInstanceId);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int getCPInstanceQuantity(long cpInstanceId) {
        Session session = null;
        try {
            Long sum;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), GET_CP_INSTANCE_QUANTITY);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar(SUM_VALUE, Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(cpInstanceId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (sum = (Long)itr.next()) != null) {
                int n = sum.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

