/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.internal.order;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.order.CommerceOrderValidator;
import com.liferay.commerce.order.CommerceOrderValidatorResult;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.service.CPDefinitionInventoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ArrayUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.order.validator.key=default", "commerce.order.validator.priority:Integer=10"}, service={CommerceOrderValidator.class})
public class DefaultCommerceOrderValidatorImpl
implements CommerceOrderValidator {
    public static final String KEY = "default";
    @Reference
    private CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;
    @Reference
    private CPDefinitionInventoryLocalService _cpDefinitionInventoryLocalService;

    public String getKey() {
        return KEY;
    }

    public CommerceOrderValidatorResult validate(CommerceOrderItem commerceOrderItem) throws PortalException {
        CPInstance cpInstance = commerceOrderItem.getCPInstance();
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        if (cpDefinitionInventoryEngine.isBackOrderAllowed(cpInstance)) {
            return new CommerceOrderValidatorResult(true);
        }
        int minOrderQuantity = cpDefinitionInventoryEngine.getMinOrderQuantity(cpInstance);
        int maxOrderQuantity = cpDefinitionInventoryEngine.getMaxOrderQuantity(cpInstance);
        Object[] allowedOrderQuantities = cpDefinitionInventoryEngine.getAllowedOrderQuantities(cpInstance);
        if (minOrderQuantity > 0 && commerceOrderItem.getQuantity() < minOrderQuantity) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, "minimum-quantity-is-x", String.valueOf(minOrderQuantity));
        }
        if (maxOrderQuantity > 0 && commerceOrderItem.getQuantity() > maxOrderQuantity) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, "maximum-quantity-is-x", String.valueOf(maxOrderQuantity));
        }
        if (allowedOrderQuantities.length > 0 && !ArrayUtil.contains((Object[])allowedOrderQuantities, (Object)String.valueOf(commerceOrderItem.getQuantity()))) {
            return new CommerceOrderValidatorResult(commerceOrderItem.getCommerceOrderItemId(), false, "quantity-is-not-allowed");
        }
        return new CommerceOrderValidatorResult(true);
    }

    public CommerceOrderValidatorResult validate(CPInstance cpInstance, int quantity) throws PortalException {
        if (cpInstance == null) {
            return new CommerceOrderValidatorResult(false);
        }
        CPDefinitionInventory cpDefinitionInventory = this._cpDefinitionInventoryLocalService.fetchCPDefinitionInventoryByCPDefinitionId(cpInstance.getCPDefinitionId());
        CPDefinitionInventoryEngine cpDefinitionInventoryEngine = this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngine(cpDefinitionInventory);
        int minOrderQuantity = cpDefinitionInventoryEngine.getMinOrderQuantity(cpInstance);
        int maxOrderQuantity = cpDefinitionInventoryEngine.getMaxOrderQuantity(cpInstance);
        Object[] allowedOrderQuantities = cpDefinitionInventoryEngine.getAllowedOrderQuantities(cpInstance);
        if (cpDefinitionInventoryEngine.isBackOrderAllowed(cpInstance) && quantity >= minOrderQuantity && quantity <= maxOrderQuantity) {
            return new CommerceOrderValidatorResult(true);
        }
        if (minOrderQuantity > 0 && quantity < minOrderQuantity) {
            return new CommerceOrderValidatorResult(false, "minimum-quantity-is-x", String.valueOf(minOrderQuantity));
        }
        if (maxOrderQuantity > 0 && quantity > maxOrderQuantity) {
            return new CommerceOrderValidatorResult(false, "maximum-quantity-is-x", String.valueOf(maxOrderQuantity));
        }
        if (allowedOrderQuantities.length > 0 && !ArrayUtil.contains((Object[])allowedOrderQuantities, (Object)String.valueOf(quantity))) {
            return new CommerceOrderValidatorResult(false, "quantity-is-not-allowed");
        }
        return new CommerceOrderValidatorResult(true);
    }
}

