/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.model.CommerceShipment;
import com.liferay.commerce.model.CommerceShipmentModel;
import com.liferay.commerce.model.CommerceShipmentSoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceShipment service. Represents a row in the &quot;CommerceShipment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceShipmentModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceShipmentImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceShipmentImpl
 * @see CommerceShipment
 * @see CommerceShipmentModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceShipmentModelImpl extends BaseModelImpl<CommerceShipment>
	implements CommerceShipmentModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce shipment model instance should use the {@link CommerceShipment} interface instead.
	 */
	public static final String TABLE_NAME = "CommerceShipment";
	public static final Object[][] TABLE_COLUMNS = {
			{ "commerceShipmentId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "siteGroupId", Types.BIGINT },
			{ "shipmentOrganizationId", Types.BIGINT },
			{ "shipmentUserId", Types.BIGINT },
			{ "commerceAddressId", Types.BIGINT },
			{ "commerceShippingMethodId", Types.BIGINT },
			{ "shippingOptionName", Types.VARCHAR },
			{ "carrier", Types.VARCHAR },
			{ "trackingNumber", Types.VARCHAR },
			{ "status", Types.INTEGER },
			{ "shippingDate", Types.TIMESTAMP },
			{ "expectedDate", Types.TIMESTAMP }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("commerceShipmentId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("siteGroupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shipmentOrganizationId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shipmentUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceAddressId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceShippingMethodId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("shippingOptionName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("carrier", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("trackingNumber", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("shippingDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("expectedDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE = "create table CommerceShipment (commerceShipmentId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,siteGroupId LONG,shipmentOrganizationId LONG,shipmentUserId LONG,commerceAddressId LONG,commerceShippingMethodId LONG,shippingOptionName VARCHAR(75) null,carrier VARCHAR(75) null,trackingNumber VARCHAR(75) null,status INTEGER,shippingDate DATE null,expectedDate DATE null)";
	public static final String TABLE_SQL_DROP = "drop table CommerceShipment";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceShipment.createDate DESC";
	public static final String ORDER_BY_SQL = " ORDER BY CommerceShipment.createDate DESC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.model.CommerceShipment"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.model.CommerceShipment"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.model.CommerceShipment"),
			true);
	public static final long GROUPID_COLUMN_BITMASK = 1L;
	public static final long SITEGROUPID_COLUMN_BITMASK = 2L;
	public static final long STATUS_COLUMN_BITMASK = 4L;
	public static final long CREATEDATE_COLUMN_BITMASK = 8L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceShipment toModel(CommerceShipmentSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceShipment model = new CommerceShipmentImpl();

		model.setCommerceShipmentId(soapModel.getCommerceShipmentId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setSiteGroupId(soapModel.getSiteGroupId());
		model.setShipmentOrganizationId(soapModel.getShipmentOrganizationId());
		model.setShipmentUserId(soapModel.getShipmentUserId());
		model.setCommerceAddressId(soapModel.getCommerceAddressId());
		model.setCommerceShippingMethodId(soapModel.getCommerceShippingMethodId());
		model.setShippingOptionName(soapModel.getShippingOptionName());
		model.setCarrier(soapModel.getCarrier());
		model.setTrackingNumber(soapModel.getTrackingNumber());
		model.setStatus(soapModel.getStatus());
		model.setShippingDate(soapModel.getShippingDate());
		model.setExpectedDate(soapModel.getExpectedDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceShipment> toModels(
		CommerceShipmentSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceShipment> models = new ArrayList<CommerceShipment>(soapModels.length);

		for (CommerceShipmentSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.model.CommerceShipment"));

	public CommerceShipmentModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceShipmentId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceShipmentId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceShipmentId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceShipment.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceShipment.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceShipmentId", getCommerceShipmentId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("siteGroupId", getSiteGroupId());
		attributes.put("shipmentOrganizationId", getShipmentOrganizationId());
		attributes.put("shipmentUserId", getShipmentUserId());
		attributes.put("commerceAddressId", getCommerceAddressId());
		attributes.put("commerceShippingMethodId", getCommerceShippingMethodId());
		attributes.put("shippingOptionName", getShippingOptionName());
		attributes.put("carrier", getCarrier());
		attributes.put("trackingNumber", getTrackingNumber());
		attributes.put("status", getStatus());
		attributes.put("shippingDate", getShippingDate());
		attributes.put("expectedDate", getExpectedDate());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceShipmentId = (Long)attributes.get("commerceShipmentId");

		if (commerceShipmentId != null) {
			setCommerceShipmentId(commerceShipmentId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long siteGroupId = (Long)attributes.get("siteGroupId");

		if (siteGroupId != null) {
			setSiteGroupId(siteGroupId);
		}

		Long shipmentOrganizationId = (Long)attributes.get(
				"shipmentOrganizationId");

		if (shipmentOrganizationId != null) {
			setShipmentOrganizationId(shipmentOrganizationId);
		}

		Long shipmentUserId = (Long)attributes.get("shipmentUserId");

		if (shipmentUserId != null) {
			setShipmentUserId(shipmentUserId);
		}

		Long commerceAddressId = (Long)attributes.get("commerceAddressId");

		if (commerceAddressId != null) {
			setCommerceAddressId(commerceAddressId);
		}

		Long commerceShippingMethodId = (Long)attributes.get(
				"commerceShippingMethodId");

		if (commerceShippingMethodId != null) {
			setCommerceShippingMethodId(commerceShippingMethodId);
		}

		String shippingOptionName = (String)attributes.get("shippingOptionName");

		if (shippingOptionName != null) {
			setShippingOptionName(shippingOptionName);
		}

		String carrier = (String)attributes.get("carrier");

		if (carrier != null) {
			setCarrier(carrier);
		}

		String trackingNumber = (String)attributes.get("trackingNumber");

		if (trackingNumber != null) {
			setTrackingNumber(trackingNumber);
		}

		Integer status = (Integer)attributes.get("status");

		if (status != null) {
			setStatus(status);
		}

		Date shippingDate = (Date)attributes.get("shippingDate");

		if (shippingDate != null) {
			setShippingDate(shippingDate);
		}

		Date expectedDate = (Date)attributes.get("expectedDate");

		if (expectedDate != null) {
			setExpectedDate(expectedDate);
		}
	}

	@JSON
	@Override
	public long getCommerceShipmentId() {
		return _commerceShipmentId;
	}

	@Override
	public void setCommerceShipmentId(long commerceShipmentId) {
		_commerceShipmentId = commerceShipmentId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getSiteGroupId() {
		return _siteGroupId;
	}

	@Override
	public void setSiteGroupId(long siteGroupId) {
		_columnBitmask |= SITEGROUPID_COLUMN_BITMASK;

		if (!_setOriginalSiteGroupId) {
			_setOriginalSiteGroupId = true;

			_originalSiteGroupId = _siteGroupId;
		}

		_siteGroupId = siteGroupId;
	}

	public long getOriginalSiteGroupId() {
		return _originalSiteGroupId;
	}

	@JSON
	@Override
	public long getShipmentOrganizationId() {
		return _shipmentOrganizationId;
	}

	@Override
	public void setShipmentOrganizationId(long shipmentOrganizationId) {
		_shipmentOrganizationId = shipmentOrganizationId;
	}

	@JSON
	@Override
	public long getShipmentUserId() {
		return _shipmentUserId;
	}

	@Override
	public void setShipmentUserId(long shipmentUserId) {
		_shipmentUserId = shipmentUserId;
	}

	@Override
	public String getShipmentUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getShipmentUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setShipmentUserUuid(String shipmentUserUuid) {
	}

	@JSON
	@Override
	public long getCommerceAddressId() {
		return _commerceAddressId;
	}

	@Override
	public void setCommerceAddressId(long commerceAddressId) {
		_commerceAddressId = commerceAddressId;
	}

	@JSON
	@Override
	public long getCommerceShippingMethodId() {
		return _commerceShippingMethodId;
	}

	@Override
	public void setCommerceShippingMethodId(long commerceShippingMethodId) {
		_commerceShippingMethodId = commerceShippingMethodId;
	}

	@JSON
	@Override
	public String getShippingOptionName() {
		if (_shippingOptionName == null) {
			return "";
		}
		else {
			return _shippingOptionName;
		}
	}

	@Override
	public void setShippingOptionName(String shippingOptionName) {
		_shippingOptionName = shippingOptionName;
	}

	@JSON
	@Override
	public String getCarrier() {
		if (_carrier == null) {
			return "";
		}
		else {
			return _carrier;
		}
	}

	@Override
	public void setCarrier(String carrier) {
		_carrier = carrier;
	}

	@JSON
	@Override
	public String getTrackingNumber() {
		if (_trackingNumber == null) {
			return "";
		}
		else {
			return _trackingNumber;
		}
	}

	@Override
	public void setTrackingNumber(String trackingNumber) {
		_trackingNumber = trackingNumber;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		_columnBitmask |= STATUS_COLUMN_BITMASK;

		if (!_setOriginalStatus) {
			_setOriginalStatus = true;

			_originalStatus = _status;
		}

		_status = status;
	}

	public int getOriginalStatus() {
		return _originalStatus;
	}

	@JSON
	@Override
	public Date getShippingDate() {
		return _shippingDate;
	}

	@Override
	public void setShippingDate(Date shippingDate) {
		_shippingDate = shippingDate;
	}

	@JSON
	@Override
	public Date getExpectedDate() {
		return _expectedDate;
	}

	@Override
	public void setExpectedDate(Date expectedDate) {
		_expectedDate = expectedDate;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceShipment.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceShipment toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceShipment)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceShipmentImpl commerceShipmentImpl = new CommerceShipmentImpl();

		commerceShipmentImpl.setCommerceShipmentId(getCommerceShipmentId());
		commerceShipmentImpl.setGroupId(getGroupId());
		commerceShipmentImpl.setCompanyId(getCompanyId());
		commerceShipmentImpl.setUserId(getUserId());
		commerceShipmentImpl.setUserName(getUserName());
		commerceShipmentImpl.setCreateDate(getCreateDate());
		commerceShipmentImpl.setModifiedDate(getModifiedDate());
		commerceShipmentImpl.setSiteGroupId(getSiteGroupId());
		commerceShipmentImpl.setShipmentOrganizationId(getShipmentOrganizationId());
		commerceShipmentImpl.setShipmentUserId(getShipmentUserId());
		commerceShipmentImpl.setCommerceAddressId(getCommerceAddressId());
		commerceShipmentImpl.setCommerceShippingMethodId(getCommerceShippingMethodId());
		commerceShipmentImpl.setShippingOptionName(getShippingOptionName());
		commerceShipmentImpl.setCarrier(getCarrier());
		commerceShipmentImpl.setTrackingNumber(getTrackingNumber());
		commerceShipmentImpl.setStatus(getStatus());
		commerceShipmentImpl.setShippingDate(getShippingDate());
		commerceShipmentImpl.setExpectedDate(getExpectedDate());

		commerceShipmentImpl.resetOriginalValues();

		return commerceShipmentImpl;
	}

	@Override
	public int compareTo(CommerceShipment commerceShipment) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(),
				commerceShipment.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceShipment)) {
			return false;
		}

		CommerceShipment commerceShipment = (CommerceShipment)obj;

		long primaryKey = commerceShipment.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceShipmentModelImpl commerceShipmentModelImpl = this;

		commerceShipmentModelImpl._originalGroupId = commerceShipmentModelImpl._groupId;

		commerceShipmentModelImpl._setOriginalGroupId = false;

		commerceShipmentModelImpl._setModifiedDate = false;

		commerceShipmentModelImpl._originalSiteGroupId = commerceShipmentModelImpl._siteGroupId;

		commerceShipmentModelImpl._setOriginalSiteGroupId = false;

		commerceShipmentModelImpl._originalStatus = commerceShipmentModelImpl._status;

		commerceShipmentModelImpl._setOriginalStatus = false;

		commerceShipmentModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceShipment> toCacheModel() {
		CommerceShipmentCacheModel commerceShipmentCacheModel = new CommerceShipmentCacheModel();

		commerceShipmentCacheModel.commerceShipmentId = getCommerceShipmentId();

		commerceShipmentCacheModel.groupId = getGroupId();

		commerceShipmentCacheModel.companyId = getCompanyId();

		commerceShipmentCacheModel.userId = getUserId();

		commerceShipmentCacheModel.userName = getUserName();

		String userName = commerceShipmentCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceShipmentCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceShipmentCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceShipmentCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceShipmentCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceShipmentCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceShipmentCacheModel.siteGroupId = getSiteGroupId();

		commerceShipmentCacheModel.shipmentOrganizationId = getShipmentOrganizationId();

		commerceShipmentCacheModel.shipmentUserId = getShipmentUserId();

		commerceShipmentCacheModel.commerceAddressId = getCommerceAddressId();

		commerceShipmentCacheModel.commerceShippingMethodId = getCommerceShippingMethodId();

		commerceShipmentCacheModel.shippingOptionName = getShippingOptionName();

		String shippingOptionName = commerceShipmentCacheModel.shippingOptionName;

		if ((shippingOptionName != null) && (shippingOptionName.length() == 0)) {
			commerceShipmentCacheModel.shippingOptionName = null;
		}

		commerceShipmentCacheModel.carrier = getCarrier();

		String carrier = commerceShipmentCacheModel.carrier;

		if ((carrier != null) && (carrier.length() == 0)) {
			commerceShipmentCacheModel.carrier = null;
		}

		commerceShipmentCacheModel.trackingNumber = getTrackingNumber();

		String trackingNumber = commerceShipmentCacheModel.trackingNumber;

		if ((trackingNumber != null) && (trackingNumber.length() == 0)) {
			commerceShipmentCacheModel.trackingNumber = null;
		}

		commerceShipmentCacheModel.status = getStatus();

		Date shippingDate = getShippingDate();

		if (shippingDate != null) {
			commerceShipmentCacheModel.shippingDate = shippingDate.getTime();
		}
		else {
			commerceShipmentCacheModel.shippingDate = Long.MIN_VALUE;
		}

		Date expectedDate = getExpectedDate();

		if (expectedDate != null) {
			commerceShipmentCacheModel.expectedDate = expectedDate.getTime();
		}
		else {
			commerceShipmentCacheModel.expectedDate = Long.MIN_VALUE;
		}

		return commerceShipmentCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(37);

		sb.append("{commerceShipmentId=");
		sb.append(getCommerceShipmentId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", siteGroupId=");
		sb.append(getSiteGroupId());
		sb.append(", shipmentOrganizationId=");
		sb.append(getShipmentOrganizationId());
		sb.append(", shipmentUserId=");
		sb.append(getShipmentUserId());
		sb.append(", commerceAddressId=");
		sb.append(getCommerceAddressId());
		sb.append(", commerceShippingMethodId=");
		sb.append(getCommerceShippingMethodId());
		sb.append(", shippingOptionName=");
		sb.append(getShippingOptionName());
		sb.append(", carrier=");
		sb.append(getCarrier());
		sb.append(", trackingNumber=");
		sb.append(getTrackingNumber());
		sb.append(", status=");
		sb.append(getStatus());
		sb.append(", shippingDate=");
		sb.append(getShippingDate());
		sb.append(", expectedDate=");
		sb.append(getExpectedDate());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(58);

		sb.append("<model><model-name>");
		sb.append("com.liferay.commerce.model.CommerceShipment");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>commerceShipmentId</column-name><column-value><![CDATA[");
		sb.append(getCommerceShipmentId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>siteGroupId</column-name><column-value><![CDATA[");
		sb.append(getSiteGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shipmentOrganizationId</column-name><column-value><![CDATA[");
		sb.append(getShipmentOrganizationId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shipmentUserId</column-name><column-value><![CDATA[");
		sb.append(getShipmentUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceAddressId</column-name><column-value><![CDATA[");
		sb.append(getCommerceAddressId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceShippingMethodId</column-name><column-value><![CDATA[");
		sb.append(getCommerceShippingMethodId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingOptionName</column-name><column-value><![CDATA[");
		sb.append(getShippingOptionName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>carrier</column-name><column-value><![CDATA[");
		sb.append(getCarrier());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>trackingNumber</column-name><column-value><![CDATA[");
		sb.append(getTrackingNumber());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>status</column-name><column-value><![CDATA[");
		sb.append(getStatus());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingDate</column-name><column-value><![CDATA[");
		sb.append(getShippingDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>expectedDate</column-name><column-value><![CDATA[");
		sb.append(getExpectedDate());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceShipment.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceShipment.class, ModelWrapper.class
		};
	private long _commerceShipmentId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _siteGroupId;
	private long _originalSiteGroupId;
	private boolean _setOriginalSiteGroupId;
	private long _shipmentOrganizationId;
	private long _shipmentUserId;
	private long _commerceAddressId;
	private long _commerceShippingMethodId;
	private String _shippingOptionName;
	private String _carrier;
	private String _trackingNumber;
	private int _status;
	private int _originalStatus;
	private boolean _setOriginalStatus;
	private Date _shippingDate;
	private Date _expectedDate;
	private long _columnBitmask;
	private CommerceShipment _escapedModel;
}