/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.product.ddm.internal;

import com.liferay.commerce.account.model.CommerceAccount;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.media.CommerceMediaResolver;
import com.liferay.commerce.product.constants.CPConstants;
import com.liferay.commerce.product.ddm.DDMHelper;
import com.liferay.commerce.product.model.CPDefinitionOptionRel;
import com.liferay.commerce.product.model.CPDefinitionOptionValueRel;
import com.liferay.commerce.product.permission.CommerceProductViewPermission;
import com.liferay.commerce.product.service.CPAttachmentFileEntryLocalService;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionRelLocalService;
import com.liferay.commerce.product.service.CPDefinitionOptionValueRelLocalService;
import com.liferay.commerce.product.service.CPInstanceLocalService;
import com.liferay.commerce.product.service.CPInstanceOptionValueRelLocalService;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.product.util.DDMFormValuesHelper;
import com.liferay.commerce.product.util.JsonHelper;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderer;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormRule;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DDMHelper.class})
public class DDMHelperImpl
implements DDMHelper {
    private static final String[] _ARRAY_VALUE_FIELD_TYPE = new String[]{"select", "checkbox", "checkbox_multiple"};
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceMediaResolver _commerceMediaResolver;
    @Reference
    private CommerceProductViewPermission _commerceProductViewPermission;
    @Reference
    private CPAttachmentFileEntryLocalService _cpAttachmentFileEntryLocalService;
    @Reference
    private CPDefinitionLocalService _cpDefinitionLocalService;
    @Reference
    private CPDefinitionOptionRelLocalService _cpDefinitionOptionRelLocalService;
    @Reference
    private CPDefinitionOptionValueRelLocalService _cpDefinitionOptionValueRelLocalService;
    @Reference
    private CPInstanceLocalService _cpInstanceLocalService;
    @Reference
    private CPInstanceOptionValueRelLocalService _cpInstanceOptionValueRelLocalService;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMFormRenderer _ddmFormRenderer;
    @Reference
    private DDMFormValuesHelper _ddmFormValuesHelper;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private JsonHelper _jsonHelper;
    @Reference
    private Portal _portal;

    public DDMForm getCPAttachmentFileEntryDDMForm(Locale locale, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) {
        return this._getDDMForm(locale, false, true, false, cpDefinitionOptionRelCPDefinitionOptionValueRels);
    }

    public DDMForm getCPInstanceDDMForm(Locale locale, boolean ignoreSKUCombinations, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) {
        return this._getDDMForm(locale, ignoreSKUCombinations, false, false, cpDefinitionOptionRelCPDefinitionOptionValueRels);
    }

    public DDMForm getPublicStoreDDMForm(long groupId, long commerceAccountId, long cpDefinitionId, Locale locale, boolean ignoreSKUCombinations, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels, long companyId, long userId) {
        DDMForm ddmForm = this._getDDMForm(locale, ignoreSKUCombinations, false, true, cpDefinitionOptionRelCPDefinitionOptionValueRels);
        if (!ignoreSKUCombinations) {
            ddmForm.addDDMFormRule(this._createDDMFormRule(ddmForm, groupId, commerceAccountId, cpDefinitionId, companyId, userId));
        }
        return ddmForm;
    }

    public String renderCPAttachmentFileEntryOptions(long cpDefinitionId, String json, RenderRequest renderRequest, RenderResponse renderResponse, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) throws PortalException {
        Locale locale = this._portal.getLocale((PortletRequest)renderRequest);
        DDMForm ddmForm = this.getCPAttachmentFileEntryDDMForm(locale, cpDefinitionOptionRelCPDefinitionOptionValueRels);
        return this._render(cpDefinitionId, locale, ddmForm, json, renderRequest, renderResponse);
    }

    public String renderCPInstanceOptions(long cpDefinitionId, String json, boolean ignoreSKUCombinations, RenderRequest renderRequest, RenderResponse renderResponse, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) throws PortalException {
        Locale locale = this._portal.getLocale((PortletRequest)renderRequest);
        DDMForm ddmForm = this.getCPInstanceDDMForm(locale, ignoreSKUCombinations, cpDefinitionOptionRelCPDefinitionOptionValueRels);
        return this._render(cpDefinitionId, locale, ddmForm, json, renderRequest, renderResponse);
    }

    public String renderPublicStoreOptions(long cpDefinitionId, String json, boolean ignoreSKUCombinations, RenderRequest renderRequest, RenderResponse renderResponse, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) throws PortalException {
        Locale locale = this._portal.getLocale((PortletRequest)renderRequest);
        long commerceAccountId = 0L;
        CommerceAccount commerceAccount = this._commerceAccountHelper.getCurrentCommerceAccount(this._commerceChannelLocalService.getCommerceChannelGroupIdBySiteGroupId(this._portal.getScopeGroupId((PortletRequest)renderRequest)), this._portal.getHttpServletRequest((PortletRequest)renderRequest));
        if (commerceAccount != null) {
            commerceAccountId = commerceAccount.getCommerceAccountId();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        DDMForm ddmForm = this.getPublicStoreDDMForm(this._portal.getScopeGroupId((PortletRequest)renderRequest), commerceAccountId, cpDefinitionId, locale, ignoreSKUCombinations, cpDefinitionOptionRelCPDefinitionOptionValueRels, themeDisplay.getCompanyId(), themeDisplay.getUserId());
        return this._render(cpDefinitionId, locale, ddmForm, json, renderRequest, renderResponse);
    }

    private DDMFormRule _createDDMFormRule(DDMForm ddmForm, long groupId, long commerceAccountId, long cpDefinitionId, long companyId, long userId) {
        String action = this._createDDMFormRuleAction(ddmForm, groupId, commerceAccountId, cpDefinitionId, companyId, userId);
        return new DDMFormRule("TRUE", new String[]{action});
    }

    private String _createDDMFormRuleAction(DDMForm ddmForm, long groupId, long commerceAccountId, long cpDefinitionId, long companyId, long userId) {
        String callFunctionStatement = "call('getCPInstanceOptionsValues', concat(%s), '%s')";
        return String.format(callFunctionStatement, this._createDDMFormRuleInputMapping(ddmForm, groupId, commerceAccountId, cpDefinitionId, companyId, userId), this._createDDMFormRuleOutputMapping(ddmForm));
    }

    private String _createDDMFormRuleInputMapping(DDMForm ddmForm, long groupId, long commerceAccountId, long cpDefinitionId, long companyId, long userId) {
        String inputMappingStatement = "'%s=', getValue('%s')";
        String delimiter = ", ';',";
        List ddmFormFields = ddmForm.getDDMFormFields();
        Stream stream = ddmFormFields.stream();
        Stream<String> inputMappingStatementStream = stream.map(field -> String.format(inputMappingStatement, field.getName(), field.getName()));
        inputMappingStatementStream = Stream.concat(Stream.of(String.format("'companyId=%s'", String.valueOf(companyId))), inputMappingStatementStream);
        inputMappingStatementStream = Stream.concat(Stream.of(String.format("'cpDefinitionId=%s'", String.valueOf(cpDefinitionId))), inputMappingStatementStream);
        inputMappingStatementStream = Stream.concat(Stream.of(String.format("'groupId=%s'", String.valueOf(groupId))), inputMappingStatementStream);
        inputMappingStatementStream = Stream.concat(Stream.of(String.format("'commerceAccountId=%s'", String.valueOf(commerceAccountId))), inputMappingStatementStream);
        inputMappingStatementStream = Stream.concat(Stream.of(String.format("'userId=%s'", String.valueOf(userId))), inputMappingStatementStream);
        return inputMappingStatementStream.collect(Collectors.joining(delimiter));
    }

    private String _createDDMFormRuleOutputMapping(DDMForm ddmForm) {
        String outputMappingStatement = "%s=%s";
        List ddmFormFields = ddmForm.getDDMFormFields();
        Stream stream = ddmFormFields.stream();
        Stream<String> stringStream = stream.map(field -> String.format(outputMappingStatement, field.getName(), field.getName()));
        return stringStream.collect(Collectors.joining(";"));
    }

    private DDMForm _getDDMForm(Locale locale, boolean ignoreSKUCombinations, boolean optional, boolean publicStore, Map<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelCPDefinitionOptionValueRels) {
        if (cpDefinitionOptionRelCPDefinitionOptionValueRels.isEmpty()) {
            return null;
        }
        DDMForm ddmForm = new DDMForm();
        for (Map.Entry<CPDefinitionOptionRel, List<CPDefinitionOptionValueRel>> cpDefinitionOptionRelEntry : cpDefinitionOptionRelCPDefinitionOptionValueRels.entrySet()) {
            CPDefinitionOptionRel cpDefinitionOptionRel = cpDefinitionOptionRelEntry.getKey();
            if (Validator.isNull((String)cpDefinitionOptionRel.getDDMFormFieldTypeName())) continue;
            List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels = cpDefinitionOptionRelEntry.getValue();
            DDMFormField ddmFormField = this._getDDMFormField(cpDefinitionOptionRel, cpDefinitionOptionValueRels, locale);
            if (!optional) {
                ddmFormField.setRequired(this._isDDMFormFieldRequired(cpDefinitionOptionRel, ignoreSKUCombinations, publicStore));
            }
            ddmForm.addDDMFormField(ddmFormField);
        }
        ddmForm.addAvailableLocale(locale);
        ddmForm.setDefaultLocale(locale);
        return ddmForm;
    }

    private DDMFormField _getDDMFormField(CPDefinitionOptionRel cpDefinitionOptionRel, List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels, Locale locale) {
        DDMFormField ddmFormField = new DDMFormField(cpDefinitionOptionRel.getKey(), cpDefinitionOptionRel.getDDMFormFieldTypeName());
        LocalizedValue ddmFormFieldLabelLocalizedValue = new LocalizedValue(locale);
        ddmFormFieldLabelLocalizedValue.addString(locale, cpDefinitionOptionRel.getName(locale));
        ddmFormField.setLabel(ddmFormFieldLabelLocalizedValue);
        if (cpDefinitionOptionValueRels.isEmpty()) {
            return ddmFormField;
        }
        DDMFormFieldOptions ddmFormFieldOptions = this._getDDMFormFieldOptions(cpDefinitionOptionValueRels, locale);
        ddmFormField.setDDMFormFieldOptions(ddmFormFieldOptions);
        CPDefinitionOptionValueRel preselectedCPDefinitionOptionValueRel = cpDefinitionOptionRel.fetchPreselectedCPDefinitionOptionValueRel();
        if (preselectedCPDefinitionOptionValueRel != null) {
            ddmFormField.setPredefinedValue(this._getDDMFormFieldPredefinedValue(ddmFormFieldOptions, this._isArrayValueCPDefinitionOptionRelFieldType(cpDefinitionOptionRel), preselectedCPDefinitionOptionValueRel.getKey()));
        } else if (cpDefinitionOptionRel.isSkuContributor()) {
            ddmFormField.setPredefinedValue(this._getDDMFormFieldPredefinedValue(ddmFormFieldOptions, this._isArrayValueCPDefinitionOptionRelFieldType(cpDefinitionOptionRel), null));
        }
        return ddmFormField;
    }

    private DDMFormFieldOptions _getDDMFormFieldOptions(List<CPDefinitionOptionValueRel> cpDefinitionOptionValueRels, Locale locale) {
        DDMFormFieldOptions ddmFormFieldOptions = new DDMFormFieldOptions();
        for (CPDefinitionOptionValueRel cpDefinitionOptionValueRel : cpDefinitionOptionValueRels) {
            ddmFormFieldOptions.addOptionLabel(cpDefinitionOptionValueRel.getKey(), locale, cpDefinitionOptionValueRel.getName(locale));
        }
        return ddmFormFieldOptions;
    }

    private LocalizedValue _getDDMFormFieldPredefinedValue(DDMFormFieldOptions ddmFormFieldOptions, boolean arrayValueFieldType, String optionValueKey) {
        Map options = ddmFormFieldOptions.getOptions();
        if (options.isEmpty()) {
            return new LocalizedValue(ddmFormFieldOptions.getDefaultLocale());
        }
        for (Map.Entry entry : options.entrySet()) {
            LocalizedValue localizedValue = new LocalizedValue();
            LocalizedValue curLocalizedValue = (LocalizedValue)entry.getValue();
            if (arrayValueFieldType) {
                localizedValue.addString(curLocalizedValue.getDefaultLocale(), String.format("[\"%s\"]", entry.getKey()));
            } else {
                localizedValue.addString(curLocalizedValue.getDefaultLocale(), (String)entry.getKey());
            }
            if (Validator.isNull((String)optionValueKey)) {
                return localizedValue;
            }
            if (!Objects.equals(optionValueKey, entry.getKey())) continue;
            return localizedValue;
        }
        throw new IllegalArgumentException("Provided DDM field options miss valid field value");
    }

    private boolean _isArrayValueCPDefinitionOptionRelFieldType(CPDefinitionOptionRel cpDefinitionOptionRel) {
        return ArrayUtil.contains((Object[])_ARRAY_VALUE_FIELD_TYPE, (Object)cpDefinitionOptionRel.getDDMFormFieldTypeName());
    }

    private boolean _isDDMFormFieldRequired(CPDefinitionOptionRel cpDefinitionOptionRel, boolean ignoreSKUCombinations, boolean publicStore) {
        if (this._isIterableCPDefinitionOptionRelFieldType(cpDefinitionOptionRel) && !this._cpDefinitionOptionValueRelLocalService.hasCPDefinitionOptionValueRels(cpDefinitionOptionRel.getCPDefinitionOptionRelId())) {
            return false;
        }
        if (ignoreSKUCombinations) {
            return cpDefinitionOptionRel.isRequired();
        }
        return cpDefinitionOptionRel.isSkuContributor() || publicStore && cpDefinitionOptionRel.isRequired();
    }

    private boolean _isIterableCPDefinitionOptionRelFieldType(CPDefinitionOptionRel cpDefinitionOptionRel) {
        return ArrayUtil.contains((Object[])CPConstants.PRODUCT_OPTION_MULTIPLE_VALUES_FIELD_TYPES, (Object)cpDefinitionOptionRel.getDDMFormFieldTypeName());
    }

    private String _render(long cpDefinitionId, Locale locale, DDMForm ddmForm, String json, RenderRequest renderRequest, RenderResponse renderResponse) throws PortalException {
        DDMFormValues ddmFormValues;
        if (ddmForm == null) {
            return "";
        }
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)renderRequest);
        HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)renderResponse);
        DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
        ddmFormRenderingContext.setContainerId("ProductOptions" + String.valueOf(cpDefinitionId));
        ddmFormRenderingContext.setHttpServletRequest(httpServletRequest);
        ddmFormRenderingContext.setHttpServletResponse(httpServletResponse);
        ddmFormRenderingContext.setLocale(locale);
        ddmFormRenderingContext.setPortletNamespace(renderResponse.getNamespace());
        ddmFormRenderingContext.setShowRequiredFieldsWarning(false);
        if (Validator.isNotNull((String)json) && (ddmFormValues = this._ddmFormValuesHelper.deserialize(ddmForm, json, locale)) != null) {
            ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
        }
        return this._ddmFormRenderer.render(ddmForm, ddmFormRenderingContext);
    }
}

