/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.pricing.internal.upgrade.base;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;

public abstract class BaseCommercePricingUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseCommercePricingUpgradeProcess.class);

    protected void changeColumnType(Class<?> tableClass, String tableName, String columnName, String newColumnType) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Changing column %s to type %s for table %s", columnName, newColumnType, tableName));
        }
        if (this.hasColumn(tableName, columnName)) {
            this.alter(tableClass, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterColumnType((UpgradeProcess)this, columnName, newColumnType)});
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("No column %s exists on table %s", columnName, tableName));
        }
    }

    protected abstract void doUpgrade() throws Exception;

    protected void dropColumn(String tableName, String columnName) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Dropping column %s from table %s", columnName, tableName));
        }
        if (this.hasColumn(tableName, columnName)) {
            this.runSQL(StringBundler.concat((String[])new String[]{"alter table ", tableName, " drop column ", columnName}));
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)String.format("Column %s does not exist on table %s", columnName, tableName));
        }
    }
}

