/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.method.web.internal.portlet.action;

import com.liferay.commerce.exception.CommercePaymentMethodNameException;
import com.liferay.commerce.exception.NoSuchPaymentMethodException;
import com.liferay.commerce.model.CommercePaymentEngine;
import com.liferay.commerce.model.CommercePaymentMethod;
import com.liferay.commerce.service.CommercePaymentMethodService;
import com.liferay.commerce.util.CommercePaymentEngineRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_commerce_admin_web_internal_portlet_CommerceAdminPortlet", "mvc.command.name=editCommercePaymentMethod"}, service={MVCActionCommand.class})
public class EditCommercePaymentMethodMVCActionCommand
extends BaseMVCActionCommand {
    @Reference
    private CommercePaymentEngineRegistry _commercePaymentEngineRegistry;
    @Reference
    private CommercePaymentMethodService _commercePaymentMethodService;
    @Reference
    private Portal _portal;

    protected CommercePaymentMethod createCommercePaymentMethod(ActionRequest actionRequest) throws PortalException {
        return this.createCommercePaymentMethod(actionRequest, false);
    }

    protected CommercePaymentMethod createCommercePaymentMethod(ActionRequest actionRequest, boolean active) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Locale siteDefaultLocale = themeDisplay.getSiteDefaultLocale();
        String engineKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"engineKey");
        CommercePaymentEngine commercePaymentEngine = this._commercePaymentEngineRegistry.getCommercePaymentEngine(engineKey);
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        nameMap.put(siteDefaultLocale, commercePaymentEngine.getName(siteDefaultLocale));
        descriptionMap.put(siteDefaultLocale, commercePaymentEngine.getDescription(siteDefaultLocale));
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CommercePaymentMethod.class.getName(), (PortletRequest)actionRequest);
        return this._commercePaymentMethodService.addCommercePaymentMethod(nameMap, descriptionMap, null, engineKey, new HashMap(), 0.0, active, serviceContext);
    }

    protected void deleteCommercePaymentMethod(ActionRequest actionRequest) throws PortalException {
        long commercePaymentMethodId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commercePaymentMethodId");
        this._commercePaymentMethodService.deleteCommercePaymentMethod(commercePaymentMethodId);
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteCommercePaymentMethod(actionRequest);
            } else if (cmd.equals("edit")) {
                this.editCommercePaymentMethod(actionRequest, actionResponse);
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            } else if (cmd.equals("add") || cmd.equals("update")) {
                this.updateCommercePaymentMethod(actionRequest);
            } else if (cmd.equals("setActive")) {
                this.setActive(actionRequest);
            } else if (cmd.equals("viewRestrictions")) {
                this.viewRestrictions(actionRequest, actionResponse);
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchPaymentMethodException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/error.jsp");
            }
            if (e instanceof CommercePaymentMethodNameException) {
                this.hideDefaultErrorMessage((PortletRequest)actionRequest);
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcRenderCommandName", "editCommercePaymentMethod");
            }
            throw e;
        }
    }

    protected void editCommercePaymentMethod(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String redirect = null;
        long commercePaymentMethodId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commercePaymentMethodId");
        if (commercePaymentMethodId > 0L) {
            redirect = this.getRedirectURL(actionRequest, commercePaymentMethodId, "editCommercePaymentMethod");
        } else {
            CommercePaymentMethod commercePaymentMethod = this.createCommercePaymentMethod(actionRequest);
            redirect = this.getRedirectURL(actionRequest, commercePaymentMethod.getCommercePaymentMethodId(), "editCommercePaymentMethod");
        }
        this.sendRedirect(actionRequest, actionResponse, redirect);
    }

    protected String getRedirectURL(ActionRequest actionRequest, long commercePaymentMethodId, String mvcRenderCommandName) {
        String engineKey;
        PortletURL portletURL = this._portal.getControlPanelPortletURL((PortletRequest)actionRequest, "com_liferay_commerce_admin_web_internal_portlet_CommerceAdminPortlet", "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", mvcRenderCommandName);
        portletURL.setParameter("commercePaymentMethodId", String.valueOf(commercePaymentMethodId));
        String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
        if (Validator.isNotNull((String)redirect)) {
            portletURL.setParameter("redirect", redirect);
        }
        if (Validator.isNotNull((String)(engineKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"engineKey")))) {
            portletURL.setParameter("engineKey", engineKey);
        }
        return portletURL.toString();
    }

    protected void setActive(ActionRequest actionRequest) throws Exception {
        long commercePaymentMethodId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commercePaymentMethodId");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        if (commercePaymentMethodId > 0L) {
            this._commercePaymentMethodService.setActive(commercePaymentMethodId, active);
        } else {
            this.createCommercePaymentMethod(actionRequest, active);
        }
    }

    protected CommercePaymentMethod updateCommercePaymentMethod(ActionRequest actionRequest) throws PortalException {
        UploadPortletRequest uploadPortletRequest = this._portal.getUploadPortletRequest((PortletRequest)actionRequest);
        long commercePaymentMethodId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commercePaymentMethodId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        File imageFile = uploadPortletRequest.getFile("imageFile");
        String engineKey = ParamUtil.getString((PortletRequest)actionRequest, (String)"engineKey");
        UnicodeProperties engineParameterMap = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"settings--");
        double priority = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"priority");
        boolean active = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"active");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)CommercePaymentMethod.class.getName(), (PortletRequest)actionRequest);
        CommercePaymentMethod commercePaymentMethod = null;
        commercePaymentMethod = commercePaymentMethodId <= 0L ? this._commercePaymentMethodService.addCommercePaymentMethod(nameMap, descriptionMap, imageFile, engineKey, (Map)engineParameterMap, priority, active, serviceContext) : this._commercePaymentMethodService.updateCommercePaymentMethod(commercePaymentMethodId, nameMap, descriptionMap, imageFile, (Map)engineParameterMap, priority, active, serviceContext);
        return commercePaymentMethod;
    }

    protected void viewRestrictions(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String redirect = null;
        long commercePaymentMethodId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"commercePaymentMethodId");
        if (commercePaymentMethodId > 0L) {
            redirect = this.getRedirectURL(actionRequest, commercePaymentMethodId, "viewCommercePaymentMethodAddressRestriction");
        } else {
            CommercePaymentMethod commercePaymentMethod = this.createCommercePaymentMethod(actionRequest);
            redirect = this.getRedirectURL(actionRequest, commercePaymentMethod.getCommercePaymentMethodId(), "viewCommercePaymentMethodAddressRestriction");
        }
        this.sendRedirect(actionRequest, actionResponse, redirect);
    }
}

