/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.method.web.internal.display.context;

import com.liferay.commerce.model.CommercePaymentEngine;
import com.liferay.commerce.model.CommercePaymentMethod;
import com.liferay.commerce.service.CommercePaymentMethodService;
import com.liferay.commerce.util.CommercePaymentEngineRegistry;
import com.liferay.commerce.util.comparator.CommercePaymentMethodNameComparator;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class CommercePaymentMethodsDisplayContext {
    private final CommercePaymentEngineRegistry _commercePaymentEngineRegistry;
    private CommercePaymentMethod _commercePaymentMethod;
    private final CommercePaymentMethodService _commercePaymentMethodService;
    private final PortletResourcePermission _portletResourcePermission;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private SearchContainer<CommercePaymentMethod> _searchContainer;

    public CommercePaymentMethodsDisplayContext(CommercePaymentEngineRegistry commercePaymentEngineRegistry, CommercePaymentMethodService commercePaymentMethodService, PortletResourcePermission portletResourcePermission, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._commercePaymentEngineRegistry = commercePaymentEngineRegistry;
        this._commercePaymentMethodService = commercePaymentMethodService;
        this._portletResourcePermission = portletResourcePermission;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
    }

    public CommercePaymentEngine getCommercePaymentEngine() throws PortalException {
        String key = null;
        CommercePaymentMethod commercePaymentMethod = this.getCommercePaymentMethod();
        if (commercePaymentMethod != null) {
            key = commercePaymentMethod.getEngineKey();
        } else {
            key = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"engineKey");
            if (Validator.isNull((String)key)) {
                return null;
            }
        }
        return this._commercePaymentEngineRegistry.getCommercePaymentEngine(key);
    }

    public CommercePaymentMethod getCommercePaymentMethod() throws PortalException {
        if (this._commercePaymentMethod != null) {
            return this._commercePaymentMethod;
        }
        long commercePaymentMethodId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"commercePaymentMethodId");
        String engineKey = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"engineKey");
        if (commercePaymentMethodId > 0L) {
            this._commercePaymentMethod = this._commercePaymentMethodService.getCommercePaymentMethod(commercePaymentMethodId);
        } else if (Validator.isNotNull((String)engineKey)) {
            this._commercePaymentMethod = this.getDefaultCommercePaymentMethod(engineKey);
        }
        return this._commercePaymentMethod;
    }

    public PortletURL getPortletURL() {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("commerceAdminModuleKey", "payment-methods");
        String delta = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"delta");
        if (Validator.isNotNull((String)delta)) {
            portletURL.setParameter("delta", delta);
        }
        portletURL.setParameter("navigation", this.getNavigation());
        return portletURL;
    }

    public SearchContainer<CommercePaymentMethod> getSearchContainer() throws PortalException {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Boolean active = null;
        String emptyResultsMessage = "there-are-no-payment-methods";
        String navigation = this.getNavigation();
        if (navigation.equals("active")) {
            active = Boolean.TRUE;
            emptyResultsMessage = "there-are-no-active-payment-methods";
        } else if (navigation.equals("inactive")) {
            active = Boolean.FALSE;
            emptyResultsMessage = "there-are-no-inactive-payment-methods";
        }
        this._searchContainer = new SearchContainer((PortletRequest)this._renderRequest, this.getPortletURL(), null, emptyResultsMessage);
        List<Object> results = active != null ? this._commercePaymentMethodService.getCommercePaymentMethods(themeDisplay.getScopeGroupId(), active.booleanValue()) : this._commercePaymentMethodService.getCommercePaymentMethods(themeDisplay.getScopeGroupId());
        if (active == null || !active.booleanValue()) {
            results = this.addDefaultCommercePaymentMethods(results);
        }
        results.sort((Comparator<CommercePaymentMethod>)new CommercePaymentMethodNameComparator(themeDisplay.getLocale()));
        this._searchContainer.setTotal(results.size());
        this._searchContainer.setResults(results);
        return this._searchContainer;
    }

    public String getSelectedScreenNavigationCategoryKey() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"screenNavigationCategoryKey", (String)"details");
    }

    public boolean hasManageCommercePaymentMethodsPermission() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._portletResourcePermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "MANAGE_COMMERCE_PAYMENT_METHODS");
    }

    protected List<CommercePaymentMethod> addDefaultCommercePaymentMethods(List<CommercePaymentMethod> commercePaymentMethods) throws PortalException {
        commercePaymentMethods = ListUtil.copy(commercePaymentMethods);
        Map commercePaymentEngines = this._commercePaymentEngineRegistry.getCommercePaymentEngines();
        TreeSet commerceEngineKeys = new TreeSet(commercePaymentEngines.keySet());
        for (CommercePaymentMethod commercePaymentMethod : commercePaymentMethods) {
            commerceEngineKeys.remove(commercePaymentMethod.getEngineKey());
        }
        for (String name : commerceEngineKeys) {
            CommercePaymentMethod commercePaymentMethod = this.getDefaultCommercePaymentMethod(name);
            commercePaymentMethods.add(commercePaymentMethod);
        }
        return commercePaymentMethods;
    }

    protected CommercePaymentMethod getDefaultCommercePaymentMethod(String engineKey) throws PortalException {
        CommercePaymentEngine commercePaymentEngine = this._commercePaymentEngineRegistry.getCommercePaymentEngine(engineKey);
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodService.createCommercePaymentMethod(0L);
        Locale locale = LocaleUtil.getSiteDefault();
        commercePaymentMethod.setName(commercePaymentEngine.getName(locale), locale);
        commercePaymentMethod.setDescription(commercePaymentEngine.getDescription(locale), locale);
        commercePaymentMethod.setEngineKey(engineKey);
        return commercePaymentMethod;
    }

    protected String getNavigation() {
        return ParamUtil.getString((PortletRequest)this._renderRequest, (String)"navigation");
    }
}

