/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.method.web.internal.display.context;

import com.liferay.commerce.item.selector.criterion.CommerceCountryItemSelectorCriterion;
import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.model.CommercePaymentMethod;
import com.liferay.commerce.service.CommerceAddressRestrictionService;
import com.liferay.commerce.service.CommercePaymentMethodService;
import com.liferay.commerce.util.CommerceUtil;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.criteria.UUIDItemSelectorReturnType;
import com.liferay.portal.kernel.dao.search.EmptyOnClickRowChecker;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class CommercePaymentMethodRestrictionsDisplayContext {
    private final CommerceAddressRestrictionService _commerceAddressRestrictionService;
    private CommercePaymentMethod _commercePaymentMethod;
    private final CommercePaymentMethodService _commercePaymentMethodService;
    private final ItemSelector _itemSelector;
    private final PortletResourcePermission _portletResourcePermission;
    private final RenderRequest _renderRequest;
    private final RenderResponse _renderResponse;
    private RowChecker _rowChecker;
    private SearchContainer<CommerceAddressRestriction> _searchContainer;

    public CommercePaymentMethodRestrictionsDisplayContext(CommerceAddressRestrictionService commerceAddressRestrictionService, CommercePaymentMethodService commercePaymentMethodService, ItemSelector itemSelector, PortletResourcePermission portletResourcePermission, RenderRequest renderRequest, RenderResponse renderResponse) {
        this._commerceAddressRestrictionService = commerceAddressRestrictionService;
        this._commercePaymentMethodService = commercePaymentMethodService;
        this._itemSelector = itemSelector;
        this._portletResourcePermission = portletResourcePermission;
        this._renderRequest = renderRequest;
        this._renderResponse = renderResponse;
    }

    public CommercePaymentMethod getCommercePaymentMethod() throws PortalException {
        if (this._commercePaymentMethod != null) {
            return this._commercePaymentMethod;
        }
        long commercePaymentMethodId = ParamUtil.getLong((PortletRequest)this._renderRequest, (String)"commercePaymentMethodId");
        if (commercePaymentMethodId > 0L) {
            this._commercePaymentMethod = this._commercePaymentMethodService.getCommercePaymentMethod(commercePaymentMethodId);
        }
        return this._commercePaymentMethod;
    }

    public long getCommercePaymentMethodId() throws PortalException {
        CommercePaymentMethod commercePaymentMethod = this.getCommercePaymentMethod();
        if (commercePaymentMethod == null) {
            return 0L;
        }
        return commercePaymentMethod.getCommercePaymentMethodId();
    }

    public String getItemSelectorUrl() throws PortalException {
        RequestBackedPortletURLFactory requestBackedPortletURLFactory = RequestBackedPortletURLFactoryUtil.create((PortletRequest)this._renderRequest);
        CommerceCountryItemSelectorCriterion commerceCountryItemSelectorCriterion = new CommerceCountryItemSelectorCriterion();
        commerceCountryItemSelectorCriterion.setDesiredItemSelectorReturnTypes(Collections.singletonList(new UUIDItemSelectorReturnType()));
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, "countriesSelectItem", new ItemSelectorCriterion[]{commerceCountryItemSelectorCriterion});
        String checkedCommerceCountryIds = StringUtil.merge((long[])this.getCheckedCommerceCountryIds());
        itemSelectorURL.setParameter("checkedCommerceCountryIds", checkedCommerceCountryIds);
        return itemSelectorURL.toString();
    }

    public PortletURL getPortletURL() throws PortalException {
        PortletURL portletURL = this._renderResponse.createRenderURL();
        portletURL.setParameter("commerceAdminModuleKey", "payment-methods");
        portletURL.setParameter("mvcRenderCommandName", "editCommercePaymentMethod");
        portletURL.setParameter("commercePaymentMethodId", String.valueOf(this.getCommercePaymentMethodId()));
        portletURL.setParameter("screenNavigationEntryKey", "restrictions");
        String delta = ParamUtil.getString((PortletRequest)this._renderRequest, (String)"delta");
        if (Validator.isNotNull((String)delta)) {
            portletURL.setParameter("delta", delta);
        }
        return portletURL;
    }

    public RowChecker getRowChecker() {
        if (this._rowChecker == null) {
            this._rowChecker = new EmptyOnClickRowChecker((PortletResponse)this._renderResponse);
        }
        return this._rowChecker;
    }

    public SearchContainer<CommerceAddressRestriction> getSearchContainer() throws PortalException {
        if (this._searchContainer != null) {
            return this._searchContainer;
        }
        this._searchContainer = new SearchContainer((PortletRequest)this._renderRequest, this.getPortletURL(), null, null);
        this._searchContainer.setEmptyResultsMessage("there-are-no-restrictions");
        String orderByCol = "create-date";
        String orderByType = "desc";
        OrderByComparator orderByComparator = CommerceUtil.getCommerceAddressRestrictionOrderByComparator((String)orderByCol, (String)orderByType);
        this._searchContainer.setOrderByCol(orderByCol);
        this._searchContainer.setOrderByComparator(orderByComparator);
        this._searchContainer.setOrderByType(orderByType);
        this._searchContainer.setRowChecker(this.getRowChecker());
        int total = this._commerceAddressRestrictionService.getCommerceAddressRestrictionsCount(CommercePaymentMethod.class.getName(), this.getCommercePaymentMethodId());
        this._searchContainer.setTotal(total);
        List<CommerceAddressRestriction> results = this.getCommerceAddressRestrictions(this._searchContainer.getStart(), this._searchContainer.getEnd(), (OrderByComparator<CommerceAddressRestriction>)orderByComparator);
        this._searchContainer.setResults(results);
        return this._searchContainer;
    }

    public boolean hasManageCommercePaymentMethodsPermission() {
        ThemeDisplay themeDisplay = (ThemeDisplay)this._renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._portletResourcePermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "MANAGE_COMMERCE_PAYMENT_METHODS");
    }

    protected long[] getCheckedCommerceCountryIds() throws PortalException {
        ArrayList<Long> commerceCountryIdsList = new ArrayList<Long>();
        List<CommerceAddressRestriction> commerceAddressRestrictions = this.getCommerceAddressRestrictions();
        for (CommerceAddressRestriction commerceAddressRestriction : commerceAddressRestrictions) {
            commerceCountryIdsList.add(commerceAddressRestriction.getCommerceCountryId());
        }
        if (!commerceCountryIdsList.isEmpty()) {
            return ArrayUtil.toLongArray(commerceCountryIdsList);
        }
        return new long[0];
    }

    protected List<CommerceAddressRestriction> getCommerceAddressRestrictions() throws PortalException {
        return this.getCommerceAddressRestrictions(-1, -1, null);
    }

    protected List<CommerceAddressRestriction> getCommerceAddressRestrictions(int start, int end, OrderByComparator<CommerceAddressRestriction> orderByComparator) throws PortalException {
        return this._commerceAddressRestrictionService.getCommerceAddressRestrictions(CommercePaymentMethod.class.getName(), this.getCommercePaymentMethodId(), start, end, orderByComparator);
    }
}

