/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.payment.constants;

/**
 * @author Luca Pellizzon
 */
public class CommercePaymentIntegrationConstants {

	public static final int TYPE_FUNCTION_OFFLINE = 5;

	public static final int TYPE_FUNCTION_ONLINE_REDIRECT = 4;

	public static final int TYPE_FUNCTION_ONLINE_STANDARD = 3;

	public static final int TYPE_INTERNAL_OFFLINE = 2;

	public static final int TYPE_INTERNAL_ONLINE_REDIRECT = 1;

	public static final int TYPE_INTERNAL_ONLINE_STANDARD = 0;

	public static final int[] TYPES_FUNCTION = {
		TYPE_FUNCTION_OFFLINE, TYPE_FUNCTION_ONLINE_REDIRECT,
		TYPE_FUNCTION_ONLINE_STANDARD
	};

	public static final int[] TYPES_INTERNAL = {
		TYPE_INTERNAL_OFFLINE, TYPE_INTERNAL_ONLINE_REDIRECT,
		TYPE_INTERNAL_ONLINE_STANDARD
	};

}