/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.payment.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the CommercePaymentMethodGroupRelQualifier service. Represents a row in the &quot;CPMethodGroupRelQualifier&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.commerce.payment.model.impl.CommercePaymentMethodGroupRelQualifierModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.commerce.payment.model.impl.CommercePaymentMethodGroupRelQualifierImpl</code>.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommercePaymentMethodGroupRelQualifier
 * @generated
 */
@ProviderType
public interface CommercePaymentMethodGroupRelQualifierModel
	extends AttachedModel, AuditedModel,
			BaseModel<CommercePaymentMethodGroupRelQualifier>, MVCCModel,
			ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a commerce payment method group rel qualifier model instance should use the {@link CommercePaymentMethodGroupRelQualifier} interface instead.
	 */

	/**
	 * Returns the primary key of this commerce payment method group rel qualifier.
	 *
	 * @return the primary key of this commerce payment method group rel qualifier
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this commerce payment method group rel qualifier.
	 *
	 * @param primaryKey the primary key of this commerce payment method group rel qualifier
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this commerce payment method group rel qualifier.
	 *
	 * @return the mvcc version of this commerce payment method group rel qualifier
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this commerce payment method group rel qualifier.
	 *
	 * @param mvccVersion the mvcc version of this commerce payment method group rel qualifier
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the commerce payment method group rel qualifier ID of this commerce payment method group rel qualifier.
	 *
	 * @return the commerce payment method group rel qualifier ID of this commerce payment method group rel qualifier
	 */
	public long getCommercePaymentMethodGroupRelQualifierId();

	/**
	 * Sets the commerce payment method group rel qualifier ID of this commerce payment method group rel qualifier.
	 *
	 * @param commercePaymentMethodGroupRelQualifierId the commerce payment method group rel qualifier ID of this commerce payment method group rel qualifier
	 */
	public void setCommercePaymentMethodGroupRelQualifierId(
		long commercePaymentMethodGroupRelQualifierId);

	/**
	 * Returns the company ID of this commerce payment method group rel qualifier.
	 *
	 * @return the company ID of this commerce payment method group rel qualifier
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this commerce payment method group rel qualifier.
	 *
	 * @param companyId the company ID of this commerce payment method group rel qualifier
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this commerce payment method group rel qualifier.
	 *
	 * @return the user ID of this commerce payment method group rel qualifier
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this commerce payment method group rel qualifier.
	 *
	 * @param userId the user ID of this commerce payment method group rel qualifier
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this commerce payment method group rel qualifier.
	 *
	 * @return the user uuid of this commerce payment method group rel qualifier
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this commerce payment method group rel qualifier.
	 *
	 * @param userUuid the user uuid of this commerce payment method group rel qualifier
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this commerce payment method group rel qualifier.
	 *
	 * @return the user name of this commerce payment method group rel qualifier
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this commerce payment method group rel qualifier.
	 *
	 * @param userName the user name of this commerce payment method group rel qualifier
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this commerce payment method group rel qualifier.
	 *
	 * @return the create date of this commerce payment method group rel qualifier
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this commerce payment method group rel qualifier.
	 *
	 * @param createDate the create date of this commerce payment method group rel qualifier
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this commerce payment method group rel qualifier.
	 *
	 * @return the modified date of this commerce payment method group rel qualifier
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this commerce payment method group rel qualifier.
	 *
	 * @param modifiedDate the modified date of this commerce payment method group rel qualifier
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the fully qualified class name of this commerce payment method group rel qualifier.
	 *
	 * @return the fully qualified class name of this commerce payment method group rel qualifier
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this commerce payment method group rel qualifier.
	 *
	 * @return the class name ID of this commerce payment method group rel qualifier
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this commerce payment method group rel qualifier.
	 *
	 * @param classNameId the class name ID of this commerce payment method group rel qualifier
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this commerce payment method group rel qualifier.
	 *
	 * @return the class pk of this commerce payment method group rel qualifier
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this commerce payment method group rel qualifier.
	 *
	 * @param classPK the class pk of this commerce payment method group rel qualifier
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the commerce payment method group rel ID of this commerce payment method group rel qualifier.
	 *
	 * @return the commerce payment method group rel ID of this commerce payment method group rel qualifier
	 */
	public long getCommercePaymentMethodGroupRelId();

	/**
	 * Sets the commerce payment method group rel ID of this commerce payment method group rel qualifier.
	 *
	 * @param CommercePaymentMethodGroupRelId the commerce payment method group rel ID of this commerce payment method group rel qualifier
	 */
	public void setCommercePaymentMethodGroupRelId(
		long CommercePaymentMethodGroupRelId);

	@Override
	public CommercePaymentMethodGroupRelQualifier cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}