/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.payment.model;

import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.base.BaseTable;

import java.math.BigDecimal;

import java.sql.Clob;
import java.sql.Types;

import java.util.Date;

/**
 * The table class for the &quot;CommercePaymentEntryAudit&quot; database table.
 *
 * @author Luca Pellizzon
 * @see CommercePaymentEntryAudit
 * @generated
 */
public class CommercePaymentEntryAuditTable
	extends BaseTable<CommercePaymentEntryAuditTable> {

	public static final CommercePaymentEntryAuditTable INSTANCE =
		new CommercePaymentEntryAuditTable();

	public final Column<CommercePaymentEntryAuditTable, Long> mvccVersion =
		createColumn(
			"mvccVersion", Long.class, Types.BIGINT, Column.FLAG_NULLITY);
	public final Column<CommercePaymentEntryAuditTable, Long>
		commercePaymentEntryAuditId = createColumn(
			"commercePaymentEntryAuditId", Long.class, Types.BIGINT,
			Column.FLAG_PRIMARY);
	public final Column<CommercePaymentEntryAuditTable, Long> companyId =
		createColumn(
			"companyId", Long.class, Types.BIGINT, Column.FLAG_DEFAULT);
	public final Column<CommercePaymentEntryAuditTable, Long> userId =
		createColumn("userId", Long.class, Types.BIGINT, Column.FLAG_DEFAULT);
	public final Column<CommercePaymentEntryAuditTable, String> userName =
		createColumn(
			"userName", String.class, Types.VARCHAR, Column.FLAG_DEFAULT);
	public final Column<CommercePaymentEntryAuditTable, Date> createDate =
		createColumn(
			"createDate", Date.class, Types.TIMESTAMP, Column.FLAG_DEFAULT);
	public final Column<CommercePaymentEntryAuditTable, Date> modifiedDate =
		createColumn(
			"modifiedDate", Date.class, Types.TIMESTAMP, Column.FLAG_DEFAULT);
	public final Column<CommercePaymentEntryAuditTable, Long>
		commercePaymentEntryId = createColumn(
			"commercePaymentEntryId", Long.class, Types.BIGINT,
			Column.FLAG_DEFAULT);
	public final Column<CommercePaymentEntryAuditTable, BigDecimal> amount =
		createColumn(
			"amount", BigDecimal.class, Types.DECIMAL, Column.FLAG_DEFAULT);
	public final Column<CommercePaymentEntryAuditTable, String> currencyCode =
		createColumn(
			"currencyCode", String.class, Types.VARCHAR, Column.FLAG_DEFAULT);
	public final Column<CommercePaymentEntryAuditTable, String> logType =
		createColumn(
			"logType", String.class, Types.VARCHAR, Column.FLAG_DEFAULT);
	public final Column<CommercePaymentEntryAuditTable, Clob> logTypeSettings =
		createColumn(
			"logTypeSettings", Clob.class, Types.CLOB, Column.FLAG_DEFAULT);

	private CommercePaymentEntryAuditTable() {
		super("CommercePaymentEntryAudit", CommercePaymentEntryAuditTable::new);
	}

}