/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.payment.util.comparator;

import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;

import java.io.Serializable;

import java.util.Comparator;

/**
 * @author Luca Pellizzon
 */
public class CommercePaymentMethodPriorityComparator
	implements Comparator<CommercePaymentMethodGroupRel>, Serializable {

	public CommercePaymentMethodPriorityComparator() {
		_ascending = false;
	}

	public CommercePaymentMethodPriorityComparator(boolean ascending) {
		_ascending = ascending;
	}

	@Override
	public int compare(
		CommercePaymentMethodGroupRel commercePaymentMethod1,
		CommercePaymentMethodGroupRel commercePaymentMethod2) {

		int value = Double.compare(
			commercePaymentMethod1.getPriority(),
			commercePaymentMethod2.getPriority());

		if (_ascending) {
			return value;
		}

		return Math.negateExact(value);
	}

	private final boolean _ascending;

}