/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.forecast.alert.internal.data.integration.process.type;

import com.liferay.commerce.account.model.CommerceAccountModel;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.data.integration.model.CommerceDataIntegrationProcess;
import com.liferay.commerce.data.integration.model.CommerceDataIntegrationProcessLog;
import com.liferay.commerce.data.integration.service.CommerceDataIntegrationProcessLocalService;
import com.liferay.commerce.data.integration.service.CommerceDataIntegrationProcessLogLocalService;
import com.liferay.commerce.data.integration.service.ScheduledTaskExecutorService;
import com.liferay.commerce.machine.learning.forecast.CommerceAccountCommerceMLForecast;
import com.liferay.commerce.machine.learning.forecast.CommerceAccountCommerceMLForecastManager;
import com.liferay.commerce.machine.learning.forecast.alert.service.CommerceMLForecastAlertEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"data.integration.service.executor.key=commerce-ml-forecast-alert-entry"}, service={ScheduledTaskExecutorService.class})
public class CommerceMLForecastAlertEntryScheduledTaskExecutorService
implements ScheduledTaskExecutorService {
    private static final String _DATE_FORMAT = "yyyyMMdd";
    private static final float _DEFAULT_COMMERCE_ML_FORECAST_ALERT_ENTRY_THRESHOLD = 20.0f;
    private static final Log _log = LogFactoryUtil.getLog(CommerceMLForecastAlertEntryScheduledTaskExecutorService.class);
    @Reference
    private CommerceAccountCommerceMLForecastManager _commerceAccountCommerceMLForecastManager;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceDataIntegrationProcessLocalService _commerceDataIntegrationProcessLocalService;
    @Reference
    private CommerceDataIntegrationProcessLogLocalService _commerceDataIntegrationProcessLogLocalService;
    @Reference
    private CommerceMLForecastAlertEntryLocalService _commerceMLForecastAlertEntryLocalService;

    public String getName() {
        return "commerce-ml-forecast-alert-entry";
    }

    public void runProcess(long commerceDataIntegrationProcessId) throws IOException, PortalException {
        CommerceDataIntegrationProcess commerceDataIntegrationProcess = this._commerceDataIntegrationProcessLocalService.getCommerceDataIntegrationProcess(commerceDataIntegrationProcessId);
        CommerceDataIntegrationProcessLog commerceDataIntegrationProcessLog = this._commerceDataIntegrationProcessLogLocalService.addCommerceDataIntegrationProcessLog(commerceDataIntegrationProcess.getUserId(), commerceDataIntegrationProcess.getCommerceDataIntegrationProcessId(), null, null, 1, new Date(), null);
        try {
            this.executeProcess(commerceDataIntegrationProcess);
            commerceDataIntegrationProcessLog.setEndDate(new Date());
            commerceDataIntegrationProcessLog.setStatus(3);
            this._commerceDataIntegrationProcessLogLocalService.updateCommerceDataIntegrationProcessLog(commerceDataIntegrationProcessLog);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            this._commerceDataIntegrationProcessLogLocalService.updateCommerceDataIntegrationProcessLog(commerceDataIntegrationProcessLog.getCommerceDataIntegrationProcessLogId(), exception.getMessage(), null, 2, new Date());
        }
    }

    protected void executeProcess(CommerceDataIntegrationProcess commerceDataIntegrationProcess) throws Exception {
        UnicodeProperties unicodeProperties = commerceDataIntegrationProcess.getTypeSettingsProperties();
        Date commerceMLForecastAlertEntryCheckDate = GetterUtil.getDate((String)unicodeProperties.getProperty("commerce.ml.forecast.alert.entry.check.date"), (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)_DATE_FORMAT));
        if (commerceMLForecastAlertEntryCheckDate != null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Using manually set Forecast Alert Check Date");
            }
        } else {
            commerceMLForecastAlertEntryCheckDate = new Date();
        }
        float commerceMLForecastAlertEntryThreshold = GetterUtil.getFloat((String)((String)unicodeProperties.get((Object)"commerce.ml.forecast.alert.entry.threshold")), (float)20.0f);
        List commerceAccounts = this._commerceAccountLocalService.getCommerceAccounts(-1, -1);
        long[] commerceAccountIds = ListUtil.toLongArray((List)commerceAccounts, CommerceAccountModel::getCommerceAccountId);
        List commerceAccountCommerceMLForecasts = this._commerceAccountCommerceMLForecastManager.getMonthlyRevenueCommerceAccountCommerceMLForecasts(commerceDataIntegrationProcess.getCompanyId(), commerceAccountIds, commerceMLForecastAlertEntryCheckDate, 1, 0);
        for (CommerceAccountCommerceMLForecast commerceAccountCommerceMLForecast : commerceAccountCommerceMLForecasts) {
            float actual = commerceAccountCommerceMLForecast.getActual();
            float forecast = commerceAccountCommerceMLForecast.getForecast();
            if (actual == Float.MIN_VALUE || forecast == Float.MIN_VALUE) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)String.format("Missing actual or forecast value for %s, skipping", commerceAccountCommerceMLForecast.getForecastId()));
                continue;
            }
            float delta = actual - forecast;
            float percentChange = delta / forecast * 100.0f;
            if (!(percentChange > commerceMLForecastAlertEntryThreshold) && !(percentChange < -commerceMLForecastAlertEntryThreshold)) continue;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)String.format("Actual value exceed threshold %s: change percent: %s", Float.valueOf(commerceMLForecastAlertEntryThreshold), Float.valueOf(percentChange)));
            }
            this._commerceMLForecastAlertEntryLocalService.upsertCommerceMLForecastAlertEntry(commerceDataIntegrationProcess.getCompanyId(), commerceDataIntegrationProcess.getUserId(), commerceAccountCommerceMLForecast.getCommerceAccountId(), commerceAccountCommerceMLForecast.getTimestamp(), actual, forecast, percentChange);
        }
    }
}

