/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.inventory.web.internal.model;

/**
 * @author Luca Pellizzon
 * @author Alessio Antonio Rendina
 */
public class BookedQuantity {

	public BookedQuantity(
		String account, long commerceOrderId, int quantity,
		String expirationDate) {

		_account = account;
		_commerceOrderId = commerceOrderId;
		_quantity = quantity;
		_expirationDate = expirationDate;
	}

	public String getAccount() {
		return _account;
	}

	public long getCommerceOrderId() {
		return _commerceOrderId;
	}

	public String getExpirationDate() {
		return _expirationDate;
	}

	public int getQuantity() {
		return _quantity;
	}

	private final String _account;
	private final long _commerceOrderId;
	private final String _expirationDate;
	private final int _quantity;

}