/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.inventory.web.internal.model;

/**
 * @author Luca Pellizzon
 * @author Alessio Antonio Rendina
 */
public class Replenishment {

	public Replenishment(
		long commerceInventoryReplenishmentItemId, String warehouse,
		String date, int quantity) {

		_commerceInventoryReplenishmentItemId =
			commerceInventoryReplenishmentItemId;
		_warehouse = warehouse;
		_date = date;
		_quantity = quantity;
	}

	public long getCommerceInventoryReplenishmentItemId() {
		return _commerceInventoryReplenishmentItemId;
	}

	public String getDate() {
		return _date;
	}

	public int getQuantity() {
		return _quantity;
	}

	public String getWarehouse() {
		return _warehouse;
	}

	private final long _commerceInventoryReplenishmentItemId;
	private final String _date;
	private final int _quantity;
	private final String _warehouse;

}