/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.inventory.web.internal.model;

/**
 * @author Luca Pellizzon
 */
public class InventoryItem {

	public InventoryItem(String sku, int stock, int booked, int incoming) {
		_sku = sku;
		_stock = stock;

		if ((stock > 0) && (booked >= 0)) {
			_available = stock - booked;
		}
		else {
			_available = 0;
		}

		_booked = booked;
		_incoming = incoming;
	}

	public int getAvailable() {
		return _available;
	}

	public int getBooked() {
		return _booked;
	}

	public int getIncoming() {
		return _incoming;
	}

	public String getSku() {
		return _sku;
	}

	public int getStock() {
		return _stock;
	}

	private final int _available;
	private final int _booked;
	private final int _incoming;
	private final String _sku;
	private final int _stock;

}