/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.web.internal.display.context;

import com.liferay.commerce.inventory.CPDefinitionInventoryEngine;
import com.liferay.commerce.inventory.CPDefinitionInventoryEngineRegistry;
import com.liferay.commerce.inventory.web.internal.portlet.action.CPDefinitionInventoryActionHelper;
import com.liferay.commerce.model.CPDAvailabilityEstimate;
import com.liferay.commerce.model.CPDefinitionInventory;
import com.liferay.commerce.model.CommerceAvailabilityEstimate;
import com.liferay.commerce.model.impl.CPDefinitionInventoryImpl;
import com.liferay.commerce.product.definitions.web.display.context.BaseCPDefinitionsDisplayContext;
import com.liferay.commerce.product.definitions.web.portlet.action.ActionHelper;
import com.liferay.commerce.service.CPDAvailabilityEstimateService;
import com.liferay.commerce.service.CommerceAvailabilityEstimateService;
import com.liferay.commerce.stock.activity.CommerceLowStockActivity;
import com.liferay.commerce.stock.activity.CommerceLowStockActivityRegistry;
import com.liferay.commerce.util.comparator.CommerceAvailabilityEstimatePriorityComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class CPDefinitionInventoryDisplayContext
extends BaseCPDefinitionsDisplayContext {
    private final CommerceAvailabilityEstimateService _commerceAvailabilityEstimateService;
    private final CommerceLowStockActivityRegistry _commerceLowStockActivityRegistry;
    private final CPDAvailabilityEstimateService _cpdAvailabilityEstimateService;
    private CPDefinitionInventory _cpDefinitionInventory;
    private final CPDefinitionInventoryActionHelper _cpDefinitionInventoryActionHelper;
    private final CPDefinitionInventoryEngineRegistry _cpDefinitionInventoryEngineRegistry;

    public CPDefinitionInventoryDisplayContext(ActionHelper actionHelper, HttpServletRequest httpServletRequest, CommerceAvailabilityEstimateService commerceAvailabilityEstimateService, CommerceLowStockActivityRegistry commerceLowStockActivityRegistry, CPDAvailabilityEstimateService cpdAvailabilityEstimateService, CPDefinitionInventoryActionHelper cpDefinitionInventoryActionHelper, CPDefinitionInventoryEngineRegistry cpDefinitionInventoryEngineRegistry) throws PortalException {
        super(actionHelper, httpServletRequest);
        this._commerceAvailabilityEstimateService = commerceAvailabilityEstimateService;
        this._commerceLowStockActivityRegistry = commerceLowStockActivityRegistry;
        this._cpdAvailabilityEstimateService = cpdAvailabilityEstimateService;
        this._cpDefinitionInventoryActionHelper = cpDefinitionInventoryActionHelper;
        this._cpDefinitionInventoryEngineRegistry = cpDefinitionInventoryEngineRegistry;
    }

    public List<CommerceAvailabilityEstimate> getCommerceAvailabilityEstimates() throws PortalException {
        return this._commerceAvailabilityEstimateService.getCommerceAvailabilityEstimates(this.getScopeGroupId(), -1, -1, (OrderByComparator)new CommerceAvailabilityEstimatePriorityComparator(true));
    }

    public List<CommerceLowStockActivity> getCommerceLowStockActivities() {
        return this._commerceLowStockActivityRegistry.getCommerceLowStockActivities();
    }

    public CPDAvailabilityEstimate getCPDAvailabilityEstimate() throws PortalException {
        return this._cpdAvailabilityEstimateService.fetchCPDAvailabilityEstimateByCPDefinitionId(this.getCPDefinitionId());
    }

    public CPDefinitionInventory getCPDefinitionInventory() throws PortalException {
        if (this._cpDefinitionInventory != null) {
            return this._cpDefinitionInventory;
        }
        this._cpDefinitionInventory = this._cpDefinitionInventoryActionHelper.getCPDefinitionInventory(this.cpRequestHelper.getRenderRequest());
        if (this._cpDefinitionInventory == null) {
            this._cpDefinitionInventory = new CPDefinitionInventoryImpl();
            this._cpDefinitionInventory.setMinOrderQuantity(1);
            this._cpDefinitionInventory.setMaxOrderQuantity(10000);
            this._cpDefinitionInventory.setMultipleOrderQuantity(1);
        }
        return this._cpDefinitionInventory;
    }

    public List<CPDefinitionInventoryEngine> getCPDefinitionInventoryEngines() {
        return this._cpDefinitionInventoryEngineRegistry.getCPDefinitionInventoryEngines();
    }

    public String getScreenNavigationCategoryKey() {
        return "configuration";
    }
}

